<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route[LOGIN_PAGE] = 'app/login';
$route['logout'] =  'app/logout';
$route['recover'] =  'app/recover';
$route['register'] =  'app/register';
$route['default_controller'] = 'app';
$route['locked'] = 'app/locked';
$route['unlockapp'] = 'app/unlock';
$route['404_override'] = 'app/error404';
$route['translate_uri_dashes'] = FALSE;
$route['clearaccesscontrol'] = 'app/clearcontrol';

// profile 
$route['profile'] = 'profile/index';
$route['profile/security'] = 'profile/index/security';
$route['profile/account'] = 'profile/index/account';
$route['profile/primary'] = 'profile/index/primary';
$route['profile/overview'] = 'profile/index/overview';

// Settings
$route['settings'] = 'settings/index';
$route['settings/sound'] = 'settings/index/sound';

// charges
$route['charges'] = 'charges/index';
// loans
$route['loans/applications/new'] = 'loans/applications/register';
$route['loans'] = 'loans/index';
$route['loans/new'] = 'loans/index/register';
$route['loans/calculator'] = 'loans/index/calculator';
$route['loans/details/(:num)'] = 'loans/index/details/$1';

// Payroll
$route['payrolls'] ='payrolls/index';


// accounting
$route['accounting/account/history/(:any)'] = 'accounting/account/index/history/$1';

$route['accounting/gl/print/glrecord/(:num)'] = 'accounting/gl/index/printrecord/$1';
$route['accounting/gl'] = 'accounting/gl/index';
$route['accounting/gl/deleteledger/(:num)'] = 'accounting/gl/index/deleteledger/$1';
$route['accounting/gl/restoreledger/(:num)'] = 'accounting/gl/index/restoreledger/$1';
$route['accounting/gl/deleteledgerforever/(:num)'] = 'accounting/gl/index/deleteledgerforever/$1';

$route['accounting/postings'] = 'accounting/postings/index';
$route['accounting/postings/filtered/(:any)'] = 'accounting/postings/index/filtered/$1';

$route['accounting/settings'] = 'accounting/settings/index';
$route['accounting/settings/quotations'] = 'accounting/settings/index/quotations';
$route['accounting/settings/invoices'] = 'accounting/settings/index/invoices';
$route['accounting/settings/loans'] = 'accounting/settings/index/loans';
$route['accounting/settings/payroll'] = 'accounting/settings/index/payroll';
$route['accounting/settings/assets'] = 'accounting/settings/index/assets';
$route['accounting/settings/periods'] = 'accounting/settings/index/periods';

$route['accounting/journals'] = 'accounting/journals/index';
$route['accounting/journals/create'] = 'accounting/journals/index/create';
$route['accounting/journals/modify/(:num)'] = 'accounting/journals/index/modify/$1';
$route['accounting/journals/details/(:num)'] = 'accounting/journals/index/details/$1';
$route['accounting/journals/deleteforever/(:num)'] = 'accounting/journals/index/deleteforever/$1';
$route['accounting/journals/delete/(:num)'] = 'accounting/journals/index/delete/$1';
$route['accounting/journals/restore/(:num)'] = 'accounting/journals/index/restore/$1';

$route['assets'] = 'accounting/assets';
$route['assets/assettypes'] = 'accounting/assets/assettypes';
$route['assets/newasset'] = 'accounting/assets/newasset';
$route['assets/newassettype'] = 'accounting/assets/newassettype';
$route['assets/modify/(:num)'] = 'accounting/assets/modify/$1';
$route['assets/type/(:num)'] = 'accounting/assets/assettypedetails/$1';

// Expenses

$route['expenses'] ='expenses/index';
$route['expenses/overview'] ='expenses/index';
$route['expenses/ajaxdetails/(:num)'] ='expenses/index/ajaxdetails/$1';

$route['expenses/categories/detailsr/(:num)'] ='expenses/categories/index/detailsr/$1';
$route['expenses/categories'] ='expenses/categories/index';
$route['expenses/categories/details/(:any)'] ='expenses/categories/index/details/$1';

$route['expenses/budgets'] ='expenses/budgets/index';
$route['expenses/budgets/detailsr/(:num)'] ='expenses/budgets/index/detailsr/$1';
$route['expenses/budgets/details/(:num)'] ='expenses/budgets/index/details/$1';

$route['expenses/types'] ='expenses/types/index';
$route['expenses/types/detailsr/(:num)'] ='expenses/types/index/detailsr/$1';
$route['expenses/types/details/(:num)'] ='expenses/types/index/details/$1';

$route['expenses/employees'] ='expenses/employees/index';
$route['expenses/employees/detailsr/(:num)'] ='expenses/employees/index/detailsr/$1';
$route['expenses/employees/details/(:num)'] ='expenses/employees/index/details/$1';

//customer
$route['customers'] ='crm/customers/index';
$route['customers/newcustomer'] ='crm/customers/index/newcustomer';
$route['customers/newcorporate'] ='crm/customers/index/newcorporate';
$route['customers/category'] ='crm/customers/category';

$route['shipper'] ='crm/shipper/index';
$route['shipper/create'] ='crm/shipper/index/newshipper';

//HR module
$route['hrm/employees'] = 'hrm/employees/index';
$route['newemployee'] = 'hrm/employees/index/newemployee';
$route['employees/details/(:num)'] = 'hrm/employees/index/details/$1';
$route['employees/titles'] = 'hrm/employees/titles';
$route['employees/roles'] = 'hrm/employees/roles';
$route['hrm/attendance'] = 'hrm/attendance/index';
$route['hrm/device'] = 'hrm/attendance/index/device';
$route['hrm/template'] = 'hrm/template/index';
$route['departments'] = 'hrm/employees/departments';
$route['hrm/holidayscheme'] = 'hrm/holiday/index';
$route['holiday/holiday'] = 'hrm/holiday/index/schemedates';
$route['hrm/leavescheme'] = 'hrm/leave/index';
$route['leave/leaves'] = 'hrm/leave/index/leavescheme';
$route['leave/leaverequest'] = 'hrm/leave/index/leaverequest';
$route['hrm/workdayscheme'] = 'hrm/workday/index';
$route['workday/workday'] = 'hrm/workday/index/workdayschemeday';

//communication
$route['sms'] ='communication/sms/index';
$route['bulk'] ='communication/sms/index/bulk';
$route['bulksms'] ='communication/sms/index/bulksms';
$route['bulksms/log'] ='communication/sms/index/log';
$route['bulksms/logbulk'] ='communication/sms/index/logbulk';
$route['email'] ='communication/email/index';
$route['message'] ='communication/message/index';

//Taxes module
$route['taxes'] = 'taxes/index';
$route['taxes/classes'] = 'taxes/index/classes';

//Communication module
$route['communication'] = 'communication/index';
$route['communication/(:num)'] = 'communication/index';
$route['communication/outbox'] = 'communication/index/outbox';
$route['communication/outbox/(:num)'] = 'communication/index/outbox';
$route['communication/draft'] = 'communication/index/draft';
$route['communication/draft/(:num)'] = 'communication/index/draft';
$route['communication/marked'] = 'communication/index/marked';
$route['communication/marked/(:num)'] = 'communication/index/marked';
$route['communication/trash'] = 'communication/index/trash';
$route['communication/trash/(:num)'] = 'communication/index/trash';

//Invoices Module
$route['invoices'] = 'invoices/index';
$route['invoices/filtered/(:any)'] = 'invoices/index/filtered/$1';
$route['invoices/addpayment'] = 'invoices/index/addpayment';
$route['invoices/create'] = 'invoices/index/create';
$route['invoices/deleteinv/(:num)'] = 'invoices/index/deleteinv/$1';
$route['invoices/deleteinvforever/(:num)'] = 'invoices/index/deleteinvforever/$1';
$route['invoices/deletepayment/(:num)'] = 'invoices/index/deletepayment/$1';
$route['invoices/deletepaymentforever/(:num)'] = 'invoices/index/deletepaymentforever/$1';
$route['invoices/details/(:num)'] = 'invoices/index/details/$1';
$route['invoices/payments/(:num)'] = 'invoices/index/payments/$1';
$route['invoices/modify/(:num)'] = 'invoices/index/modify/$1';
$route['invoices/sourceinvoices'] = "invoices/index/sourceinvoices";
$route['invoices/sourceinvoices/(:any)'] = "invoices/index/sourceinvoices/$1";
$route['invoices/sourceinvoicesbin'] = "invoices/index/sourceinvoicesbin";
$route['invoices/sourceinvoicesbin/(:any)'] = "invoices/index/sourceinvoicesbin/$1";
$route['invoices/sourcetransactions'] = "invoices/index/sourcetransactions";
$route['invoices/sourcetransactionsbin'] = "invoices/index/sourcetransactionsbin";
$route['invoices/transactions'] = 'invoices/index/transactions';
$route['invoices/postpayment/(:num)'] = 'invoices/index/postpayment/$1';
$route['invoices/restorepayment/(:num)'] = 'invoices/index/restorepayment/$1';
$route['invoices/restoreinv/(:num)'] = 'invoices/index/restoreinv/$1';

//Quotations Module
$route['quotations'] = 'quotations/index';
$route['quotations/filtered/(:any)'] = 'quotations/index/filtered/$1';
$route['quotations/addpayment'] = 'quotations/index/addpayment';
$route['quotations/create'] = 'quotations/index/create';
$route['quotations/deleteinv/(:num)'] = 'quotations/index/deleteinv/$1';
$route['quotations/deleteinvforever/(:num)'] = 'quotations/index/deleteinvforever/$1';
$route['quotations/deletepayment/(:num)'] = 'quotations/index/deletepayment/$1';
$route['quotations/deletepaymentforever/(:num)'] = 'quotations/index/deletepaymentforever/$1';
$route['quotations/details/(:num)'] = 'quotations/index/details/$1';
$route['quotations/toinvoice/(:num)'] = 'quotations/index/toinvoice/$1';
$route['quotations/payments/(:num)'] = 'quotations/index/payments/$1';
$route['quotations/modify/(:num)'] = 'quotations/index/modify/$1';
$route['quotations/sourcequotations'] = "quotations/index/sourcequotations";
$route['quotations/sourcequotations/(:any)'] = "quotations/index/sourcequotations/$1";
$route['quotations/sourcequotationsbin'] = "quotations/index/sourcequotationsbin";
$route['quotations/sourcequotationsbin/(:any)'] = "quotations/index/sourcequotationsbin/$1";
$route['quotations/sourcetransactions'] = "quotations/index/sourcetransactions";
$route['quotations/sourcetransactionsbin'] = "quotations/index/sourcetransactionsbin";
$route['quotations/transactions'] = 'quotations/index/transactions';
$route['quotations/postpayment/(:num)'] = 'quotations/index/postpayment/$1';
$route['quotations/restorepayment/(:num)'] = 'quotations/index/restorepayment/$1';
$route['quotations/restoreinv/(:num)'] = 'quotations/index/restoreinv/$1';



//Task Manager Module
$route['task'] = 'task/index';
$route['selftask'] = 'task/index/selftask';
$route['task/create'] = 'task/index/create';
$route['task/mytask'] = 'task/index/mytask';
$route['projects'] = 'task/projects';
$route['projects/finished'] = 'task/projects/finished';
$route['projects/ongoing'] = 'task/projects/ongoing';
$route['calendar'] = 'calendar/index';

$route['mailing'] = 'mailing/index';
$route['mailing/read/(:any)/(:num)'] = 'mailing/index/read/$1/$1';
$route['mailing/mailbox/(:any)'] = 'mailing/index/mailbox/$1';

// --Clock Manager----//
$route['clock'] = 'clock/index';
$route['projects'] = 'task/projects';
$route['calendar'] = 'calendar/index';


//Freight Forwarding
$route['freight'] = 'freight/index';
$route['freight/create'] = 'freight/index/create';
$route['freight/importers'] = 'freight/index/importers';
$route['freight/exporters'] = 'freight/index/exporters';
$route['freight/importers/details/(:num)'] = 'freight/index/importer_details/$1';
$route['freight/exporters/details/(:num)'] = 'freight/index/exporter_details/$1';
$route['freight/documents/(:num)'] = 'freight/index/documents/$1';
$route['freight/settings'] = 'freight/index/settings';
$route['freight/addcountry'] = 'freight/index/addcountry';
$route['freight/addcategory'] = 'freight/index/addcategory';
$route['freight/addplan'] = 'freight/index/addplan';
$route['freight/edit/(:num)'] = 'freight/index/editfreight/$1';
$route['freight/details/(:num)'] = 'freight/index/freight_details/$1';
$route['freight/debitnote/(:num)'] = 'freight/index/debit_note/$1';
$route['freight/stages/(:num)'] = 'freight/index/stages/$1';
$route['freight/quotations/(:num)'] = 'freight/index/quotations/$1';
$route['freight/quotation/create/(:num)'] = 'freight/index/create_quotation/$1';
$route['freight/invoices/(:num)'] = 'freight/index/invoices/$1';
$route['freight/invoice/create/(:num)'] = 'freight/index/create_invoice/$1';
$route['request/myrequest'] = 'freight/request/myrequest';
$route['freight/assessment/(:num)'] = 'freight/index/loadAssessment/$1';
$route['freight/documentation/(:num)'] = 'freight/index/loadDocumentation/$1';
$route['freight/import_permit/(:num)'] = 'freight/index/loadImportPermit/$1';
$route['freight/payment_duty/(:num)'] = 'freight/index/loadPaymentDuty/$1';
$route['freight/shipping_line/(:num)'] = 'freight/index/loadShippingLine/$1';
$route['freight/verification_physical/(:num)'] = 'freight/index/loadVerificationPhysical/$1';
$route['freight/port_charges/(:num)'] = 'freight/index/loadPortCharges/$1';
$route['freight/release_container/(:num)'] = 'freight/index/loadReleaseContainer/$1';
$route['freight/delivery_note/(:num)'] = 'freight/index/loadDeliveryNote/$1';
$route['freight/delivery_consignee/(:num)'] = 'freight/index/loadDeliveryConsignee/$1';
$route['freight/received_interchange/(:num)'] = 'freight/index/loadReceivedInterchange/$1';
$route['freight/freight_task/(:num)'] = 'freight/index/loadTaskFreight/$1';