<?php

/**
 * Description of Dashboard
 * 
 * @author Kelvin Benard
 */
class Activities extends MY_Controller{

    public  $pagedata;

    public function __construct() {
        parent::__construct();
        ( $this->require_role('employee'));
        $this->load->model(array('ActivitiesModel'=>'activitiesModel'));
    }

    public function index() {
        $this->load->helper(array('form','activities'));
        $this->pagedata['link']= 'activites';
        $this->pagedata['title'] = 'Activities | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('employee/activities/activities');
    }

    function appstoapprove($me){
      if($me !== $this->auth_user_id)
      exit('Your identity is not recognized');
      $todayapprove = $this->activitiesModel->applicationsToApprove();
        if(!empty($todayapprove)){?>
        <div class="col-sm-12">
          <!--begin:: Widgets/Tasks -->
          <div class="kt-portlets kt-portlet--tabs kt-portlet--height-fluid">
            <div class="kt-portlet__body kt-portlet__body--fit">
              <h5 class="margin-b-20" style="margin-top:-20px; margin-bottom:15px;">
                Loans to Approve
              </h5>
              <div class="kt-widget2">
                <?php
                  foreach ($todayapprove as $key => $today) {?>
                    <div class="kt-widget2__item kt-widget2__item--primary">
                      <div class="kt-widget2__checkbox">
                        <label class="kt-checkbox kt-checkbox--solid kt-checkbox--single">
                          <input type="checkbox">
                          <span></span>
                        </label>
                      </div>
                      <div class="kt-widget2__info">
                        <a href="javascript:approve('<?php echo $this->auth_user_id;?>','<?php echo $today['app_approver_id'];?>',1);" class="kt-widget2__title">
                          <b>Customer: <?php echo ucwords(strtolower(profile($today['app_customer'])->firstname.' '.profile($today['app_customer'])->lastname)).' '.profile($today['app_customer'])->phonenumber;?></b>
                        </a>
                        <a href="javascript:approve('<?php echo $this->auth_user_id;?>','<?php echo $today['app_approver_id'];?>',1);" class="kt-widget2__username">
                          Principal & Interest:  <?php echo runnCurrency()->currency_symbol.''.number_format(to_money($this->loansModel->applicationTotalPrincipal($today['app_key']))).' '.runnCurrency()->currency_symbol.''.number_format(to_money($this->loansModel->applicationTotalInterest($today['app_key'])));?>
                        </a>
                        <a href="javascript:approve('<?php echo $this->auth_user_id;?>','<?php echo $today['app_approver_id'];?>',1);" class="kt-widget2__username">
                          By <?php echo profile($today['app_registra'])->firstname.' '.profile($today['app_registra'])->lastname.' | <b>'.date('Y M d H:i:s',strtotime($today['app_date']))?></b>
                        </a>
                      </div>
                      <div class="kt-widget2__actions">
                        <a href="#" class="btn btn-info btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                          <i class="flaticon-more-1"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-fit dropdown-menu-right">
                          <ul class="kt-nav">
                            <li class="kt-nav__item">
                              <a href="<?php echo base_url($this->auth_role.'/loans/applications/details/'.$today['app_key']);?>" class="kt-nav__link">
                                <i class="kt-nav__link-icon flaticon2-send"></i>
                                <span class="kt-nav__link-text">View Details</span>
                              </a>
                            </li>
                            <li class="kt-nav__item">
                              <a href="javascript:approve('<?php echo $this->auth_user_id;?>',<?php echo $today['app_approver_id'];?>,1);" class="kt-nav__link">
                                <i class="kt-nav__link-icon flaticon2-send"></i>
                                <span class="kt-nav__link-text">Approve</span>
                              </a>
                            </li>
                              <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link">
                                  <i class="kt-nav__link-icon flaticon2-line-chart"></i>
                                  <span class="kt-nav__link-text">Approve Sellected</span>
                                </a>
                              </li>
                          </ul>
                        </div>
                      </div>
                    </div>
                  <?php }; ?>
              </div>
            </div>
          </div>
        </div>
      <?php }
    }


}
