<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Ajax
 *
 * @author Sarah Bigambalaye
 */
class Ajax extends MY_Controller {
    public  $appdata;

    public function __construct() {
        parent::__construct();

        ( $this->require_min_level(1));

        // $this->load->model (array('admin_model'=>'model','app_model'=>'appmodel','stocksModel'));
        // $this->load->helper('admin');
    }
    
    function push(){
            $data['role_action'] = "freight_view_all";
            $data['title'] = "New message received from ";
            $data['link']= base_url('communication');
            $data['content'] = "You have got new message";
            $data['sender'] = "sender";
            $data['type'] = 'messages';
            $data['target'] = 'system';
            $data['receiver'] = 'system'; // $inbox['receiver_id'];
            $data['time'] = date("H:i:s");
            publishEventFlash('notification', $data);
    }

    public function getcategories($key){
        $categories = $this->model->categories_get_by_class($key);
        print "<option></option>";
        if(!empty($categories)):
        foreach ($categories as $vars): ?>
        <option value="<?php echo $vars['category_key'];?>" >
            <?php echo $vars['category_name'];?>
        </option>
        <?php
        endforeach;
        endif;
    }

    public function gettypes($key){
        $types = $this->model->types_get_by_category($key);

        if(!empty($types)):
        foreach ($types as $vars): ?>
        <option value="<?php echo $vars['type_key'];?>" >
            <?php echo $vars['type_name'];?>
        </option>
        <?php
        endforeach;
        endif;
    }

    public function getProducts($data){
        $product = $this->model->product_get_search_details($data);
        if(!empty($product))
        {
            $data .= '
             <div class="table-responsive">
              <table class="table table bordered">
               <tr>
                    <th>Name</th>
                    <th>Class</th>
                    <th>Category</th>
                    <th>Type</th>
                    <th>Action</th>
               </tr>
            ';
        foreach ($product as $var)
        {
        $data .= '
         <tr>
          <td>'.$var['name'].'</td>
          <td>'.$var['class_name'].'</td>
          <td>'.$var['category_name'].'</td>
          <td>'.$var['type_name'].'</td>
          <td><a href="'.base_url("admin/stocks/stockpurchaseitem").'/'.$var["product_key"].'">Select </a></td>
         </tr>
        ';
        }
           echo $data;
       }
       else
       {
            echo 'Product Not Found';
       }

    }

    public function getProductForOrder($data){
        $product = $this->model->product_get_search_details($data);
        if(!empty($product))
        {
            $data .= '
             <div class="table-responsive">
              <table class="table table bordered">
               <tr>
                    <th>Name</th>
                    <th>Class</th>
                    <th>Category</th>
                    <th>Type</th>
                    <th>Action</th>
               </tr>
            ';
        foreach ($product as $var)
        {
        $data .= '
         <tr>
          <td>'.$var['name'].'</td>
          <td>'.$var['class_name'].'</td>
          <td>'.$var['category_name'].'</td>
          <td>'.$var['type_name'].'</td>
          <td><a href="'.base_url("admin/stocks/stockpurchaseitem").'/'.$var["product_key"].'">Select </a></td>
         </tr>
        ';
        }
           echo $data;
       }
       else
       {
            echo 'Product Not Found';
       }

    }

    public function gettransaction($key=null){
    $transaction = $this->model->product_get_price_detail($key);
    $data['price'] = $transaction->price;
    $data['cost'] = $this->model->product_buying_price($key);
      print json_encode($data);
    }

    public function pos_receipt() {
        $this->load->library('cart');
        $data = $this->cart->cart_contents();
    }

public function cart_content(){
      $this->load->library('cart');

      if( ! empty($this->input->get('product_key'))){
        $data = array(
                    'id'      => (int)$this->input->get('product_key'),
                    'qty'     => (float)$this->input->get('quantity'),
                    'price'   => (float)$this->input->get('price'),
                    'units' => $this->stocksModel->product($this->input->get('product_key'))->units,
                    'name'    => $this->stocksModel->product($this->input->get('product_key'))->name
                  );

        $this->cart->insert($data);

      }

   $this->cart_content_data();
   $this->update_script();
 }

 
 
public function cart_update(){
    $this->load->library('cart');

    $data['rowid'] = $this->input->get('id');
    $data['price'] =  $this->input->get('price');
    $data['qty'] =  $this->input->get('qty');        

    $this->cart->update($data);

   $this->cart_content_data();
   $this->update_script();
 }


public function cart_delete_row($rowid=''){
   $this->load->library('cart');

    $this->cart->remove($rowid);

   $this->cart_content_data();
   $this->update_script();
 }

public function cart_content_data(){
  $this->load->helper('form');?>

      <table  class="table table-striped table-bordered" style="width:100%" border="0">

        <tr>
                <th>Item Description</th>
                <th>QTY</th>
                <th style="text-align:right">Item Price</th>
                <th style="text-align:right">Sub-Total</th>
        </tr>

        <?php $i = 1; ?>

        <?php foreach ($this->cart->contents() as $items): ?>

                <?php echo form_hidden($i.'[rowid]', $items['rowid']); ?>

                <tr>
                        <td>
                                <?php echo $items['name']; ?>
                                <a  href="javascript:(0);" class="deleteRow text-danger" size="4" data-rowid='<?php echo $items['rowid'];?>' ><b>x</b></a>
                        </td>

                        <td>
                          <input name="<?php echo $i.'[qty]';?>" value='<?php echo $items['qty'];?>' class="updateqty" size="4" data-rowid='<?php echo $items['rowid'];?>' />
                        </td>
                        <td style="text-align:right"><?php echo number_format($items['price']); ?></td>
                        <td style="text-align:right"><?php echo number_format($items['subtotal']); ?></td> 
                </tr>

        <?php $i++; ?>

        <?php endforeach; ?>

        <tr>
                <td colspan="2"> </td>
                <td style="text-align:right"><strong>Total</strong></td>
                <td style="text-align:right"><?php echo number_format($this->cart->total()); ?></td>
        </tr>

        </table>
        <?php
}



public function poscontent(){
    $this->load->library('cart');?>
        <table  class="table table-striped table-bordered" style="width:100%" border="0">
            <tr>
                    <th>Product</th>
                    <th>QTY</th>
                    <th style="text-align:right">Price</th>
                    <th style="text-align:right">Total</th>
            </tr>

            <?php $i = 1; ?>

            <?php foreach ($this->cart->contents() as $items): ?>
                     <tr>
                            <td>
                                    <?php echo $items['name']; ?>
                                    <a  href="javascript:(0);" class="deleteRow text-danger" size="4" data-rowid='<?php echo $items['rowid'];?>' ><b>x</b></a>
                            </td>

                            <td>
                                <a  data-rowid='<?php echo $items['rowid'];?>' data-key="<?php echo $items['id'];?>" data-toggle="modal" data-backdrop="static" href="#productDetails" data-price='<?php echo $items['price'];?>' data-total='<?php echo $items['subtotal'];?>' data-qty='<?php echo $items['qty'];?>'><?php echo $items['qty'];?></a>
                            </td>
                            <td style="text-align:right">
                                <a data-rowid='<?php echo $items['rowid'];?>' data-key="<?php echo $items['id'];?>" data-toggle="modal" data-backdrop="static" href="#productDetails" data-price='<?php echo $items['price'];?>' data-total='<?php echo $items['subtotal'];?>' data-qty='<?php echo $items['qty'];?>'><?php echo $items['price'];?></a></td>
                            <td style="text-align:right"><?php echo number_format($items['subtotal']); ?></td>
                    </tr>

            <?php $i++; ?>

            <?php endforeach; ?>
            </table>
        <?php $this->pos_scripts();
}

public function posreceipt() {
        $this->load->library('cart');
        $configs= $this->app_model->loadConfigs();
        $total = $this->cart->total();
            $tax = $this->model->get_class_total_tax($configs->config_pos_tax_class);
            $taxValue = $total * $tax;
            if($configs->config_pos_tax_mode){
                $beforeTax =  $total- $taxValue;
            }else{
                $beforeTax = $total;
                $total = $total + $taxValue;
            }
        ?>

        <table class="table table-striped">
            <tr>
                <th>Cashier</th>
                <th><?php echo ucwords(strtolower(profile()->firstname.' '.profile()->lastname));?></th>
            </tr>
            <?php

            if($configs->config_show_tax_receipt){?> <tr>
                 <td>Tax</td>
                 <td><?php echo number_format(round($taxValue,2));?></td>
             </tr>
             <tr>
                 <td>Before Tax</td>
                 <td><?php echo number_format($beforeTax);?></td>
            </tr> <?php } ?>
              <tr>
                <td>Total</td>
                <td><?php echo number_format(round($total,2));?> <input type="hidden" id="input-total" value="<?php echo $total;?>" /></td>
            </tr>
            <tr>
                <td>Cash</td>
                <td id="cash"><?php echo number_format(round($total,2));?></td>
            </tr>
            <tr>
                <td>Change</td>
                <td id="change">0</td>
            </tr>
        </table>
       <form id="sale-form">
            <input type="hidden" id="paid" name="paid" />
            <input class="form-control cal-change" placeholder="Enter Cash" /><br/>
            <label>Payment Method</label>
            <?php payment_methods();?><br/><br/>
            <label>Delivery Method</label>
            <?php delivery_methods();?>
            <div class="modal fade" id="delivery-methods" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-md" role="document">
                  <div class="modal-content">
                      <div class="modal-body" id="modalview">
                          <center><h3>Delivery Information</h3></center>
                          <br/>
                              <select style="width:100%" readonly name="receipt_delivery_driver" id="drivers" class="form-control">
                                  <option></option>
                                  <?php if(!empty($suppliers = $this->admin_model->driver_get_details())){
                                  foreach($suppliers as $driver){?>
                                      <option value="<?php echo $driver['user_id'];?>"><?php echo $driver['firstname'].' '.$driver['lastname'];?></option>
                                  <?php }
                              } ?>
                              </select><br/><br/>
                            <select style="width:100%" readonly name="receipt_delivery_truck" id="trucks" class="form-control">
                                  <option></option>
                                  <?php if(!empty($trucks = $this->admin_model->truck_get_details())){
                                  foreach($trucks as $truck){?>
                                      <option   value="<?php echo $truck['truck_plate_number'];?>"><?php echo $truck['truck_name'];?></option>
                                  <?php }
                              } ?>
                              </select>
                      </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        Save
                      </button>
                    </div>
                  </div>
                </div>
              </div>
        </form>
        <script>
              $( function(){
      $('select#method').select2({placeholder:'Select payment method'});
      $('select#trucks').select2({placeholder:'Select trucks'});
      $('select#drivers').select2({placeholder:'Select driver'});
      $('select#dmethods').select2({placeholder:'Select delivery method'});
      $('select#method').select2({placeholder:'Select payment method'});
      $("button#process-sell").click( function(e){
            e.preventDefault();            
            var customer = $('#customerkey').data('key');  
            var method = $('select#method').val();
            if(method == '' || method == undefined){
                swal('Payment method missing','You must select payment method','warning');
                return;
            }
            if(customer == '' || customer == undefined){
                swal('Missing customer','You must choose either existing customer or register new one','warning');
                return;
            }
           
            var data = $('form#sale-form').serialize();
            $.ajax({
                url: '<?php echo base_url('admin/ajax/processsell?receipt_customer=');?>'+customer+'&receipt_pay_method='+method,
                data: data,
                beforeSend: function(){
                    mApp.blockPage({overlayColor:"#000000",type:"loader",state:"primary",message:"Processing..."})
                },
                success: function(r){
                    update_pos_content();
                    update_pos_receipt();
                    mApp.unblockPage()
                    if(r == 'ok'){
                      swal('Successfull','Sell processed','info');
                    }else{
                      swal('Failed',r,'error');
                    }

                },
                error: function(er){
                    mApp.unblockPage();
                    swal('An error occured',er.status + ' ' + er.statusText,'error');
                }
            });
        });
     $('select#dmethods').change( function(){
        var val =  $( this ).val();
        if(val == 'custom'){
         $("div#delivery-methods").modal('show');         
            }else{
            $('select#drivers').val('')   
            $('select#trucks').val('')
        }
    })
        $("input.cal-change").keyup( function(){
            var total = $('input#input-total').val();
            var val = $( this ).val();
            var change = Math.round(val-total);
           /* if(change < 0){
                $("button#process-sell").attr('disabled','disabled');
                }else{
                $("button#process-sell").removeAttr('disabled');
            }*/
            $('input#paid').val(val);
            $('td#cash').text(val);
            $('td#change').text(change);
            if(val == ''){
                $('td#change').text('');
                 $('input#paid').val(0);
            }
        });
        $("button#cancel-sell").click( function(){
                distroy_cart();
            });
  });</script>
            
   <?php $this->pos_receipt_scripts();
   }

public function destroycart() {
    $this->load->library('cart');
    $this->cart->destroy();
}

public function update_script(){?>
    <script>

        $(".updateqty").change( function(){
            var rowid = $( this ).data('rowid');
            var qty = $( this ).val();
            var data = 'id='+ rowid + '&quantity= ' + qty;
            $.ajax({
                url: '<?php echo base_url('admin/ajax/cart_update');?>',
                data: data,
                beforeSend: function(){
                    mApp.block("#cart-content",{
                                          overlayColor:"#000000",
                                          type:"loader",
                                          state:"warning",
                                          message:"Updating cart ..."
                                      });
                },
                success: function(r){
                    update_pos_receipt();
                    update_pos_content();
                    mApp.unblock('#cart-content');
                },
                error : function(){
                    mApp.unblock('#cart-content');
                }
            })
        });

        $(".deleteRow").each (function(){
           $(this).click(function(){
              var row = $(this).data('rowid');
              swal({
                  title:"Are you sure?",
                  text:"You won't be able to revert this!",
                  type:"warning",
                  confirmButtonClass: "btn-danger btn",
                  showCancelButton:!0,
                  confirmButtonText: "Yes, Delete it",
              }).then(function(e){
                  if(e.value){
                      $.ajax({
                          url: '<?php echo base_url('admin/ajax/cart_delete_row');?>' + '/' + row,
                          type: 'get',
                          beforeSend: function(){
                              mApp.block("#cart-content",{
                                      overlayColor:"#000000",
                                      type:"loader",
                                      state:"danger",
                                      message:"Updating cart ...."
                                  });
                            },
                           success: function(r){
                                update_pos_receipt();
                                update_pos_content();
                                mApp.unblock('#cart-content');
                               },
                            error: function(){
                                mApp.unblock('#cart-content');
                                }
                      });
                  }
              });
           });
        });
         function update_pos_receipt(){
            $.ajax({
               url: '<?php echo base_url('admin/sales/posreceipt');?>',
               success: function(r){
                   $("#sales-receipt").html(r);
               }
            });
           }
    </script>
   <?php }

public function pos_scripts(){?>
    <script>

        $(".updateqty").change( function(){
            var rowid = $( this ).data('rowid');
            var qty = $( this ).val();
            var data = 'id='+ rowid + '&quantity= ' + qty;
            $.ajax({
                url: '<?php echo base_url('admin/ajax/cart_update');?>',
                data: data,
                beforeSend: function(){
                    mApp.block("#cart-content",{
                                          overlayColor:"#000000",
                                          type:"loader",
                                          state:"warning",
                                          message:"Updating cart ..."
                                      });
                },
                success: function(r){
                    update_pos_receipt();
                    update_pos_content();
                    mApp.unblock('#cart-content');
                },
                error : function(){
                    mApp.unblock('#cart-content');
                }
            })
        });

        $(".deleteRow").each (function(){
           $(this).click(function(){
              var row = $(this).data('rowid');
              swal({
                  title:"Are you sure?",
                  text:"You won't be able to revert this!",
                  type:"warning",
                  confirmButtonClass: "btn-danger btn",
                  showCancelButton:!0,
                  confirmButtonText: "Yes, Delete it",
              }).then(function(e){
                  if(e.value){
                      $.ajax({
                          url: '<?php echo base_url('admin/ajax/cart_delete_row');?>' + '/' + row,
                          type: 'get',
                          beforeSend: function(){
                              mApp.block("#cart-content",{
                                      overlayColor:"#000000",
                                      type:"loader",
                                      state:"danger",
                                      message:"Updating cart ...."
                                  });
                            },
                           success: function(r){
                                update_pos_receipt();
                                update_pos_content();
                                mApp.unblock('#cart-content');
                               },
                            error: function(){
                                mApp.unblock('#cart-content');
                                }
                      });
                  }
              });
           });
        });

        function update_pos_receipt(){
                $.ajax({
                   url: '<?php echo base_url('admin/ajax/posreceipt');?>',
                   success: function(r){
                       $("#sales-receipt").html(r);
                   }
                });
               }

        function update_pos_content(){
         $.ajax({
            url: '<?php echo base_url('admin/ajax/poscontent');?>',
            success: function(r){
                $("#cart-content").html(r);
            }
         });
        }

    </script>
   <?php }

public function pos_receipt_scripts() {?>
    <script>
    $( function(){
      $('select#method').select2({placeholder:'Select payment method'});
      $('select#trucks').select2({placeholder:'Select trucks'});
      $('select#drivers').select2({placeholder:'Select driver'});
      $('select#dmethods').select2({placeholder:'Select delivery method'});
      $('select#method').select2({placeholder:'Select payment method'});
      $("button#process-sell").click( function(e){
            e.preventDefault();            
            var customer = $('#customerkey').data('key');  
            var method = $('select#method').val();
            if(method == '' || method == undefined){
                swal('Payment method missing','You must select payment method','warning');
                return;
            }
            if(customer == '' || customer == undefined){
                swal('Missing customer','You must choose either existing customer or register new one','warning');
                return;
            }
           
            var data = $('form#sale-form').serialize();
            $.ajax({
                url: '<?php echo base_url('admin/ajax/processsell?receipt_customer=');?>'+customer+'&receipt_pay_method='+method,
                data: data,
                beforeSend: function(){
                    mApp.blockPage({overlayColor:"#000000",type:"loader",state:"primary",message:"Processing..."})
                },
                success: function(r){
                    update_pos_content();
                    update_pos_receipt();
                    mApp.unblockPage()
                    if(r == 'ok'){
                      swal('Successfull','Sell processed','info');
                    }else{
                      swal('Failed',r,'error');
                    }

                },
                error: function(er){
                    mApp.unblockPage();
                    swal('An error occured',er.status + ' ' + er.statusText,'error');
                }
            });
        });
     $('select#dmethods').change( function(){
        var val =  $( this ).val();
        if(val == 'custom'){
         $("div#delivery-methods").modal('show');         
            }else{
            $('select#drivers').val('')   
            $('select#trucks').val('')
        }
    })
        $("input.cal-change").keyup( function(){
            var total = $('input#input-total').val();
            var val = $( this ).val();
            var change = Math.round(val-total);
           /* if(change < 0){
                $("button#process-sell").attr('disabled','disabled');
                }else{
                $("button#process-sell").removeAttr('disabled');
            }*/
            $('input#paid').val(val);
            $('td#cash').text(val);
            $('td#change').text(change);
            if(val == ''){
                $('td#change').text('');
                 $('input#paid').val(0);
            }
        });
        $("button#cancel-sell").click( function(){
                distroy_cart();
            });
  });
        function distroy_cart(){
            $.ajax({
                   url: '<?php echo base_url('admin/ajax/destroycart');?>',
                   beforeSend: function(){
                       mApp.block("#cart-content",{
                                             overlayColor:"#000000",
                                             type:"loader",
                                             state:"warning",
                                             message:"Cancelling cart ..."
                                         });
                       mApp.block("#sales-receipt",{
                                             overlayColor:"#000000",
                                             type:"loader",
                                             state:"warning"
                                         });
                   },
                   success: function(r){
                       update_pos_content();
                       update_pos_receipt();
                       mApp.unblock('#cart-content');
                       mApp.unblock('#sales-receipt');
                   },
                   error : function(){
                       mApp.unblock('#cart-content');
                       mApp.unblock('#sales-receipt');
                   }
               });
           }
        function update_pos_receipt(){
                $.ajax({
                   url: '<?php echo base_url('admin/ajax/posreceipt');?>',
                   success: function(r){
                       $("#sales-receipt").html(r);
                   }
                });
               }
        function update_pos_content(){
         $.ajax({
            url: '<?php echo base_url('admin/ajax/poscontent');?>',
            success: function(r){
                $("#cart-content").html(r);
            }
         });
        }
    </script>
 <?php }

public function restock() {
     $this->load->library('cart');
     $products = $this->cart->contents();

     foreach ($products as $key => $pro) {
        $user['transaction_key'] = $this->model->get_unused_product_purchase_key();
        $user['product_name'] = $pro['id'];
        $user['cost'] = $pro['price'];
        $user['quantity'] = $pro['qty'];
        $user['total_price'] = $pro['subtotal'];
       $query = " UPDATE sarah_products SET quantity = quantity + ".$pro['qty']." WHERE product_key = ".$pro['id'];
       $this->db->query($query);

       $this->db->insert('product_transactions',$user);
     }
     $this->db->trans_complete();
     if($this->db->trans_status()  === TRUE){
       $this->cart->destroy();
       print 'ok';
     }else{
       print 'no';
     }
 }



    public function receiptcontent($key){
        receipt_header();
      ?>
    <h4>PAYMENT RECEIPT - <?php echo $key;?></h4><br/>
    <table class="table table-striped table-bordered" style="width:100%" border="0">
        <tr>
            <th>Name</th>
            <td><?php echo ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->firstname.' '.profile($this->model->receipt($key)->receipt_customer)->lastname));?></b><br/></td>
        </tr>
        <tr>
            <th>Customer No.</th>
            <td><?php echo profile($this->model->receipt($key)->receipt_customer)->user_id;?></b><br/></td>
        </tr>
        <tr>
            <th>Phone Number</th>
            <td><?php echo ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->phonenumber));?></td>
        </tr>
        <tr>
            <th>Email</th>
            <td><?php echo ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->email));?></td>
        </tr>        
        <tr>
            <th>Address</th>
            <td><?php echo ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->primary_address));?></td>
        </tr>
    </table>
    &nbsp;<?php echo nbs(3);?>&nbsp;
           <table  class="table table-striped table-bordered" style="width:100%" border="0">
          <thead>
            <tr>
              <th>Cashier</th>
              <th colspan="4"><?php echo ucwords(strtolower(profile($this->model->receipt($key)->receipt_cashier)->firstname.' '.profile($this->model->receipt($key)->receipt_cashier)->lastname));?></th>
            </tr>
            <tr>
              <th>Date</th>
              <th colspan="4"><?php echo date('M d-Y',strtotime($this->model->receipt($key)->receipt_date));?></th>
            </tr>
            <tr>
                <th>Product</th>
                <th>Price</th>
                <th>Qty</th>
                <th>Sub Total</th>
            </tr>
          </thead>
          <tbody>
            <?php $tax=0; $total=0; if(! empty($p = $this->model->receipt_products($key))){
              foreach ($p as $pp) {?>
                <tr>
                  <td><?php echo $pp['name'];?></td>
                  <td><?php echo number_format($pp['rd_price']);?></td>
                  <td><?php echo $pp['rd_qty'];?></td>
                  <td><?php echo $pp['rd_total'];?></td>
                </tr>
              <?php $tax += $pp['rd_tax_amount']; $total += $pp['rd_total']; }
            } ?>
             <!--<tr>
              <td colspan="2"></td>
              <th>Paid</th>
              <th><?php echo number_format($this->model->receipt_payments_paid($key))?></th>
            </tr>
            <tr>
              <td colspan="2"></td>
              <th>Due</th>
              <th><?php echo number_format($total-$this->model->receipt_payments_paid($key))?></th>
            </tr>-->
            <tr>
              <td colspan="2"></td>
              <th>Total</th>
              <th><?php echo number_format($total);?></th>
            </tr>
          </tbody>
        </table>
    
    <div class="m-alert__text">
                <strong>
                        Thank you!
                </strong>
                for your business
        </div>
<?php
    }

    public function addliability(){
      $data['li_date'] = date('Y-m-d',strtotime($this->input->get('li_date')));
      $data['li_item'] = $this->input->get('li_item',TRUE);
      $data['li_type'] = $this->input->get('li_type',TRUE);
      $data['li_amount'] = $this->input->get('li_amount',TRUE);
      $data['li_description'] = $this->input->get('li_description',TRUE);
      if($this->model->addliability($data)){
        print 'ok';
      }else{
        print 'no';
      }
    }
    
    
public function processsell() {  
    $this->load->library('cart');
    $this->db->trans_start();
    $customer = $this->input->get('receipt_customer',TRUE);
    
     $total = $this->cart->total();
        if($total>0){
           
            $paid = $this->input->get('paid');
            if($paid > $total){
                print 'You can not receive cashe greater than total sell';
                return;
            }
           
            $configs= $this->app_model->loadConfigs();
            $tax = $this->model->get_class_total_tax($configs->config_pos_tax_class); 
            $taxValue = $total * $tax;
                   if($configs->config_pos_tax_mode){
                       $beforeTax =  $total- $taxValue;
                    }else{
                       $beforeTax = $total;
                       $total = $total + $taxValue;
                   }
                                      
            $products = $this->cart->contents();
            $receipt['receipt_onhold']  = $this->input->get('hold',TRUE);               
            $receipt['receipt_delivery_method'] = $this->input->get('receipt_delivery_method',TRUE);
            
            if($receipt['receipt_delivery_method'] == 'custom'){                
                $receipt['receipt_delivery_driver'] = $this->input->get('receipt_delivery_driver',TRUE);
                $receipt['receipt_delivery_truck'] = $this->input->get('receipt_delivery_truck',TRUE);
            }
            
            $receipt['receipt_pay_method'] = $this->input->get('receipt_pay_method');
            $receipt['receipt_tax_percent'] = $tax;
            $receipt['receipt_tax_amount'] = $taxValue;
            $receipt['receipt_total_before_tax'] = $beforeTax;
            $receipt['receipt_total'] = $total;
            $receipt['receipt_customer'] = $customer;
            $receipt['receipt_cashier'] = config_item('auth_user_id');
            $receipt['receipt_date'] = date('Y-m-d');
            $receipt['receipt_key'] = $this->get_unused_receipt_key();

            $taxcol['col_amount'] = $taxValue;
            $taxcol['col_date'] = $receipt['receipt_date'];
            $taxcol['col_receipt'] = $receipt['receipt_key'];
            $taxcol['col_class_tax'] = $configs->config_pos_tax_class;

            $rd['rd_receipt_key'] = $receipt['receipt_key'];
            $rd['rd_cashier'] = config_item('auth_user_id');
            $rd['rd_customer'] = $receipt['receipt_customer'];
            $rd['rd_date'] = $receipt['receipt_date'];


            $this->db->insert('sales_receipts',$receipt);

            if($paid > 0){
                $this->db->insert('receipt_payments',['payment_receipt'=>$receipt['receipt_key'],'payment_amount'=>$paid,'payment_date'=>date('Y-m-d'),'payment_customer'=>$customer]);
            }
            
            $this->db->insert('tax_collection',$taxcol);

            foreach ($products as $key => $pro) {
              $rdtotal = $pro['subtotal'];
              $rdtaxValue = $rdtotal * $tax;
                     if($configs->config_pos_tax_mode){
                         $rdbeforeTax =  $rdtotal- $taxValue;
                     }else{
                         $rdbeforeTax = $rdtotal;
                         $rdtotal = $rdtotal + $taxValue;
                     }
              $rd['rd_product'] = $pro['id'];
              $rd['rd_price'] = $pro['price'];
              $rd['rd_cost'] = $this->model->product_buying_price($pro['id']);
              $rd['rd_qty'] = $pro['qty'];
              $rd['rd_total'] = $rdtotal;
              $rd['rd_total_before_tax'] = $rdbeforeTax;
              $rd['rd_tax'] = $tax;
              $rd['rd_tax_amount'] = $rdtaxValue;

              $query = " UPDATE sarah_products SET quantity = quantity - ".$pro['qty']." WHERE product_key = ".$pro['id'];
              $this->db->query($query);

              $this->db->insert('receipt_data',$rd);
            }
            $this->db->trans_complete();
            if($this->db->trans_status()  === TRUE){
              $this->cart->destroy();
              $_SESSION['customer'] = NULL;              
              $key = $receipt['receipt_key'];
              $email['recepient'] = shop()->shop_backup_email;
              $email['name'] = profile($customer)->firstname.' '. profile($customer)->lastname;
              $email['subject'] = 'Receipt '.$receipt['receipt_key'];
              $email['message'] = ''
                      . '<center><h2>'. shop()->shop_name.'</h2>
                        <p>'.shop()->shop_tagline.'<br/>
                            Fax: '.shop()->shop_fax.', Mobile: '.shop()->shop_phonenumber.'<br/>
                            '. shop()->shop_location.'<br/>
                        </p>
                        </center><h4>PAYMENT RECEIPT - '.$key.'</h4><br/>'
                      .'<table style="width:100%;" border="0">
                        <tr>
                            <td><b>Name</b></td>
                            <td>'.ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->firstname.' '.profile($this->model->receipt($key)->receipt_customer)->lastname)).'</b><br/></td>
                        </tr>
                        <tr>
                            <td><b>Customer No.</b></td>
                            <td>'. profile($this->model->receipt($key)->receipt_customer)->user_id.'</b><br/></td>
                        </tr>
                        <tr>
                            <td><b>Phone Number</b></td>
                            <td>'.ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->phonenumber)).'</td>
                        </tr>
                        <tr>
                            <td><b>Email</b></td>
                            <td>'.ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->email)).'</td>
                        </tr>        
                        <tr>
                            <td><b>Address</b></td>
                            <td>'.ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->primary_address)).'</td>
                        </tr>                         
                        <tr>
                          <td><b>Cashier</b></td>
                          <td>'. ucwords(strtolower(profile($this->model->receipt($key)->receipt_cashier)->firstname.' '.profile($this->model->receipt($key)->receipt_cashier)->lastname)).'</td>
                        </tr>
                        <tr>
                          <th><b>Date</b></td>
                          <td>'.date('M d-Y',strtotime($this->model->receipt($key)->receipt_date)).'</td>
                        </tr>
                    </table><br/>
                     <table   style="width:100%" border="0">
                            <thead>
                              <tr>
                                  <td><b>Product</b></td>
                                  <td><b>Price</b></td>
                                  <td><b>Qty</b></td>
                                  <td><b>Sub Total</b></td>
                              </tr>
                            </thead>
                            <tbody>';

                             if(! empty($p = $this->model->receipt_products($key))){
                                foreach ($p as $pp) {
                                $email['message'].= '
                                 <tr>
                                    <td> '.$pp['name'].'</td>
                                    <td>'.number_format($pp['rd_price']).'</td>
                                    <td>'.$pp['rd_qty'].'</td>
                                    <td>'.$pp['rd_total'].'</td>
                                  </tr>';
                                  }
                              }

                             $email['message'].= ' 
                              <tr>
                                <td colspan="2"></td>
                                <td><b>Total</b></td>
                                <td><b>'.number_format($receipt['receipt_total']).'</b></td>
                              </tr>
                            </tbody>
                          </table>';
              $this->app_library->send_receipt_email($email);
              print 'ok';
            }else{
              print 'Failed to process sell';
            }
        }else{
            print 'You must choose product to sell';
        }
 }
 
  public function receiptPayment($key){
      receipt_header();
      ?>
    <h4>PAYMENT RECEIPT - <?php echo $key;?></h4><br/>
   <table class="table table-striped table-bordered" style="width:100%" border="0">
        <tr>
            <th>Name</th>
            <td><?php echo ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->firstname.' '.profile($this->model->receipt($key)->receipt_customer)->lastname));?></b><br/></td>
        </tr>
        <tr>
            <th>Customer No.</th>
            <td><?php echo profile($this->model->receipt($key)->receipt_customer)->user_id;?></b><br/></td>
        </tr>
        <tr>
            <th>Phone Number</th>
            <td><?php echo ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->phonenumber));?></td>
        </tr>
        <tr>
            <th>Email</th>
            <td><?php echo ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->email));?></td>
        </tr>        
        <tr>
            <th>Address</th>
            <td><?php echo ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->primary_address));?></td>
        </tr>
    </table>
    &nbsp;<?php echo nbs(3);?>&nbsp;
           <table  class="table table-striped table-bordered" style="width:100%" border="0">
          <thead> 
            <tr>
              <th>Cashier</th>
              <th colspan="4"><?php echo ucwords(strtolower(profile($this->model->receipt($key)->receipt_cashier)->firstname.' '.profile($this->model->receipt($key)->receipt_cashier)->lastname));?></th>
            </tr>
            <tr>
              <th>Date</th>
              <th colspan="4"><?php echo date('M d-Y',strtotime($this->model->receipt($key)->receipt_date));?></th>
            </tr>
            <tr>
                <th>Product</th>
                <th>Price</th>
                <th>Qty</th>
                <th>Sub Total</th>
            </tr>
          </thead>
          <tbody>
            <?php $tax=0; $total=0; 
            if(! empty($p = $this->model->receipt_products($key))){
              foreach ($p as $pp) {?>
                <tr>
                  <td><?php echo $pp['product_name'];?></td>
                  <td><?php echo number_format($pp['sale_price']);?></td>
                  <td><?php echo $pp['sale_quantity'];?></td>
                  <td><?php echo $pp['sale_total'];?></td>
                </tr>
              <?php  $total += $pp['sale_total']; }
            } ?>
             <tr>
              <td colspan="2"></td>
              <th>Paid</th>
              <th><?php echo number_format($this->model->receipt_payments_paid($key))?></th>
            </tr>
            <tr>
              <td colspan="2"></td>
              <th>Due</th>
              <th><?php echo number_format($total-$this->model->receipt_payments_paid($key))?></th>
            </tr>
            <tr>
              <td colspan="2"></td>
              <th>Total</th>
              <th><?php echo number_format($total);?></th>
            </tr>
          </tbody>
        </table>
    <!--<div class="row">
        <div class="col-sm-6">
            <input type="number" id="payment_amount" class="form-control" placeholder="Enter amount to receive" />
        </div>
        <div class="col-md-6">
            <select style="width:100%;" required name="receipt_pay_method" class="form-control" id="method">
                <option></option>
                <option value="Cash">Cash</option>
                <option value="Mobile">Mobile</option>
                <option value="Bank">Bank</option>
            </select>
        </div>
    </div>-->
    
        <input type="hidden" id="receipt_key" value="<?php echo $key;?>" />
        <input type="hidden" id="customer" value="<?php echo $this->model->receipt($key)->receipt_customer;?>" /
        <input type="hidden" id="max_amount" value="<?php echo $total-$this->model->receipt_payments_paid($key);?>" />
        <script>
          $('select#method').select2({placeholder:'Select payment method'});
          </script>
<?php
    }
 
    public function receiptHistory($key){
        receipt_header();
      ?>
    &nbsp;<?php echo nbs(3);?>&nbsp;
           <table class="table table-striped table-bordered" style="width:100%" border="0">
                <tr>
                    <th>Name</th>
                    <td><?php echo ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->firstname.' '.profile($this->model->receipt($key)->receipt_customer)->lastname));?></b><br/></td>
                </tr>
                <tr>
                    <th>Customer No.</th>
                    <td><?php echo profile($this->model->receipt($key)->receipt_customer)->user_id;?></b><br/></td>
                </tr>
                <tr>
                    <th>Phone Number</th>
                    <td><?php echo ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->phonenumber));?></td>
                </tr>
                <tr>
                    <th>Email</th>
                    <td><?php echo ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->email));?></td>
                </tr>        
                <tr>
                    <th>Address</th>
                    <td><?php echo ucwords(strtolower(profile($this->model->receipt($key)->receipt_customer)->primary_address));?></td>
                </tr>
            </table>
          <table  class="table table-striped table-bordered" style="width:100%" border="0">
              <tr>
                  <td colspan="2">Payments</td>
              </tr>
              <tr>
                  <td>Date</td>
                  <td>Amount</td>
              </tr>
                    <?php if(! empty($p = $this->model->receipt_payments($key))){
                      foreach ($p as $pp) {?>
                        <tr>
                            <td><?php echo date('d-M-Y', strtotime($pp['payment_date']));?></td>
                          <td><?php echo number_format($pp['payment_amount']);?></td>
                        </tr>
                      <?php  }
                    } ?>
          </table>
        <table  class="table table-striped table-bordered" style="width:100%" border="0">
                 <tr>
                  <td colspan="2">Summary</td>
              </tr>
             <tr>
              <th>Paid</th>
              <th><?php echo number_format($this->model->receipt_payments_paid($key))?></th>
            </tr>
            <tr>
              <th>Due</th>
              <th><?php echo number_format($this->model->receipt($key)->receipt_total-$this->model->receipt_payments_paid($key))?></th>
            </tr>
            <tr>
              <th>Total</th>
              <th><?php echo number_format($this->model->receipt($key)->receipt_total);?></th>
            </tr>
        </table>
<?php
    }
    
   public function receivePayment(){
        $amount = $this->input->get('amount');
        $method = $this->input->get('method');
        $customer = $this->input->get('customer');
        $key = $this->input->get('key');
        $receipt = $this->model->receipt($key);
        $due = $receipt->receipt_total - $this->model->receipt_payments_paid($key);
        if($amount > $due){
            print 'no';
        }else{
            
            if(!empty($key) & $amount > 0 & $method !=''){
                $this->db->insert('receipt_payments',['payment_receipt'=>$key,'payment_amount'=>$amount,'payment_date'=>date('Y-m-d'),'payment_customer'=>$customer,'receipt_pay_method'=>$method]);
                if($this->db->affected_rows()>0){
                    print 'ok';
                }else{
                    print 'no';
                }
            }else{
                print 'no';
            }
        }
    }
  
   
   
     public function productSellInfo($key,$price='',$qty='',$total='',$rowid='') { 
        $product = $this->stocksModel->product($key);?>
    <h4>Product Details</h4> <br/>
    <form id="productDetails" onsubmit="cartAdd(); return false;">
        <input type="hidden" name="product_key" id="product_key" value="<?php echo $key;?>" />
        <input type="hidden"  id="cat-edit" value="<?php echo $price;?>" />
        <input type="hidden"  id="rowid" value="<?php if($total != 'undefined') echo $rowid;?>" />
    <table class="table table-borderless">
        <tr>
            <th>Name</th>
            <td><?php echo $product->name;?></td>
        </tr>
        <tr>
            <th>Category</th>
            <td><?php echo $this->model->categories_get_single_detail($product->product_category_key)->category_name;?>
            </td>
        </tr> 
         <tr>
            <th>Purchasing Price</th>
            <td>
                <input required autofocus autocomplete="off" type="text" name="cost" id="cost" placeholder="Cost" class="form-control" />
            </td>
        </tr>
        <tr>
            <th>Quantity</th>
            <td><input required autocomplete="off" class="form-control" name="qty" id="qty" value="<?php if($qty != 'undefined') echo $qty;?>" placeholder="Quantity" /></td>
        </tr>
         <tr>
            <th>Total</th>
            <td><input required readonly class="form-control" id="total" value="<?php if($total != 'undefined') echo $total;?>" placeholder="Total" /></td>
        </tr>
       
          <tr>
              <th colspan="2"><center>Selling Price</center></th>
        </tr>
        <tr>
            <th>Retail Price</th>
            <td>
                <input required type="text" class="form-control" name="retail_price" value="<?php echo $product->retail_price;?>" placeholder="Retail Price" />
            </td>
        </tr>
        <tr>
            <th>Agent Price</th>
            <td>
                <input required type="text" class="form-control" name="agent_price" value="<?php echo $product->agent_price;?>" placeholder="Agent Price" />
            </td>
        </tr>
        <tr>
            <th>WholeSale Price</th>
            <td>
                <input required type="text" class="form-control" name="wholesale_price" value="<?php echo $product->wholesale_price;?>" placeholder="Wholesale Price" />
            </td>
        </tr>
    </table>
        <div class="row">
            <div class="col-md-6"><button data-dismiss="modal" class="btn btn-dark btn-block" type="button">dismiss</button></div>  
            <div class="col-md-6"><button class="btn btn-accent btn-block" type="submit">save</button></div>          
        </div>
    </form>
    <script>
        $('input#cost').focus();
        $('input#qty').keyup( function(){
            var $this = $( this );
            var $qty = $('input#cost').val();
            var $price = $this.val();
            var $total = $price * $qty;
            $('input#total').val($total);
        });
        
        $('input#cost').keyup( function(){
            var $this = $( this );
            var $qty = $('input#qty').val();
            var $price = $this.val();
            var $total = $price * $qty;
            $('input#total').val($total);
        });
    </script>
    <?php }
    
    
    
    
    
    public function productSellInfo_order($key,$qty='',$rowid='') { 
    $product = $this->stocksModel->product($key);?>
    <h4>Product Details</h4> <br/>
    <form id="productDetails" method="post" onsubmit="addtocart(); return false;">
        <input type="hidden"  id="product_key" value="<?php echo $key;?>" />
        <!--<input type="hidden"  id="cat-edit" value="<?php echo $price;?>" />-->
        <input type="hidden"  id="rowid" value="<?php if($rowid != 'undefined') echo $rowid;?>" />
    <table class="table table-borderless">
        <tr>
            <th>Name</th>
            <td><?php echo $product->name;?></td>
        </tr>
        <tr>
            <th>Category</th>
            <td><?php echo $this->model->categories_get_single_detail($product->product_category_key)->category_name;?>
            </td>
        </tr> 
        <tr>
            <th>Quantity</th>
            <td><input autofocus class="form-control" name="qty" id="qty" value="<?php if($qty != 'undefined') echo $qty;?>" placeholder="Quantity" /></td>
        </tr>
        <tr>
    </table>
        <div class="row">
            <div class="col-md-6"><button data-dismiss="modal" class="btn btn-dark btn-block" type="button">dismiss</button></div>  
            <div class="col-md-6"><button class="btn btn-accent btn-block" type="submit">save</button></div>          
        </div>
    </form>
    <?php }
    
   function addcustomer(){
       $this->load->library('admin_library');
            $user['firstname'] = $this->input->get('firstname', TRUE);
            $user['lastname'] = $this->input->get('lastname', TRUE);
            $user['phonenumber'] = $this->input->get('phonenumber', TRUE);
            $user['email'] = $this->input->get('email', TRUE);
            $user['primary_address'] = $this->input->get('primary_address', TRUE);
            $user['auth_level'] = 3;
            $user['position'] = 'customer';
            $user['user_id'] = $this->appmodel->get_unused_id();
            $user['created_at'] = date('Y-m-d H:i:s');
               
            if($this->model->user_create($user)){
                    $data['status']= 'ok';
                    $data['message'] = $user['user_id'];
            }else{
                    $data['status']= 'fail';
                    $data['message'] = 'Failed to register customer';
               };
                
           print json_encode($data);
   }   
   
   function customersellinfo($key){
       $customer = profile($key);?>
        <div class="row">
            <div class="col-sm-10 m--marginless">
                <a href="#customerSummary" data-toggle="modal" data-backdrop="static" data-key="<?php echo $_SESSION['customer'];?>" id="customerkey"><b><?php echo $customer->firstname.' '.$customer->lastname;?></b></a>
            </div>
        </div>
  <?php $_SESSION['customer']= $key; }
  
  
 /*Sarah Changes begin here
  * --------------------------------------------
  */   
 public function cart_content_order(){
      $this->load->library('cart');

      if( ! empty($this->input->get('product_key'))){
        $data = array(
                    'id'      => (int)$this->input->get('product_key'),
                    'qty'     => (float)$this->input->get('quantity'),
                    'price'   => (float)$this->input->get('price'),
                    'units' => $this->stocksModel->product($this->input->get('product_key'))->units,
                    'name'    => $this->stocksModel->product($this->input->get('product_key'))->name
                  );

        $this->cart->insert($data);

      }

   $this->cart_content_data_order();
   $this->update_script_order();
 }
 
 public function update_script_order(){?>
    <script>

        $(".updateqty").change( function(){
            var rowid = $( this ).data('rowid');
            var qty = $( this ).val();
            var data = 'id='+ rowid + '&quantity= ' + qty;
            $.ajax({
                url: '<?php echo base_url('admin/ajax/cart_update_order');?>',
                data: data,
                beforeSend: function(){
                    mApp.block("#cart-content",{
                                          overlayColor:"#000000",
                                          type:"loader",
                                          state:"warning",
                                          message:"Updating cart ..."
                                      });
                },
                success: function(r){
                    update_pos_content_order();
                    mApp.unblock('#cart-content');
                },
                error : function(){
                    mApp.unblock('#cart-content');
                }
            })
        });

        $(".deleteRow").each (function(){
           $(this).click(function(){
              var row = $(this).data('rowid');
              swal({
                  title:"Are you sure?",
                  text:"You won't be able to revert this!",
                  type:"warning",
                  confirmButtonClass: "btn-danger btn",
                  showCancelButton:!0,
                  confirmButtonText: "Yes, Delete it",
              }).then(function(e){
                  if(e.value){
                      $.ajax({
                          url: '<?php echo base_url('admin/ajax/cart_delete_row');?>' + '/' + row,
                          type: 'get',
                          beforeSend: function(){
                              mApp.block("#cart-content",{
                                      overlayColor:"#000000",
                                      type:"loader",
                                      state:"danger",
                                      message:"Updating cart ...."
                                  });
                            },
                           success: function(r){
                                update_pos_content_order();
                                mApp.unblock('#cart-content');
                               },
                            error: function(){
                                mApp.unblock('#cart-content');
                                }
                      });
                  }
              });
           });
        });
         function update_pos_content_order(){
         $.ajax({
            url: '<?php echo base_url('admin/ajax/poscontent_order');?>',
            success: function(r){
                $("#cart-content").html(r);
            }
            });
           }
    </script>
   <?php }
 
public function cart_update_order(){
    $this->load->library('cart');

    $data['rowid'] = $this->input->get('id');
    $data['qty'] =  $this->input->get('qty');        

    $this->cart->update($data);
    
    $this->cart_content_data_order();
    $this->update_script_order();
 }
   
 public function cart_content_data_order(){
  $this->load->helper('form');?>

      <table  class="table table-striped table-bordered" style="width:100%" border="0">

        <tr>
                <th>Item Description</th>
                <th>QTY</th>
                <th style="text-align:right">Unit</th>
        </tr>

        <?php $i = 1; ?>

        <?php foreach ($this->cart->contents() as $items): ?>

                <?php echo form_hidden($i.'[rowid]', $items['rowid']); ?>

                <tr>
                        <td>
                                <?php echo $items['name']; ?>
                                <a  href="javascript:(0);" class="deleteRow text-danger" size="4" data-rowid='<?php echo $items['rowid'];?>' ><b>x</b></a>
                        </td>

                        <td>
                            <a  data-rowid='<?php echo $items['rowid'];?>' data-key="<?php echo $items['id'];?>" data-toggle="modal" data-backdrop="static" href="#productDetails" data-price='<?php echo $items['price'];?>' data-total='<?php echo $items['subtotal'];?>' data-qty='<?php echo $items['qty'];?>'><?php echo $items['qty'];?></a>
                        </td>
                        <td style="text-align:right"><?php echo $items['units']; ?></td>
                </tr>

        <?php $i++; ?>

        <?php endforeach; ?>

        </table>
        <?php
}
public function posreceipt_order() {
        $this->load->library('cart');
        $configs= $this->app_model->loadConfigs();
        $total = $this->cart->total();
            $tax = $this->model->get_class_total_tax($configs->config_pos_tax_class);
            $taxValue = $total * $tax;
            if($configs->config_pos_tax_mode){
                $beforeTax =  $total- $taxValue;
            }else{
                $beforeTax = $total;
                $total = $total + $taxValue;
            }
        ?>

        <table class="table table-striped">
            <tr>
                <th>Cashier</th>
                <th><?php echo ucwords(strtolower(profile()->firstname.' '.profile()->lastname));?></th>
            </tr>
            <?php

            if($configs->config_show_tax_receipt){?> <tr>
                 <td>Tax</td>
                 <td><?php echo number_format(round($taxValue,2));?></td>
             </tr>
             <tr>
                 <td>Before Tax</td>
                 <td><?php echo number_format($beforeTax);?></td>
            </tr> <?php } ?>
              <tr>
                <td>Total</td>
                <td><?php echo number_format(round($total,2));?> <input type="hidden" id="input-total" value="<?php echo $total;?>" /></td>
            </tr>
            <tr>
                <td>Cash</td>
                <td id="cash"><?php echo number_format(round($total,2));?></td>
            </tr>
            <tr>
                <td>Change</td>
                <td id="change">0</td>
            </tr>
        </table>
        <input class="form-control cal-change" placeholder="Enter Cash" /><br/>
        <div class="row">
                <div class="col-md-6"><button id="cancel-sell" type="button" class="btn btn-warning btn-block">Cancel</button></div>
               <div class="col-md-6"> <button id="process-sell" type="button" class="btn btn-success btn-block">Process</button></div>
        </div>

   <?php $this->pos_receipt_scripts();
   }
   
   public function poscontent_order(){
    $this->load->library('cart');?>

      <table  class="table table-striped table-bordered" style="width:100%" border="0">
        <tr>
                <th>Product</th>
                <th>QTY</th>
                <th style="text-align:right">Unit</th>
        </tr>

        <?php $i = 1; ?>

        <?php foreach ($this->cart->contents() as $items): ?>
                <tr>
                        <td>
                        <?php echo $items['name']; ?>
                                <a  href="javascript:(0);" class="deleteRow text-danger" size="4" data-rowid='<?php echo $items['rowid'];?>' ><b>x</b></a>
                        </td>

                        <td>
                            <a  data-rowid='<?php echo $items['rowid'];?>' data-key="<?php echo $items['id'];?>" data-toggle="modal" data-backdrop="static" href="#productDetails" data-price='<?php echo $items['price'];?>' data-total='<?php echo $items['subtotal'];?>' data-qty='<?php echo $items['qty'];?>'><?php echo $items['qty'];?></a>
                        </td>
                        <td style="text-align:right"><?php echo $items['units']; ?></td>
                </tr>

        <?php $i++; ?>

        <?php endforeach; ?>
        </table>
        <?php $this->pos_scripts_order();
}


function customerSummary($key){?>        
       <div class="m-portlets m-portlet--tabs ">
                                        <div class="m-portlet__head">
                                                <div class="m-portlet__head-caption">
                                                        <div class="m-portlet__head-title">
                                                                <h3 class="m-portlet__head-text">
                                                                        <?php echo profile($key)->firstname.' '.profile($key)->lastname.' | '.profile($key)->phonenumber;?>
                                                                </h3><br/><br/>
                                                        </div>
                                                </div>
                                        </div>
                                        <div class="m-portlet__body">
                                                <div class="tab-content">                                                    
                                                        <div class="tab-pane active" id="transactions" role="tabpanel">
                                                            <div id="lm-customer-top">
                                                                <?php customer_money_summary($key);?>
                                                            </div><br/>
                                                            <div class="row">
                                                                <div class="col-md-12">
                                                                     <form id="receivePaymentForm" class="row" onsubmit="receivePayment();return false;" >
                                                                         <input type="hidden" class="form-control" required id="customers" name="customer" value="<?php echo $key;?>">
                                                                         <div class="form-group col-sm-4">
                                                                             <input required class="form-control" type="number" name="amount" placeholder="amount" />
                                                                        </div>
                                                                         <div class="form-group col-sm-2">
                                                                             <button type="submit" class="btn btn-flat btn-block btn-danger">Receive</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="form-group col-md-12">
                                                                  <input class="form-control" id="generalSearch" placeholder="Search" />
                                                                </div>
                                                              </div>
                                                                <table class="table table-striped">
                                                                    <thead>
                                                                      <tr>
                                                                        <th>Date</th>
                                                                        <th>Receipt #</th>
                                                                        <th>Paid</th>
                                                                        <th>Due</th>
                                                                        <th>Total</th>
                                                                      </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                      <?php if(! empty($receipts =$this->model->receipts_customer($key))){
                                                                        foreach( $receipts as $receipt){?>
                                                                          <tr>
                                                                            <td><?php echo date('d-m-Y',strtotime($receipt['receipt_date']));?></td>
                                                                            <td  style="width:100;"><a href="#receipt-preview" data-toggle="modal" data-backdrop="static" data-key="<?php echo $receipt['receipt_key'];?>"><?php echo $receipt['receipt_key'];?></a></td>
                                                                            <td><?php echo number_format($this->model->receipt_payments_paid($receipt['receipt_key']));?></td>
                                                                            <td><?php echo $due = number_format($receipt['receipt_total'] - $this->model->receipt_payments_paid($receipt['receipt_key']));?></td>
                                                                            <td><?php echo number_format($receipt['receipt_total']);?></td>
                                                                          </tr>
                                                                        <?php }
                                                                      } ?>
                                                                   </tbody>
                                                                 </table>
                                                        </div>
                                                </div>
                                        </div>
                                    </div> 
<?php } 

public function pos_scripts_order(){?>
    <script>
        $('button#cart-add').click( function(){
            var key = $('input#product_key').val();
            var quantity = $('input#qty').val();
            var rowid = $('input#rowid').val();
            
            if(quantity == '' || quantity == undefined){
                swal('Warning','Quantity not set','warning');
                return;
            }
            if(key == '' || key == undefined){
                swal('Warning','Could not get product information','warning');
                return;
            }
          
            if( rowid != ''){
                var dataUpdate = 'id='+ rowid + '&qty=' + quantity;
                $.ajax({
                    url: '<?php echo base_url('admin/ajax/cart_update_order');?>',
                    data: dataUpdate,
                    type:'get',
                    beforeSend: function(){
                        mApp.block("#productDetails .modal-content",{
                                overlayColor:"#000000",
                                type:"loader",
                                state:"warning",
                                message:"Updating ..."
                            });
                    },
                    success: function(r){
                        update_pos_content_order();
                        mApp.unblock('#updateQty');
                        $('#productDetails').modal('hide');
                    },
                    error : function(){
                        mApp.unblock('#updateQty');
                        $('#productDetails').modal('hide');
                    }
                })
                }else{
                var dataAdd = 'product_key='+ key + '&quantity= ' + quantity;
                $.ajax({
                url: '<?php echo base_url('admin/ajax/cart_content_order');?>',
                data: dataAdd,
                beforeSend: function(){
                    mApp.block("#productDetails .modal-content",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Loading product ..."
                        });
                },
                success: function(){
                    update_pos_content_order();
                    mApp.unblock('#productDetails .modal-content');
                    $('#productDetails').modal('hide');
                },
                error : function(xhr){
                    mApp.unblock('#productDetails .modal-content');
                    $('#productDetails').modal('hide');
                    swa('Warning',xhr.status,'warning');
                }
            });
           }
            
        });

         $(".deleteRow").each (function(){
           $(this).click(function(){
              var row = $(this).data('rowid');
              swal({
                  title:"Are you sure?",
                  text:"You won't be able to revert this!",
                  type:"warning",
                  confirmButtonClass: "btn-danger btn",
                  showCancelButton:!0,
                  confirmButtonText: "Yes, Delete it",
              }).then(function(e){
                  if(e.value){
                      $.ajax({
                          url: '<?php echo base_url('admin/ajax/cart_delete_row');?>' + '/' + row,
                          type: 'get',
                          beforeSend: function(){
                              mApp.block("#cart-content",{
                                      overlayColor:"#000000",
                                      type:"loader",
                                      state:"danger",
                                      message:"Updating cart ...."
                                  });
                            },
                           success: function(r){
                                $('div#cart-content').html(r);
                                update_pos_content_order();
                                mApp.unblock('#cart-content');
                               },
                            error: function(){
                                mApp.unblock('#cart-content');
                                }
                      });
                  }
              });
           });
        });
        
         function update_pos_content_order(){
         $.ajax({
            url: '<?php echo base_url('admin/ajax/poscontent_order');?>',
            success: function(r){
                $("#cart-content").html(r);
            }
            });
           }
    </script>
   <?php }
   
 public function searchurl(){
     print 'ok';
 }
 
private function get_unused_receipt_key()
    {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'receipt_key', $random_unique_int )
            ->get_where('sarah_sales_receipts');

        if( $query->num_rows() > 0 ) 
        {
            $query->free_result();
            // If the random user_id is already in use, try again
            return $this->get_unused_receipt_key();
        }

        return $random_unique_int;
    }
}
