<?php
defined('BASEPATH') or exit('No direct script access allowed');

class App extends MY_Controller
{
public function __construct()
{
parent::__construct();
    $this->force_ssl();
}

public function index()
{
  if( $this->require_min_level(1))
  {
    $redirect_protocol = USE_SSL ? 'https' : NULL;
    redirect( base_url('dashboard'), $redirect_protocol );
  }
}

function fetchnonemployees(){
    $this->require_min_level(1);
    $q = $this->input->get("q",true);
    $this->db->select("*");
    $this->db->select("user_id as id");
    $this->db->like("firstname",$q);
    $this->db->or_like("middlename",$q);
    $this->db->or_like("lastname",$q);
    $this->db->select('CONCAT_WS(" ", firstname, lastname) AS name');
    $this->db->select('CONCAT_WS("'.uploadFilePath("").'profile_pictures/", no_value, avatar) AS avatar');
    $this->db->join('users u','u.user_id=users_details.user_key','both');
    $query = $this->db->get('users_details');
    if(!empty($query) && $query->num_rows()>0){
        $rows = $query->num_rows();
        $data = $query->result_array();
    }else{
        $rows =  0;
        $data = array();
    }


    $result['total_count'] = $rows;
    $result['incomplete_results'] = false;
    $result['items'] = $data;
    header('Content-Type: application/json');
    header('Access-Control-Allow-Origin: ' . base_url());
    header('Access-Control-Allow-Methods: GET, POST');
    header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
    echo json_encode($result, JSON_PRETTY_PRINT);
    exit();
}
 public function checkusernameonly($username='') {
        // if (!$this->input->is_ajax_request())
        //  exit('not direct script allowed');
        $this->db->where('username',urldecode($username));
        $query = $this->db->get('users');
        if($query->num_rows()>0){
            $result['status'] = 'no';
        }else{
            $result['status'] = 'ok';
        }
        print json_encode($result);
    }

  public function checkusername($employee='',$username='') {
        // if (!$this->input->is_ajax_request())
        //  exit('not direct script allowed');
        $this->db->where('username',urldecode($username));
        $this->db->where('user_id !=',$employee);
        $query = $this->db->get('users');
        if($query->num_rows()>0){
            $result['status'] = 'no';
        }else{
            $result['status'] = 'ok';
        }
        print json_encode($result);
    }

    public function checkemailonly($email) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');

        $this->db->where('email',urldecode($email));
        $query = $this->db->get('users');
        if($query->num_rows()>0){
            $result['status'] = 'no';
        }else{
            $result['status'] = 'ok';
        }
        print json_encode($result);
    }

    public function checkemail($employee,$email) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');

        $this->db->where('email',urldecode($email));
        $this->db->where('user_id !=',$employee);
        $query = $this->db->get('users');
        if($query->num_rows()>0){
            $result['status'] = 'no';
        }else{
            $result['status'] = 'ok';
        }
        print json_encode($result);
    }


function changeavatar($user=''){
    
    header('Content-Type: application/json');
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
    
    $this->require_min_level(1);
    
   if(empty($user)) {
       $user = $this->auth_user_id;
   } 
  
  $uploadStatus = $this->appLibrary->uploadFileImage(uploadPath('media/'));
  
        if($uploadStatus['status']){             
            if(!empty(profile()->user_key)){
                
                if(file_exists(uploadPath('media/'.profile($user)->avatar))){
                    if(strtolower(profile($user)->avatar) != 'avatar.png'){
                        unlink(uploadPath('media/'.profile($user)->avatar));
                    }
                    if(strtolower(profile($user)->avatar) != 'avatar.jpg'){
                        unlink(uploadPath('media/'.profile($user)->avatar));
                    }
                    if(strtolower(profile($user)->avatar) != 'avatarjpeg'){
                        unlink(uploadPath('media/'.profile($user)->avatar));
                    }
                }
                 
                $this->db->where('user_key',$user);
                $data['avatar'] = $uploadStatus['data']['file_name'];
                $this->db->update('users_details',$data);
            }else{
                $business = runningBusiness()->business_key; 
                $branch = runningBranch()->branch_key;                
                $data['user_key'] = $user;
                $data['details_business'] = $business;
                $data['details_branch'] = $branch;
                $data['avatar'] = $uploadStatus['data']['file_name'];
                $this->db->insert('users_details',$data); 
            }       
             
          if($this->db->affected_rows()>0){
              $result['status'] = 'ok';
              $result['message'] = 'Profile picture changed';
            }else{
//                $data['avatar'] = $uploadStatus['data']['file_name'];
//                if(file_exists(uploadPath('media/'.$data['avatar']))){
//                    unlink(uploadPath('media/'.$data['avatar']));                    
//                }
              $result['status'] = 'no';
              $result['message'] = 'Failed to update profile picture';
          }         
          
        }else{  
            $result['status'] = 'no';
            $result['message'] = $uploadStatus['data'];
        }

      print json_encode($result,JSON_PRETTY_PRINT);
}


function clearcontrol(){
  if( $this->uri->uri_string() == 'app/clearcontrol')
	      return;
  unset($_SESSION['noaccess']);
}

function changecurrency($currencykey=''){
  $this->require_min_level(1);
	if(!empty($currencykey)){
    $this->currenceModel->currency_make_default($currencykey);
    if (isset($_SERVER["HTTP_REFERER"])) {
            header("Location: " . $_SERVER["HTTP_REFERER"]);
        }else{
             header("Location: " . base_url());
        }
		}else{
		    if (isset($_SERVER["HTTP_REFERER"])) {
	            header("Location: " . $_SERVER["HTTP_REFERER"]);
	        }else{
	             header("Location: " . base_url());
	        }
		}
}

function changebranch($key=''){
	if(!empty($key)){
    $_SESSION['branch'] = $key;
    if (isset($_SERVER["HTTP_REFERER"])) {
            header("Location: " . $_SERVER["HTTP_REFERER"]);
        }else{
             header("Location: " . base_url());
        }
		}else{
		    if (isset($_SERVER["HTTP_REFERER"])) {
	            header("Location: " . $_SERVER["HTTP_REFERER"]);
	        }else{
	             header("Location: " . base_url());
	        }
		}
}

function changelanguage($language=''){
    $this->load->language(array('display'),$language);
    $_SESSION['language'] = $language;
    if(!empty($language)){
    if (isset($_SERVER["HTTP_REFERER"])) {
            header("Location: " . $_SERVER["HTTP_REFERER"]);
        }else{
             header("Location: " . base_url());
        }
		}else{
		    if (isset($_SERVER["HTTP_REFERER"])) {
	            header("Location: " . $_SERVER["HTTP_REFERER"]);
	        }else{
	             header("Location: " . base_url());
	        }
		}
}


    public function ajax_login()
    {
        if( $this->input->is_ajax_request() )
        {
            $this->tokens->name = config_item('login_token_name');
            header('Content-Type: application/json');
            header('Access-Control-Allow-Origin: *');
            header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
            header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
            // Allow this page to be an accepted login page
            $this->config->set_item('allowed_pages_for_login', ['app/ajax_login'] );

            // Make sure we aren't redirecting after a successful login
            $this->authentication->redirect_after_login = FALSE;

            // Do the login attempt
            $this->auth_data = $this->authentication->user_status( 0 );

            // Set user variables if successful login
            if( $this->auth_data )
                $this->_set_user_variables();

            // Call the post auth hook
            $this->post_auth_hook();

            // Login attempt was successful
            if( $this->auth_data )
            {
                echo json_encode([
                    'status'   => 1,
                    'user_id'  => $this->auth_user_id,
                    'username' => $this->auth_username,
                    'level'    => $this->auth_level,
                    'role'     => $this->auth_role,
                    'token'   => $this->tokens->token(),
                    'login_token_name'   => config_item('login_token_name'),
                    'email'    => $this->auth_email
                ],JSON_PRETTY_PRINT);
            }

            // Login attempt not successful
            else
            {

                $on_hold = (
                    $this->authentication->on_hold === TRUE OR
                    $this->authentication->current_hold_status()
                )
                    ? 1 : 0;

                echo json_encode([
                    'status'  => 0,
                    'count'   => $this->authentication->login_errors_count,
                    'on_hold' => $on_hold,
                    'token'   => $this->tokens->token(),
                    'login_token_name'   => config_item('login_token_name'),
                    'message' => 'Invalid account details'
                ], JSON_PRETTY_PRINT);
            }
        }

        // Show 404 if not AJAX
        else
        {
            show_404();
        }
    }



    public function login()
    {
        $this->load->helper('form');
        // Method should not be directly accessible
        if( $this->uri->uri_string() == 'app/login')
            return;

        if( strtolower( $_SERVER['REQUEST_METHOD'] ) == 'post' )
            $this->require_min_level(1);

        $this->setup_login_form();

        $pagedata = array('title'=>'Login | '. config_item('application_name'));
        $this->load->vars($pagedata);
        $this->load->view('auth/login');
    }

    public function logout()
{

$this->authentication->logout();

// Set redirect protocol
$redirect_protocol = USE_SSL ? 'https' : NULL;

redirect( site_url( LOGIN_PAGE . '?' . AUTH_LOGOUT_PARAM . '=1', $redirect_protocol ) );
}

  public function recover()
{
    $this->load->helper('form');
// Load resources
    $view_data = array();
/// If IP or posted email is on hold, display message
if( $on_hold = $this->authentication->current_hold_status( TRUE ) )
{
$view_data['disabled'] = 1;
}
else
{
// If the form post looks good
if( $this->tokens->match && $this->input->post('email') )
{
    $user_data = $this->appModel->get_recovery_data( $this->input->post('email') );
if($user_data  )
{
// Check if user is banned
if( $user_data->banned == '1' )
{
// Log an error if banned
$this->authentication->log_error( $this->input->post('email', TRUE ) );

// Show special message for banned user
$view_data['banned'] = 1;
}
else
{
$recovery_code = substr( $this->authentication->random_salt()
	. $this->authentication->random_salt()
	. $this->authentication->random_salt()
	. $this->authentication->random_salt(), 0, 72 );

// Update user record with recovery code and time
$this->appModel->update_user_raw_data(
	$user_data->user_id,
	[
		'passwd_recovery_code' => $this->authentication->hash_passwd($recovery_code),
		'passwd_recovery_date' => date('Y-m-d H:i:s')
	]
);

// Set the link protocol
$link_protocol = USE_SSL ? 'https' : NULL;

// Set URI of link
$link_uri = 'app/reverify/' . $user_data->user_id . '/' . $recovery_code;

$re_link = anchor(
	site_url( $link_uri, $link_protocol ),
	site_url( $link_uri, $link_protocol ),
	'target ="_blank"'
);
  $emailData['subject'] = 'Account recovery';
  $emailData['recepient'] = $user_data->email;
  $emailData['message'] = '<h1>Account Recovery</h1>'
          . 'Hellow <b>'.ucfirst($user_data->username).'</b><br/><br/>'
          . 'The recovery email for <b>'.config_item('application_name').'</b> is <b><i>'.$user_data->email.'</i></b> '
          . 'was requesting change of password on '.date('Y-m-d H:i:s').'<br/> '
          . 'If you made this change click the link to recover the password. <br/><br/>'
          . $re_link.'<br/>'
          . '<br/>Sincerely, <br/>'
          .config_item('account_recovery_sender');
  if($this->appLibrary->send_recover_email($emailData)){
      $view_data['confirmation'] = 1;
    }else{
      $view_data['email_error'] = 1;
  }
}
}

// There was no match, log an error, and display a message
else
{

$view_data['no_match'] = 1;
}
}
}
    $view_data['title']='Recovery | '. config_item('application_name');
    $this->load->vars($view_data);
$this->load->view('auth/recovery_form');
}

  public function reverify( $user_id = '', $recovery_code = '' )
    {
        $this->load->helper('form');
/// If IP is on hold, display message
        if( $on_hold = $this->authentication->current_hold_status( TRUE ) )
        {
            $view_data['disabled'] = 1;
        }
        else
        {
// Load resources
            $this->load->model('auth_model');

            if(
                /**
                 * Make sure that $user_id is a number and less
                 * than or equal to 10 characters long
                 */
                is_numeric( $user_id ) && strlen( $user_id ) <= 10 &&

                /**
                 * Make sure that $recovery code is exactly 72 characters long
                 */
                strlen( $recovery_code ) == 72 &&

                /**
                 * Try to get a hashed password recovery
                 * code and user salt for the user.
                 */
                $recovery_data = $this->appModel->get_recovery_verification_data( $user_id ) )
            {
                /**
                 * Check that the recovery code from the
                 * email matches the hashed recovery code.
                 */
                if( $recovery_data->passwd_recovery_code == $this->authentication->check_passwd( $recovery_data->passwd_recovery_code, $recovery_code ) )
                {
                    $view_data['user_id']       = $user_id;
                    $view_data['username']     = $recovery_data->username;
                    $view_data['recovery_code'] = $recovery_data->passwd_recovery_code;
                }

// Link is bad so show message
                else
                {
                    $view_data['recovery_error'] = 1;

// Log an error
                    $this->authentication->log_error('');
                }
            }

// Link is bad so show message
            else
            {
                $view_data['recovery_error'] = 1;

// Log an error
                $this->authentication->log_error('');
            }

            /**
             * If form submission is attempting to change password
             */
            if( $this->tokens->match )
            {
                $this->appModel->recovery_password_change();
            }
        }

        $view_data['title']='Recovery | '. config_item('application_name');
        $this->load->vars($view_data);
        $this->load->view('auth/verify_form');
    }

  public function register()
{
    $this->tokens->name = config_item('login_token_name');
    header('Content-Type: application/json');
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $user_data = [
            'phonenumber'     => $this->input->post('phonenumber'),
            'passwd'     => $this->input->post('password'),
            'email'      =>  $this->input->post('email'),
            'auth_level' => '8',
            'user_lang' => 'english',
        ];

        $this->is_logged_in();

        // Load resources
        $this->load->helper('auth');
        $this->load->model('validation_callables');
        $this->load->library('form_validation');

        //
        $this->form_validation->set_data( $user_data );

        $validation_rules = [
                    [
                    'field' => 'username',
                    'label' => 'username',
                    'rules' => 'is_unique[' . db_table('user_table') . '.email]',
                    'errors' => [
                                'is_unique' => 'Email already used as administrator.'
                                ]
                    ],
                    [
                        'field' => 'email',
                        'label' => 'email',
                        'rules' => 'is_unique[' . db_table('user_table') . '.email]',
                        'errors' => [
                            'is_unique' => 'This Email has been used in our system.'
                        ]
                    ],
                 [
                        'field' => 'phonenumber',
                        'label' => 'Phone Number',
                        'rules' => 'is_unique[' . db_table('user_table') . '.phonenumber]',
                        'errors' => [
                            'is_unique' => 'Phone number you have used is already used in our system. Consider recovering your account <a href="'.'https://'.$_SERVER['SERVER_NAME'].'/app/recover">here</a>',
                        ]
                    ],
                    [
                    'field' => 'passwd',
                    'label' => 'Password',
                    'rules' => [
                            'required',
                            [
                            '_check_password_strength',
                                [ $this->validation_callables, '_check_password_strength' ]
                            ]
                    ],
                    'errors' => [
                                'required' => 'You must provide password.'
                                ]
                    ],
            ];

        $this->form_validation->set_rules( $validation_rules );

        if( $this->form_validation->run() )
        {

        $business['business_name'] = $this->input->post('company_name');
        $business['business_key'] = $this->businessModel->businessKey();

        $branch['branch_name'] = "Head Quarter";
        $branch['branch_key'] = $this->branchesModel->branchKey();
        $branch['branch_primary'] = 1;
        $branch['branch_business'] = $business['business_key'];

        $user_data['passwd']  = $this->authentication->hash_passwd($user_data['passwd']);
        $user_data['user_id'] = $this->appModel->get_unused_id();
        $user_data['created_at'] = date('Y-m-d H:i:s');
        $user_data['user_business'] = $business['business_key'];
        $user_data['user_branch']  =  $branch['branch_key'];
        // If username is not used, it must be entered into the record as NULL
        if( empty( $user_data['username'] ) )
        {
           $user_data['username'] = NULL;
        }

        $this->db->trans_start();
        $this->db->insert('users',$user_data);
        $this->db->insert('business',$business);
        $this->db->insert('branches',$branch);
        $this->db->trans_complete();
        if( $this->db->trans_status() === true ){
            $this->pagedata['status'] = 1;
            $this->pagedata['token']   = $this->tokens->token();
            $this->pagedata['login_token_name']   = config_item('login_token_name');
            $this->pagedata['message'] = '<h3>Congratulations! Your account has been create. <a href="'.base_url('login').'" style="color:#ffffff;"><b>LOGIN</b></a></h3>';
            } else{
            $this->pagedata['token']   = $this->tokens->token();
            $this->pagedata['login_token_name']   = config_item('login_token_name');
            $this->pagedata['status'] = 0;
            $this->pagedata['message'] = "Sorry we could not process your request at a time, Try again later";
        }
      }else{
            $this->pagedata['token']   = $this->tokens->token();
            $this->pagedata['login_token_name']   = config_item('login_token_name');
            $this->pagedata['status'] = 0;
            $this->pagedata['message'] = validation_errors();
        }

        print json_encode($this->pagedata,JSON_PRETTY_PRINT);

}

  public function error404() {
    redirect(base_url());
  //$this->load->view('auth/error404');
}

  public function locked() {

  $this->require_min_level(1);

    if (isset($_SERVER["HTTP_REFERER"])) {
        $url =  $_SERVER["HTTP_REFERER"];
      }else{
        $url = base_url();
    }

    if(!profileSimple()->app_locked){
        $this->db->where('user_id',$this->auth_user_id);
        $this->db->update('users',['app_locked'=>1,'app_locked_url' => $url]);
    }

  $this->load->view('auth/locked');
}

  function unlock(){
    // if (!$this->input->is_ajax_request())
    //  exit('not direct script allowed');
     $this->require_min_level(1);
     $url =  profileSimple()->app_locked_url;
     if($url == base_url('locked')){
         $url = base_url();
     }
     $password = $this->input->get('login',TRUE);
    if($this->authentication->check_passwd(profileSimple()->passwd,$password)){
        $this->db->where('user_id',$this->auth_user_id);
        $this->db->update('users',['app_locked'=>FALSE,'app_locked_url' => NULL]);
        $result['status'] = 'ok';
        $result['message'] = $url;
      }else{
        $result['status'] = 'no';
        $result['message'] = 'It seems, the password is not correct';
      }
   print json_encode($result);
}

}
