<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author Elieza Kalaita
 */

class Assets extends MY_Controller{
    public  $pagedata;

    public function __construct() {
        parent::__construct();
        ( $this->require_min_level(1));
        $this->load->model(array('assets/AssetsModel'=>'assetsModel',
            'accounting/accounting'=>'accountingModel',
            'assets/AssetTypesModel'=>'assetTypesModel',
            'FinancialPeriodsModel'=>'periodModel'
        ));
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
        $this->load->helper('assets');
        $this->load->helper('form');
        $this->pagedata['title'] = 'Assets | '.$this->config->item('application_name');
    }

    public function index() {
        //has_control('assets_view_all','View all assets');
        $this->pagedata['link']= 'assets';
        $this->pagedata['types'] = $this->assetsModel->assetTypes();
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/assets/assets');
    }

    public function fetch_asset_type($key){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $asset_type = $this->assetTypesModel->find_by(['asset_type_key'=>$key]);
        echo json_encode(array('asset_type_key' => $asset_type['asset_type_key'],
            'asset_type_value' => $asset_type['asset_type_value'],
            'asset_type_value_nature' => $asset_type['asset_type_value_nature'],
            'asset_type_description' => $asset_type['asset_type_description'],
            'asset_type_account' => $asset_type['asset_type_account'],
            'asset_type_name' => $asset_type['asset_type_name']));
        //echo json_encode($asset_type);
    }

    public function newasset() {
        //has_control('assets_create','Create assets');
        $this->load->helper('form');
        $this->pagedata['link']= 'newasset';
        if($this->tokens->match){
            $this->db->trans_start();
            $asset['asset_key'] =  $this->assetsModel->asset_key();
            $asset['asset_serial'] = $this->input->post('asset_serial',TRUE);
            $asset['asset_withdraw_account'] = $this->input->post('fund_source',TRUE);
            $asset['asset_type'] = $this->input->post('asset_type',TRUE);
            if(!empty($type = $this->assetsModel->assetType($this->input->post('asset_type',TRUE)))){
                $asset['asset_category'] = $type->category_key;
            }else{
                $asset['asset_category'] = NULL;
            }
            $asset['asset_cost'] = to_dollar(str_replace(',','',$this->input->post('asset_cost',TRUE)));
            $asset['asset_date'] = date('Y-m-d');
            $asset['asset_evaluation_date'] = date('Y-m-d',strtotime($this->input->post('asset_evaluation_date',TRUE)));
            $asset['asset_quantity'] = 1;
            $asset['asset_disposal_value'] = to_dollar(str_replace(',','',$this->input->post('asset_disposal_value',TRUE)));
            $asset['asset_total_cost'] = $asset['asset_cost'];
            $asset['asset_description'] = $this->input->post('asset_description',TRUE);
            $asset['asset_bougth_from'] = $this->input->post('asset_bougth_from',TRUE);
            $asset['asset_lifetime'] = $this->input->post('asset_lifetime',TRUE);
            $asset['asset_evaluation_value'] = $this->input->post('asset_evaluation_value',TRUE);
            $asset['asset_value_nature'] = $this->input->post('asset_value_nature',TRUE);

            if($asset['asset_value_nature'] == "Depreciate"){
                $asset['asset_annual_dep'] = ($asset['asset_evaluation_value']/100) * (1/$asset['asset_lifetime']) * ($asset['asset_cost']);
                $asset['asset_monthly_dep'] = $asset['asset_annual_dep']/12;
            }
            elseif ($asset['asset_value_nature'] == "Appreciate"){
                $finVal = ($asset['asset_cost']) * pow($asset['asset_evaluation_value']/100 + 1, $asset['asset_lifetime']);
                $appRate = pow($finVal/$asset['asset_cost'],1/$asset['asset_evaluation_value']) - 1;
                $asset['asset_annual_app'] = $appRate * $finVal;
                $asset['asset_monthly_app'] = $asset['asset_annual_app']/12;
            }

            $this->assetsModel->newAsset($asset);
            if(!empty($items = $this->input->post('group_items'))){
                foreach ($items as $item){
                    $itemData['ass_data_item'] = $item['ass_item'];
                    $itemData['ass_data_value'] = $item['ass_value'];
                    $itemData['ass_data_item_desc'] = $item['ass_desc'];
                    $itemData['ass_data_item_asset'] = $asset['asset_key'];
                    $this->db->insert('asset_data_items',$itemData);
                }
            }

            $this->postPaymentLedger($asset);
            $this->db->trans_complete();

            if($this->db->trans_status() === TRUE):
                $this->appLibrary->action_status('success','Asset created successfully');
            else:
                $this->appLibrary->action_status('fail','Could not create Asset');
            endif;
        }

        $this->pagedata['accounts'] = $this->accountingModel->accounts();
        $this->pagedata['types'] = $this->assetsModel->assetTypes();
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/assets/newasset');
    }

    public function newassettype() {
        $this->load->helper('form');
        if($this->tokens->match){
            $asset['asset_type_account'] = $this->input->post('asset_type_account',TRUE);
            $asset['asset_type_name'] = $this->input->post('asset_type_name',TRUE);
            $asset['asset_type_value'] = $this->input->post('asset_type_value',TRUE);
            $asset['asset_type_category'] = $this->input->post('asset_type_category',TRUE);
            $asset['asset_type_description'] = $this->input->post('asset_type_description',TRUE);
            $asset['asset_type_value_nature'] = $this->input->post('asset_type_value_nature',TRUE);
            if($this->assetsModel->newAssetType($asset)):
                $this->appLibrary->action_status('success','Asset Type created successifully');
            else:
                $this->appLibrary->action_status('fail','Could not create Asset Type');
            endif;
        }
        $this->pagedata['categories'] = $this->assetsModel->assetCategories();
        $this->pagedata['accounts'] = $this->accountingModel->accounts();
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/assets/newassettype');
    }

    public function assettypes() {
        $this->pagedata['link']= 'assettypes';
        $this->pagedata['types'] = $this->assetsModel->assetTypes();
        $this->pagedata['title'] = 'Asset Types | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/assets/assettypes');
    }

    public function assettypedetails($assetType='') {
        $this->load->helper('form');
        if($this->tokens->match){
            $asset['asset_type_account'] = $this->input->post('asset_type_account',TRUE);
            $asset['asset_type_name'] = $this->input->post('asset_type_name',TRUE);
            $asset['asset_type_value'] = $this->input->post('asset_type_value',TRUE);
            $asset['asset_type_category'] = $this->input->post('asset_type_category',TRUE);
            $asset['asset_type_description'] = $this->input->post('asset_type_description',TRUE);
            if($this->assetsModel->updateAssetType($assetType,$asset)):
                $this->appLibrary->action_status('success','Asset Type updated successfully');
            else:
                $this->appLibrary->action_status('fail','Could not update Asset Type');
            endif;
        }
        $this->pagedata['categories'] = $this->assetsModel->assetCategories();
        $this->pagedata['type'] = $this->assetsModel->assetType($assetType);
        $this->pagedata['accounts'] = $this->accountingModel->accounts();
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/assets/assettypedetails');
    }

    public function assetmodifyaction($assetKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');

        $asset['asset_serial'] = $this->input->post('asset_serial',TRUE);
        if(!empty($type = $this->assetsModel->assetType($this->input->post('asset_type',TRUE)))){
            $asset['asset_category'] = $type->category_key;
        }else{
            $asset['asset_category'] = NULL;
        }
        $asset['asset_withdraw_account'] = $this->input->post('asset_withdraw_account',TRUE);
        $asset['asset_type'] = $this->input->post('asset_type',TRUE);
        $asset['asset_cost'] = str_replace(',','',$this->input->post('asset_cost',TRUE));
        $asset['asset_date'] = date('Y-m-d',strtotime($this->input->post('asset_date',TRUE)));
        $asset['asset_quantity'] = str_replace(',','',$this->input->post('asset_quantity',TRUE));
        $asset['asset_disposal_value'] = str_replace(',','',$this->input->post('asset_disposal_value',TRUE));
        $asset['asset_total_cost'] = $asset['asset_quantity'] * $asset['asset_cost'];
        $asset['asset_description'] = $this->input->post('asset_description',TRUE);
        $asset['asset_bougth_from'] = $this->input->post('asset_bougth_from',TRUE);
        if($this->assetsModel->updateAsset($assetKey,$asset)){
            $result['status'] = 'ok';
            $result['message'] = 'Asset updated';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError();
        }
        print json_encode($result);
    }

    public function details($assetKey='') {
        //has_control('assets_view_single','View Asset Details');
        $this->load->helper('form');

        //$get_asset_type = $this->assetsModel->asset($assetKey);
        //var_dump($get_asset_type);
        //exit;

        //$asset_type_key = $get_asset_type->asset_type;
        //$asset_type = $this->assetTypesModel->find_by(['asset_type_key'=>$asset_type_key]);

        $this->pagedata['types'] = $this->assetsModel->assetTypes();
        //$this->pagedata['types'] = $asset_type;
        $this->pagedata['asset'] = $this->assetsModel->asset($assetKey);
        $this->pagedata['accounts'] = $this->accountingModel->accounts();
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/assets/details');
    }
    public function modify($assetKey='') {
        //has_control('assets_update','Update Asset Details');
        $this->load->helper('form');

        if($this->tokens->match){
            if($this->assetsModel->count_depreciated($assetKey)){
                $this->appLibrary->action_status('fail','You can\'t modify because depreciation has already ran on this asset, changes could affect the entire depreciation process.');
            }
            else{
                $this->db->trans_start();
                $asset['asset_serial'] = $this->input->post('asset_serial',TRUE);
                $asset['asset_withdraw_account'] = $this->input->post('fund_source',TRUE);
                $asset['asset_type'] = $this->input->post('asset_type',TRUE);
                if(!empty($type = $this->assetsModel->assetType($this->input->post('asset_type',TRUE)))){
                    $asset['asset_category'] = $type->category_key;
                }else{
                    $asset['asset_category'] = NULL;
                }
                $asset['asset_cost'] = to_dollar(str_replace(',','',$this->input->post('asset_cost',TRUE)));
                //$asset['asset_date'] = date('Y-m-d');
                $asset['asset_evaluation_date'] = date('Y-m-d',strtotime($this->input->post('asset_evaluation_date',TRUE)));
                //$asset['asset_quantity'] = 1;
                //$asset['asset_disposal_value'] = to_dollar(str_replace(',','',$this->input->post('asset_disposal_value',TRUE)));
                $asset['asset_total_cost'] = $asset['asset_cost'];
                $asset['asset_description'] = $this->input->post('asset_description',TRUE);
                $asset['asset_bougth_from'] = $this->input->post('asset_bougth_from',TRUE);
                $asset['asset_lifetime'] = $this->input->post('asset_lifetime',TRUE);
                $asset['asset_evaluation_value'] = $this->input->post('asset_evaluation_value',TRUE);
                $asset['asset_value_nature'] = $this->input->post('asset_value_nature',TRUE);

                if($asset['asset_value_nature'] == "Depreciate"){
                    $asset['asset_annual_dep'] = ($asset['asset_evaluation_value']/100) * (1/$asset['asset_lifetime']) * ($asset['asset_cost']);
                    $asset['asset_monthly_dep'] = $asset['asset_annual_dep']/12;
                }
                elseif ($asset['asset_value_nature'] == "Appreciate"){
                    $finVal = ($asset['asset_cost']) * pow($asset['asset_evaluation_value']/100 + 1, $asset['asset_lifetime']);
                    $appRate = pow($finVal/$asset['asset_cost'],1/$asset['asset_evaluation_value']) - 1;
                    $asset['asset_annual_app'] = $appRate * $finVal;
                    $asset['asset_monthly_app'] = $asset['asset_annual_app']/12;
                }

                $this->assetsModel->upadateAsset($assetKey, $asset);
                if(!empty($items = $this->input->post('group_items'))){
                    foreach ($items as $item){
                        $itemData['ass_data_item'] = $item['ass_item'];
                        $itemData['ass_data_value'] = $item['ass_value'];
                        $itemData['ass_data_item_desc'] = $item['ass_desc'];
                        $itemData['ass_data_item_asset'] = $asset['asset_key'];
                        $this->db->insert('asset_data_items',$itemData);
                    }
                }

                //$this->postPaymentLedger($asset);
                $this->db->trans_complete();

                if($this->db->trans_status() === TRUE):
                    $this->appLibrary->action_status('success','Asset details successfully changed');
                else:
                    $this->appLibrary->action_status('fail','Could not create Asset');
                endif;
            }

        }

        $this->pagedata['types'] = $this->assetsModel->assetTypes();
        //$this->pagedata['types'] = $asset_type;
        $this->pagedata['asset'] = $this->assetsModel->asset($assetKey);
        $this->pagedata['accounts'] = $this->accountingModel->accounts();
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/assets/modify');
    }

    public function loadassetdetails($assetKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->load->helper('form');
        $this->pagedata['types'] = $this->assetsModel->assetTypes();
        $this->pagedata['asset'] = $this->assetsModel->asset($assetKey);
        $this->pagedata['accounts'] = $this->accountingModel->accounts();
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/assets/detailsajax');
    }

    function updateassetdetails(){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $assetKey = $this->input->post('asset_key');
        $asset['asset_serial'] = $this->input->post('asset_serial',TRUE);
        $asset['asset_withdraw_account'] = $this->input->post('asset_withdraw_account',TRUE);
        $asset['asset_type'] = $this->input->post('asset_type',TRUE);
        if(!empty($type = $this->assetsModel->assetType($this->input->post('asset_type',TRUE)))){
            $asset['asset_category'] = $type->category_key;
        }else{
            $asset['asset_category'] = NULL;
        }
        $asset['asset_evaluation_date'] = date('Y-m-d',strtotime($this->input->post('asset_evaluation_date',TRUE)));
        $asset['asset_evaluation_value'] = to_dollar(str_replace(',','',$this->input->post('asset_evaluation_value',TRUE)));
        $asset['asset_cost'] = to_dollar(str_replace(',','',$this->input->post('asset_cost',TRUE)));
        $asset['asset_date'] = date('Y-m-d',strtotime($this->input->post('asset_date',TRUE)));
        $asset['asset_quantity'] = str_replace(',','',$this->input->post('asset_quantity',TRUE));
        $asset['asset_disposal_value'] = to_dollar(str_replace(',','',$this->input->post('asset_disposal_value',TRUE)));
        $asset['asset_total_cost'] = $asset['asset_quantity'] * $asset['asset_cost'];
        $asset['asset_description'] = $this->input->post('asset_description',TRUE);
        $asset['asset_bougth_from'] = $this->input->post('asset_bougth_from',TRUE);
        if($this->assetsModel->updateAsset($assetKey,$asset)){
            $result['status'] = 'ok';
            $result['message'] = 'Asset updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError();
        }
        print json_encode($result);
    }

    function datasource(){
        $data =  $this->assetsModel->assets();
        $columnsDefault = [
            'asset_id'     => true,
            'asset_key'     => true,
            'asset_serial'     => true,
            'asset_type_name'  => true,
            'asset_annual_dep'  => true,
            'asset_dep_key' => true,
            'asset_dep_status'  => true,
            'asset_dep_period'  => true,
            'fp_prefix'  => true,
            'asset_dep_year' => true,
            'asset_dep_month' => true,
            'asset_dep_depriciation_month_price' => true,
            'asset_dep_price_difference'=> true,
            'asset_dep_created_by'=> true,
            'asset_dep_modified_by' => true,
            'asset_dep_date_created'=> true,
            'asset_cost'     => true,
            'asset_quantity'     => true,
            'asset_total_cost'    => true,
            'asset_date'    => true,
        ];
        $this->sourcedataserver($data,$columnsDefault);
    }
    function datasource_appreciating(){
        $data =  $this->assetsModel->appreciating_assets();
        $columnsDefault = [
            'asset_id'     => true,
            'asset_key'     => true,
            'asset_serial'     => true,
            'asset_type_name'  => true,
            'asset_annual_app'  => true,
            'asset_app_key' => true,
            'asset_app_status'  => true,
            'asset_app_period'  => true,
            'fp_prefix'  => true,
            'asset_app_year' => true,
            'asset_app_month' => true,
            'asset_app_month_price' => true,
            'asset_app_price_difference'=> true,
            'asset_app_created_by'=> true,
            'asset_app_modified_by' => true,
            'asset_app_date_created'=> true,
            'asset_cost'     => true,
            'asset_quantity'     => true,
            'asset_total_cost'    => true,
            'asset_date'    => true,
        ];
        $this->sourcedataserver($data,$columnsDefault);
    }

    function datasourceassets(){
        include dirname(APPPATH).'/resources/includes/lib/class-list-util.php';

        $data = $alldata = $this->assetsModel->assets();

        $datatable = array_merge(['pagination' => [], 'sort' => [], 'query' => []], $_REQUEST);

        // search filter by keywords
        $filter = isset($datatable['query']['generalSearch']) && is_string($datatable['query']['generalSearch'])
            ? $datatable['query']['generalSearch'] : '';
        if ( ! empty($filter)) {
            $data = array_filter($data, function ($a) use ($filter) {
                return (boolean)preg_grep("/$filter/i", (array)$a);
            });
            unset($datatable['query']['generalSearch']);
        }

        // filter by field query
        $query = isset($datatable['query']) && is_array($datatable['query']) ? $datatable['query'] : null;
        if (is_array($query)) {
            $query = array_filter($query);
            foreach ($query as $key => $val) {
                $data = list_filter($data, [$key => $val]);
            }
        }

        $sort  = ! empty($datatable['sort']['sort']) ? $datatable['sort']['sort'] : 'asc';
        $field = ! empty($datatable['sort']['field']) ? $datatable['sort']['field'] : 'RecordID';

        $meta    = [];
        $page    = ! empty($datatable['pagination']['page']) ? (int)$datatable['pagination']['page'] : 1;
        $perpage = ! empty($datatable['pagination']['perpage']) ? (int)$datatable['pagination']['perpage'] : -1;

        $pages = 1;
        $total = count($data); // total items in array

        // sort
        usort($data, function ($a, $b) use ($sort, $field) {
            if ( ! isset($a->$field) || ! isset($b->$field)) {
                return false;
            }

            if ($sort === 'asc') {
                return $a->$field > $b->$field ? true : false;
            }

            return $a->$field < $b->$field ? true : false;
        });

        // $perpage 0; get all data
        if ($perpage > 0) {
            $pages  = ceil($total / $perpage); // calculate total pages
            $page   = max($page, 1); // get 1 page when $_REQUEST['page'] <= 0
            $page   = min($page, $pages); // get last page when $_REQUEST['page'] > $totalPages
            $offset = ($page - 1) * $perpage;
            if ($offset < 0) {
                $offset = 0;
            }

            $data = array_slice($data, $offset, $perpage, true);
        }

        $meta = [
            'page'    => $page,
            'pages'   => $pages,
            'perpage' => $perpage,
            'total'   => $total,
        ];

        // if selected all records enabled, provide all the ids
        if (isset($datatable['requestIds']) && filter_var($datatable['requestIds'], FILTER_VALIDATE_BOOLEAN)) {
            $meta['rowIds'] = array_map(function ($row) {
                foreach($row as $first) break;
                return $first;
            }, $alldata);
        }


        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $result = [
            'meta' => $meta + [
                    'sort'  => $sort,
                    'field' => $field,
                ],
            'data' => $data,
        ];

        echo json_encode($result, JSON_PRETTY_PRINT);
    }

    function datasourceassettypes(){

        $data = $this->assetTypesModel->find_all();
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        //$data = $this->countriesModel->find_all();
        $columns = array();
        foreach ($this->assetTypesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }

    function datasourceassettypes2(){
        include dirname(APPPATH).'/resources/includes/lib/class-list-util.php';

        $data = $alldata = $this->assetsModel->assetTypes();

        $datatable = array_merge(['pagination' => [], 'sort' => [], 'query' => []], $_REQUEST);

        // search filter by keywords
        $filter = isset($datatable['query']['generalSearch']) && is_string($datatable['query']['generalSearch'])
            ? $datatable['query']['generalSearch'] : '';
        if ( ! empty($filter)) {
            $data = array_filter($data, function ($a) use ($filter) {
                return (boolean)preg_grep("/$filter/i", (array)$a);
            });
            unset($datatable['query']['generalSearch']);
        }

        // filter by field query
        $query = isset($datatable['query']) && is_array($datatable['query']) ? $datatable['query'] : null;
        if (is_array($query)) {
            $query = array_filter($query);
            foreach ($query as $key => $val) {
                $data = list_filter($data, [$key => $val]);
            }
        }

        $sort  = ! empty($datatable['sort']['sort']) ? $datatable['sort']['sort'] : 'asc';
        $field = ! empty($datatable['sort']['field']) ? $datatable['sort']['field'] : 'RecordID';

        $meta    = [];
        $page    = ! empty($datatable['pagination']['page']) ? (int)$datatable['pagination']['page'] : 1;
        $perpage = ! empty($datatable['pagination']['perpage']) ? (int)$datatable['pagination']['perpage'] : -1;

        $pages = 1;
        $total = count($data); // total items in array

        // sort
        usort($data, function ($a, $b) use ($sort, $field) {
            if ( ! isset($a->$field) || ! isset($b->$field)) {
                return false;
            }

            if ($sort === 'asc') {
                return $a->$field > $b->$field ? true : false;
            }

            return $a->$field < $b->$field ? true : false;
        });

        // $perpage 0; get all data
        if ($perpage > 0) {
            $pages  = ceil($total / $perpage); // calculate total pages
            $page   = max($page, 1); // get 1 page when $_REQUEST['page'] <= 0
            $page   = min($page, $pages); // get last page when $_REQUEST['page'] > $totalPages
            $offset = ($page - 1) * $perpage;
            if ($offset < 0) {
                $offset = 0;
            }

            $data = array_slice($data, $offset, $perpage, true);
        }

        $meta = [
            'page'    => $page,
            'pages'   => $pages,
            'perpage' => $perpage,
            'total'   => $total,
        ];

        // if selected all records enabled, provide all the ids
        if (isset($datatable['requestIds']) && filter_var($datatable['requestIds'], FILTER_VALIDATE_BOOLEAN)) {
            $meta['rowIds'] = array_map(function ($row) {
                foreach($row as $first) break;
                return $first;
            }, $alldata);
        }


        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $result = [
            'meta' => $meta + [
                    'sort'  => $sort,
                    'field' => $field,
                ],
            'data' => $data,
        ];

        echo json_encode($result, JSON_PRETTY_PRINT);
    }

//-----------------DOCUMENTS---------------//
    public function loadassetdocuments($assetKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->load->helper('form');
        $this->pagedata['types'] = $this->assetsModel->assetTypes();
        $this->pagedata['accounts'] = $this->accountingModel->accounts();
        $this->pagedata['asset'] = $this->assetsModel->asset($assetKey);
        $this->pagedata['document']= $this->assetsModel->documents($assetKey);
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/assets/assetdocuments');
    }

    function newDocument(){
        $docs['asset_doc_asset_key'] = $this->input->get('asset_doc_asset_key',TRUE);
        $docs['asset_doc_title'] = $this->input->get('asset_doc_title',TRUE);
        $docs['asset_doc_desc'] = $this->input->get('asset_doc_desc',TRUE);
        $docs['asset_doc_date_created'] = date('Y-m-d');
        if (!empty($this->input->get('uploadedfiles'))) {
            $raw = explode('LM-55', $_GET['uploadedfiles']);
            foreach ($raw as $key => $file) {
                $file = unserialize($file);
                if (is_array($file)) {
                    foreach ($file as $dt) {
                        if (!empty($dt)) {
                            $docs['asset_doc_image'] = $dt['asset_doc_image'];
                            $docs['asset_doc_type'] =getFileExt($dt['asset_doc_image']);
                        }
                    }
                }
            }
        }
        if($this->assetsModel->createDocument($docs)){
            $result['status'] = 'ok';
            $result['message'] = 'Asset Document uploaded successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function uploadempdocs(){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $uploadPath = uploadPath('asset_doc_image/');
        $config['upload_path'] = $uploadPath;
        $config['file_ext_tolower']     = TRUE;
        $config['encrypt_name']         = TRUE;
        $config['allowed_types'] = 'jpg|jpeg|png|docx|doc|pdf|xls|xlsx';

        // Load and initialize upload library
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $i  = 0;
        if($this->upload->do_upload('file')){
            // Uploaded file data
            $fileData = $this->upload->data();
            $uploadData[$i]['asset_doc_image'] = $fileData['file_name'];
        }
        if(!empty($uploadData)){
            $files = array();
            $result['status'] = true;
            foreach ($uploadData as $key => $file){
                $files[$key]['asset_doc_image'] = $file['asset_doc_image'];
            }
            $result['files'] = serialize($files);
        }else{
            $result['status'] = false;
            $result['files'] = '';
        }
        echo json_encode($result, JSON_PRETTY_PRINT);
    }

    function datasourceDocuments($key=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->assetsModel->documents($key);
        $columns = [
            'asset_doc_id' => true,
            'asset_doc_key' => true,
            'asset_doc_title' => true,
            'asset_doc_desc' => true,
            'asset_doc_type'=> true,
            'asset_doc_image' => true,
            'asset_doc_date_created'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }

    public function deleteDocument($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $image_path = dirname(APPPATH).'/uploads/asset_doc_image/';
        $query = $this->db->where('asset_doc_key',$key)->from('asset_documents')->get();

        foreach ($query->result_array() as $record){
            $filename = $image_path . $record['asset_doc_image'];
            if (file_exists($filename)){
                unlink($filename);
            }
        }
        switch ($flag) {
            case 'document':
                if($this->assetsModel->documentDelete($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Document deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

    /** Asset Appreciation Module */
    function load_appreciation_calculator($asset){
        $this->pagedata['asset'] = $this->assetsModel->asset($asset);
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/assets/asset_calculator');
    }

    function calculateAppreciation(){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['app_start'] = $this->input->post("app_start",true);
        $data['app_end'] = $this->input->post("app_end",true);
        $data['app_rate'] = $this->input->post("app_rate",true);
        $data['app_cost'] = $this->input->post("asset_cost",true);
        $year_start = date('Y',strtotime($data['app_start']));
        $year_end = date('Y',strtotime($data['app_end']));
        $data['app_period'] = $year_end - $year_start;
        $output = $this->getAppreciation($data);
        if($output){
            $results['status'] = true;
            $results['finVal'] = $output['finVal'];
            $results['appRate'] = $output['appRate'];
        }else{
            $results['status'] = false;
            $results['message'] = 'Failed to appreciate';
        }

        echo json_encode($results);
    }
    function getAppreciation($data){
        // calculation for final appreciation value
        $stVal = $data['app_cost'];
        $rate = ($data['app_rate']/100) + 1;
        $period = $data['app_period'];

        $finVal = $stVal * pow($rate, $period);

        //calculation for appreciation rate per year
        $appRate = pow($finVal/$stVal,1/$period)-1;

        $results = array('finVal'=>number_format($finVal,2,'.',','),
            'appRate'=>number_format($appRate, 2, '.', ','));

        return $results;
    }
    public function loadassetapreciations($assetKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->load->helper('form');
        $this->pagedata['types'] = $this->assetsModel->assetTypes();
        $this->pagedata['accounts'] = $this->accountingModel->accounts();
        $this->pagedata['asset'] = $this->assetsModel->asset($assetKey);
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/assets/asset_appreciation');
    }
    function runAppreciation($app_key){
        //has_control('assets_appreciation','Run Asset Appreciation');
        $this->load->helper('reports/accounting/helper');
        $this->load->model(array('accounting/GeneralLedgerModel'=>'generalLedgerModel','accounting/Accounting'=>'accountingModel'));

        $appre = $this->assetsModel->select_app_data($app_key);
        //$date = date('Y-m-d', strtotime('+1 month'));
        $date = date("Y-m-01");
        $newdate = strtotime ( '+1 month' , strtotime ( $date ) ) ;

        $period_key = $this->input->post('financial_period', true);
        //$financialPeriod = $this->periodsModel->find_by(['fp_key'=>$period_key]);

        if($this->assetsModel->check_appreciation($appre->asset_app_asset_key, $period_key)){
            $result['status'] = 'no';
            $result['message'] = "Appreciation has already ran on this period, please try to run on different financial period!";
        }
        else{
            $this->db->trans_start();
            $data['asset_app_key'] = $this->assetsModel->assetAppKey();
            $data['asset_app_period'] = $period_key;
            $data['asset_appreciation_date'] = $this->input->post('asset_appreciation_date', true);
            $data['asset_app_branch_key']= $this->branch;
            $data['asset_app_business_key'] = $this->business;
            //$data['asset_dep_year'] = date('Y');
            //$data['asset_dep_month'] = date('m');
            $data['asset_app_year'] = date('Y',$newdate);
            $data['asset_app_month'] = date('m',$newdate);
            $data['asset_app_asset_key'] = $appre->asset_app_asset_key;
            $data['asset_app_month_price'] =   $appre->asset_app_month_price;
            //$data['asset_dep_price_difference'] = ($depre->asset_dep_price_difference) - ($depre->asset_dep_depriciation_month_price);
            $data['asset_app_price_difference'] = ($appre->asset_app_price_difference) + ($appre->asset_annual_app);
            $data['asset_app_date_created'] = date('Y-m-d');
            $data['asset_app_created_by'] = $this->auth_user_id;
            $this->assetsModel->runAppreciation($app_key);

            $this->db->insert('asset_appreciation',$data);

            /** Before posting data to Ledger,
             * first check if an asset being appreciated has an approval status on Ledger.
             */
            //$checkApproval = $this->generalLedgerModel->find_by(['gl_reference'=>$data['asset_dep_asset_key'], 'gl_activity'=>$data['asset_dep_asset_key'], 'gl_status'=>'APPROVED']);
            $expenseAccount = $this->accountingModel->account($this->input->post('app_expense_account', true));
            $account = $this->assetsModel->asset($data['asset_app_asset_key']);
            //$account = $this->assetTypesModel->find_by(["asset_type_key" => $assets['asset_type']]);

            $ledgerDebit['gl_account'] = $expenseAccount->account_key;
            $ledgerDebit['gl_'.$expenseAccount->account_to_increase] = $appre->asset_annual_app;
            $ledgerDebit['gl_amount'] = $appre->asset_annual_app;
            $ledgerDebit['gl_date'] = $data['asset_appreciation_date'];
            $ledgerDebit['gl_status'] = "PENDING";
            $ledgerDebit['gl_category'] = "ASSETS";
            $ledgerDebit['gl_type'] = "ASSET";
            $ledgerDebit['gl_reference'] = $app_key;
            $ledgerDebit['gl_details'] = "Asset Appreciation";
            $ledgerDebit['gl_activity'] = $app_key;
            $id = $this->generalLedgerModel->insert($ledgerDebit);
            $balance['gl_balance'] = accountBalance($ledgerDebit['gl_account']);
            $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

            $ledgerCredit['gl_account'] = $account->account_key;
            $ledgerCredit['gl_'.$account->account_to_increase] = $appre->asset_annual_app;
            $ledgerCredit['gl_date'] = $data['asset_appreciation_date'];
            $ledgerCredit['gl_status'] = "PENDING";
            $ledgerCredit['gl_category'] = "ASSETS";
            $ledgerCredit['gl_type'] = "ASSET";
            $ledgerCredit['gl_reference'] = $app_key;
            $ledgerCredit['gl_details'] = "Asset Appreciation";
            $ledgerCredit['gl_activity'] = $app_key;
            $ledgerCredit['gl_amount'] = $appre->asset_annual_app;
            $id = $this->generalLedgerModel->insert($ledgerCredit);
            $balance['gl_balance'] = accountBalance($ledgerCredit['gl_account']);
            $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);
//            if(!$checkApproval){
//                $result['status'] = 'no';
//                $result['message'] = "Failed to post data onto Ledger, because an asset is not approved on Ledger!";
//            }
//            else{
//
//            }
            $this->db->trans_complete();
            if($this->db->trans_status() === true){
                $result['status'] = 'ok';
                $result['message'] = 'Operation done successfully';
            }else{
                $result['status'] = 'no';
                $result['message'] = checkError($this->dbexeption());
            }

        }

        print json_encode($result);
    }
    function runAppSelected(){
        //has_control('assets_appreciation','Run Asset Appreciation');
        $this->load->helper('reports/accounting/helper');
        $this->load->model(array('accounting/GeneralLedgerModel'=>'generalLedgerModel','accounting/Accounting'=>'accountingModel'));

        $app_key = $this->input->post('data', true);
        foreach ($app_key as $asset => $value):
            $appre = $this->assetsModel->select_app_data($value);
            //$date = date('Y-m-d', strtotime('+1 month'));
            $date = date("Y-m-01");
            $newdate = strtotime ( '+1 month' , strtotime ( $date ) ) ;

            $period_key = $this->input->post('financial_period', true);
            //$financialPeriod = $this->periodsModel->find_by(['fp_key'=>$period_key]);

            if($this->assetsModel->check_appreciation($appre->asset_app_asset_key, $period_key)){
                $result['status'] = 'no';
                $result['message'] = "One of assets being appreciated is already ran on this period, please try to run on different financial period!";
            }
            else{
                $this->db->trans_start();
                $data['asset_app_key'] = $this->assetsModel->assetAppKey();
                $data['asset_app_period'] = $period_key;
                $data['asset_appreciation_date'] = $this->input->post('asset_appreciation_date', true);
                $data['asset_app_branch_key']= $this->branch;
                $data['asset_app_business_key'] = $this->business;
                $data['asset_app_year'] = date('Y',$newdate);
                $data['asset_app_month'] = date('m',$newdate);
                $data['asset_app_asset_key'] = $appre->asset_app_asset_key;
                $data['asset_app_month_price'] =   $appre->asset_app_month_price;
                //$data['asset_dep_price_difference'] = ($depre->asset_dep_price_difference) - ($depre->asset_dep_depriciation_month_price);
                $data['asset_app_price_difference'] = ($appre->asset_app_price_difference) + ($appre->asset_annual_app);
                $data['asset_app_date_created'] = date('Y-m-d');
                $data['asset_app_created_by'] = $this->auth_user_id;
                $this->assetsModel->runAppreciation($value);

                $this->db->insert('asset_appreciation',$data);

                /** Before posting data to Ledger,
                 * first check if an asset being depreciated has an approval status on Ledger.
                 */
                //$checkApproval = $this->generalLedgerModel->find_by(['gl_reference'=>$data['asset_dep_asset_key'], 'gl_activity'=>$data['asset_dep_asset_key'], 'gl_status'=>'APPROVED']);
                $expenseAccount = $this->accountingModel->account($this->input->post('app_expense_account', true));
                $account = $this->assetsModel->asset($data['asset_app_asset_key']);
                //$account = $this->assetTypesModel->find_by(["asset_type_key" => $assets['asset_type']]);

                $ledgerDebit['gl_account'] = $expenseAccount->account_key;
                $ledgerDebit['gl_'.$expenseAccount->account_to_increase] = $appre->asset_annual_app;
                $ledgerDebit['gl_amount'] = $appre->asset_annual_app;
                $ledgerDebit['gl_date'] = $data['asset_appreciation_date'];
                $ledgerDebit['gl_status'] = "PENDING";
                $ledgerDebit['gl_category'] = "ASSETS";
                $ledgerDebit['gl_type'] = "ASSET";
                $ledgerDebit['gl_reference'] = $value;
                $ledgerDebit['gl_details'] = "Asset Appreciation";
                $ledgerDebit['gl_activity'] = $value;
                $id = $this->generalLedgerModel->insert($ledgerDebit);
                $balance['gl_balance'] = accountBalance($ledgerDebit['gl_account']);
                $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

                $ledgerCredit['gl_account'] = $account->account_key;
                $ledgerCredit['gl_'.$account->account_to_decrease] = $appre->asset_annual_app;
                $ledgerCredit['gl_date'] = $data['asset_appreciation_date'];
                $ledgerCredit['gl_status'] = "PENDING";
                $ledgerCredit['gl_category'] = "ASSETS";
                $ledgerCredit['gl_type'] = "ASSET";
                $ledgerCredit['gl_reference'] = $value;
                $ledgerCredit['gl_details'] = "Asset Appreciation";
                $ledgerCredit['gl_activity'] = $value;
                $ledgerCredit['gl_amount'] = $appre->asset_annual_app;
                $id = $this->generalLedgerModel->insert($ledgerCredit);
                $balance['gl_balance'] = accountBalance($ledgerCredit['gl_account']);
                $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);
//            if(!$checkApproval){
//                $result['status'] = 'no';
//                $result['message'] = "Failed to post data onto Ledger, because an asset is not approved on Ledger!";
//            }
//            else{
//
//            }
                $this->db->trans_complete();
                if($this->db->trans_status() === true){
                    $result['status'] = 'ok';
                    $result['message'] = 'Operation done successfully';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }

            }
        endforeach;

        print json_encode($result);
    }
    public function deleteAssetApp($key) {
        if (!$this->input->is_ajax_request())
            exit('no direct script allowed');
        if($this->assetsModel->count_appreciated($key)){
            $result['status'] = 'no';
            $result['message'] = 'You can\'t delete because appreciation has already ran on this asset';
        }
        else{
            $this->db->trans_start();
            $this->assetsModel->deleteAsset($key);
            $this->assetsModel->deleteApp($key);
            $this->db->trans_complete();
            if($this->db->trans_status() === true){
                $result['status'] = 'ok';
                $result['message'] = 'Asset successfully deleted!';
            }else{
                $result['status'] = 'no';
                $result['message'] = checkError();
            }
        }
        print json_encode($result);
    }
    public function deleteSelectedApp() {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');

        $data = $this->input->get('data');
        foreach ($data as $asset => $value):
            if($this->assetsModel->count_appreciated($value)){
                $result['status'] = 'no';
                $result['message'] = 'Operation failed, appreciation has already ran on one of the assets being deleted';
            }
            else{
                $this->db->trans_start();
                $this->assetsModel->deleteAsset($value);
                $this->assetsModel->deleteApp($value);
                $this->db->trans_complete();
                if($this->db->trans_status() === true){
                    $result['status'] = 'ok';
                    $result['message'] = 'Assets successfully deleted!';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError();
                }
            }
        endforeach;
        print json_encode($result);
    }

    /** Asset Depreciation Module */
    public function loadassetdepreciations($assetKey='') {
        // if (!$this->input->is_ajax_request())
        //  exit('not direct script allowed');
        $this->load->helper('form');
        $this->pagedata['types'] = $this->assetsModel->assetTypes();
        $this->pagedata['accounts'] = $this->accountingModel->accounts();
        $this->pagedata['asset'] = $this->assetsModel->asset($assetKey);
        $this->pagedata['document']= $this->assetsModel->documents($assetKey);
        $this->pagedata['depreciations']= $this->assetsModel->asset_depreciation($assetKey);
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/assets/asset_depreciation');
    }
    function datasourceDepreciation($key=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->assetsModel->asset_depreciation($key);
        $columns = [
            'asset_dep_id' => true,
            'asset_dep_key' => true,
            'asset_dep_year' => true,
            'asset_dep_month' => true,
            'asset_dep_asset_key'=> true,
            'asset_dep_status' => true,
            'asset_serial'=> true,
            'asset_dep_depriciation_month_price' => true,
            'asset_dep_price_difference'=> true,
            'asset_dep_created_by'=> true,
            'asset_dep_modified_by' => true,
            'asset_dep_date_created'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }

    function runDepreciation($dep_key){
        //has_control('assets_depreciation','Run Asset Depreciation');
        $this->load->helper('reports/accounting/helper');
        $this->load->model(array('accounting/GeneralLedgerModel'=>'generalLedgerModel','accounting/Accounting'=>'accountingModel'));

        $depre = $this->assetsModel->select_one_data($dep_key);
        //$date = date('Y-m-d', strtotime('+1 month'));
        $date = date("Y-m-01");
        $newdate = strtotime ( '+1 month' , strtotime ( $date ) ) ;

        $period_key = $this->input->post('financial_period', true);
        //$financialPeriod = $this->periodsModel->find_by(['fp_key'=>$period_key]);

        if($this->assetsModel->check_depreciation($depre->asset_dep_asset_key, $period_key)){
            $result['status'] = 'no';
            $result['message'] = "Depreciation has already ran on this period, please try to run on different financial period!";
        }
        else{
            $this->db->trans_start();
            $data['asset_dep_key'] = $this->assetsModel->assetDepKey();
            $data['asset_dep_period'] = $period_key;
            $data['asset_depreciation_date'] = $this->input->post('asset_depreciation_date', true);
            $data['asset_dep_branch_key']= $this->branch;
            $data['asset_dep_business_key'] = $this->business;
            $data['asset_dep_year'] = date('Y',$newdate);
            $data['asset_dep_month'] = date('m',$newdate);
            $data['asset_dep_asset_key'] = $depre->asset_dep_asset_key;
            $data['asset_dep_depriciation_month_price'] =   $depre->asset_dep_depriciation_month_price;
            $data['asset_dep_price_difference'] = ($depre->asset_dep_price_difference) - ($depre->asset_annual_dep);
            $data['asset_dep_date_created'] = date('Y-m-d');
            $this->assetsModel->runDepreciation($dep_key);

            $this->db->insert('asset_depreciation',$data);

            /** Before posting data to Ledger,
             * first check if an asset being depreciated has an approval status on Ledger.
             */

            $accumulatedAccount = $this->accountingModel->account($this->input->post('dep_accumulated_account', true));
            $expenseAccount = $this->accountingModel->account($this->input->post('dep_expense_account', true));

            $ledgerDebit['gl_account'] = $expenseAccount->account_key;
            $ledgerDebit['gl_debit'] = $depre->asset_annual_dep;
            $ledgerDebit['gl_amount'] = $depre->asset_annual_dep;
            $ledgerDebit['gl_date'] = $data['asset_depreciation_date'];
            $ledgerDebit['gl_status'] = "PENDING";
            $ledgerDebit['gl_category'] = "ASSETS";
            $ledgerDebit['gl_type'] = "ASSET";
            $ledgerDebit['gl_reference'] = $dep_key;
            $ledgerDebit['gl_details'] = "Asset Depreciation";
            $ledgerDebit['gl_activity'] = $dep_key;
            $id = $this->generalLedgerModel->insert($ledgerDebit);
            $balance['gl_balance'] = accountBalance($ledgerDebit['gl_account']);
            $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

            //$ledgerCredit['gl_account'] = $account->account_key;
            $ledgerCredit['gl_account'] = $accumulatedAccount->account_key;
            $ledgerCredit['gl_credit'] = $depre->asset_annual_dep;
            $ledgerCredit['gl_date'] = $data['asset_depreciation_date'];
            $ledgerCredit['gl_status'] = "PENDING";
            $ledgerCredit['gl_category'] = "ASSETS";
            $ledgerCredit['gl_type'] = "ASSET";
            $ledgerCredit['gl_reference'] = $dep_key;
            $ledgerCredit['gl_details'] = "Asset Depreciation";
            $ledgerCredit['gl_activity'] = $dep_key;
            $ledgerCredit['gl_amount'] = $depre->asset_annual_dep;
            $id = $this->generalLedgerModel->insert($ledgerCredit);
            $balance['gl_balance'] = accountBalance($ledgerCredit['gl_account']);
            $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

            $this->db->trans_complete();
            if($this->db->trans_status() === true){
                $result['status'] = 'ok';
                $result['message'] = 'Operation done successfully';
            }else{
                $result['status'] = 'no';
                $result['message'] = checkError($this->dbexeption());
            }

        }

        print json_encode($result);
    }

    function runDepSelected(){
        //has_control('assets_depreciation','Run Asset Depreciation');
        $this->load->helper('reports/accounting/helper');
        $this->load->model(array('accounting/GeneralLedgerModel'=>'generalLedgerModel','accounting/Accounting'=>'accountingModel'));

        $dep_key = $this->input->post('data', true);
        foreach ($dep_key as $asset => $value):
            $depre = $this->assetsModel->select_one_data($value);
            //$date = date('Y-m-d', strtotime('+1 month'));
            $date = date("Y-m-01");
            $newdate = strtotime ( '+1 month' , strtotime ( $date ) ) ;

            $period_key = $this->input->post('financial_period', true);
            //$financialPeriod = $this->periodsModel->find_by(['fp_key'=>$period_key]);

            if($this->assetsModel->check_depreciation($depre->asset_dep_asset_key, $period_key)){
                $result['status'] = 'no';
                $result['message'] = "One of the assets being depreciated is already ran on this period, please try to run on different financial period!";
            }
            else{
                $this->db->trans_start();
                $data['asset_dep_key'] = $this->assetsModel->assetDepKey();
                $data['asset_dep_period'] = $period_key;
                $data['asset_depreciation_date'] = $this->input->post('asset_depreciation_date', true);
                $data['asset_dep_branch_key']= $this->branch;
                $data['asset_dep_business_key'] = $this->business;
                $data['asset_dep_year'] = date('Y',$newdate);
                $data['asset_dep_month'] = date('m',$newdate);
                $data['asset_dep_asset_key'] = $depre->asset_dep_asset_key;
                $data['asset_dep_depriciation_month_price'] =   $depre->asset_dep_depriciation_month_price;
                $data['asset_dep_price_difference'] = ($depre->asset_dep_price_difference) - ($depre->asset_annual_dep);
                $data['asset_dep_date_created'] = date('Y-m-d');
                $this->assetsModel->runDepreciation($value);

                $this->db->insert('asset_depreciation',$data);

                /** Before posting data to Ledger,
                 * first check if an asset being depreciated has an approval status on Ledger.
                 */
                $accumulatedAccount = $this->accountingModel->account($this->input->post('dep_accumulated_account', true));
                $expenseAccount = $this->accountingModel->account($this->input->post('dep_expense_account', true));

                $ledgerDebit['gl_account'] = $expenseAccount->account_key;
                $ledgerDebit['gl_debit'] = $depre->asset_annual_dep;
                $ledgerDebit['gl_amount'] = $depre->asset_annual_dep;
                $ledgerDebit['gl_date'] = $data['asset_depreciation_date'];
                $ledgerDebit['gl_status'] = "PENDING";
                $ledgerDebit['gl_category'] = "ASSETS";
                $ledgerDebit['gl_type'] = "ASSET";
                $ledgerDebit['gl_reference'] = $dep_key;
                $ledgerDebit['gl_details'] = "Asset Depreciation";
                $ledgerDebit['gl_activity'] = $dep_key;
                $id = $this->generalLedgerModel->insert($ledgerDebit);
                $balance['gl_balance'] = accountBalance($ledgerDebit['gl_account']);
                $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

                $ledgerCredit['gl_account'] = $accumulatedAccount->account_key;
                $ledgerCredit['gl_credit'] = $depre->asset_annual_dep;
                $ledgerCredit['gl_date'] = $data['asset_depreciation_date'];
                $ledgerCredit['gl_status'] = "PENDING";
                $ledgerCredit['gl_category'] = "ASSETS";
                $ledgerCredit['gl_type'] = "ASSET";
                $ledgerCredit['gl_reference'] = $dep_key;
                $ledgerCredit['gl_details'] = "Asset Depreciation";
                $ledgerCredit['gl_activity'] = $dep_key;
                $ledgerCredit['gl_amount'] = $depre->asset_annual_dep;
                $id = $this->generalLedgerModel->insert($ledgerCredit);
                $balance['gl_balance'] = accountBalance($ledgerCredit['gl_account']);
                $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

                $this->db->trans_complete();
                if($this->db->trans_status() === true){
                    $result['status'] = 'ok';
                    $result['message'] = 'Operation done successfully';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }

            }
        endforeach;

        print json_encode($result);
    }

    public function deleteAsset($key) {
        //has_control('assets_delete','Delete Asset');
        if (!$this->input->is_ajax_request())
            exit('no direct script allowed');
        if($this->assetsModel->count_depreciated($key)){
            $result['status'] = 'no';
            $result['message'] = 'You can\'t delete because depreciation has already ran on this asset';
        }
        else{
            $this->db->trans_start();
            $this->assetsModel->deleteAsset($key);
            $this->assetsModel->deleteDep($key);
            $this->db->trans_complete();
            if($this->db->trans_status() === true){
                $result['status'] = 'ok';
                $result['message'] = 'Asset successfully deleted!';
            }else{
                $result['status'] = 'no';
                $result['message'] = checkError();
            }
        }
        print json_encode($result);

    }
    public function deleteSelected() {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');

        $data = $this->input->get('data');
        foreach ($data as $asset => $value):
            if($this->assetsModel->count_depreciated($value)){
                $result['status'] = 'no';
                $result['message'] = 'Operation failed, depreciation has already ran on one of the assets being deleted';
            }
            else{
                $this->db->trans_start();
                $this->assetsModel->deleteAsset($value);
                $this->assetsModel->deleteDep($value);
                $this->db->trans_complete();
                if($this->db->trans_status() === true){
                    $result['status'] = 'ok';
                    $result['message'] = 'Assets successfully deleted!';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError();
                }
            }
        endforeach;
        print json_encode($result);
    }
    public function deleteDep($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'depreciation':
                if($this->assetsModel->depDelete($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Data deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }


    //----------------Armotizations----------------------//

    public function loadassetamotizations($assetKey='') {
        // if (!$this->input->is_ajax_request())
        //  exit('not direct script allowed');
        $this->load->helper('form');
        $this->pagedata['types'] = $this->assetsModel->assetTypes();
        $this->pagedata['accounts'] = $this->accountingModel->accounts();
        $this->pagedata['asset'] = $this->assetsModel->asset($assetKey);
        $this->pagedata['document']= $this->assetsModel->documents($assetKey);
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/assets/asset_amortization');
    }

    function postPaymentLedger($asset){
        $this->load->helper('reports/accounting/helper');
        $this->load->model(array('accounting/GeneralLedgerModel'=>'generalLedgerModel','accounting/Accounting'=>'accountingModel'));

        $sourceAccount = $this->accountingModel->account($asset['asset_withdraw_account']);
        $account = $this->assetTypesModel->find_by(["asset_type_key" => $asset['asset_type']]);

        $ledgerDebit['gl_account'] = $sourceAccount->account_key;
        $ledgerDebit['gl_'.$sourceAccount->account_to_decrease] = $asset['asset_total_cost'];
        $ledgerDebit['gl_amount'] = $asset['asset_total_cost'];
        $ledgerDebit['gl_date'] = $asset['asset_date'];
        $ledgerDebit['gl_status'] = "PENDING";
        $ledgerDebit['gl_category'] = "ASSETS";
        $ledgerDebit['gl_type'] = "ASSETS";
        $ledgerDebit['gl_reference'] = $asset['asset_key'];
        $ledgerDebit['gl_details'] = "Registering asset";
        $ledgerDebit['gl_activity'] = $asset['asset_key'];
        $id = $this->generalLedgerModel->insert($ledgerDebit);
        $balance['gl_balance'] = accountBalance($ledgerDebit['gl_account']);
        $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

        $ledgerCredit['gl_account'] = $account['account_key'];
        $ledgerCredit['gl_'.$account['account_to_increase']] = $asset['asset_total_cost'];
        $ledgerCredit['gl_date'] = $asset['asset_date'];
        $ledgerCredit['gl_status'] = "PENDING";
        $ledgerCredit['gl_category'] = "ASSETS";
        $ledgerCredit['gl_type'] = "ASSETS";
        $ledgerCredit['gl_reference'] = $asset['asset_key'];
        $ledgerCredit['gl_details'] = "Registering asset";
        $ledgerCredit['gl_activity'] = $asset['asset_key'];
        $ledgerCredit['gl_amount'] = $asset['asset_total_cost'];
        $id = $this->generalLedgerModel->insert($ledgerCredit);
        $balance['gl_balance'] = accountBalance($ledgerCredit['gl_account']);
        $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);
    }

}