<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
* Description of Dashboard
*
* @author test
*/

class Chatofaccounts extends MY_Controller{

  public  $pagedata;

  public function __construct() {
    parent::__construct();
    $this->require_min_level(1);
    $this->pagedata['link']= 'accounting';
    $this->load->model(array('accounting/accounting'=>'accountingModel'));
  }
 
  public function index() {
      $this->pagedata['title'] = 'Accounting | '.$this->config->item('application_name');
      $this->pagedata['types'] = $this->accountingModel->accountTypes();
      $this->pagedata['accounts']= $this->accountingModel->accounts();
      $this->load->vars($this->pagedata);
      $this->load->view('accounting/chatofaccounts');
  }

  public function  accounthistory($account=""){
      $this->load->helper("form");
      $this->load->model(array('accounting/GlModel'=>'glModel'));
      $this->pagedata['title'] = 'Account History | '.$this->config->item('application_name');
      $this->pagedata['account'] = $this->accountingModel->account($account);
      $this->load->vars($this->pagedata);
      $this->load->view('accounting/accounts/accounthistory');
    }

  public function createaccount(){
      header('Content-Type: application/json');
      header('Access-Control-Allow-Origin: ' . base_url());
      header('Access-Control-Allow-Methods: GET, POST');
      header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

      $subtype = $this->accountingModel->accountSubTypeDetails($this->input->post('account_sub_type',TRUE));
      $this->db->trans_start();
      $data['account_key'] = $this->accountingModel->account_key();
      $data['account_to_increase'] = $subtype->subtype_increase_nature;
      $data['account_to_decrease'] = $subtype->subtype_decrease_nature;
      $data['account_name'] = $this->input->post('account_name',TRUE);
      $data['account_type'] = $this->input->post('account_type',TRUE);
      $data['account_sub_type'] = $this->input->post('account_sub_type',TRUE);
      $data['account_details'] = $this->input->post('account_details',TRUE);
      $data['account_number'] = filterNumber($this->input->post('account_number',TRUE));
      $data['account_business'] = runningBusiness()->business_key;
      $this->db->insert('accounting_accounts',$data);

      if(!empty($this->input->post("account_balance"))){
          $this->load->model(array('accounting/glModel'=>'glModel'));
          $gldata['gl_key'] = $this->glModel->glKey();
          $gldata['gl_details'] = "Account opening balance";
          $gldata['gl_account'] = $data['account_key'];
          $gldata['gl_account_type'] = $data['account_type'];
          $gldata['gl_account_sub_type'] = $data['account_sub_type'];
          $gldata['gl_amount'] = filterNumber($this->input->post("account_balance"));
          $gldata['gl_'.$subtype->subtype_increase_nature] = filterNumber($this->input->post("account_balance"));
          $gldata['gl_status'] = "PENDING";
          $gldata['gl_user'] = $this->auth_user_id;
          $gldata['gl_business'] = runningBusiness()->business_key;
          $gldata['gl_branch'] = runningBranch()->branch_key;
          $gldata['gl_date'] = !empty($this->input->post('balance_date',TRUE)) ? date("Y-m-d",strtotime($this->input->post('balance_date',TRUE))) : date("Y-m-d");
          $this->db->insert('accounting_general_ledger',$gldata);
      }

      $this->db->trans_complete();
      if($this->db->trans_status() === TRUE){
          $result['status'] = true;
          $result['message'] = 'Account created';
      }else{
          $result['status'] = false;
          $result['message'] = 'An error occurred, Try again later';
      }

      echo json_encode($result, JSON_PRETTY_PRINT);
      exit();
  }

  function deleteselected(){
      $accounts = $this->input->get('data');
      $deleted = 0;
      if(!empty($accounts)){
          foreach ($accounts as $account){
              $this->accountingModel->deleteAccount($account);
              if($this->db->affected_rows()>0){
                  $deleted = $deleted + 1;
              }
          }
          if($this->db->affected_rows()>0){
              $s = $deleted>1 ? "s": '';
              $result['status'] = true;
              $result['message'] = $deleted.' account'.$s.' deleted';
          }else{
              $result['status'] = false;
              $result['message'] = checkMysqlErrorWithCode();
          }
      }else{
          $result['status'] = false;
          $result['message'] = 'Nothing deleted';
      }

      header('Content-Type: application/json');
      header('Access-Control-Allow-Origin: ' . base_url());
      header('Access-Control-Allow-Methods: GET, POST');
      header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
      echo json_encode($result, JSON_PRETTY_PRINT);
      exit();
  }

  public function deleteaccount($account=""){

      header('Content-Type: application/json');
      header('Access-Control-Allow-Origin: ' . base_url());
      header('Access-Control-Allow-Methods: GET, POST');
      header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

      if($this->accountingModel->deleteAccount($account)){
          $result['status'] = true;
          $result['message'] = 'Account deleted';
      }else{
          $result['status'] = false;
          $result['message'] = checkMysqlErrorWithCode();
      }

      echo json_encode($result, JSON_PRETTY_PRINT);
      exit();

  }

  function datasource(){
    $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
    $data = $this->accountingModel->accounts();
    $columnsDefault = [
      'account_key'     => true,
      'account_name'  => true,
      'account_number'     => true,
      'account_type'     => true,
      'type_name'     => true,
      'account_details'     => true,
      'subtype_name'     => true,
      'account_sub_type'     => true,
    ];
      print $this->datasourceLibrary->server($data,$columnsDefault);
  }

  function source_account_history($account,$when=""){
      $this->load->model(array('accounting/GlModel'=>'glModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->accountingModel->account_history($account,$when);
        $columnsDefault = [
            'account_key'     => true,
            'account_name'  => true,
            'account_number'     => true,
            'account_type'     => true,
            'type_name'     => true,
            'account_details'     => true,
            'subtype_name'     => true,
            'account_sub_type'     => true,
        ];
        print $this->datasourceLibrary->server($data,$columnsDefault);
    }
}
