<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
* Description of Dashboard
*
* @author test
*/

class Registers extends MY_Controller{

  public  $pagedata;

  public function __construct() {
      parent::__construct();
      $this->require_min_level(1);
      $this->pagedata['link']= 'accounting';
      $this->load->model(array('accounting/accounting'=>'accountingModel'));
  }


  public function index() {
    $this->pagedata['types'] = $this->accountingModel->accountTypes();
    $this->pagedata['rules'] = $this->accountingModel->accountingRules();
    $this->load->vars($this->pagedata);
    $this->load->view('accounting/accounting');
  }

  public function account(){
      $this->pagedata['types'] = $this->accountingModel->accountTypes();
      $this->load->vars($this->pagedata);
      $this->load->view('accounting/registers/account');
  }

    public function updateaccount($account){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $subtype = $this->accountingModel->accountSubTypeDetails($this->input->post('account_sub_type',TRUE));

        $data['account_to_increase'] = $subtype->subtype_increase_nature;
        $data['account_to_decrease'] = $subtype->subtype_decrease_nature;
        $data['account_name'] = $this->input->post('account_name',TRUE);
        $data['account_type'] = $this->input->post('account_type',TRUE);
        $data['account_sub_type'] = $this->input->post('account_sub_type',TRUE);
        $data['account_details'] = $this->input->post('account_details',TRUE);
        $data['account_number'] = filterNumber($this->input->post('account_number',TRUE));
        $this->db->where("account_key",$account);
        $this->db->update('accounting_accounts',$data);

        if($this->db->affected_rows()>0){
            $result['status'] = true;
            $result['message'] = 'Account updates';
        }else{
            $result['status'] = false;
            $result['message'] = 'An error occurred, Try again later';
        }

        echo json_encode($result, JSON_PRETTY_PRINT);
    }

    public function editaccount($account=''){
        $this->pagedata['types'] = $this->accountingModel->accountTypes();
        $this->pagedata['account'] = $this->accountingModel->account($account);
        $this->pagedata['subtypes'] = $this->accountingModel->accountSubTypesAll();
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/registers/edit_account');
    }

    public function getsubtypedetails($type="")
    {
        if (empty($this->accountingModel)) {
            $this->load->model(array("accounting/Accounting" => "accountingModel"));
        }

        $type= $this->accountingModel->accountSubTypeDetails($type);
        print !empty($type) ? $type->subtype_details : "None";
    }

    public function gettypedetails($type=""){
      if(empty($this->accountingModel)){
          $this->load->model(array("accounting/Accounting" => "accountingModel"));
      }
    $types= $this->accountingModel->accountSubTypes($type);?>
        <div class="form-group">
            <label>Type Details</label>
            <select name="account_sub_type"  class="form-control" required>
                <option value="" disabled selected>Select Option</option>
                <?php if(!empty($types)){
                    foreach ($types as $i => $typ) {
                        print '<option value="'.$typ['subtype_key'].'">'.$typ['subtype_name'].'</option>';
                    }
                }?>
            </select>
        </div>
      <div class="form-group" id="typeDesc" style="border-color: #dddddd; border: solid 1px; color: rgba(52,52,52,0.88); padding: 10px; border-radius: 3px;"></div>
      <script type="text/javascript">
          $('select').select2({placeholder: "Select Option"});
          $("select[name='account_sub_type']").change( function(event){
              const $this = $(this);
              const key = $this.val();
              let typeDesc= $("div#typeDesc");
              typeDesc.load('<?php echo base_url('accounting/registers/getsubtypedetails/');?>' + key, function( response, status, xhr ) {
                  if ( status == "error" ) {
                      typeDesc.html("");
                  }
              });
          });
      </script>
  <?php }

}
