<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
* Description of Dashboard
*
* @author Kelvin Benard
*/

class Index extends MY_Controller{

  public  $pagedata;

  public function __construct() {
    parent::__construct();
    $this->require_min_level(1);
    $this->pagedata['link']= 'accounting';
    $this->load->model(array('accounting/accounting'=>'accountingModel'));
      $this->load->model(array('accounting/GeneralLedgerModel'=>'generalLedgerModel'));
  }
 
  public function index($account="") {
      $this->load->helper("form");
      $this->pagedata['title'] = 'Account Account| '.$this->config->item('application_name');
      $this->pagedata['account']= $this->accountingModel->account($account);
      $this->load->vars($this->pagedata);
      $this->load->view('accounting/accounts/accounthistory');
  }

  public function history($account="") {
        $this->load->model(array(
            'expenses/ExpensesBudgetsModel'=>'expensesBudgetsModel',
            'expenses/ExpensesTypesModel'=>'expensesTypesModel',
            'expenses/ExpensesCategoriesModel'=>'expensesCategoriesModel'
        ));
        $this->load->helper("form");
        $this->pagedata['title'] = 'Account History | '.$this->config->item('application_name');
        $this->pagedata['account']= $this->accountingModel->account($account);
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/accounts/accounthistory');
    }

  function increasedecrease($key=''){
      $this->load->model(array('accounting/glModel'=>'glModel'));
      $this->load->helper('reports/accounting/helper');
      $this->load->model(array('accounting/GeneralLedgerModel'=>'generalLedgerModel'));
      $account = $this->accountingModel->account($key);
      $action = $this->input->get('action',TRUE);
            switch (strtolower($action)){
                case "increase":
                    $gldata['gl_'.$account->subtype_increase_nature] = to_dollar(filterNumber($this->input->get("amount",TRUE)));
                    break;
                case "decrease":
                    $gldata['gl_'.$account->subtype_decrease_nature] = to_dollar(filterNumber($this->input->get("amount",TRUE)));
                    break;
                default:
                    $result['status'] = false;
                    $result['message'] = 'We could not process your request at a time';
                    break;
            }

        $this->db->trans_start();
        $gldata['gl_key'] = $this->glModel->glKey();
        $gldata['gl_amount'] = to_dollar(filterNumber($this->input->get("amount",TRUE)));
        $gldata['gl_type'] = $action;
        $gldata['gl_details'] = $this->input->get('desc',TRUE);
        $gldata['gl_account'] = $key;
        $gldata['gl_reference'] = $gldata['gl_key'];
        $gldata['gl_account_type'] = $account->account_type;
        $gldata['gl_account_sub_type'] = $account->account_sub_type;
        $gldata['gl_status'] = "PENDING";
        $gldata['gl_user'] = $this->auth_user_id;
        $gldata['gl_business'] = runningBusiness()->business_key;
        $gldata['gl_branch'] = runningBranch()->branch_key;
        $gldata['gl_date'] =  date("Y-m-d",strtotime($this->input->get('date',TRUE)));
        $id = $this->generalLedgerModel->insert($gldata);
        $balance['gl_balance'] = accountBalance($gldata['gl_account']);
        $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

        $this->db->trans_complete();
            if($this->db->trans_status() == TRUE){
                $result['status'] = true;
                $result['message'] = 'Successfully';
            }else{
                $result['status'] = false;
                $result['message'] = checkMysqlErrorWithCode();
            }

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        echo json_encode($result, JSON_PRETTY_PRINT);
        exit();
    }

  public function newexpense() {
        $this->load->model(array(
            'expenses/ExpensesModel'=>'expensesModel',
            'expenses/ExpensesBudgetsModel'=>'expensesBudgetsModel',
            'expenses/ExpensesTypesModel'=>'expensesTypesModel',
            'expenses/ExpensesCategoriesModel'=>'expensesCategoriesModel'
        ));
        $this->load->helper('form');
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/accounts/newexpense');
    }

  function registerexpense($account)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->load->model(array(
            'expenses/ExpensesModel'=>'expensesModel',
            'expenses/ExpensesBudgetsModel'=>'expensesBudgetsModel',
            'expenses/ExpensesTypesModel'=>'expensesTypesModel',
            'expenses/ExpensesCategoriesModel'=>'expensesCategoriesModel'
        ));

        $data['expense_business'] = runningBusiness()->business_key;
        $data['expense_branch'] = runningBranch()->branch_key;
        $data['expense_creator'] = $this->auth_user_id;
        $data['expense_date_posted'] = date('Y-m-d H:i:s',strtotime($this->input->get('expense_date_posted', TRUE)));
        $data['expense_account'] = $this->input->get('expense_account', TRUE);
        $data['expense_withdraw_account'] = $account;
        $data['expense_status'] = $this->input->get('expense_status', TRUE);
        $data['expense_payee'] = $this->input->get('expense_payee', TRUE);
        $data['expense_category'] = $this->input->get('expense_category', TRUE);
        $data['expense_type'] = $this->input->get('expense_type', TRUE);
        $data['expense_budget'] = $this->input->get('expense_budget', TRUE);
        $data['expense_details'] = $this->input->get('expense_details', TRUE);
        $data['expense_amount'] = to_dollar(str_ireplace(',', '', $this->input->get('expense_amount', TRUE)));
        $data['expense_paid'] = to_dollar(str_ireplace(',', '', $this->input->get('expense_paid', TRUE)));
        $data['expense_key'] = $this->expensesModel->expenseKey();

        if(!empty($settings = $this->expensesModel->expense_settings())){

            if(!$settings->setting_budget_override){
                if(to_dollar(str_ireplace(',', '', $this->input->get('expense_paid', TRUE))) <= 0){
                    $results['message'] = 'You must enter <b class="text-danger">Expense Paid Amount</b>';
                    $results['status'] = false;
                    echo json_encode($results, JSON_PRETTY_PRINT);
                    return;
                }

                $budgetbalance = $this->expensesBudgetsModel->getBalance($data['expense_budget']);
                if($budgetbalance < $data['expense_paid']){
                    $results['message'] = 'You can not spend more than budget, Current balance is '.number_format(to_money($budgetbalance));
                    $results['status'] = false;
                    echo json_encode($results, JSON_PRETTY_PRINT);
                    return;
                }

            }
        }

        $this->db->trans_start();

        $this->db->insert('expenses', $data);
        if (!empty($this->input->get('uploadedfiles'))) {
            $raw = explode('LM-55', $_GET['uploadedfiles']);
            foreach ($raw as $key => $file) {
                $file = unserialize($file);
                if (is_array($file)) {
                    foreach ($file as $dt) {
                        if (!empty($dt)) {
                            $filedata['doc_expense'] = $data['expense_key'] ;
                            $filedata['doc_name'] = $dt['doc_name'];
                            $filedata['doc_type'] = $dt['doc_type'];
                            $filedata['doc_ext'] = $dt['doc_ext'];
                            $this->db->insert('expense_docs', $filedata);
                        }
                    }
                }
            }
        }

        $this->db->trans_complete();
        if ($this->db->trans_status() == TRUE) {
            publishEventFlash("expenses_register");
            $results['message'] = 'Expense registered successfully ';
            $results['status'] = true;

        } else {
            $results['message'] = 'Failed to register expense';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

  function source_account_history($account,$when=""){
      $this->load->model(array('accounting/GlModel'=>'glModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->generalLedgerModel->find_many_by(['gl_account' => $account]);
      $columns = array();
      foreach ($this->generalLedgerModel->selectable_fields as $field){
          $columns[$field] = TRUE;
      }
      print $this->datasourceLibrary->server($data,$columns);
    }
}
