<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
* Description of Dashboard
*
* @author test
*/

class Index extends MY_Controller{

  public  $pagedata;

  public function __construct() {
    parent::__construct();
    $this->require_min_level(1);
    $this->pagedata['link']= 'accounting';
    $this->load->model(array(
        'accounting/accounting'=>'accountingModel',
        'accounting/GlModel'=>'glModel',
        'accounting/GeneralLedgerModel'=>'generalLedgerModel'
    ));
  }
 
  public function index() {
    $this->pagedata['title'] = 'General Ledger | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('accounting/gl/gl');
  }

  function setinvoicestatus($password='',$invoice='',$status=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if (empty($password)) {
            $results['status'] = false;
            $results['message'] = 'You must provide password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        if (!checkAccessPassword($password)) {
            $results['status'] = false;
            $results['message'] = 'You provided wrong password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

      $business = runningBusiness()->business_key;
      $branch = runningBranch()->branch_key;
      $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
      $ledger = $this->generalLedgerModel->find($invoice);

      $this->generalLedgerModel->where('gl_business',$business);
      $this->generalLedgerModel->where('gl_branch',$branch);
      if(urldecode(strtoupper($status)) == "DRAFT"){
          $this->generalLedgerModel->where('gl_business',$business);
          $this->generalLedgerModel->where('gl_branch',$branch);
          $this->generalLedgerModel->soft_delete(FALSE);
          $flag = $this->generalLedgerModel->delete_by(['gl_activity' => $ledger['gl_activity']]);
      }else{
          $flag = $this->generalLedgerModel->update_by(['gl_activity' => $ledger['gl_activity']],['gl_status' => urldecode(strtoupper($status))]);
      }

      if($flag){
          $this->invoiceTransactionsModel->where('inv_pay_business',$business);
          $this->invoiceTransactionsModel->where('inv_pay_branch',$branch);
          $this->invoiceTransactionsModel->update($ledger['gl_activity'],['inv_pay_post_status' => urldecode(strtoupper($status))]);

          $results['message'] = 'Record restored successfully';
          $results['status'] = true;
      }else{
          $results['message'] = 'Failed to restore Record';
          $results['status'] = false;
      }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

  function setjournalstatus($password='',$key='',$status=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if (empty($password)) {
            $results['status'] = false;
            $results['message'] = 'You must provide password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        if (!checkAccessPassword($password)) {
            $results['status'] = false;
            $results['message'] = 'You provided wrong password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->load->model(array('accounting/JournalsModel'=>'journalsModel'));
        $ledger = $this->generalLedgerModel->find($key);

        $this->generalLedgerModel->where('gl_business',$business);
        $this->generalLedgerModel->where('gl_branch',$branch);
        if(urldecode(strtoupper($status)) == "DRAFT"){
            $this->generalLedgerModel->where('gl_business',$business);
            $this->generalLedgerModel->where('gl_branch',$branch);
            $this->generalLedgerModel->soft_delete(FALSE);
            $flag = $this->generalLedgerModel->delete_by(['gl_activity' => $ledger['gl_activity']]);
        }else{
            $flag = $this->generalLedgerModel->update_by(['gl_activity' => $ledger['gl_activity']],['gl_status' => urldecode(strtoupper($status))]);
        }
        if($flag){
            $this->journalsModel->where('journal_business',$business);
            $this->journalsModel->where('journal_branch',$branch);
            $this->journalsModel->update($ledger['gl_activity'],['journal_status' => urldecode(strtoupper($status))]);

            $results['message'] = 'Record restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore Record';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

  function datasource(){
    $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
    $transactions = $this->generalLedgerModel->find_all();
    $columns = array();
    foreach ($this->generalLedgerModel->selectable_fields as $field){
        $columns[$field] = TRUE;
    }

    print $this->datasourceLibrary->server($transactions,$columns);
}

  function datasourcebin(){
    $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
    $this->generalLedgerModel->where('gl_deleted',1);
    $transactions = $this->generalLedgerModel->with_deleted()->find_all();
    $columns = array();
    foreach ($this->generalLedgerModel->selectable_fields as $field){
        $columns[$field] = TRUE;
    }
    print $this->datasourceLibrary->server($transactions,$columns);
}

  function printrecord($record){
        $gl = $this->glModel->gl($record);
        if(!empty($gl)){
            switch (strtolower($gl->gl_type)){
                case 'increase':
                    $this->pagedata['gl'] = $gl;
                    $this->pagedata['account'] = $this->accountingModel->account($gl->gl_account);
                    $this->load->vars($this->pagedata);
                    $output = $this->load->view('accounting/print_templates/account_increase_default',$this->pagedata,TRUE);
                    print $output;
                    break;
                case 'decrease':
                    $this->pagedata['gl'] = $gl;
                    $this->pagedata['account'] = $this->accountingModel->account($gl->gl_account);
                    $this->load->view('accounting/record_details/account_decrease','',$gl);
                    break;
            }
        }else{
            print "<h3>We could not find a record</h3>";
        }
    }

}
