<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author noely
 */
class Index extends MY_Controller{

  public $pagedata;
  public $branch;
  public $business;

  public function __construct() {
    parent::__construct();
    ($this->require_min_level(1));
    $this->pagedata['link']= 'administration';
    $this->load->model(array('hrm/employees'=>'employeesModel','administration/titlesModel'=>'titlesModel','payrollsModel'=>'titlesModel','hrm/TitlesModel'=>'titlesModel'));
    $this->branch = runningBranch()->branch_key;
    $this->business = runningBusiness()->business_key;
    $this->load->helper('hrm/hrm');
  }

  public function index() {
    has_control('employee_view_all','View all employees');
    $this->load->helper('form');
    $this->pagedata['employees'] = $this->employeesModel->employees();
    $this->pagedata['title'] = 'Employees | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('administration/employees/employees');
  }

  public function newemployee() {
    has_control('employee_register','Register Employee');
    $this->load->helper('form');
    //$this->pagedata['departments'] = $this->departmentsModel->departments();
    $this->pagedata['titles'] = $this->titlesModel->categories();
    $this->pagedata['taxes'] = $this->payrollsModel->taxes();
    $this->pagedata['paye'] = $this->payrollsModel->paye();
    $this->pagedata['variables'] = $this->variablesModel->variables();
    $this->pagedata['title'] = 'New Employee | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('administration/employees/newemployee');
  }


function createEmployee(){
  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');
  has_control_ajax('employee_register','Register Employee');
  $primary = $this->collectPrimaryInfo();
  $security = $this->collectSecurityInfo();
  $taxes = $this->collectTaxinfo();
  $variables = $this->collectVariableinfo();
  $roles = $this->collectRolesinfo();
  if($this->employeesModel->registerEmployee($primary,$security,$taxes,$variables,$roles)){
      $result['status'] = 'ok';
      $result['message'] = 'You have successfully registered an Employee';
    }else{
      $result['status'] = 'no';
      $result['message'] = checkError($this->dbexeption());
  }

  print json_encode($result);
}


  public function departments() {
    $this->load->helper('form');
    $this->pagedata['titles'] = $this->TitlesModel->categories();
    $this->pagedata['departments'] = $this->departmentsModel->departments();
    $this->pagedata['title'] = 'Employees | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('administration/employees/employee/departments');
  }

  public function checkusernameonly($username='') {
     if (!$this->input->is_ajax_request())
      exit('not direct script allowed');
    $this->db->where('username',urldecode($username));
    $query = $this->db->get('users');
     if($query->num_rows()>0){
               $result['status'] = 'no';
         }else{
           $result['status'] = 'ok';
     }
    print json_encode($result);
  }

  public function checkusername($employee='',$username='') {
    // if (!$this->input->is_ajax_request())
    //  exit('not direct script allowed');
    $this->db->where('username',urldecode($username));
    $this->db->where('user_id !=',$employee);
    $this->db->where('user_branch',$this->branch);
    $this->db->where('user_business',$this->business);
    $query = $this->db->get('users');
     if($query->num_rows()>0){
               $result['status'] = 'no';
         }else{
           $result['status'] = 'ok';
     }
    print json_encode($result);
  }

  public function checkemailonly($email) {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');

    $this->db->where('email',urldecode($email));
    $query = $this->db->get('users');
     if($query->num_rows()>0){
               $result['status'] = 'no';
         }else{
           $result['status'] = 'ok';
     }
    print json_encode($result);
  }

  public function checkemail($employee,$email) {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');

    $this->db->where('email',urldecode($email));
    $this->db->where('user_id !=',$employee);
    $this->db->where('user_branch',$this->branch);
    $this->db->where('user_business',$this->business);
    $query = $this->db->get('users');
     if($query->num_rows()>0){
               $result['status'] = 'no';
         }else{
           $result['status'] = 'ok';
     }
    print json_encode($result);
  }

  public function details($employee='') {
    has_control('employee_view_details','View Employee details');
    $this->load->helper('form');
    $this->pagedata['employee']= $this->employeesModel->employee($employee);
    $this->pagedata['title'] = 'Employee details | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('administration/employees/employee/details');
  }

  public function loadInformationsallaryadvances($employee='') {
    $this->load->model(array('TitlesModel'=>'titlesModel'));
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax_content('employee_view_details','View Employee details');
    $data['ad_employee'] = $employee;
    $data['ad_date'] = date('Y-m-d');
    $data['ad_amount'] = to_dollar($this->input->get('amount',TRUE));
    $data['ad_details'] = $this->input->get('details',TRUE);
    if(!empty($_GET)){
       has_control_ajax('employee_update','Update Employee details');
      if($this->employeesModel->addsallaryadvance($employee,$data)){
        $result['status'] = 'ok';
        $result['message'] = 'Sallary Advance added successfully';
        }else{
          $result['status'] = 'no';
          $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
        exit();
    }
    $this->pagedata['total_advance'] = $this->employeesModel->employeetotalsallaryadvace($employee);
    $this->pagedata['month_advance'] = $this->employeesModel->employeemonthsallaryadvance($employee);
    $this->pagedata['paid_advance'] = $this->employeesModel->employeesallaryadvancepaidtotal($employee);
    $this->pagedata['employee']= $this->employeesModel->employee($employee);
    $this->pagedata['titles'] = $this->titlesModel->categories();
    $this->load->vars($this->pagedata);
    $this->load->view('administration/employees/employee/sallaryadvances');
  }

  function modifysallaryadvance($employee='',$dept=''){
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax_content('employee_view_details','View Employee details');
    $data['ad_amount'] = to_dollar($this->input->get('amount',TRUE));
    $data['ad_details'] = $this->input->get('details',TRUE);
    if(!empty($_GET)){
      has_control_ajax('employee_update','Update Employee details');
      if($this->employeesModel->employeesallaryadvanceupdate($employee,$dept,$data)){
        $result['status'] = 'ok';
        $result['message'] = 'Sallary Advance updated successfully';
        }else{
          $result['status'] = 'no';
          $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
        exit();
    }
    $this->pagedata['employee']= $this->employeesModel->employee($employee);
    $this->pagedata['advance'] = $this->employeesModel->employeesallaryadvancedetails($employee,$dept);
    $this->load->vars($this->pagedata);
    $this->load->view('administration/employees/employee/sallaryadvancedetails');
  }

  public function loadInformationinternaldepts($employee='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax_content('employee_view_details','View Employee details');
    $this->load->model(array('TitlesModel'=>'titlesModel'));
    $data['id_employee'] = $employee;
    $data['id_date'] = date('Y-m-d');
    $data['id_amount'] = to_dollar($this->input->get('amount',TRUE));
    $data['id_rate'] = to_dollar($this->input->get('rate',TRUE));
    $data['id_rate_type'] = $this->input->get('rate_type',TRUE);
    $data['id_details'] = $this->input->get('details',TRUE);
    if(!empty($_GET)){
      has_control_ajax('employee_update','Update Employee details');
      if($this->employeesModel->adddept($employee,$data)){
        $result['status'] = 'ok';
        $result['message'] = 'Dept added successfully';
        }else{
          $result['status'] = 'no';
          $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
        exit();
    }
    $this->pagedata['total_dept'] = $this->employeesModel->employeetotaldept($employee);
    $this->pagedata['month_dept'] = $this->employeesModel->employeemonthdept($employee);
    $this->pagedata['paid_depts'] = $this->employeesModel->employeedeptspaidtotal($employee);
    $this->pagedata['employee']= $this->employeesModel->employee($employee);
    $this->pagedata['titles'] = $this->titlesModel->categories();
    $this->load->vars($this->pagedata);
    $this->load->view('administration/employees/employee/internaldepts');
  }

function modifyinternaldept($employee='',$dept=''){
  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');
   has_control_ajax_content('employee_view_details','View Employee details');
  $data['id_rate'] = to_dollar($this->input->get('rate',TRUE));
  $data['id_rate_type'] = $this->input->get('rate_type',TRUE);
  $data['id_amount'] = to_dollar($this->input->get('amount',TRUE));
  $data['id_details'] = $this->input->get('details',TRUE);
  if(!empty($_GET)){
    has_control_ajax('employee_update','Update Employee details');
    if($this->employeesModel->employeeinternaldeptupdate($employee,$dept,$data)){
      $result['status'] = 'ok';
      $result['message'] = 'Dept updated successfully';
      }else{
        $result['status'] = 'no';
        $result['message'] = checkError($this->dbexeption());
      }
      print json_encode($result);
      exit();
  }
  $this->pagedata['employee']= $this->employeesModel->employee($employee);
  $this->pagedata['dept'] = $this->employeesModel->employeedeptdetails($employee,$dept);
  $this->load->vars($this->pagedata);
  $this->load->view('administration/employees/employee/deptdetails');
}
  public function loadInformationsecurity($key='') {
    // if (!$this->input->is_ajax_request())
    //  exit('not direct script allowed');
     has_control_ajax_content('employee_view_details','View Employee details');
    $this->load->model(array('TitlesModel'=>'titlesModel'));
    $this->pagedata['employee']= $this->employeesModel->employee($key);
    $this->pagedata['titles'] = $this->titlesModel->categories();
    $this->load->vars($this->pagedata);
    $this->load->view('administration/employees/employee/securityAjax');
  }

  public function loadInformationroles($key='') {
//    if (!$this->input->is_ajax_request())
//     exit('not direct script allowed');
     has_control_ajax_content('employee_view_details','View Employee details');
    $this->load->model(array('hrm/RolesModel'=>'rolesModel','hrm/TitlesModel'=>'titlesModel'));
    $this->pagedata['employee']= $this->employeesModel->employee($key);
    $this->pagedata['roles'] = $this->rolesModel->roles();
    $this->load->vars($this->pagedata);
    $this->load->view('administration/employees/employee/rolesAjax');
  }

  public function loadInformationprimary($key='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax_content('employee_view_details','View Employee details');
    $this->pagedata['employee']= $this->employeesModel->employee($key);
    $this->load->vars($this->pagedata);
    $this->load->view('administration/employees/employee/detailsAjax');
  }

  public function loadInformationsalaryslips($key='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax_content('employee_view_details','View Employee details');
    $this->pagedata['taxes'] = $this->payrollsModel->taxes();
    $this->pagedata['paye'] = $this->payrollsModel->paye();
    $this->pagedata['variables'] = $this->variablesModel->variables();
    $this->pagedata['employee']= $this->employeesModel->employee($key);
    $this->load->vars($this->pagedata);
    $this->load->view('administration/employees/employee/payrollAjax');
  }


  public function loadInformationRoleAction($key='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax('employee_update','Update Employee details');
     has_control_ajax('roles_control','Update Role details');
     $roles['role_register_client'] = !empty($this->input->get('role_register_client', TRUE)) ? $this->input->get('role_register_client', TRUE) : 0;
     if($this->employeesModel->employeeUpdateRoles($key,$roles)){
               $result['status'] = 'ok';
               $result['message'] = 'Role(s) information changed successifully';
             }else{
               $result['status'] = 'no';
               $result['message'] = checkError($this->dbexeption());
             }
    print json_encode($result);
  }

  public function loadInformationSecurityAction($key='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax('employee_update','Update Employee details');
         $security['user_lang'] = $this->input->get('user_lang', TRUE);
         $security['auth_level'] = $this->input->get('auth_level',TRUE);
         $security['user_title'] = $this->input->get('user_title',TRUE);
         $security['email'] = $this->input->get('email',TRUE);
         $security['username'] = $this->input->get('username',TRUE);
         if(!empty($this->input->get('password',TRUE))){
           $security['passwd'] =$this->authentication->hash_passwd($this->input->get('password',TRUE));
         }
         $security['communicate_sms'] = !empty($this->input->get('communicate_sms', TRUE)) ? $this->input->get('communicate_sms', TRUE) : 0;
         $security['communicate_phone'] = !empty($this->input->get('communicate_phone', TRUE)) ? $this->input->get('communicate_phone', TRUE) : 0;
         $security['communicate_email'] = !empty($this->input->get('communicate_email', TRUE)) ? $this->input->get('communicate_email', TRUE) : 0;
         if($this->employeesModel->employeeUpdateSecurity($key,$security)){
                   $result['status'] = 'ok';
                   $result['message'] = 'Security information changed successifully';
                 }else{
                   $result['status'] = 'no';
                   $result['message'] = checkError($this->dbexeption());
                 }
        print json_encode($result);

  }

  public function loadInformationPayrollAction($key=''){
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax('employee_update','Update Employee details');
     $taxes = $this->collectTaxinfo();
     $variables = $this->collectVariableinfo();
     $salary['net_salary']  = to_dollar($this->input->get('net_salary',TRUE));
     if($this->employeesModel->employeeUpdatePayroll($key,$salary,$taxes,$variables)){
               $result['status'] = 'ok';
               $result['message'] = 'Payroll information changed successifully';
             }else{
               $result['status'] = 'no';
               $result['message'] = checkError($this->dbexeption());
             }
       print json_encode($result);
  }

  public function loadInformationPrimaryAction($key=''){
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax('employee_update','Update Employee details');
     $employee['net_salary']  = to_dollar($this->input->get('net_salary',TRUE));
     $employee['gender'] = $this->input->get('gender', TRUE);
     $employee['country'] = $this->input->get('country', TRUE);
     $employee['state'] = $this->input->get('state', TRUE);
     $employee['city'] = $this->input->get('city', TRUE);
     $employee['residential_address'] = $this->input->get('residential_address', TRUE);
     $employee['home_address'] = $this->input->get('home_address', TRUE);
     $employee['city'] = $this->input->get('city', TRUE);
     $employee['dob'] = date('Y-m-d',strtotime($this->input->get('dob', TRUE)));
     $employee['middlename'] = $this->input->get('middlename', TRUE);
     $employee['firstname'] = $this->input->get('firstname', TRUE);
     $employee['lastname'] = $this->input->get('lastname', TRUE);
     if($this->employeesModel->employeeUpdatePrimary($key,$employee)){
               $result['status'] = 'ok';
               $result['message'] = 'Primary information changed successifully';
             }else{
               $result['status'] = 'no';
               $result['message'] = checkError($this->dbexeption());
             }
       print json_encode($result);
  }

  function collectSecurityInfo(){
    $security['auth_level'] = $this->input->get('auth_level',TRUE);
    $security['user_title'] = $this->input->get('user_title',TRUE);
    $security['email'] = $this->input->get('email',TRUE);
    $security['username'] = $this->input->get('username',TRUE);
    $security['phonenumber'] = $this->input->get('phonenumber',TRUE);
    if(!empty($this->input->get('password',TRUE))){
      $security['passwd'] =$this->authentication->hash_passwd($this->input->get('password',TRUE));
    }
    $security['communicate_sms'] = !empty($this->input->get('communicate_sms', TRUE)) ? $this->input->get('communicate_sms', TRUE) : 0;
    $security['communicate_phone'] = !empty($this->input->get('communicate_phone', TRUE)) ? $this->input->get('communicate_phone', TRUE) : 0;
    $security['communicate_email'] = !empty($this->input->get('communicate_email', TRUE)) ? $this->input->get('communicate_email', TRUE) : 0;
    $security['user_branch'] = $this->branch;
    $security['user_business'] = $this->business;
    $security['user_lang'] = profile()->user_lang;
    return $security;
  }

  function collectPrimaryInfo(){
    $primary['details_branch'] = $this->branch;
    $primary['details_business'] = $this->business;
    $primary['net_salary'] = to_dollar(str_ireplace(',','',$this->input->get('net_salary',TRUE)));
    $primary['firstname'] = $this->input->get('firstname',TRUE);
    $primary['middlename'] = $this->input->get('middlename',TRUE);
    $primary['lastname'] = $this->input->get('lastname',TRUE);
    $primary['gender'] = $this->input->get('gender',TRUE);
    $primary['dob'] = $this->input->get('dob',TRUE);
    $primary['country'] = $this->input->get('country',TRUE);
    $primary['state'] = $this->input->get('state',TRUE);
    $primary['city'] = $this->input->get('city',TRUE);
    $primary['home_address'] = $this->input->get('home_address',TRUE);
    $primary['residential_address'] = $this->input->get('residential_address',TRUE);
    $primary['identity_type'] = $this->input->get('identity_type',TRUE);
    $primary['identity_value'] = $this->input->get('identity_value',TRUE);
    return $primary;
  }

  function collectTaxinfo(){
    $taxes = $this->input->get('payroll_tax',TRUE);
    if(empty($taxes))
    return false;
    $overide = to_dollar($this->input->get('payroll_tax_overide',TRUE));
    $data = array();
    foreach ($taxes as $i => $tax) {
      $data[$i]['et_tax_key'] =  $tax;
      if(!empty($overide[$i])){
        $data[$i]['et_overide_value'] = $overide[$i];
      }else{
        $data[$i]['et_overide_value'] = NULL;
      }
    }
  return $data;
  }

  function collectRolesinfo(){
    $title = $this->input->get('user_title',TRUE);
    $categoryId = $this->db->where('category_key',$title)->get('acl_categories')->row()->category_id;
    $this->db->select('action_id');
    $this->db->where('action_business',$this->business);
    $this->db->where('category_id',$categoryId);
    $results = $this->db->get('acl_actions');
    if($results->num_rows()>0){
     $data = array();
      foreach ($results->result_array() as $k => $result) {
        $data[$k]['action_id'] =  $result['action_id'];
      }
      return $data;
    }else{
      return false;
    }
  }

  function collectVariableinfo(){
    $variables = $this->input->get('payroll_variable',TRUE);
    if(empty($variables))
    return false;
    $overide = to_dollar(str_ireplace(',','',$this->input->get('payroll_variable_overide',TRUE)));
    $data = array();
    foreach ($variables as $i => $variable) {
      $data[$i]['ev_variable_key'] =  $variable;
      if(!empty($overide[$i])){
        $data[$i]['ev_overide_value'] = $overide[$i];
      }else{
        $data[$i]['ev_overide_value'] = NULL;
      }
    }
  return $data;
  }

 public function delete($flag,$key) {
     // if (!$this->input->is_ajax_request())
     //  exit('not direct script allowed');
           switch ($flag) {
               case 'employee':
               if($key != 1010101010){
               if($this->employeesModel->employee_delete($key)){
                         $result['status'] = 'ok';
                         $result['message'] = 'Employee deleted';
                       }else{
                         $result['status'] = 'no';
                         $result['message'] = checkError();
                       }
                 print json_encode($result);
                }else{
                  $result['status'] = 'no';
                  $result['message'] = 'You can not delete System Administrator';
                   print json_encode($result);
                }
               break;
               case 'dept':
               if($this->employeesModel->deletedept($key)){
                         $result['status'] = 'ok';
                         $result['message'] = 'Dept deleted successfully';
                       }else{
                         $result['status'] = 'no';
                         $result['message'] = checkError($this->dbexeption());
                       }
                 print json_encode($result);
                break;
                case 'sallaryadvance':
                if($this->employeesModel->deletesallaryadvance($key)){
                          $result['status'] = 'ok';
                          $result['message'] = 'Sallary Advance deleted successfully';
                        }else{
                          $result['status'] = 'no';
                          $result['message'] = checkError($this->dbexeption());
                        }
                  print json_encode($result);
                 break;
               default:
                   print 'fail';
               break;
           }
 }

 function employeedeptsummary($employee=''){
   $this->data['total_dept'] = $this->employeesModel->employeetotaldept($employee);
   $this->data['month_dept'] = $this->employeesModel->employeemonthdept($employee);
   $this->data['paid_depts'] = $this->employeesModel->employeedeptspaidtotal($employee);
   $this->load->view('administration/employees/employee/deptsummary',$this->data);
 }

 function employeesallaryadvancesummary($employee=''){
   $this->pagedata['total_advance'] = $this->employeesModel->employeetotalsallaryadvace($employee);
   $this->pagedata['month_advance'] = $this->employeesModel->employeemonthsallaryadvance($employee);
   $this->pagedata['paid_advance'] = $this->employeesModel->employeesallaryadvancepaidtotal($employee);
   $this->load->view('administration/employees/employee/sallaryadvancesummary',$this->pagedata);
 }

function datasource(){
  $data =  $this->employeesModel->employees();
  $this->sourcedata($data);
}

function datasourcedepartments(){
  $data =  $this->employeesModel->departments();
  $this->sourcedata($data);
}

function datasourcedepts($key=''){
  $data =  $this->employeesModel->employee_depts($key);
  $this->sourcedata($data);
}

function datasourcesallaryadvances($key=''){
  $data =  $this->employeesModel->employeesallaryadvances($key);
  $this->sourcedata($data);
}


}