<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Titles extends MY_Controller{

  public $pagedata;
  public $branch;
  public $business;

  public function __construct() {
    parent::__construct();
    ($this->require_min_level(1));
    $this->pagedata['link']= 'administration';
    $this->load->helper('administration');
    $this->load->model(array('administration/titlesModel'=>'titlesModel'));
    $this->branch = runningBranch()->branch_key;
    $this->business = runningBusiness()->business_key;
  }

  public function index() {
    has_control('titles_view_all','View all Titles');
    $this->load->helper('form');
    $this->pagedata['title'] = 'Titles | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('administration/employees/titles/titles');
  }

function details($category=''){
  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');
   has_control_ajax_content('titles_details','View Title details');
  $this->load->helper('form');
  $this->pagedata['category'] = $this->titlesModel->category($category);
  $this->load->vars($this->pagedata);
  $this->load->view('administration/employees/titles/details');
}

function modify($category=''){
  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');
   has_control_ajax_content('titles_update','Update Title details');
  $this->load->helper('form');
  $this->pagedata['category'] = $this->titlesModel->category($category);
  $this->load->vars($this->pagedata);
  $this->load->view('administration/employees/titles/detailsModify');
}

function update($categoryKey=''){
  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');
   has_control_ajax('titles_update','Update Title details');
  $category['category_name'] = $this->input->get('category_name',TRUE);
  $category['category_code'] = str_ireplace('.','',str_ireplace(' ','_',$this->input->get('category_name',TRUE)));
  $category['category_details'] = $this->input->get('category_details',TRUE);
  if($this->titlesModel->categoryUpdate($categoryKey,$category)){
            $result['status'] = 'ok';
            $result['message'] = 'Title updated successfully';
          }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
          }
 print json_encode($result);
}

function newTitle(){
  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');
   has_control_ajax('titles_register','Register Title');
    $category['category_name'] = $this->input->get('category_name',TRUE);
    $category['category_code'] = str_ireplace('.','',str_ireplace(' ','_',$this->input->get('category_name',TRUE)));
    $category['category_details'] = $this->input->get('category_details',TRUE);
    if($this->titlesModel->categoryRegister($category)){
              $result['status'] = 'ok';
              $result['message'] = 'Title registered successfully';
            }else{
              $result['status'] = 'no';
              $result['message'] = checkError($this->dbexeption());
            }
   print json_encode($result);
  }

  function deleteselected(){
    $rawids = $this->input->get('data');
    if(!empty($rawids)){
      $this->db->trans_start();
      foreach ($rawids as $y => $row) {
        $this->titlesModel->deleteTitle($row);
      }

      $this->db->trans_complete();
      if($this->db->trans_status() == TRUE){
        $result['status'] = 'ok';
        $result['message'] = 'Congratulations! You have successifully Deleted Title(S)';
        $result['type'] = 'success';
      }else{
        $result['status'] = 'no';
        $result['message'] = 'Unfortunatelly, You request could not be completed';
        $result['type'] = 'warning';
      }
    }else{
      $result['status'] = 'no';
      $result['message'] = 'Please select Title(s) to delete';
      $result['type'] = 'warning';
    }
    echo json_encode( $result);
  }



public function delete($flag,$key) {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
      switch ($flag) {
          case 'title':
          has_control_ajax('titles_delete','Delete Title');
          if($this->titlesModel->deleteTitle($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Title deleted';
                  }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                  }
            print json_encode($result);
          break;
          default:
            $result['status'] = 'no';
            $result['message'] = 'No action';
             print json_encode($result);
          break;
      }
  }

function datasource(){
  $data =  $this->titlesModel->categories();
  $columnsDefault = [
    'category_id' =>true,
    'category_key' => true,
    'category_name' => true,
    'category_details' => true
  ];
  $this->sourcedataserver($data,$columnsDefault);
}

}