<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Dashboard
 *
 * @author Elieza Kalaita
 */
class Index extends MY_Controller{

    public  $appdata;

    function __construct() {
        parent::__construct();

        $this->require_min_level(1);
        $this->appdata['title']= 'Communication | Inbox';
        $this->load->model(array(
            'communication/InboxModel' =>'inboxModel',
            'communication/OutboxModel' =>'outboxModel',
            'communication/ReplyModel' =>'replyModel',
            'communication/UsersModel' =>'usersModel'
        ));
        $this->appdata['link']= 'communication';
        $this->load->vars($this->appdata);
        $this->load->helper('form');
        $this->load->library("pagination");
        $this->load->helper('url');
    }

    function index() {
        //for pagination
        $user_key = profile()->user_key;
        $inboxrows = $this->inboxModel->count_by(['receiver_id'=>$user_key,'is_receiver_deleted'=>0, 'is_receiver_recycle'=>0]);
        $repliedinboxrows = $this->inboxModel->count_by(['sender_id'=>$user_key, 'msg_replied'=>1,'is_sender_deleted'=>0, 'is_sender_recycle'=>0]);
        $totalinboxrows = $inboxrows + $repliedinboxrows;

        $config = array();
        $config["base_url"] = base_url() . "communication";
        $config["total_rows"] = $totalinboxrows;
        $config["per_page"] = 10;
        $config["uri_segment"] = 2;

        $this->pagination->initialize($config);
        $page = ($this->uri->segment(2)) ? $this->uri->segment(2) : 0;
        $data["links"] = $this->pagination->create_links();
        $data['msg'] = $this->inboxModel->getInbox($config["per_page"], $page);
        $data['myreplies'] = $this->inboxModel->getRepliedMsg($config["per_page"], $page);
        $this->load->view('communication/inbox', $data);

    }
    function send_msg()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        //Data for table comm_sent
        $user_key = profile()->user_key;
        $outbox = array('sender_id'=>$user_key,
            'receiver_id'=>$this->input->post('compose_to', TRUE),
            'msg_subject'=>$this->input->post('compose_subject', TRUE),
            'msg_body'=>$this->input->post('compose_msg', TRUE),
            'msg_status'=>'sent');

        //Data for table comm_inbox
        $inbox = array('sender_id'=>$user_key,
            'receiver_id'=>$this->input->post('compose_to', TRUE),
            'msg_subject'=>$this->input->post('compose_subject', TRUE),
            'msg_body'=>$this->input->post('compose_msg', TRUE));

        $this->db->trans_start();

        $id = $this->outboxModel->insert($outbox);

        $rawData = $this->outboxModel->find_by(["msg_id" => $id]);

        $inbox['msg_key'] = $rawData['msg_key'];
        $this->inboxModel->insert($inbox);

        $this->db->trans_complete();

        $profile = profile();
        if($this->db->trans_status() === TRUE){
            $res['message'] = 'Message successfully sent';
            $res['status'] = true;

            /** Here we alert receiver on new message */
            $data['role_action'] = "freight_view_all";
            $data['title'] = "New message received from ".$profile->firstname." ".$profile->lastname;
            $data['link']= base_url('communication');
            $data['content'] = "You have got a new message";
            $data['sender'] = $this->auth_user_id;
            $data['type'] = 'communication';
            $data['target'] = 'system';
            $data['receiver'] = $inbox['receiver_id'];
            $data['time'] = date("H:i:s");
            publishEventFlash('notification', $data);
        }else{
            $res['message'] = 'Failed to send message';
            $res['status'] = false;
        }

        echo json_encode($res, JSON_PRETTY_PRINT);
        exit();
    }
    function createReply()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data = array('rep_created_by'=>$this->input->post('rep_created_by', TRUE),
            'rep_msg_key'=>$this->input->post('rep_msg_key', TRUE),
            'rep_body'=>$this->input->post('rep_body', TRUE));

        $this->db->trans_start();

        $id = $this->replyModel->insert($data);

        $rawData = $this->replyModel->find_by(["rep_id" => $id]);

        $key = $rawData['rep_msg_key'];
        $inbox['msg_replied'] = 1;

        //in case the sender was deleted this message, change (is_sender_deleted) to zero to return the message active
        $inbox['is_sender_deleted'] = 0;

        //in case the sender was deleted and trashed this message, change (is_sender_recycle) to zero to return the message active
        $inbox['is_sender_recycle'] = 0;

        //in case the receiver was deleted this message, change (is_receiver_deleted) to zero to return the message active
        $inbox['is_receiver_deleted'] = 0;

        //in case the receiver was deleted and trashed this message, change (is_receiver_recycle) to zero to return the message active
        $inbox['is_receiver_recycle'] = 0;

        $this->inboxModel->update($key, $inbox);

        // here we want to push notification to receiver on this reply
        // get the main message from inbox
        $message = $this->inboxModel->find($key);

        //check if the receiver is not the main message initiator
        if($message['receiver_id'] == $this->auth_user_id){
            $receiver = $message['receiver_id'];
        }

        //check if the receiver is the main message initiator
        elseif ($message['sender_id'] == $this->auth_user_id && $message['msg_replied'] == 1){
            $receiver = $message['sender_id'];
        }

        $this->db->trans_complete();
        $profile = profile();
        if($this->db->trans_status() === TRUE){
            $res['message'] = 'Reply successfully sent';
            $res['status'] = true;

            /** Here we alert receiver on a new reply */
            $msg['role_action'] = "freight_view_all";
            $msg['title'] = $profile->firstname." ".$profile->lastname." Replied your message";
            $msg['link'] = base_url('communication');
            $msg['content'] = "You have got a new reply";
            $msg['sender'] = $this->auth_user_id;
            $msg['type'] = 'communication';
            $msg['target'] = 'system';
            $msg['receiver'] = $receiver;
            $msg['time'] = date("H:i:s");
            publishEventFlash('notification', $msg);
        }else{
            $res['message'] = 'Failed to reply';
            $res['status'] = false;
        }

        echo json_encode($res, JSON_PRETTY_PRINT);
        //exit();

    }
    function saveAsDraft()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        //Data for table comm_sent
        $user_key = profile()->user_key;
        $outbox = array('sender_id'=>$user_key,
            'receiver_id'=>$this->input->post('compose_to', TRUE),
            'msg_subject'=>$this->input->post('subject', TRUE),
            'msg_body'=>$this->input->post('body', TRUE),
            'msg_status'=>$this->input->post('status', TRUE));

        if ($this->outboxModel->insert($outbox)){
            $results['message'] = 'Message saved as draft';
            $results['status'] = true;
        }
        else{
            $results['message'] = 'Failed to save message as draft';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    function viewinbox($id){
        $this->load->helper('url');
        $this->load->helper('form');
        $this->load->vars($this->appdata);
        $query = $this->inboxModel->find_by(['msg_key'=>$id]);
        $this->appdata['title']= 'View Message';
        $this->appdata['query']= $query;
        $this->appdata['id']= $id;
        if (!empty($query))
        {
            $data['msg_status'] = 'read';
            $this->inboxModel->update($id, $data);

            $this->load->vars($this->appdata);
            $this->load->view('communication/load_inbox');
        }
    }
    function deleteinbox()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $user = profile()->user_key;
        $values = $this->input->get('value');
        $check_value = explode(",", $values);
        if(is_array($check_value))
        {
            foreach ($check_value as $key => $value)
            {
                if(empty($value))
                    return;
                $query =  $this->inboxModel->find_by(['msg_key'=>$value]);
                if(!empty($query)){
                    if ($query['receiver_id'] == $user)
                    {
                        $data['is_receiver_deleted']=1;
                        if($this->inboxModel->update($value,$data)){
                            $results['message'] = 'Messages successfully delete!';
                            $results['status'] = true;
                        }
                        else{
                            $results['message'] = 'Failed to delete messages';
                            $results['status'] = false;
                        }

                        echo json_encode($results, JSON_PRETTY_PRINT);
                        //exit();
                    }
                    elseif ($query['sender_id'] == $user && $query['msg_replied'] = 1)
                    {
                        $data2['is_sender_deleted']=1;
                        if($this->inboxModel->update($value,$data2)){
                            $results['message'] = 'Messages successfully delete!';
                            $results['status'] = true;
                        }else{
                            $results['message'] = 'Failed to delete messages';
                            $results['status'] = false;
                        }

                        echo json_encode($results, JSON_PRETTY_PRINT);
                        //exit();
                    }
                }
            }
        }
        else
        {
            $query =  $this->inboxModel->find_by(['msg_key'=>$values]);
            if(!empty($query)){
                if ($query['receiver_id'] == $user)
                {
                    $data['is_receiver_deleted']=1;
                    if($this->inboxModel->update($values,$data)){
                        $results['message'] = 'Message successfully delete!';
                        $results['status'] = true;
                    }
                    else{
                        $results['message'] = 'Failed to delete message';
                        $results['status'] = false;
                    }

                    echo json_encode($results, JSON_PRETTY_PRINT);
                    //exit();
                }
                elseif ($query['sender_id'] == $user && $query['msg_replied'] = 1)
                {
                    $data2['is_sender_deleted']=1;
                    if($this->inboxModel->update($values,$data2)){
                        $results['message'] = 'Message successfully delete!';
                        $results['status'] = true;
                    }else{
                        $results['message'] = 'Failed to delete message';
                        $results['status'] = false;
                    }

                    echo json_encode($results, JSON_PRETTY_PRINT);
                    //exit();
                }
            }
        }

    }
    function outbox(){

        $this->appdata['link']= 'communication';
        $this->appdata['title']= 'Communication | Outbox';
        $this->load->vars($this->appdata);

        //for pagination
        $user_key = profile()->user_key;
        $config = array();
        $config["base_url"] = base_url() . "communication/outbox";
        $config["total_rows"] = $this->outboxModel->count_by(['sender_id'=>$user_key,'msg_status'=>'sent','is_deleted'=>0,'is_recycle'=>0]);
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;

        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data["links"] = $this->pagination->create_links();
        $data['msg'] = $this->outboxModel->getOutbox($config["per_page"], $page);
        $this->load->view('communication/outbox', $data);
    }
    function viewoutbox($id){
        $this->load->helper('url');
        $this->load->helper('form');
        $this->load->vars($this->appdata);
        $query = $this->outboxModel->find_by(['msg_key'=>$id]);
        $this->appdata['title']= 'View Message';
        $this->appdata['query']= $query;
        $this->appdata['id']= $id;
        if (!empty($query))
        {
            $this->load->vars($this->appdata);
            $this->load->view('communication/load_outbox');
        }
    }
    function deleteoutbox()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $values = $this->input->get('value');
        $check_value = explode(",", $values);
        if(is_array($check_value))
        {
            //$query = $this->outboxModel->find_many_by(['msg_key'=>$check_value]);
            foreach ($check_value as $key => $value)
            {
                $data['is_deleted']=1;
                if($this->outboxModel->update($value,$data)){
                    $results['message'] = 'Messages successfully delete!';
                    $results['status'] = true;
                }
                else{
                    $results['message'] = 'Failed to delete messages';
                    $results['status'] = false;
                }

                echo json_encode($results, JSON_PRETTY_PRINT);
                //exit();
            }
        }
        else
        {
            $data['is_deleted']=1;
            if($this->outboxModel->update($values,$data)){
                $results['message'] = 'Message successfully delete!';
                $results['status'] = true;
            }
            else{
                $results['message'] = 'Failed to delete message';
                $results['status'] = false;
            }

            echo json_encode($results, JSON_PRETTY_PRINT);
            exit();
        }

    }
    function marked()
    {
        $this->appdata['link']= 'communication';
        $this->appdata['title']= 'Communication | Marked';
        $this->load->vars($this->appdata);

        //for pagination
        $user_key = profile()->user_key;
        $inboxrows = $this->inboxModel->count_by(['receiver_id'=>$user_key,'is_receiver_deleted'=>0, 'is_receiver_recycle'=>0, 'is_receiver_marked'=>1]);
        //$outboxrows = $this->outboxModel->count_by(['sender_id'=>$user_key,'is_deleted'=>0, 'is_recycle'=>0, 'is_marked'=>1]);
        $repliedinboxrows = $this->inboxModel->count_by(['sender_id'=>$user_key, 'msg_replied'=>1,'is_sender_deleted'=>0, 'is_sender_recycle'=>0, 'is_sender_marked'=>1]);
        $totalinboxrows = $inboxrows  + $repliedinboxrows;

        $config = array();
        $config["base_url"] = base_url() . "communication/marked";
        $config["total_rows"] = $totalinboxrows;
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;

        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data["links"] = $this->pagination->create_links();
        $data['marked_inbox'] = $this->inboxModel->getMarkedInbox($config["per_page"], $page);
        $data['marked_replies'] = $this->inboxModel->getMarkedReplies($config["per_page"], $page);
        //$data['marked_outbox'] = $this->outboxModel->getMarkedOutbox($config["per_page"], $page);
        $this->load->view('communication/marked', $data);
    }
    function view_marked($id)
    {
        $this->load->vars($this->appdata);
        $query = $this->inboxModel->find_by(['msg_key'=>$id]);
        $this->appdata['title']= 'View Message';
        $this->appdata['query']= $query;
        $this->appdata['id']= $id;
        if (!empty($query))
        {
            $this->load->vars($this->appdata);
            $this->load->view('communication/load_marked');
        }
    }
    function markAsImportant()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $id = $this->input->post('id', TRUE);
        $user_key = profile()->user_key;

        $message = $this->inboxModel->find_by(['msg_key'=>$id]);
        //$message2 = $this->outboxModel->find_by(['msg_key'=>$id]);

        //check if the message is marked from inbox by receiver
        if($message['receiver_id'] == $user_key)
        {
            $data['is_receiver_marked']=1;
            if ($this->inboxModel->update($id,$data))
            {
                $result['message'] = 'Message successfully marked';
                $result['status'] = true;
            }
            else
            {
                $result['message'] = 'Failed to mark message';
                $result['status'] = false;
            }
            echo json_encode($result, JSON_PRETTY_PRINT);
            //exit();
        }

        //check if the message is marked from inbox by sender
        elseif ($message['sender_id'] == $user_key && $message['msg_replied'] = 1)
        {
            $data['is_sender_marked'] = 1;
            if ($this->inboxModel->update($id,$data))
            {
                $result['message'] = 'Message successfully marked';
                $result['status'] = true;
            }
            else
            {
                $result['message'] = 'Failed to mark message';
                $result['status'] = false;
            }
            echo json_encode($result, JSON_PRETTY_PRINT);
            exit();
        }

        //check if the message is marked from outbox by sender
//        if ($message2['sender_id'] == $user_key)
//        {
//            $data['is_marked'] = 1;
//            if ($this->outboxModel->update($id,$data))
//            {
//                $result['message'] = 'Message successfully marked';
//                $result['status'] = true;
//            }
//            else
//            {
//                $result['message'] = 'Failed to mark message';
//                $result['status'] = false;
//            }
//        }
    }
    function unMark()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $id = $this->input->post('id', TRUE);
        $user_key = profile()->user_key;

        $message = $this->inboxModel->find_by(['msg_key'=>$id]);
        //$message2 = $this->outboxModel->find_by(['msg_key'=>$id]);

        //check if the message is marked from inbox by receiver
        if($message['receiver_id'] == $user_key)
        {
            $data['is_receiver_marked']=0;
            if ($this->inboxModel->update($id,$data))
            {
                $result['message'] = 'Message successfully unmarked';
                $result['status'] = true;
            }
            else
            {
                $result['message'] = 'Failed to unmark message';
                $result['status'] = false;
            }
            echo json_encode($result, JSON_PRETTY_PRINT);
            //exit();
        }

        //check if the message is marked from inbox by sender
        elseif ($message['sender_id'] == $user_key && $message['msg_replied'] = 1)
        {
            $data['is_sender_marked'] = 0;
            if ($this->inboxModel->update($id,$data))
            {
                $result['message'] = 'Message successfully unmarked';
                $result['status'] = true;
            }
            else
            {
                $result['message'] = 'Failed to unmark message';
                $result['status'] = false;
            }
            echo json_encode($result, JSON_PRETTY_PRINT);
            exit();
        }
    }
    function markOutboxAsImportant()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $id = $this->input->post('id', TRUE);
        $user_key = profile()->user_key;
        $message = $this->outboxModel->find_by(['msg_key'=>$id]);

        if ($message['sender_id'] == $user_key)
        {
            $data['is_marked'] = 1;
            if ($this->outboxModel->update($id,$data))
            {
                $result['message'] = 'Message successfully marked';
                $result['status'] = true;
            }
            else
            {
                $result['message'] = 'Failed to mark message';
                $result['status'] = false;
            }
            echo json_encode($result, JSON_PRETTY_PRINT);
        }
    }
    function deletemarked()
{
    header('Content-Type: application/json');
    header('Access-Control-Allow-Origin: ' . base_url());
    header('Access-Control-Allow-Methods: GET, POST');
    header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

    $user = profile()->user_key;
    $values = $this->input->get('value', TRUE);
    $check_value = explode(",", $values);
    if(is_array($check_value))
    {
        foreach ($check_value as $key => $value)
        {
            if(empty($value))
                return;
            $query =  $this->inboxModel->find_by(['msg_key'=>$value]);
            if(!empty($query)){
                if ($query['receiver_id'] == $user)
                {
                    $data['is_receiver_marked']=0;
                    if($this->inboxModel->update($value,$data)){
                        $results['message'] = 'Messages successfully unmarked!';
                        $results['status'] = true;
                    }
                    else{
                        $results['message'] = 'Failed to unmark messages';
                        $results['status'] = false;
                    }

                    echo json_encode($results, JSON_PRETTY_PRINT);
                    //exit();
                }
                elseif ($query['sender_id'] == $user && $query['msg_replied'] = 1)
                {
                    $data2['is_sender_marked']=0;
                    if($this->inboxModel->update($value,$data2)){
                        $results['message'] = 'Messages successfully unmarked!';
                        $results['status'] = true;
                    }else{
                        $results['message'] = 'Failed to unmark messages';
                        $results['status'] = false;
                    }

                    echo json_encode($results, JSON_PRETTY_PRINT);
                    //exit();
                }
            }
        }
    }
    else
    {
        $query =  $this->inboxModel->find_by(['msg_key'=>$values]);
        if(!empty($query)){
            if ($query['receiver_id'] == $user)
            {
                $data['is_receiver_marked']=0;
                if($this->inboxModel->update($values,$data)){
                    $results['message'] = 'Message successfully unmarked!';
                    $results['status'] = true;
                }
                else{
                    $results['message'] = 'Failed to unmark message';
                    $results['status'] = false;
                }

                echo json_encode($results, JSON_PRETTY_PRINT);
                //exit();
            }
            elseif ($query['sender_id'] == $user && $query['msg_replied'] = 1)
            {
                $data2['is_sender_marked']=0;
                if($this->inboxModel->update($values,$data2)){
                    $results['message'] = 'Message successfully unmarked!';
                    $results['status'] = true;
                }else{
                    $results['message'] = 'Failed to unmark message';
                    $results['status'] = false;
                }

                echo json_encode($results, JSON_PRETTY_PRINT);
                //exit();
            }
        }
    }

}
    function draft()
    {
        $this->appdata['link']= 'communication';
        $this->appdata['title']= 'Communication | Drafts';
        $this->load->vars($this->appdata);

        //for pagination
        $user_key = profile()->user_key;
        $config = array();
        $config["base_url"] = base_url() . "communication/draft";
        $config["total_rows"] = $this->outboxModel->count_by(['sender_id'=>$user_key,'msg_status'=>'draft','is_deleted'=>0,'is_recycle'=>0]);
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;

        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data["links"] = $this->pagination->create_links();
        $data['msg'] = $this->outboxModel->getDraft($config["per_page"], $page);
        $this->load->view('communication/draft', $data);
    }
    function trash()
    {
        $this->appdata['link']= 'communication';
        $this->appdata['title']= 'Communication | Trash';
        $this->load->vars($this->appdata);

        //for pagination
        $user_key = profile()->user_key;
        $inboxrows = $this->inboxModel->count_by(['receiver_id'=>$user_key,'is_receiver_deleted'=>1, 'is_receiver_recycle'=>0]);
        $outboxrows = $this->outboxModel->count_by(['sender_id'=>$user_key,'is_deleted'=>1, 'is_recycle'=>0, 'msg_status'=>'sent']);
        $repliedinboxrows = $this->inboxModel->count_by(['sender_id'=>$user_key, 'msg_replied'=>1,'is_sender_deleted'=>1, 'is_sender_recycle'=>0]);
        $totalinboxrows = $inboxrows  + $outboxrows + $repliedinboxrows;

        $config = array();
        $config["base_url"] = base_url() . "communication/trash";
        $config["total_rows"] = $totalinboxrows;
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;

        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data["links"] = $this->pagination->create_links();
        $data['trash_inbox'] = $this->inboxModel->getTrashInbox($config["per_page"], $page);
        $data['trash_replies'] = $this->inboxModel->getTrashReplies($config["per_page"], $page);
        $data['trash_outbox'] = $this->outboxModel->getTrashOutbox($config["per_page"], $page);
        $this->load->view('communication/trash', $data);
    }
    function emptytrash()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $user = profile()->user_key;
        $values = $this->input->get('value');
        $check_value = explode(",", $values);
        if(is_array($check_value))
        {
            foreach ($check_value as $key => $value)
            {
                if(empty($value))
                    return;
                $query =  $this->inboxModel->find_by(['msg_key'=>$value]);
                $query2 = $this->outboxModel->find_by(['msg_key'=>$value]);
                if(!empty($query)){
                    if ($query['receiver_id'] == $user)
                    {
                        $data['is_receiver_recycle']=1;
                        if($this->inboxModel->update($value,$data)){
                            $results['message'] = 'Messages successfully deleted!';
                            $results['status'] = true;
                        }
                        else{
                            $results['message'] = 'Failed to delete messages';
                            $results['status'] = false;
                        }

                        echo json_encode($results, JSON_PRETTY_PRINT);
                        //exit();
                    }
                    elseif ($query['sender_id'] == $user && $query['msg_replied'] = 1)
                    {
                        $data2['is_sender_recycle']=1;
                        if($this->inboxModel->update($value,$data2)){
                            $results['message'] = 'Messages successfully deleted!';
                            $results['status'] = true;
                        }else{
                            $results['message'] = 'Failed to delete messages';
                            $results['status'] = false;
                        }

                        echo json_encode($results, JSON_PRETTY_PRINT);
                        //exit();
                    }
                }
                elseif (!empty($query2))
                {
                        $data['is_recycle']=1;
                        if($this->outboxModel->update($value,$data)){
                            $results['message'] = 'Messages successfully deleted!';
                            $results['status'] = true;
                        }
                        else{
                            $results['message'] = 'Failed to delete messages';
                            $results['status'] = false;
                        }

                        echo json_encode($results, JSON_PRETTY_PRINT);
                        //exit();
                }
            }
        }
        else
        {
            $query =  $this->inboxModel->find_by(['msg_key'=>$values]);
            $query2 = $this->outboxModel->find_by(['msg_key'=>$values]);
            if(!empty($query)){
                if ($query['receiver_id'] == $user)
                {
                    $data['is_receiver_recycle']=1;
                    if($this->inboxModel->update($values,$data)){
                        $results['message'] = 'Message successfully deleted!';
                        $results['status'] = true;
                    }
                    else{
                        $results['message'] = 'Failed to delete message';
                        $results['status'] = false;
                    }

                    echo json_encode($results, JSON_PRETTY_PRINT);
                    //exit();
                }
                elseif ($query['sender_id'] == $user && $query['msg_replied'] = 1)
                {
                    $data2['is_sender_recycle']=1;
                    if($this->inboxModel->update($values,$data2)){
                        $results['message'] = 'Message successfully deleted!';
                        $results['status'] = true;
                    }
                    else{
                        $results['message'] = 'Failed to delete message';
                        $results['status'] = false;
                    }

                    echo json_encode($results, JSON_PRETTY_PRINT);
                    //exit();
                }
            }
            elseif (!empty($query2))
            {
                $data['is_recycle']=1;
                if($this->outboxModel->update($values,$data)){
                    $results['message'] = 'Messages successfully deleted!';
                    $results['status'] = true;
                }
                else{
                    $results['message'] = 'Failed to delete messages';
                    $results['status'] = false;
                }

                echo json_encode($results, JSON_PRETTY_PRINT);
                //exit();
            }
        }
    }
    function viewtrash($id){
        $user = profile()->user_key;
        $this->load->vars($this->appdata);
        $query = $this->inboxModel->find_by(['msg_key'=>$id, 'receiver_id'=>$user, 'is_receiver_deleted'=>1]);
        $query2 = $this->inboxModel->find_by(['msg_key'=>$id, 'sender_id'=>$user, 'is_sender_deleted'=>1, 'msg_replied'=>1]);
        $query3 = $this->outboxModel->find_by(['msg_key'=>$id, 'sender_id'=>$user]);
        $this->appdata['title']= 'View Message';
        $this->appdata['query']= $query;
        $this->appdata['query2']= $query2;
        $this->appdata['query3']= $query3;
        $this->appdata['id']= $id;
        if (!empty($query))
        {
            $this->load->vars($this->appdata);
            $this->load->view('communication/load_trash');
        }
        elseif (!empty($query2))
        {
            $this->load->vars($this->appdata);
            $this->load->view('communication/load_trash');
        }
        elseif (!empty($query3))
        {
            $this->load->vars($this->appdata);
            $this->load->view('communication/load_trash');
        }

    }


    function deletemessage()
    {
        $values = $this->input->get('value');
        $check_value = explode(",", $values);
        if(is_array($check_value))
        {
            foreach ($check_value as $key => $value)
            {
                $query =  $this->sentList_model->deleteMsg($value);
                if($query){
                    ?>
                    <script type="text/javascript">
                        swal.fire({
                            'type': 'success',
                            'text': 'Messages successfully deleted!'
                        })
                    </script>
                    <?php
                    header('location:communication/sent');
                }
            }
        }
        else
        {
            $query = $this->sentList_model->deleteMsg($values);
            if($query) {
                ?>
                <script type="text/javascript">
                    swal.fire({
                        'type': 'success',
                        'text': 'Message was successfully deleted!'
                    })
                </script>
                <?php
                header('location:communication/sent');
            }
        }

    }


//---------------------------------------------------------------------------------------------/////
























    function classes() {
        $this->load->helper('form');
        $this->appdata['link']= 'taxes';
        $this->load->vars($this->appdata);
        $this->load->view('taxes/tax_classes');
    }

    function settaxclassstatus($tax='',$status=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->db->trans_start();
        $data['tax_class_status'] = urldecode($status);
        $this->db->where('tax_class_key',$tax);
        $this->db->update('tax_class_key',$data);

        $this->db->trans_complete();
        if($this->db->trans_status() === TRUE){
            publishEventFlash("tax_class_updated");
            $results['message'] = 'Changes applied successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to save changes';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function settaxstatus($tax='',$status=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->db->trans_start();

        $data['tax_status'] = urldecode($status);
        $this->db->where('tax_key',$tax);
        $this->db->update('taxes',$data);

        $this->db->trans_complete();
        if($this->db->trans_status() === TRUE){
            publishEventFlash("tax_updated");
            $results['message'] = 'Changes applied successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to save changes';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function taxdetails($tax='') {
        $this->load->helper('form');
        $this->appdata['tax'] = $this->taxesModel->taxDetails($tax);
        $this->load->vars($this->appdata);
        $this->load->view('taxes/tax_details');
    }

    function taxclassdetails($tax='') {
        $this->load->helper('form');
        $this->appdata['class']= $this->taxesModel->taxClassDetails($tax);
        $this->load->vars($this->appdata);
        $this->load->view('taxes/class_details');
    }
    
    function deleteclass($tax)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->db->where('tax_class_key',$tax);
        $this->db->delete('tax_classes');

        if($this->db->affected_rows()>0){
            publishEventFlash("tax_class_updated");
            $results['message'] = 'Class deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete Class';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function deletetax($tax)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->db->where('tax_key',$tax);
        $this->db->delete('taxes');

        if($this->db->affected_rows()>0){
            publishEventFlash("tax_updated");
            $results['message'] = 'Tax deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete Tax';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }
    
    function updatetax()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['tax_title'] = $this->input->get("tax_title",TRUE);
        $data['tax_class'] = $this->input->get("tax_class",TRUE);
        $data['tax_type_value'] = $this->input->get("tax_type_value",TRUE);
        $data['tax_type'] = $this->input->get("tax_type",TRUE);
        $data['tax_status'] = $this->input->get("tax_status",TRUE);

        $tax = $this->input->get("tax_key",TRUE);

        $this->db->where('tax_key',$tax);
        $this->db->update('taxes',$data);

        if($this->db->affected_rows()>0){
            publishEventFlash("tax_updated");
            $results['message'] = 'Tax changed successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to update Tax';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function updatetaxclass()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $class = $this->input->get("tax_class_key",TRUE);
        $data['tax_class_title'] = $this->input->get("tax_class_title",TRUE);
        $data['tax_class_details'] = $this->input->get("tax_class_details",TRUE);
        $data['tax_class_status'] = $this->input->get("tax_class_status",TRUE);

        $this->db->where('tax_class_key',$class);
        $this->db->update('tax_classes',$data);

        if($this->db->affected_rows()>0){
            publishEventFlash("tax_class_updated");
            $results['message'] = 'Tax Class changed successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to update Class';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function createtax()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['tax_business'] = runningBusiness()->business_key;
        $data['tax_branch'] = runningBranch()->branch_key;
        $data['tax_status'] = $this->input->get('tax_status', TRUE);
        $data['tax_class'] = $this->input->get('tax_class', TRUE);
        $data['tax_type'] = $this->input->get('tax_type', TRUE);
        $data['tax_title'] = $this->input->get('tax_title', TRUE);
        $data['tax_type_value'] = $this->input->get('tax_type_value', TRUE);
        $data['tax_key'] = $this->taxesModel->taxKey();

        $this->db->trans_start();

        $this->db->insert('taxes', $data);
        $this->db->trans_complete();
        if ($this->db->trans_status() == TRUE) {
            publishEventFlash("tax_register");
            $results['message'] = 'Tax registered successfully ';
            $results['status'] = true;

            } else {
                $results['message'] = 'Failed to register Tax';
                $results['status'] = false;
            }

            echo json_encode($results, JSON_PRETTY_PRINT);
        }

    function createtaxclass()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['tax_class_details'] = $this->input->post("tax_class_details",TRUE);
        $data['tax_class_business'] = runningBusiness()->business_key;
        $data['tax_class_branch'] = runningBranch()->branch_key;
        $data['tax_class_status'] = $this->input->get('tax_class_status', TRUE);
        $data['tax_class_title'] = $this->input->get('tax_class_title', TRUE);
        $data['tax_class_key'] = $this->taxesModel->taxClassKey();

        $this->db->trans_start();

        $this->db->insert('tax_classes', $data);
        $this->db->trans_complete();
        if ($this->db->trans_status() == TRUE) {
            publishEventFlash("tax_class_register");
            $results['message'] = 'Tax Class registered successfully ';
            $results['status'] = true;

        } else {
            $results['message'] = 'Failed to register Tax Class';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function datasourcetaxes($when=''){
      $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
      $taxes = $this->taxesModel->taxes($when);
      $columns = [
        'tax_key' => true,
        'tax_title' => true,
        'tax_class_title' => true,
        'tax_class_key' => true,
        'tax_status' => true,
        'tax_created_at' => true,
        'date' => true,
        'tax_type' => true,
        'tax_type_value' => true,
      ];
      print $this->datasourceLibrary->server($taxes,$columns);
    }

    function datasourcetaxclasses($when=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $classes = $this->taxesModel->taxClasses($when);
        $columns = [
            'date' => true,
            'tax_class_key' => true,
            'tax_class_title' => true,
            'tax_class_details' => true,
            'tax_class_status' => true,
            'tax_class_created' => true,
        ];
        print $this->datasourceLibrary->server($classes,$columns);
    }


}
