<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author noely
 */
class Index extends MY_Controller{

  public $pagedata;
  public $branch;
  public $business;

  public function __construct() {
    parent::__construct();
    ($this->require_min_level(1));
    $this->pagedata['link']= 'customers';
    $this->load->model(array(
            'communication/communicationsModel' => 'communicationsModel',
            'crm/customersModel' => 'customersModel',
             'bms/branchesModel' => 'branchesModel',
            'crm/groupsModel' => 'groupsModel'
            ));
    $this->load->helper('crm/crm_helper');
    $this->load->library(array('infobip/infobipLibrary'=>'infobipLibrary'));
    $this->load->model(array('hrm/TitlesModel'=>'titlesModel'));
    $this->load->model('documents/documentsModel');
    $this->load->library("pagination");
    $this->load->helper('url');
  }

  public function index() {
      //has_control('sms_view_all','View all customers');
      $this->load->helper('form');
      $data['link']= 'log';
      $data['customers'] = $this->customersModel->customers();
      $data['employees'] = $this->customersModel->employees();
      $data['title'] = 'Communication Sms | '.$this->config->item('application_name');

      $config = array();
      $config["base_url"] = base_url() . "sms";
      $config["total_rows"] = $this->communicationsModel->allCount();
      $config["per_page"] = 5;
      $config["uri_segment"] = 2;
      $this->pagination->initialize($config);
      $page = ($this->uri->segment(2)) ? $this->uri->segment(2) : 0;
      $data["smslinks"] = $this->pagination->create_links();
      $data['messages'] = $this->infobipLibrary->smsLog($config["per_page"], $page);
      //$this->load->vars($this->data);
      $this->load->view('communication/sms/sms',$data);
  }

    public function bulk() {
        $this->load->helper('form');
        $this->pagedata['link']= 'bulk';
        $this->pagedata['customers'] = $this->customersModel->customers();
        $this->pagedata['employees'] = $this->customersModel->employees();
        $this->pagedata['messages'] = $this->infobipLibrary->smsLogBulk();
        $this->pagedata['title'] = 'Bulk Sms | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('communication/sms/bulk');
    }

    function bulksms(){
        //$farmers = $this->db->get('farmtypes')->result_array();
        $this->pagedata['title'] = 'Sent Bulk SMS';
        $this->pagedata['link']= 'sendbulksms';
        $this->pagedata['customers'] = customers();
        //$this->pagedata['farmers'] = $farmers;
        $this->load->vars($this->pagedata);
        $this->load->view('communication/sms/sendbulksms');
    }

    function log(){
        $this->pagedata['title'] = 'Sent History';
        $this->pagedata['messages'] = $this->infobipLibrary->smsLog();
        $this->load->vars($this->pagedata);
        $this->load->view('communication/sms/log');
    }

    function historydelivered(){
        $this->pagedata['title'] = 'Sent History';
        $this->pagedata['messages'] = $this->infobipLibrary->deliveredSms();
        $this->load->vars($this->pagedata);
        $this->load->view('communication/sms/deliveredsms');
    }

    function sendsinglesms1(){
        $recipient = $this->input->get('recepient');
        $sender = $this->input->get('senderid');
        $message = $this->input->get('message');

        if(strtolower(phone_number_format($recipient)) == 'invalid'){
            print 'Phone number is invalid, Follow format 2556537436xx';
        }else{
            $result = $this->infobipLibrary->sendSingleSms($sender,$recipient,$message);
            if($result['status']){
                print 'Sent';
            }else{
                print $result['message'];
            }
        }
    }

    function sendsinglesms(){
        $recipient = $this->input->get('recepient');
        $sender = $this->input->get('senderid');
        $message = $this->input->get('message');

        if(strtolower(phone_number_format($recipient)) == 'invalid'){
            print 'Phone number is invalid, Follow format 2556537436xx';

        }else{
            if($this->infobipLibrary->sendSingleSms($sender,$recipient,$message)){
                $result['status'] = 'ok';
                $result['message'] = 'Message Sent successfully';
            }else{
                $result['status'] = 'no';
                $result['message'] = checkError($this->dbexeption());
            }
            print json_encode($result);
        }
    }

    function sendBulkSmsCustomers(){
        $data['recipients'] = $this->input->get('recepients');
        $data['sender'] = $this->input->get('senderid');
        $data['text'] = $this->input->get('message');
        $data['title'] = $this->input->get('title');
        if($this->infobipLibrary->sendBulk($data)){
            $result['status'] = 'ok';
            $result['message'] = 'Message Sent successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function sendBulkSms(){
        $data['title'] = 'What is bulk messing and what does it function';
        $data['recipients'] = [255653743604,255746251394,255653743604,255746251394];// $this->input->get('recepients');
        $data['sender'] = 'IBTEST';//$this->input->get('senderid');
        $data['text'] = 'Bulk messaging is the dissemination of large numbers of SMS messages for delivery to mobile phone terminals. It is used by media companies, enterprises, banks (for marketing and fraud control) and consumer brands for a variety of purposes including entertainment, enterprise and mobile marketing.';//$this->input->get('message');
        $result = $this->infobipLibrary->sendBulk($data);
        if($result['status']){
            print 'Sent';
        }else{
            print $result['message'];
        }
    }

    function sendBulkSmsCustomers1(){
        $data['recipients'] = $this->input->get('recepients');
        $data['sender'] = $this->input->get('senderid');
        $data['text'] = $this->input->get('message');
        $result = $this->infobipLibrary->sendBulk($data);
        if($result['status']){
            print 'Sent';
        }else{
            print $result['message'];
        }
    }

    function processCallback(){
        $this->infobipLibrary->processNotifyUrl();
    }

    function processCallbackBulk(){
        $this->infobipLibrary->processNotifyUrlBulk();
    }

    public function readMore($smsKey='') {
//        if (!$this->input->is_ajax_request())
//            exit('not direct script allowed');
        $this->pagedata['sms'] = $this->customersModel->select_one_sms($smsKey);
        $this->load->vars($this->pagedata);
        $this->load->view('communication/sms/smsDetails');
    }

    public function readMoreBulk($smsKey='') {
//        if (!$this->input->is_ajax_request())
//            exit('not direct script allowed');
        $this->pagedata['sms'] = $this->customersModel->select_one_bulk($smsKey);
        $this->load->vars($this->pagedata);
        $this->load->view('communication/sms/smsDetailsBulk');
    }


}