<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Index extends MY_Controller{

  public $pagedata;
  public $branch;
  public $business;

  public function __construct() {
    parent::__construct();
    ($this->require_min_level(1));
    $this->pagedata['link']= 'customers';
    $this->load->model(array(
            'crm/customersModel' => 'customersModel',
             'bms/branchesModel' => 'branchesModel',
            'crm/groupsModel' => 'groupsModel'
            ));
    $this->load->helper('crm/crm_helper');
    $this->load->model(array('hrm/TitlesModel'=>'titlesModel'));
    $this->load->model('documents/documentsModel');
  }

  public function index() {
    has_control('customers_view_all','View all customers');
    $this->load->helper('form');
    $this->pagedata['customers'] = $this->customersModel->customers();
    $this->pagedata['title'] = 'Customers | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('customers/customers');
  }

  public function newcustomer() {
    $this->load->helper('form');
    $this->pagedata['groups'] = $this->groupsModel->groups();
    $this->pagedata['title'] = 'New Customer | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('customers/newcustomer');
  }

  public function details($key='') {
    has_control('customers_details','View customer details');
    $this->load->helper('form');
    $this->pagedata['customer']= $this->customersModel->customer($key);
    $this->pagedata['groups'] = $this->groupsModel->groups();
    $this->pagedata['title'] = 'Customer details | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('customers/details');
  }

  function createCustomer(){
  // if (!$this->input->is_ajax_request())
  //  exit('not direct script allowed');
   has_control_ajax('customers_register','Register customer');
  $primary = $this->collectPrimaryInfo();
  $location = $this->collectLocationInfo();
  $details = array_merge($primary,$location);
  $security = $this->collectSecurityInfo();
  $business = $this->collectBusinessinfo();
  if($this->customersModel->registerCustomer($primary,$security,$business)){
    $event = 'all';
    $channel = runningBranch()->branch_key;
    $data['not_url'] = '';
    $data['not_content'] = profile()->firstname.' '.profile()->lastname.' has registered new customer';
    $data['not_origin_content'] = 'You have successfully registered new customer';
    $data['not_title'] = 'Customer Registration';
    $data['not_origin'] = $this->auth_user_id;
    $data['not_channel'] = $channel;
    $data['not_event'] = $event;
    //$this->pusher->triggerRegister($event,$data);
      $result['status'] = true;
      $result['message'] = 'You have successfully registered an Customer';
    }else{
      $result['status'] = false;
      $result['message'] = checkError($this->dbexeption());
  }
  header('Content-Type: application/json');
  header('Access-Control-Allow-Origin: ' . base_url());
  header('Access-Control-Allow-Methods: GET, POST');
  header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
  print json_encode($result, JSON_PRETTY_PRINT);
}

  public function loadInformationSecurity($key='') {
     if (!$this->input->is_ajax_request())
      exit('not direct script allowed');
     has_control_ajax_content('customers_details','View customer details');
    $this->pagedata['customer']= $this->customersModel->customer($key);
    $this->load->vars($this->pagedata);
    $this->load->view('crm/customers/securityAjax');
  }

  public function loadInformationPrimary($key='') {
     if (!$this->input->is_ajax_request())
      exit('not direct script allowed');
     has_control_ajax_content('customers_details','View customer details');
    $this->pagedata['customer']= $this->customersModel->customer($key);
    $this->load->vars($this->pagedata);
    $this->load->view('crm/customers/detailsAjax');
  }

  public function loadInformationLocation($key='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax_content('customers_details','View customer details');
    $this->pagedata['customer']= $this->customersModel->customer($key);
    $this->load->vars($this->pagedata);
    $this->load->view('crm/customers/locationAjax');
  }

  public function loadInformationBusiness($key='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax_content('customers_details','View customer details');
    $this->pagedata['customer']= $this->customersModel->customer($key);
    $this->load->vars($this->pagedata);
    $this->load->view('customers/businessAjax');
  }

  public function loadInformationDocuments($key='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax_content('customers_details','View customer details');
    $this->load->helper('form');
    $this->pagedata['customer']= $this->customersModel->customer($key);
    $this->pagedata['documents']= $this->documentsModel->documents();
    $this->load->vars($this->pagedata);
    $this->load->view('customers/documentsAjax');
  }

  function loadInformationDocumentsAction($customer){
  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');
   has_control_ajax('customers_update','Update customer details');
  $uploadStatus = $this->appLibrary->uploadCustomerDocument(uploadPath('documents/customers/'));
        if($uploadStatus['status']){
          $document['document_customer'] = $customer;
          $document['document_branch'] = runningBranch()->branch_key;
          $document['document_business'] = runningBusiness()->business_key;
          $document['document_details'] = $this->input->post('document_details',TRUE);
          $document['document_name'] = $this->input->post('document_name',TRUE);
          $document['document_file_name'] = $uploadStatus['data']['file_name'];
          $document['document_type'] = str_ireplace('.','',$uploadStatus['data']['file_ext']);
          $this->documentsModel->documentRegister($document);
          if(!empty($this->input->post('is_passport',TRUE))){
            $user['avatar'] = $document['document_file_name'];
            $this->db->where('user_key',$document['document_customer']);
            $this->db->update('users_details',$user);
          }
          $result['status'] = 'ok';
          $result['message'] = 'Document uploaded';
        }else{
            $result['status'] = 'no';
            $result['message'] = $uploadStatus['data'];
        }

      print json_encode($result);
}

  public function loadInformationSecurityAction($key='') {
     if (!$this->input->is_ajax_request())
      exit('not direct script allowed');
     has_control_ajax('customers_update','Update customer details');
         if($this->customersModel->customerUpdateSecurity($key,$this->collectSecurityInfo())){
                   $result['status'] = 'ok';
                   $result['message'] = 'Security information changed successifully';
                 }else{
                   $result['status'] = 'no';
                   $result['message'] = checkError($this->dbexeption());
                 }
        print json_encode($result);

  }

  public function loadInformationBusinessAction($key='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax('customers_update','Update customer details');
         if($this->customersModel->customerUpdateBusiness($key,$this->collectBusinessInfo())){
                   $result['status'] = 'ok';
                   $result['message'] = 'Business information changed successifully';
                 }else{
                   $result['status'] = 'no';
                   $result['message'] = checkError($this->dbexeption());
                 }
        print json_encode($result);

  }

  public function loadInformationLocationAction($key=''){
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax('customers_update','Update customer details');
     if($this->customersModel->customerUpdatePrimary($key,$this->collectLocationInfo())){
               $result['status'] = 'ok';
               $result['message'] = 'Location information changed successifully';
             }else{
               $result['status'] = 'no';
               $result['message'] = checkError($this->dbexeption());
             }
       print json_encode($result);
  }

  public function loadInformationPrimaryAction($key=''){
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax('customers_update','Update customer details');
     if($this->customersModel->customerUpdatePrimary($key,$this->collectPrimaryInfo())){
               $result['status'] = 'ok';
               $result['message'] = 'Primary information changed successifully';
             }else{
               $result['status'] = 'no';
               $result['message'] = checkError($this->dbexeption());
             }
       print json_encode($result);
  }

  function collectSecurityInfo(){
    $security['auth_level'] = $this->input->get('auth_level',TRUE);
    $security['user_group'] = $this->input->get('user_group',TRUE);
    $security['user_branch'] = $this->input->get('user_branch',TRUE);
    $security['email'] = !empty($this->input->get('email',TRUE)) ? $this->input->get('email',TRUE) : NULL;
    $security['username'] = !empty($this->input->get('username',TRUE)) ? $this->input->get('username',TRUE) : NULL;
    $security['phonenumber'] = $this->input->get('phonenumber',TRUE);
    if(!empty($this->input->get('password',TRUE))){
      $security['passwd'] =$this->authentication->hash_passwd($this->input->get('password',TRUE));
    }
    $security['communicate_sms'] = !empty($this->input->get('communicate_sms', TRUE)) ? $this->input->get('communicate_sms', TRUE) : 0;
    $security['communicate_phone'] = !empty($this->input->get('communicate_phone', TRUE)) ? $this->input->get('communicate_phone', TRUE) : 0;
    $security['communicate_email'] = !empty($this->input->get('communicate_email', TRUE)) ? $this->input->get('communicate_email', TRUE) : 0;
    $security['user_business'] = runningBusiness()->business_key;
    $security['user_lang'] = profile()->user_lang;
    return $security;
  }

  function collectPrimaryInfo(){
    $primary['details_branch'] = runningBranch()->branch_key;
    $primary['details_business'] = runningBusiness()->business_key;
    $primary['education_level'] = $this->input->get('education_level',TRUE);
    $primary['marital_status'] = $this->input->get('marital_status',TRUE);
    $primary['firstname'] = $this->input->get('firstname',TRUE);
    $primary['middlename'] = $this->input->get('middlename',TRUE);
    $primary['lastname'] = $this->input->get('lastname',TRUE);
    $primary['gender'] = $this->input->get('gender',TRUE);
    $primary['dob'] = date('Y-m-d',strtotime($this->input->get('dob',TRUE)));
    $primary['identity_type'] = $this->input->get('identity_type',TRUE);
    $primary['identity_value'] = $this->input->get('identity_value',TRUE);
    $primary['display_name'] = $primary['firstname'].' '.$primary['middlename'] .' '.$primary['lastname'] ;
    return $primary;
  }

  function collectLocationInfo(){
    $primary['details_branch'] = runningBranch()->branch_key;
    $primary['details_business'] = runningBusiness()->business_key;
    $primary['country'] = $this->input->get('country',TRUE);
    $primary['state'] = $this->input->get('state',TRUE);
    $primary['city'] = $this->input->get('city',TRUE);
    $primary['home_address'] = $this->input->get('home_address',TRUE);
    $primary['residential_address'] = $this->input->get('residential_address',TRUE);
    return $primary;
  }

  function collectBusinessInfo(){
    $primary['business_branch'] = runningBranch()->branch_key;
    $primary['business_business'] = runningBusiness()->business_key;
    $primary['business_name'] = $this->input->get('business_name',TRUE);
    $primary['business_location'] = $this->input->get('business_location',TRUE);
    $primary['business_type'] = $this->input->get('business_type',TRUE);
    $primary['business_age'] = str_ireplace(',','',$this->input->get('business_age',TRUE));
    $primary['business_registered'] = $this->input->get('business_registered',TRUE);
    $primary['business_expense_average_day'] = to_dollar($this->input->get('business_expense_average_day',TRUE));
    $primary['business_sales_average_day'] = to_dollar($this->input->get('business_sales_average_day',TRUE));
    $primary['business_other_income'] = $this->input->get('business_other_income',TRUE);
    return $primary;
  }

  public function checkusernameonly($username='') {
      if (!$this->input->is_ajax_request())
       exit('not direct script allowed');
      $this->db->where('username',urldecode($username));
      $query = $this->db->get('users');
       if($query->num_rows()>0){
                 $result['status'] = 'no';
           }else{
             $result['status'] = 'ok';
       }
      print json_encode($result);
    }

  public function checkusername($customer='',$username='') {
      if (!$this->input->is_ajax_request())
       exit('not direct script allowed');
      $this->db->where('username',urldecode($username));
      $this->db->where('user_id !=',$customer);
      $this->db->where('user_branch',$this->branch);
      $this->db->where('user_business',$this->business);
      $query = $this->db->get('users');
       if($query->num_rows()>0){
                 $result['status'] = 'no';
           }else{
             $result['status'] = 'ok';
       }
      print json_encode($result);
    }

  public function checkemailonly($email) {
      if (!$this->input->is_ajax_request())
       exit('not direct script allowed');

      $this->db->where('email',urldecode($email));
      $query = $this->db->get('users');
       if($query->num_rows()>0){
                 $result['status'] = 'no';
           }else{
             $result['status'] = 'ok';
       }
      print json_encode($result);
    }

  public function checkemail($customer,$email) {
      if (!$this->input->is_ajax_request())
       exit('not direct script allowed');

      $this->db->where('email',urldecode($email));
      $this->db->where('user_id !=',$customer);
      $this->db->where('user_branch',$this->branch);
      $this->db->where('user_business',$this->business);
      $query = $this->db->get('users');
       if($query->num_rows()>0){
                 $result['status'] = 'no';
           }else{
             $result['status'] = 'ok';
       }
      print json_encode($result);
    }

  public function delete($flag,$key,$document='') {
     if (!$this->input->is_ajax_request())
      exit('not direct script allowed');
           switch ($flag) {
               case 'customer':
                has_control_ajax('customers_delete','Delete customer');
               if($this->customersModel->customer_delete($key)){
                         $result['status'] = 'ok';
                         $result['message'] = 'Customer deleted';
                       }else{
                         $result['status'] = 'no';
                         $result['message'] = checkError();
                       }
                 print json_encode($result);
               break;
               case 'document':
               if (!$this->input->is_ajax_request())
                exit('not direct script allowed');
                has_control_ajax('customers_update','Update customer details');
               $file  = uploadPath('documents/customers/'.$this->documentsModel->document($document)->document_file_name);
               if($this->documentsModel->documentDelete($key,$document)){
                  if(file_exists($file)){
                    unlink($file);
                  }
                         $result['status'] = 'ok';
                         $result['message'] = 'Document deleted';
                       }else{
                         $result['status'] = 'no';
                         $result['message'] = checkError($this->dbexeption());
                       }
                 print json_encode($result);
               break;
               default:
                   print 'fail';
               break;
           }
 }

  function datasourcecustomers($when =''){
      $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
      $data = $this->customersModel->customers($when);
      $columns = [
          'id' => true,
          'firstname' => true,
          'lastname' => true,
          'group_name' => true,
          'joined'=> true,
          'gender'=> true,
          'phonenumber'=> true,
          'user_id'=> true,
      ];
      print $this->datasourceLibrary->server($data,$columns);
    }

  function datasourcedepartments(){
      $data = $this->customersModel->departments();
      $this->sourcedata($data);
    }

  function customerAppsSelectOptions($customer){

    $this->load->model(array(
            'loans/LoanApplicationsModel' => 'loanApplicationsModel',
            'loans/LoansModel' => 'loansModel'
    ));
    $applications = $this->loanApplicationsModel->customerApplications($customer);?>
    <select id="application" onchange="getInstallment(this.value)" name="return_application" class="form-control" style="width: 100%;">
        <option value="">Select Loan/Application</option>
        <?php if(!empty($applications)){
            foreach ($applications as $app){
                if(!$this->loansModel->applicationisfullpaid($app['app_key'])){?>
                <option value="<?php echo $app['app_key'];?>"><?php echo $app['product_name'].' - '.$app['loan_name'].' - '.runnCurrency()->currency_symbol.number_format(to_money($app['app_principal']));?></option>
            <?php } }
        } ?>
    </select>
    <?php }
}