<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Roles extends MY_Controller{

  public $pagedata;
  public $store;
  public $business;

  public function __construct() {
    parent::__construct();
    ($this->require_min_level(1));
    $this->pagedata['link']= 'administration';
    $this->store = $this->storesModel->store()->store_key;
    $this->business = $this->businessModel->business(profile()->user_business)->business_key;
  }

  public function index() {
    $this->load->helper('form');
    $this->pagedata['title'] = 'Roles | '.$this->config->item('application_name');
    $this->pagedata['titles'] = $this->titlesModel->categories();
    $this->pagedata['roles'] = $this->rolesModel->roles();
    $this->load->vars($this->pagedata);
    $this->load->view('administration/employees/roles/roles');
  }

  function title($title){
    $this->load->helper('form');
    $this->pagedata['title'] = 'Roles | '.$this->config->item('application_name');
    $this->pagedata['category'] = $this->titlesModel->category($title);
    $this->pagedata['roles'] = $this->rolesModel->roles();
    $this->load->vars($this->pagedata);
    $this->load->view('administration/employees/roles/category');
  }

public function employee($user='',$title='',$action=''){
  $action = urldecode($action);
  $title = urldecode($title);
  $status = isMyRoleAction($user,$title,$action);

  if($status){
    $this->db->where('action_id',$status->action_id);
    $this->db->where('user_id',$user);
    $this->db->delete('acl');
    $result['status'] = $this->db->affected_rows()>0 ? 'ok' : 'no';
  }else{
    $query = isTitleAction($title,$action);
      if($query){
        $data['action_id'] = $query->action_id;
        $data['user_id'] = $user;
        $this->db->insert('acl',$data);
        $result['status'] = $this->db->affected_rows()>0 ? 'ok' : 'no';
      }else{
        $data['action_code'] = $action;
        $data['category_id'] = $title;
        $data['action_desc'] = '';
        $data['action_store'] = $this->store;
        $data['action_business'] = $this->business;
        $this->db->insert('acl_actions',$data);

        $action_id = $this->db->insert_id();

        $acl['action_id'] = $action_id;
        $acl['user_id'] = $user;
        $this->db->insert('acl',$acl);
        $result['status'] = $this->db->affected_rows()>0 ? 'ok' : 'no';
      }

  }

  print json_encode($result);

}

public function titleAction($title='',$action=''){
  $action = urldecode($action);
  $title = urldecode($title);
  $status = isTitleAction($title,$action);

  if($status){
    $this->db->where('action_code',$action);
    $this->db->where('category_id',$title);
    $this->db->where('action_business',$this->business);
    $this->db->where('action_store',$this->store);
    $this->db->delete('acl_actions');
    $result['status'] = $this->db->affected_rows()>0 ? 'ok' : 'no';
  }else{
    $data['action_code'] = $action;
    $data['category_id'] = $title;
    $data['action_desc'] = '';
    $data['action_store'] = $this->store;
    $data['action_business'] = $this->business;
    $this->db->insert('acl_actions',$data);
    $result['status'] = $this->db->affected_rows()>0 ? 'ok' : 'no';
  }

  print json_encode($result);

}

}