<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Administration extends MY_Controller{

  public $pagedata;

  public function __construct() {
    parent::__construct();
    ($this->require_min_level(1));
    $this->pagedata['link']= 'expenses';
  }

  public function index() {
    $this->load->helper('form');
    $this->pagedata['employees'] = $this->employeesModel->employees();
    $this->pagedata['title'] = 'Employees | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('expenses/employeeistration/expenses');
  }

  public function details($key='') {
    if($this->tokens->match):
      $employee['gender'] = $this->input->post('gender', TRUE);
      $employee['office'] = $this->input->post('office', TRUE);
      $employee['department'] = $this->input->post('department', TRUE);
      $employee['firstname'] = $this->input->post('firstname', TRUE);
      $employee['lastname'] = $this->input->post('lastname', TRUE);
      $employee['auth_level'] = $this->input->post('auth_level', TRUE);
      if($this->employeesModel->employee_update($key,$employee)):
          $this->app_library->action_status('success','Updated successifully');
      else:
          $this->app_library->action_status('fail',checkError());
      endif;
    endif;
    $this->load->helper('form');
    $this->pagedata['employee']= $this->employeesModel->employee($key);
    $this->pagedata['title'] = 'Employee details | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('employeeistration/employees/details');
  }

  public function register(){
     $this->load->helper('form');
      if($this->tokens->match):
       $employee['user_id'] = $this->employeesModel->unused_user_id();
       $employee['gender'] = $this->input->post('gender', TRUE);
       $employee['office'] = $this->input->post('office', TRUE);
       $employee['department'] = $this->input->post('department', TRUE);
       $employee['firstname'] = $this->input->post('firstname', TRUE);
       $employee['lastname'] = $this->input->post('lastname', TRUE);
       $employee['username'] = $this->input->post('username', TRUE);
       $employee['auth_level'] = $this->input->post('auth_level', TRUE);
       $employee['passwd'] = $this->authentication->hash_passwd('jikwamuefs');
         if($this->employeesModel->employee_register($employee)):
             $this->app_library->action_status('success','Employee registered successifully');
         else:
             $this->app_library->action_status('fail',checkError());
         endif;
      endif;
     $this->pagedata['title'] = 'Register Employee | '.$this->config->item('application_name');
     $this->load->vars($this->pagedata);
     $this->load->view('employee/employees/register');
 }

 public function delete($flag,$key) {
     if (!$this->input->is_ajax_request())
      exit('not direct script allowed');
      if($key != 1010101010){
        $password = profile()->passwd;
        if($this->authentication->check_passwd($password,$this->input->get('password'))){
           switch ($flag) {
               case 'employee':
               if($this->employeesModel->employee_delete($key)){
                         $result['status'] = 'ok';
                         $result['message'] = 'Employee deleted';
                       }else{
                         $result['status'] = 'no';
                         $result['message'] = checkError();
                       }
                 print json_encode($result);
               break;
               default:
                   print 'fail';
               break;
           }
         }else{
             $result['status'] = 'no';
             $result['message'] = 'Incorrect password provided';
             print json_encode($result);
         }
        }else{
          $result['status'] = 'no';
          $result['message'] = 'You can not delete System Administrator';
           print json_encode($result);
        }
 }

function datasource(){
include dirname(APPPATH).'/resources/includes/lib/class-list-util.php';

$data = $alldata = $this->employeesModel->employees();

$datatable = array_merge(['pagination' => [], 'sort' => [], 'query' => []], $_REQUEST);

// search filter by keywords
$filter = isset($datatable['query']['generalSearch']) && is_string($datatable['query']['generalSearch'])
  ? $datatable['query']['generalSearch'] : '';
if ( ! empty($filter)) {
  $data = array_filter($data, function ($a) use ($filter) {
      return (boolean)preg_grep("/$filter/i", (array)$a);
  });
  unset($datatable['query']['generalSearch']);
}

// filter by field query
$query = isset($datatable['query']) && is_array($datatable['query']) ? $datatable['query'] : null;
if (is_array($query)) {
  $query = array_filter($query);
  foreach ($query as $key => $val) {
      $data = list_filter($data, [$key => $val]);
  }
}

$sort  = ! empty($datatable['sort']['sort']) ? $datatable['sort']['sort'] : 'asc';
$field = ! empty($datatable['sort']['field']) ? $datatable['sort']['field'] : 'RecordID';

$meta    = [];
$page    = ! empty($datatable['pagination']['page']) ? (int)$datatable['pagination']['page'] : 1;
$perpage = ! empty($datatable['pagination']['perpage']) ? (int)$datatable['pagination']['perpage'] : -1;

$pages = 1;
$total = count($data); // total items in array

// sort
usort($data, function ($a, $b) use ($sort, $field) {
  if ( ! isset($a->$field) || ! isset($b->$field)) {
      return false;
  }

  if ($sort === 'asc') {
      return $a->$field > $b->$field ? true : false;
  }

  return $a->$field < $b->$field ? true : false;
});

// $perpage 0; get all data
if ($perpage > 0) {
  $pages  = ceil($total / $perpage); // calculate total pages
  $page   = max($page, 1); // get 1 page when $_REQUEST['page'] <= 0
  $page   = min($page, $pages); // get last page when $_REQUEST['page'] > $totalPages
  $offset = ($page - 1) * $perpage;
  if ($offset < 0) {
      $offset = 0;
  }

  $data = array_slice($data, $offset, $perpage, true);
}

$meta = [
  'page'    => $page,
  'pages'   => $pages,
  'perpage' => $perpage,
  'total'   => $total,
];

// if selected all records enabled, provide all the ids
if (isset($datatable['requestIds']) && filter_var($datatable['requestIds'], FILTER_VALIDATE_BOOLEAN)) {
  $meta['rowIds'] = array_map(function ($row) {
      foreach($row as $first) break;
      return $first;
  }, $alldata);
}


header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

$result = [
  'meta' => $meta + [
          'sort'  => $sort,
          'field' => $field,
      ],
  'data' => $data,
];

echo json_encode($result, JSON_PRETTY_PRINT);
}

}
