<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Dashboard
 *
 * @author test
 */
class Index extends MY_Controller{

    public  $appdata;

    public function __construct() {
        parent::__construct();

        ( $this->require_min_level(1));
        $this->appdata['title']= 'Expense Manager';
        $this->load->model(array(
            'admin_model',
            'reports/SalesModel'=>'salesModel',
            'managers/expenses/ExpensesModel'=>'expensesModel'
        ));
        $this->load->helper('admin');
        $this->appdata['link']= 'managers';
    }

    public function index() {
        if(!empty($this->input->get('remove')) && !empty($this->input->get('cat'))){
            if($this->expensesModel->removeBudget($this->input->get('cat'))){
                $this->appdata['msg'] = 'Budget removed successfully';
            }else{
                $this->appdata['msg'] = 'Could not remove budget';
            }
        }

        if($this->tokens->match){
            $data['budget_value'] = str_ireplace(',','',$this->input->post('budget_value',TRUE));
            $data['budget_title'] = $this->input->post('budget_title',TRUE);
            if($this->expensesModel->createBudget($data)){
                $this->appdata['msg'] = 'Budget created successfully';
            }else{
                $this->appdata['msg'] = 'Could not create budget';
            }
        }
        $this->appdata['budgets'] = $this->expensesModel->budgets();
        $this->load->helper('form');
        $this->load->vars($this->appdata);
        $this->load->view('managers/expenses/budgets/index');
    }

    public function detailsr($employee ='') {
        $this->appdata['details'] = profile($employee);
        $this->appdata['employee'] = profile($employee);
        $this->load->helper('form');
        $this->load->vars($this->appdata);
        $this->load->view('managers/expenses/employees/detailsr');
    }

    public function details($category ='') {


        if($this->tokens->match){
            $data['type_category'] = $category;
            $data['type_title'] = $this->input->post('type_title',TRUE);
            //$data['type_details'] = $this->input->post('type_details',TRUE);
            if($this->expensesModel->createType($data)){
                $this->appdata['msg'] = 'Category type updated successfully';
            }else{
                $this->appdata['msg'] = 'Could not update category type';
            }
        }
        $this->appdata['categories'] = $this->expensesModel->categories();
        $this->appdata['types'] = $this->expensesModel->categoryTypes($category);
        $this->appdata['details'] = $this->expensesModel->details($category);
        $this->load->helper('form');
        $this->load->vars($this->appdata);
        $this->load->view('managers/expenses/categories/details');
    }


   function delete($expense = ''){
       $this->load->vars($this->appdata);
       $this->load->view('managers/expenses/categories/index');
   }

   function modify($expense = ''){
       $this->load->vars($this->appdata);
       $this->load->view('managers/expenses/categories/index');
   }

    function changetitle()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['budget_title'] = $this->input->get('value',TRUE);

        $this->db->where('budget_id',$this->input->get('cat',TRUE));

        $this->db->update('expense_budgets',$data);

        if($this->db->affected_rows()>0){
            $results['msg'] = 'saved';
            $results['success'] = true;
        }else{
            $results['msg'] = 'failed';
            $results['success'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
    }
    function changevalue()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['budget_value'] = $this->input->get('value',TRUE);

        $this->db->where('budget_id',$this->input->get('cat',TRUE));

        $this->db->update('expense_budgets',$data);

        if($this->db->affected_rows()>0){
            $results['msg'] = 'saved';
            $results['success'] = true;
        }else{
            $results['msg'] = 'failed';
            $results['success'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
    }


    function datasourcer($employee,$when=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $sales = $this->expensesModel->expenseEmployees($employee,$when);
        $columns = [
            'expense_id' => true,
            'expense_payee' => true,
            'expense_details' => true,
            'expense_status' => true,
            'employee' => true,
            'user_id' => true,
            'expense_date' => true,
            'title_id' => true,
            'type_id' => true,
            'budget_id' => true,
            'category_id' => true,
            'budge_title' => true,
            'category_title' => true,
            'type_title' => true,
            'budget_title' => true,
            'expense_amount' => true,
            'expense_creator' => true,
            'expense_created_at' => true,
            'expense_deleted' => true,
            'expense_delete_request' => true
        ];
        print $this->datasourceLibrary->server($sales,$columns);
    }

}