<?php

class Request extends MY_Controller {

    public $pagedata;
    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        ($this->require_min_level(1));
        $this->pagedata['link']= 'petty';
        $this->load->model(array(
            'freight/RequestModel'=>'requestModel',
            'freight/FreightsModel'=>'freightsModel',
            'task/TaskModel'=>'taskModel',
            'hrm/Employees'=>'employeesModel',
            'accounting/accounting'=>'accountingModel',
        ));
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
        $this->load->helper('freight_forward/helper');
        //$this->pagedata['link']= 'freight';
        $this->load->vars($this->pagedata);
    }

    public function index() {
        has_control('petty_view_all','View all requests');
        $this->pagedata['title'] = 'Request List | '.$this->config->item('application_name');
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['task'] = $this->requestModel->all_freight_task();
        $this->load->vars($this->pagedata);
        $this->load->view('freight/petty_request');
    }

    public function requestPettyCash($taskKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['task'] = $this->taskModel->select_one_task_freight($taskKey);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/request_form');
    }

    function newPettyRequest(){
        $request['petty_request_payee'] = $this->input->get('petty_request_payee',TRUE);
        $request['petty_request_file_number'] = $this->input->get('petty_request_file_number',TRUE);
        $request['petty_request_purpose_expense'] = $this->input->get('petty_request_purpose_expense',TRUE);
        $request['petty_request_mode_payment'] = $this->input->get('petty_request_mode_payment',TRUE);
        $request['petty_request_payment_amount'] = $this->input->get('petty_request_payment_amount',TRUE);
        $request['petty_request_payment_total_amount'] = $this->input->get('petty_request_payment_amount',TRUE);
        $request['petty_request_comment'] = $this->input->get('petty_request_comment',TRUE);
        $request['petty_request_consignee_name'] = $this->input->get('petty_request_consignee_name',TRUE);
        $request['petty_request_details'] = $this->input->get('petty_request_details',TRUE);
        //$request['petty_request_payment_amount_word'] = $this->input->get('petty_request_payment_amount_word',TRUE);

        $request['petty_request_date_created'] = date('Y-m-d');
        $request['petty_request_by'] = $this->auth_user_id;
        //$request['petty_request_date_approved'] = $this->input->get('petty_request_date_approved',TRUE);
        //$request['petty_request_approved_by'] = $this->input->get('petty_request_approved_by',TRUE);
        $freightKey = $this->input->get('freight_task_key',TRUE);

        $profile = profile();
        if($this->requestModel->createRequest($request,$freightKey)){
            $result['status'] = 'ok';
            $result['message'] = 'Petty Cash Requested successfully';

            /** Here we alert targeted user on a new petty request arrival */
            $data['role_action'] = "petty_approve";
            $data['title'] = "New petty request from ".$profile->firstname." ".$profile->lastname;
            $data['link']= base_url('freight/request');
            $data['content'] = "You have got new petty request";
            $data['sender'] = $this->auth_user_id;
            $data['type'] = 'petty';
            $data['target'] = 'system';
            $data['receiver'] = 'system';
            $data['time'] = date("H:i:s");
            publishEventFlash('petty', $data);
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function datasourceUnapproved($when =''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->requestModel->unapproved_request($when);
        $columns = [
            'petty_request_id' => true,
            'petty_request_key' => true,
            'firstname' => true,
            'lastname' => true,
            'petty_request_payee' => true,
            'petty_request_file_number'=> true,
            'petty_request_purpose_expense'=> true,
            'petty_request_date_created'=> true,
            'petty_request_status'=> true,
            'petty_request_comment'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }

    function datasourceApproved($when =''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->requestModel->approved_request($when);
        $columns = [
            'petty_request_id' => true,
            'petty_request_key' => true,
            'firstname' => true,
            'lastname' => true,
            'petty_request_payee' => true,
            'petty_request_file_number'=> true,
            'petty_request_purpose_expense'=> true,
            'petty_request_date_created'=> true,
            'petty_request_status'=> true,
            'petty_request_comment'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }

    public function myrequest() {
        $this->pagedata['title'] = 'My Request | '.$this->config->item('application_name');
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['taskme'] = $this->requestModel->all_freight_taskme($this->auth_user_id);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/my_petty_request');
    }

    function newMyPettyRequest(){
        $request['petty_request_payee'] = $this->input->get('petty_request_payee',TRUE);
        $request['petty_request_file_number'] = $this->input->get('petty_request_file_number',TRUE);
        $request['petty_request_purpose_expense'] = $this->input->get('petty_request_purpose_expense',TRUE);
        $request['petty_request_mode_payment'] = $this->input->get('petty_request_mode_payment',TRUE);
        $request['petty_request_payment_amount'] = $this->input->get('petty_request_payment_amount',TRUE);
        $request['petty_request_payment_total_amount'] = $this->input->get('petty_request_payment_total_amount',TRUE);
        $request['petty_request_comment'] = $this->input->get('petty_request_comment',TRUE);
        $request['petty_request_consignee_name'] = $this->input->get('petty_request_consignee_name',TRUE);
        $request['petty_request_details'] = $this->input->get('petty_request_details',TRUE);
        $request['petty_request_payment_amount_word'] = $this->input->get('petty_request_payment_amount_word',TRUE);

        $request['petty_request_date_created'] = date('Y-m-d');
        $request['petty_request_by'] = $this->auth_user_id;
        $request['petty_request_date_approved'] = $this->input->get('petty_request_date_approved',TRUE);
        $request['petty_request_approved_by'] = $this->input->get('petty_request_approved_by',TRUE);
        $freightKey = $this->input->get('freight_task_key',TRUE);

        if($this->requestModel->createRequest($request,$freightKey)){
            $result['status'] = 'ok';
            $result['message'] = 'Petty Cash Requested successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function datasourceMyrequest($when=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $auth_user_id = $this->auth_user_id;
        $data = $this->requestModel->my_request($when,$auth_user_id);
        $columns = [
            'petty_request_id' => true,
            'petty_request_key' => true,
            'firstname' => true,
            'lastname' => true,
            'petty_request_payee' => true,
            'petty_request_file_number'=> true,
            'petty_request_purpose_expense'=> true,
            'petty_request_date_created'=> true,
            'petty_request_status'=> true,
            'petty_request_comment'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }

    public function approveRequest($requestKey='') {
        has_control('petty_approve','Approve petty request');
        $this->pagedata['request'] = $this->requestModel->select_one_request($requestKey);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/request_approve_form');
    }

    function approvePettyRequest($requestKey='') {
        has_control('petty_approve','Approve petty request');
        $this->load->helper('reports/accounting/helper');
        $this->load->model(array('accounting/GeneralLedgerModel'=>'generalLedgerModel'));

        $this->db->trans_start();
        $data['petty_request_payee'] = $this->input->get('petty_request_payee',TRUE);
        $data['petty_request_file_number'] = $this->input->get('petty_request_file_number',TRUE);
        $data['petty_request_purpose_expense'] = $this->input->get('petty_request_purpose_expense',TRUE);
        $data['petty_request_mode_payment'] = $this->input->get('petty_request_mode_payment',TRUE);
        $data['petty_request_payment_amount'] = to_dollar(toNumber($this->input->get('petty_request_payment_amount',TRUE)));
        $data['petty_request_payment_total_amount'] = to_dollar(toNumber($this->input->get('petty_request_payment_amount',TRUE)));
        $data['petty_request_comment'] = $this->input->get('petty_request_comment',TRUE);
        $data['petty_request_consignee_name'] = $this->input->get('petty_request_consignee_name',TRUE);
        $data['petty_request_details'] = $this->input->get('petty_request_details',TRUE);
        $data['petty_request_payment_amount_word'] = $this->input->get('petty_request_payment_amount_word',TRUE);
        $data['petty_request_status'] = 'Approved';
        $data['petty_request_date_created'] = $this->input->get('petty_request_date_created',TRUE);
        $data['petty_request_by'] = $this->input->get('petty_request_by',TRUE);
        $data['petty_request_date_approved'] = date('Y-m-d');
        $data['petty_request_approved_by'] = $this->auth_user_id;

        $this->requestModel->requestApproveUpdate($requestKey,$data);

        /** Start posting petty cash to General Ledger
         *
         ** Here we have two options;
         *
         * @Option 0 (Operational expenses or office based expense)
         * if $expense_ownership value is zero, then we record the expense as operational
         *
         * @Option 1 (Consignee/Customer based expense)
         * if $expense_ownership value is 1,
         * then we record the expense as customer based along with customer ID.
         */

        $expense_ownership =  $this->input->get('expense_type',TRUE);
        $freight = $this->freightsModel->find($data['petty_request_file_number']);
        $consignee = $freight['fr_client'];

        if($expense_ownership == 0){

            // 1. Debit Account Details
            $ledgerDebit['gl_account'] = $this->input->get('petty_request_debit_account',TRUE);
            $ledgerDebit['gl_debit'] = $data['petty_request_payment_amount'];
            $ledgerDebit['gl_amount'] = $data['petty_request_payment_amount'];
            $ledgerDebit['gl_date'] = $data['petty_request_date_approved'];
            $ledgerDebit['gl_status'] = "PENDING";
            $ledgerDebit['gl_category'] = "PETTY-CASH";
            $ledgerDebit['gl_type'] = "PETTY-CASH";
            $ledgerDebit['gl_reference'] = $this->input->get('petty_request_file_number',TRUE);
            $ledgerDebit['gl_details'] = $data['petty_request_purpose_expense'];
            $ledgerDebit['gl_activity'] = $requestKey;
            $id = $this->generalLedgerModel->insert($ledgerDebit);
            $balance['gl_balance'] = accountBalance($ledgerDebit['gl_account']);
            $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

            // 2. Credit Account Details
            $ledgerCredit['gl_account'] = $this->input->get('petty_request_credit_account',TRUE);
            $ledgerCredit['gl_credit'] = $data['petty_request_payment_amount'];
            $ledgerCredit['gl_date'] = $data['petty_request_date_approved'];
            $ledgerCredit['gl_status'] = "PENDING";
            $ledgerCredit['gl_category'] = "PETTY-CASH";
            $ledgerCredit['gl_type'] = "PETTY-CASH";
            $ledgerCredit['gl_reference'] = $this->input->get('petty_request_file_number',TRUE);
            $ledgerCredit['gl_details'] = $data['petty_request_purpose_expense'];
            $ledgerCredit['gl_activity'] = $requestKey;
            $ledgerCredit['gl_amount'] = $data['petty_request_payment_amount'];
            $id = $this->generalLedgerModel->insert($ledgerCredit);
            $balance['gl_balance'] = accountBalance($ledgerCredit['gl_account']);
            $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);
        }
        elseif ($expense_ownership == 1){

            // 1. GL Details
            $ledger['gl_debit'] = $data['petty_request_payment_amount'];
            $ledger['gl_amount'] = $data['petty_request_payment_amount'];
            $ledger['gl_date'] = $data['petty_request_date_approved'];
            $ledger['gl_status'] = "PENDING";
            $ledger['gl_category'] = "EXPENSES";
            $ledger['gl_type'] = "EXPENSE";
            $ledger['gl_reference'] = $this->input->get('petty_request_file_number',TRUE);
            $ledger['gl_details'] = $data['petty_request_purpose_expense'];
            $ledger['gl_activity'] = $requestKey;
            $ledger['gl_ownership'] = 1;
            $ledger['gl_customer'] = $consignee;
            $this->generalLedgerModel->insert($ledger);

        }
        $this->db->trans_complete();

        if($this->db->trans_status() === true){
            $result['status'] = 'ok';
            $result['message'] = 'Petty Request Approved successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function approvePettyRequest1($requestKey='') {
        $data['petty_request_payee'] = $this->input->get('petty_request_payee',TRUE);
        $data['petty_request_file_number'] = $this->input->get('petty_request_file_number',TRUE);
        $data['petty_request_purpose_expense'] = $this->input->get('petty_request_purpose_expense',TRUE);
        $data['petty_request_mode_payment'] = $this->input->get('petty_request_mode_payment',TRUE);
        $data['petty_request_payment_amount'] = $this->input->get('petty_request_payment_amount',TRUE);
        $data['petty_request_payment_total_amount'] = $this->input->get('petty_request_payment_total_amount',TRUE);
        $data['petty_request_comment'] = $this->input->get('petty_request_comment',TRUE);
        $data['petty_request_consignee_name'] = $this->input->get('petty_request_consignee_name',TRUE);
        $data['petty_request_details'] = $this->input->get('petty_request_details',TRUE);
        $data['petty_request_payment_amount_word'] = $this->input->get('petty_request_payment_amount_word',TRUE);
        $data['petty_request_status'] = 'Approved';
        $ledgerCredit['gl_account'] = $this->input->get('petty_request_credit_account',TRUE);
        $ledgerDebit['gl_account'] = $this->input->get('petty_request_debit_account',TRUE);

        $data['petty_request_date_created'] = $this->input->get('petty_request_date_created',TRUE);
        $data['petty_request_by'] = $this->input->get('petty_request_by',TRUE);
        $data['petty_request_date_approved'] = date('Y-m-d');
        $data['petty_request_approved_by'] = $this->auth_user_id;

        if($this->requestModel->requestApproveUpdate($requestKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Petty Request Approved successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function requestReject($request){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax_content('petty_reject','Reject petty request');
        if($this->requestModel->rejectRequest($request,['petty_request_status'=>'Rejected'])){
            $result['status'] = 'ok';
            $result['message'] = 'Request Rejected successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function details($key='') {
        $this->load->helper('form');
        //$this->pagedata['link']= 'freight';
        $this->pagedata['title'] = 'Request Details | '.$this->config->item('application_name');
        $this->pagedata['request'] = $this->requestModel->select_one_request($key);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/request_more');
    }

    public function deleteRequest($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'request':
                if($this->requestModel->request_delete($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Request Data deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

}