<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
* Description of Freight Forwarding
*
* @author Elieza Kalaita
*/

class Index extends MY_Controller{

  public  $pagedata;

  public function __construct() {
    parent::__construct();
    $this->require_min_level(1);
    $this->pagedata['link']= 'freight';
    $this->load->helper('freight_forward/helper');
    $this->load->vars($this->pagedata);
    $this->load->model(array(
        'freight/FreightsModel'=>'freightsModel',
        'freight/PlansModel'=>'plansModel',
        'CountriesModel'=>'countriesModel',
        'freight/CategoriesModel'=>'categoriesModel',
        'freight/AssessedValuationModel'=>'assessedValuationModel',
        'freight/DeclaredValuationModel'=>'declaredValuationModel',
        'freight/ImportersModel'=>'importersModel',
        'freight/ExportersModel'=>'exportersModel',
        'freight/DocumentsModel'=>'documentsModel',
      ));
  }
 
   public function index() {
    $this->pagedata['title'] = 'Freight List | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('freight/freight');
  }

   public function settings()
  {
      $this->pagedata['title'] = "Freight Settings |" .$this->config->item('application_name');
      $this->load->helper('form');
      $this->load->vars($this->pagedata);
      $this->load->view('freight/settings');
  }

   function create(){
      $this->pagedata['title'] = "Create Freight | ".$this->config->item('application_name');
      $this->load->helper('form');
      $this->load->vars($this->pagedata);
      $this->load->view('freight/create');
  }

   function importers(){
      $this->pagedata['title'] = "Importers List | ".$this->config->item('application_name');
      $this->load->helper('form');
      $this->load->vars($this->pagedata);
      $this->load->view('freight/importers');
  }

   function exporters(){
      $this->pagedata['title'] = "Exporters List | ".$this->config->item('application_name');
      $this->load->helper('form');
      $this->load->vars($this->pagedata);
      $this->load->view('freight/exporters');
  }

   function documents($id){
      $this->pagedata['title'] = "Freight Docs | ".$this->config->item('application_name');
      $this->load->helper('form');
      $this->pagedata['freight'] = $this->freightsModel->find($id);
      $this->load->vars($this->pagedata);
      $this->load->view('freight/documents');
  }

    /*
     * miscs
     */

//    function collectFreghtData(){
//        return inputAllPost();
//    }

    /*
     * end miscs
     */

    //----------------Countries---------------//
    public function addcountry() {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $this->load->model(array(
            'CountriesModel'=>'countriesModel',
        ));

        $data = array(
            'country_name' => $this->input->post('country',TRUE)
        );

        if($this->countriesModel->insert($data)){
            $results['message'] = 'Country added successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to add country';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();

    }
    public function country_details($key) {
        $this->load->model(array('CountriesModel'=>'countriesModel'));
        $this->load->helper('form');
        $this->pagedata['country'] = $this->countriesModel->find($key);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/country_details');
    }
    public function modify_country() {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->load->model(array(
            'CountriesModel'=>'countriesModel',
        ));

        $data = array(
            'country_name' => $this->input->post('country',TRUE)
        );

        $key = $this->input->post('country_key',TRUE);

        if($this->countriesModel->update($key,$data)){
            $results['message'] = 'Country updated successfully '.$key;
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to update country';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();

    }
    function datasource_contries(){
       $this->load->model(array('CountriesModel'=>'countriesModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->countriesModel->find_all();
        $columns = array();
        foreach ($this->countriesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function datasource_contries_bin(){
        $this->load->model(array('CountriesModel'=>'countriesModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));

        $this->countriesModel->where('country_deleted',1);
        $data = $this->countriesModel->with_deleted()->find_all();

        $columns = array();
        foreach ($this->countriesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function delete_country($key=''){
        $this->load->model(array('CountriesModel'=>'countriesModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->countriesModel->delete($key)){
            $results['message'] = 'Country deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete Country';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    function restore_country($key=''){
        $this->load->model(array('CountriesModel'=>'countriesModel'));

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->countriesModel->update($key,['country_deleted' => 0])){
            $results['message'] = 'Country restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore Country';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    //---------------End Countries-------------//


    //--------------Categories---------------------//
    public function addcategory() {

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->load->model(array(
            'freight/CategoriesModel'=>'categoriesModel',
        ));

        $data = array(
            'fr_category_name' => $this->input->post('category',TRUE)
        );

        if($this->categoriesModel->insert($data)){
            $results['message'] = 'Category added successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to add category';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();

    }
    public function category_details($key) {
        $this->load->model(array('freight/CategoriesModel'=>'categoriesModel'));

        $this->load->helper('form');
        $this->pagedata['category'] = $this->categoriesModel->find($key);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/category_details');
    }
    function datasource_categories()
    {
        $this->load->model(array('freight/CategoriesModel'=>'categoriesModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->categoriesModel->find_all();
        $columns = array();
        foreach ($this->categoriesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function datasource_categories_bin(){
        $this->load->model(array('freight/CategoriesModel'=>'categoriesModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));

        $this->categoriesModel->where('fr_category_deleted',1);
        $data = $this->categoriesModel->with_deleted()->find_all();

        $columns = array();
        foreach ($this->categoriesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function delete_category($key=''){
        $this->load->model(array('freight/CategoriesModel'=>'categoriesModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->categoriesModel->delete($key)){
            $results['message'] = 'Category deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete Category';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    function restore_category($key='')
    {
        $this->load->model(array('freight/CategoriesModel'=>'categoriesModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->categoriesModel->update($key,['fr_category_deleted' => 0])){
            $results['message'] = 'Category restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore Category';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    public function modify_category() {
        $this->load->model(array('freight/CategoriesModel'=>'categoriesModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data = array(
            'fr_category_name' => $this->input->post('category',TRUE)
        );

        $key = $this->input->post('fr_category_key',TRUE);

        if($this->categoriesModel->update($key,$data)){
            $results['message'] = 'Category updated successfully '.$key;
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to update category';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    //--------------End Categories----------------//

    //--------------Plans-------------------------//
    public function addplan() {

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->load->model(array(
            'freight/PlansModel'=>'plansModel',
        ));

        $data = array(
            'fr_plan_name' => $this->input->post('plan',TRUE)
        );

        if($this->plansModel->insert($data)){
            $results['message'] = 'Plan added successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to add plan';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();

    }
    public function plan_details($key) {
        $this->load->model(array('freight/PlansModel'=>'plansModel'));

        $this->load->helper('form');
        $this->pagedata['plan'] = $this->plansModel->find($key);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/plan_details');
    }
    function datasource_plans()
    {
        $this->load->model(array('freight/PlansModel'=>'plansModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->plansModel->find_all();
        $columns = array();
        foreach ($this->plansModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function datasource_plans_bin(){
        $this->load->model(array('freight/PlansModel'=>'plansModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));

        $this->plansModel->where('fr_plan_deleted',1);
        $data = $this->plansModel->with_deleted()->find_all();

        $columns = array();
        foreach ($this->plansModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function delete_plan($key=''){
        $this->load->model(array('freight/PlansModel'=>'plansModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->plansModel->delete($key)){
            $results['message'] = 'Plan deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete Plan';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    function restore_plan($key='')
    {
        $this->load->model(array('freight/PlansModel'=>'plansModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->plansModel->update($key,['fr_plan_deleted' => 0])){
            $results['message'] = 'Plan restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore Plan';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    public function modify_plan() {
        $this->load->model(array('freight/PlansModel'=>'plansModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data = array(
            'fr_plan_name' => $this->input->post('plan',TRUE)
        );

        $key = $this->input->post('fr_plan_key',TRUE);

        if($this->plansModel->update($key,$data)){
            $results['message'] = 'Plan updated successfully '.$key;
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to update plan';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    //--------------End Plans---------------------//

    //-------------- Freights---------------------//
    function createfreight(){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        //$data = inputAllGet();

        //Data for table freights
        $data = array('fr_declaration_type'=>$this->input->post('fr_declaration_type'),'fr_processing_office'=>$this->input->post('fr_processing_office'),
            'fr_transad_number'=>$this->input->post('fr_transad_number'),'fr_transad_date'=>$this->input->post('fr_transad_date'),
            'fr_number_of_items'=>$this->input->post('fr_number_of_items'),'fr_cl_plan'=>$this->input->post('fr_cl_plan'),
            'fr_security_account_number'=>$this->input->post('fr_security_account_number'),
            'fr_receipt_number'=>$this->input->post('fr_receipt_number'),'fr_receipt_date'=>$this->input->post('fr_receipt_date'),
            'fr_country_last_consignment'=>$this->input->post('fr_country_last_consignment'),
            'fr_trading_country'=>$this->input->post('fr_trading_country'),'fr_country_of_export'=>$this->input->post('fr_country_of_export'),
            'fr_importer'=>$this->input->post('fr_importer'),'fr_exporter'=>$this->input->post('fr_exporter'),
            'fr_country_of_destination'=>$this->input->post('fr_country_of_destination'),
            'fr_delivery_term_code'=>$this->input->post('fr_delivery_term_code'),
            'fr_delivery_place'=>$this->input->post('fr_delivery_place'),'fr_nature_of_transport'=>$this->input->post('fr_nature_of_transport'),
            'fr_exchange_rate'=>$this->input->post('fr_exchange_rate'),'fr_exchange_currency'=>$this->input->post('fr_exchange_currency'),
            'fr_total_invoice_value'=>$this->input->post('fr_total_invoice_value'),'fr_invoice_number'=>$this->input->post('fr_invoice_number'),
            'fr_invoice_date'=>$this->input->post('fr_invoice_date'),'fr_valuation_note'=>$this->input->post('fr_valuation_note'),
            'fr_freight_charges'=>$this->input->post('fr_freight_charges'),'fr_freight_currency'=>$this->input->post('fr_freight_currency'),
            'fr_insurance'=>$this->input->post('fr_insurance'),'fr_insurance_currency'=>$this->input->post('fr_insurance_currency'),
            'fr_other_charges'=>$this->input->post('fr_other_charges'),'fr_other_currency'=>$this->input->post('fr_other_currency'),
            'fr_deductions'=>$this->input->post('fr_deductions'),'fr_deductions_currency'=>$this->input->post('fr_deductions_currency'),
            'fr_number_of_packages'=>$this->input->post('fr_number_of_packages'),'fr_gross_weight'=>$this->input->post('fr_gross_weight'),
            'fr_net_weight'=>$this->input->post('fr_net_weight'),'fr_exit_office'=>$this->input->post('fr_exit_office'),
            'fr_entry_office'=>$this->input->post('fr_entry_office'),'fr_location_goods'=>$this->input->post('fr_location_goods'),
            'fr_category_of_goods'=>$this->input->post('fr_category_of_goods'),'fr_shipping_order'=>$this->input->post('fr_shipping_order'),
            'fr_agent_reference_number'=>$this->input->post('fr_agent_reference_number'));

        //Data for table freight_declared_valuation
        $data2 = array('fr_de_currency'=>$this->input->post('fr_de_currency'),'fr_de_total_fob'=>$this->input->post('fr_de_total_fob'),
            'fr_de_freight'=>$this->input->post('fr_de_freight'),'fr_de_insurance'=>$this->input->post('fr_de_insurance'),
            'fr_de_other_charges'=>$this->input->post('fr_de_other_charges'),'fr_de_deductions'=>$this->input->post('fr_de_deductions'),
            'fr_de_customs_value'=>$this->input->post('fr_de_customs_value'),
            'fr_de_item_no'=>$this->input->post('fr_de_item_no'),'fr_de_description'=>$this->input->post('fr_de_description'),
            'fr_de_hs_code'=>$this->input->post('fr_de_hs_code'),
            'fr_de_value_for_customs'=>$this->input->post('fr_de_value_for_customs'),'fr_de_fob_value'=>$this->input->post('fr_de_fob_value'),
            'fr_de_model'=>$this->input->post('fr_de_model'),'fr_de_specification'=>$this->input->post('fr_de_specification'),
            'fr_de_component'=>$this->input->post('fr_de_component'),
            'fr_de_quantity'=>$this->input->post('fr_de_quantity'),
            'fr_de_unit_price'=>$this->input->post('fr_de_unit_price'),'fr_de_item_invoice_price'=>$this->input->post('fr_de_item_invoice_price'));

        //Data for table freight_assessed_valuation
        $data3 = array('fr_av_currency'=>$this->input->post('fr_av_currency'),'fr_av_total_fob'=>$this->input->post('fr_av_total_fob'),
            'fr_av_freight'=>$this->input->post('fr_av_freight'),'fr_av_insurance'=>$this->input->post('fr_av_insurance'),
            'fr_av_other_charges'=>$this->input->post('fr_av_other_charges'),'fr_av_deductions'=>$this->input->post('fr_av_deductions'),
            'fr_av_customs_value'=>$this->input->post('fr_av_customs_value'),
            'fr_av_item_no'=>$this->input->post('fr_av_item_no'),'fr_av_description'=>$this->input->post('fr_av_description'),
            'fr_av_hs_code'=>$this->input->post('fr_av_hs_code'),
            'fr_av_value_for_customs'=>$this->input->post('fr_av_value_for_customs'),'fr_av_fob_value'=>$this->input->post('fr_av_fob_value'),
            'fr_av_model'=>$this->input->post('fr_av_model'),'fr_av_specification'=>$this->input->post('fr_av_specification'),
            'fr_av_component'=>$this->input->post('fr_av_component'),
            'fr_av_quantity'=>$this->input->post('fr_av_quantity'),
            'fr_av_unit_price'=>$this->input->post('fr_av_unit_price'),'fr_av_item_invoice_price'=>$this->input->post('fr_av_item_invoice_price'));

        $this->db->trans_start();

        $id = $this->freightsModel->insert($data);

        $rawData = $this->freightsModel->find_by(["fr_id" => $id]);

        $data3['fr_av_freight_key'] = $rawData['fr_key'];
        $this->assessedValuationModel->insert($data3);

        $data2['fr_de_freight_key'] = $rawData['fr_key'];
        $this->declaredValuationModel->insert($data2);

        $this->db->trans_complete();

        if($this->db->trans_status() === TRUE){
            $res['message'] = 'Results of valuation records added successfully';
            $res['status'] = true;
        }else{
            $res['message'] = 'Failed to add results of valuation records';
            $res['status'] = false;
        }

        echo json_encode($res, JSON_PRETTY_PRINT);
        exit();

    }
    function freight_details($key)
    {
        $this->load->helper('form');
        $this->pagedata['title'] = 'Freight Details | '.$this->config->item('application_name');
        $this->pagedata['freight'] = $this->freightsModel->find($key);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/freight_details');
        //echo json_encode($this->pagedata['freight'], JSON_PRETTY_PRINT);
        //exit();
    }
    function datasource_freights()
    {
        $this->load->model(array('freight/FreightsModel'=>'freightsModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->freightsModel->find_all();
        $columns = array();
        foreach ($this->freightsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        $columns['country_name'] = TRUE;
        $columns['country_name'] = TRUE;
        print $this->datasourceLibrary->server($data,$columns);
    }
    function datasource_freights_bin()
    {
        $this->load->model(array('freight/FreightsModel'=>'freightsModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $this->freightsModel->where('fr_deleted',1);
        $data = $this->freightsModel->with_deleted()->find_all();
        $columns = array();
        foreach ($this->freightsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        $columns['country_name'] = TRUE;
        $columns['country_name'] = TRUE;
        print $this->datasourceLibrary->server($data,$columns);
    }
    function delete_freight($key=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->freightsModel->delete($key)){
            $results['message'] = 'Freight deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete Freight';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    function restore_freight($key='')
    {
        $this->load->model(array('freight/FreightsModel'=>'freightsModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->freightsModel->update($key,['fr_deleted' => 0])){
            $results['message'] = 'Freight restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore Freight';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    function editfreight($id)
    {
        $this->pagedata['title'] = "Edit Freight |" .$this->config->item('application_name');
        $this->load->helper('form');
        $this->pagedata['data'] = $this->freightsModel->find($id);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/edit_freight');
    }
    function edit_freight($id)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        //$data = inputAllGet();
        $data = array('fr_declaration_type'=>$this->input->post('fr_declaration_type'),'fr_processing_office'=>$this->input->post('fr_processing_office'),
            'fr_transad_number'=>$this->input->post('fr_transad_number'),'fr_transad_date'=>$this->input->post('fr_transad_date'),
            'fr_number_of_items'=>$this->input->post('fr_number_of_items'),'fr_cl_plan'=>$this->input->post('fr_cl_plan'),
            'fr_security_account_number'=>$this->input->post('fr_security_account_number'),
            'fr_receipt_number'=>$this->input->post('fr_receipt_number'),'fr_receipt_date'=>$this->input->post('fr_receipt_date'),
            'fr_country_last_consignment'=>$this->input->post('fr_country_last_consignment'),
            'fr_trading_country'=>$this->input->post('fr_trading_country'),'fr_country_of_export'=>$this->input->post('fr_country_of_export'),
            'fr_importer'=>$this->input->post('fr_importer'),'fr_exporter'=>$this->input->post('fr_exporter'),
            'fr_country_of_destination'=>$this->input->post('fr_country_of_destination'),
            'fr_delivery_term_code'=>$this->input->post('fr_delivery_term_code'),
            'fr_delivery_place'=>$this->input->post('fr_delivery_place'),'fr_nature_of_transport'=>$this->input->post('fr_nature_of_transport'),
            'fr_exchange_rate'=>$this->input->post('fr_exchange_rate'),'fr_exchange_currency'=>$this->input->post('fr_exchange_currency'),
            'fr_total_invoice_value'=>$this->input->post('fr_total_invoice_value'),'fr_invoice_number'=>$this->input->post('fr_invoice_number'),
            'fr_invoice_date'=>$this->input->post('fr_invoice_date'),'fr_valuation_note'=>$this->input->post('fr_valuation_note'),
            'fr_freight_charges'=>$this->input->post('fr_freight_charges'),'fr_freight_currency'=>$this->input->post('fr_freight_currency'),
            'fr_insurance'=>$this->input->post('fr_insurance'),'fr_insurance_currency'=>$this->input->post('fr_insurance_currency'),
            'fr_other_charges'=>$this->input->post('fr_other_charges'),'fr_other_currency'=>$this->input->post('fr_other_currency'),
            'fr_deductions'=>$this->input->post('fr_deductions'),'fr_deductions_currency'=>$this->input->post('fr_deductions_currency'),
            'fr_number_of_packages'=>$this->input->post('fr_number_of_packages'),'fr_gross_weight'=>$this->input->post('fr_gross_weight'),
            'fr_net_weight'=>$this->input->post('fr_net_weight'),'fr_exit_office'=>$this->input->post('fr_exit_office'),
            'fr_entry_office'=>$this->input->post('fr_entry_office'),'fr_location_goods'=>$this->input->post('fr_location_goods'),
            'fr_category_of_goods'=>$this->input->post('fr_category_of_goods'),'fr_shipping_order'=>$this->input->post('fr_shipping_order'),
            'fr_agent_reference_number'=>$this->input->post('fr_agent_reference_number'));

        //Data for table freight_declared_valuation
        $data2 = array('fr_de_currency'=>$this->input->post('fr_de_currency'),'fr_de_total_fob'=>$this->input->post('fr_de_total_fob'),
            'fr_de_freight'=>$this->input->post('fr_de_freight'),'fr_de_insurance'=>$this->input->post('fr_de_insurance'),
            'fr_de_other_charges'=>$this->input->post('fr_de_other_charges'),'fr_de_deductions'=>$this->input->post('fr_de_deductions'),
            'fr_de_customs_value'=>$this->input->post('fr_de_customs_value'),
            'fr_de_item_no'=>$this->input->post('fr_de_item_no'),'fr_de_description'=>$this->input->post('fr_de_description'),
            'fr_de_hs_code'=>$this->input->post('fr_de_hs_code'),
            'fr_de_value_for_customs'=>$this->input->post('fr_de_value_for_customs'),'fr_de_fob_value'=>$this->input->post('fr_de_fob_value'),
            'fr_de_model'=>$this->input->post('fr_de_model'),'fr_de_specification'=>$this->input->post('fr_de_specification'),
            'fr_de_component'=>$this->input->post('fr_de_component'),
            'fr_de_quantity'=>$this->input->post('fr_de_quantity'),
            'fr_de_unit_price'=>$this->input->post('fr_de_unit_price'),'fr_de_item_invoice_price'=>$this->input->post('fr_de_item_invoice_price'));

        //Data for table freight_assessed_valuation
        $data3 = array('fr_av_currency'=>$this->input->post('fr_av_currency'),'fr_av_total_fob'=>$this->input->post('fr_av_total_fob'),
            'fr_av_freight'=>$this->input->post('fr_av_freight'),'fr_av_insurance'=>$this->input->post('fr_av_insurance'),
            'fr_av_other_charges'=>$this->input->post('fr_av_other_charges'),'fr_av_deductions'=>$this->input->post('fr_av_deductions'),
            'fr_av_customs_value'=>$this->input->post('fr_av_customs_value'),
            'fr_av_item_no'=>$this->input->post('fr_av_item_no'),'fr_av_description'=>$this->input->post('fr_av_description'),
            'fr_av_hs_code'=>$this->input->post('fr_av_hs_code'),
            'fr_av_value_for_customs'=>$this->input->post('fr_av_value_for_customs'),'fr_av_fob_value'=>$this->input->post('fr_av_fob_value'),
            'fr_av_model'=>$this->input->post('fr_av_model'),'fr_av_specification'=>$this->input->post('fr_av_specification'),
            'fr_av_component'=>$this->input->post('fr_av_component'),
            'fr_av_quantity'=>$this->input->post('fr_av_quantity'),
            'fr_av_unit_price'=>$this->input->post('fr_av_unit_price'),'fr_av_item_invoice_price'=>$this->input->post('fr_av_item_invoice_price'));

        $this->db->trans_start();
        $this->freightsModel->update($id,$data);
        $this->assessedValuationModel->update_by(["fr_av_freight_key" => $id],$data3);
        $this->declaredValuationModel->update_by(["fr_de_freight_key" => $id],$data2);
        $this->db->trans_complete();

        if($this->db->trans_status() === TRUE){
            $res['message'] = 'Results of valuation records updated successfully';
            $res['status'] = true;
        }else{
            $res['message'] = 'Failed to update results of valuation records';
            $res['status'] = false;
        }

        echo json_encode($res, JSON_PRETTY_PRINT);
        exit();

//        if($this->freightsModel->update($id,$data)){
//            $results['message'] = 'Freight records updated successfully';
//            $results['status'] = true;
//        }else{
//            $results['message'] = 'Failed to update freight records';
//            $results['status'] = false;
//        }
//
//        echo json_encode($results, JSON_PRETTY_PRINT);
//        exit();
    }
    //--------------End Freights-----------------//

    //-------------- Importers ------------------//
    function datasource_importers(){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->importersModel->find_all();
        $columns = array();
        foreach ($this->importersModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        //$columns['country_name'] = TRUE;
        //$columns['country_name'] = TRUE;
        print $this->datasourceLibrary->server($data,$columns);
    }
    function importer_details($num)
    {
        $this->load->helper('form');
        $this->pagedata['title'] = 'Importer Details | '.$this->config->item('application_name');
        $this->pagedata['importer'] = $this->freightsModel->find_many_by(["fr_importer" => $num]);
        $this->pagedata['users'] = $this->importersModel->find($num);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/importer_details');

        //var_dump($this->pagedata['importer']);
        //echo json_encode($this->pagedata['importer'], JSON_PRETTY_PRINT);
       // exit();
    }
    function datasource_importer_freights($key)
    {
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->freightsModel->find_many_by(["fr_importer" => $key]);
        $columns = array();
        foreach ($this->freightsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        //$columns['country_name'] = TRUE;
        //$columns['country_name'] = TRUE;
        print $this->datasourceLibrary->server($data,$columns);
    }
    //-------------- End Importers ------------------//

    //-------------- Exporters ------------------//
    function datasource_exporters(){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->exportersModel->find_all();
        $columns = array();
        foreach ($this->exportersModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function exporter_details($num)
    {
        $this->load->helper('form');
        $this->pagedata['title'] = 'Importer Details | '.$this->config->item('application_name');
        $this->pagedata['exporter'] = $this->freightsModel->find_many_by(["fr_exporter" => $num]);
        $this->pagedata['users'] = $this->exportersModel->find($num);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/exporter_details');

        //var_dump($this->pagedata['importer']);
        //echo json_encode($this->pagedata['importer'], JSON_PRETTY_PRINT);
       // exit();
    }
    function datasource_exporter_freights($key)
    {
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->freightsModel->find_many_by(["fr_exporter" => $key]);
        $columns = array();
        foreach ($this->freightsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    //-------------- End Exporters ------------------//

    //-------------- Documents ----------------------//
    function newDocumentation($key='')
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $this->load->helper('form');

        $data['doc_fr_key'] = $key;
        $data['doc_name'] = $this->input->get('doc_name',TRUE);
        $data['doc_type'] = $this->input->get('doc_type',TRUE);
        $data['doc_description'] = $this->input->get('doc_description',TRUE);
        //$data['doc_file'] = $this->input->get('doc_file',TRUE);

        if (!empty($this->input->get('uploadedfiles'))) {
            $raw = explode('LM-55', $_GET['uploadedfiles']);
            foreach ($raw as $key => $file) {
                $file = unserialize($file);
                if (is_array($file)) {
                    foreach ($file as $dt) {
                        if (!empty($dt)) {
                            $data['doc_file'] = $dt['doc_file'];
                        }
                    }
                }
            }
        }
        if($this->documentsModel->insert($data)){
            $results['message'] = 'Document added successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to add document';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    function uploadfrdoc(){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $uploadPath = uploadPath('freight_docs/');
        $config['upload_path'] = $uploadPath;
        $config['file_ext_tolower']     = TRUE;
        $config['encrypt_name']         = TRUE;
        $config['allowed_types'] = 'jpg|jpeg|png|docx|doc|pdf|xls|xlsx|zip';

        // Load and initialize upload library
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $i  = 0;
        if($this->upload->do_upload('file')){
            // Uploaded file data
            $fileData = $this->upload->data();
            $uploadData[$i]['doc_file'] = $fileData['file_name'];
        }

        if(!empty($uploadData)){
            $files = array();
            $result['status'] = true;
            foreach ($uploadData as $key => $file){
                $files[$key]['doc_file'] = $file['doc_file'];
            }
            $result['files'] = serialize($files);
        }else{
            $result['status'] = false;
            $result['files'] = '';
        }

        echo json_encode($result, JSON_PRETTY_PRINT);
    }
    public function loadDocumentation($key='') {
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/documentation');
    }
    public function loadAssessment($key='') {
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/assessment');
    }
    public function loadImportPermit($key='') {
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/import_permit');
    }
    public function loadPaymentDuty($key='') {
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/payment_duty');
    }
    public function loadShippingLine($key='') {
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/shipping_line');
    }
    public function loadVerificationPhysical($key='') {
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/verification_physical');
    }
    public function loadPortCharges($key='') {
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/port_charges');
    }
    public function loadReleaseContainer($key='') {
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/release_container');
    }
    public function loadDeliveryNote($key='') {
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/delivery_note');
    }
    public function loadDeliveryConsignee($key='') {
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/delivery_consignee');
    }
    public function loadReturnContainer($key='') {
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/return_container');
    }
    public function loadReceivedInterchange($key='') {
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/received_interchange');
    }
    //-------------- End Documents ----------------------//

}
