<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author noely
 */
class Index extends MY_Controller{

  public $pagedata;
  public $branch;
  public $business;

  public function __construct() {
    parent::__construct();
    ($this->require_min_level(1));
    $this->pagedata['link']= 'employees';
    $this->load->model(array(
        'hrm/Employees'=>'employeesModel',
        'hrm/TitlesModel'=>'titlesModel',
        'hrm/LeaveModel'=>'leaveModel',
        'hrm/HolidaySchemesModel'=>'holidaySchemesModel',
        'hrm/WorkDaySchemes'=>'workDaySchemes',
        'payroll/PayrollsModel'=>'payrollsModel',
        'hrm/DepartmentsModel' => 'departmentsModel',
        'payroll/VariablesModel' => 'variablesModel',
        'payroll/InsuranceModel' => 'insuranceModel',
        //'DocumentsModel' => 'documentsModel',
    ));
    $this->branch = runningBranch()->branch_key;
    $this->business = runningBusiness()->business_key;
    $this->load->helper('hrm/hrm');
  }

  public function index() {
    has_control('employee_view_all','View all employees');
    $this->pagedata['employees'] = $this->employeesModel->employees();
    $this->pagedata['title'] = 'Employees | HRM '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('hrm/employees/employees');
  }

  public function newemployee() {
      $this->load->model(array(
          'payroll/InsuranceModel' => 'insuranceModel',
          'payroll/DeductionsModel' => 'deductionsModel',
          'payroll/BenefitsModel' => 'benefitsModel',
          'payroll/AllowancesModel' => 'allowancesModel'
      ));

    has_control('employee_register','Register Employee');
    $this->pagedata['link']= 'newemployee';
    $this->load->helper('form');
    $this->pagedata['departments'] = $this->departmentsModel->departments();
    $this->pagedata['holiday'] = $this->holidaySchemesModel->holidaySchemes();
    $this->pagedata['leave'] = $this->leaveModel->leaves();
    $this->pagedata['workday'] = $this->workDaySchemes->allWorkDaySchemes();
    $this->pagedata['titles'] = $this->titlesModel->categories();
    $this->pagedata['title'] = 'New Employee | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('hrm/employees/newemployee');
  }

    function uloadpassport(){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        move_uploaded_file($_FILES["files"]["tmp_name"], uploadPath('/passports/').basename($_FILES["files"]["name"]));
        $result['status'] = true;
        print json_encode($result,JSON_PRETTY_PRINT);
    }
function createEmployee(){

    $this->load->helper('payroll/payroll');
//  if (!$this->input->is_ajax_request())
//   exit('not direct script allowed');
//  has_control_ajax('employee_register','Register Employee');
  $primary = $this->collectPrimaryInfo();
  $security = $this->collectSecurityInfo();
  $hlw = $this->collectHolidayLeaveWorkday();
  $variables = $this->collectVariableinfo();
  $roles = $this->collectRolesinfo();

  if($this->employeesModel->registerEmployee($primary,$security,$variables,$roles,$hlw)){
      $result['status'] = 'ok';
      $result['message'] = 'You have successfully registered an Employee';
    }else{
      $result['status'] = 'no';
      $result['message'] = json_encode($this->dbexeption());
  }

  print json_encode($result);
}

  public function departments() {
    $this->load->helper('form');
    $this->pagedata['titles'] = $this->TitlesModel->categories();
    $this->pagedata['departments'] = $this->departmentsModel->departments();
    $this->pagedata['title'] = 'Employees | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('hrm/employees/employee/departments');
  }

  public function checkusernameonly($username='') {
    // if (!$this->input->is_ajax_request())
    //  exit('not direct script allowed');
    $this->db->where('username',urldecode($username));
    $query = $this->db->get('users');
     if($query->num_rows()>0){
               $result['status'] = 'no';
         }else{
           $result['status'] = 'ok';
     }
    print json_encode($result);
  }

  public function checkusername($employee='',$username='') {
    // if (!$this->input->is_ajax_request())
    //  exit('not direct script allowed');
    $this->db->where('username',urldecode($username));
    $this->db->where('user_id !=',$employee);
    $this->db->where('user_branch',$this->branch);
    $this->db->where('user_business',$this->business);
    $query = $this->db->get('users');
     if($query->num_rows()>0){
               $result['status'] = 'no';
         }else{
           $result['status'] = 'ok';
     }
    print json_encode($result);
  }

  public function checkemailonly($email) {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');

    $this->db->where('email',urldecode($email));
    $query = $this->db->get('users');
     if($query->num_rows()>0){
               $result['status'] = 'no';
         }else{
           $result['status'] = 'ok';
     }
    print json_encode($result);
  }

  public function checkemail($employee,$email) {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');

    $this->db->where('email',urldecode($email));
    $this->db->where('user_id !=',$employee);
    $this->db->where('user_branch',$this->branch);
    $this->db->where('user_business',$this->business);
    $query = $this->db->get('users');
     if($query->num_rows()>0){
               $result['status'] = 'no';
         }else{
           $result['status'] = 'ok';
     }
    print json_encode($result);
  }

  public function details($employee='') {
    has_control('employee_view_details','View Employee details');
    $this->load->helper('form');
    $this->pagedata['employee']= $this->employeesModel->employee($employee);
    $this->pagedata['title'] = 'Employee details | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('hrm/employees/employee/details');
  }

  ///--------------WORK STATUS---------------//

  public function loadInformationWork($key='') {
         if (!$this->input->is_ajax_request())
          exit('not direct script allowed');
        has_control_ajax_content('employee_view_details','View Employee details');
      $this->load->model(array(
          'hrm/holidaySchemesModel'=>'holidayScheme',
          'hrm/workDaySchemes'=>'workdaySchemes',
          'hrm/leaveModel'=>'leaveModel',
          'hrm/TitlesModel'=>'titlesModel',
      ));
        $this->pagedata['employee']= $this->employeesModel->employee($key);
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['titles'] = $this->titlesModel->categories();
        $this->pagedata['departments'] = $this->departmentsModel->departments();
        $this->pagedata['hlw']= $this->employeesModel->employee_hlw($key);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/employee/hlwAjax');
    }

  function updateWorkStatus($userKey='') {
        $data['date_of_join'] = $this->input->get('date_of_join',TRUE);
        $data['end_of_probation'] = $this->input->get('end_of_probation',TRUE);
        $data['user_position'] = $this->input->get('user_position',TRUE);
        $data['date_effective'] = $this->input->get('date_effective',TRUE);
        $data['line_manager'] = $this->input->get('line_manager',TRUE);
        $data['user_department_key'] = $this->input->get('user_department_key',TRUE);
        $data['details_branch'] = $this->input->get('details_branch',TRUE);
        $data['job_type'] = $this->input->get('job_type',TRUE);
        $data['job_status'] = $this->input->get('job_status',TRUE);
        $data['mobilephone'] = $this->input->get('mobilephone',TRUE);
        $data['office_phone'] = $this->input->get('office_phone',TRUE);
        $data['education_level'] = $this->input->get('education_level',TRUE);
        if($this->employeesModel->workstatusUpdate($userKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Work status updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

///---------------DOCUMENTS------------------///

  public function loadInformationDocument($key='') {
//        if (!$this->input->is_ajax_request())
//            exit('not direct script allowed');
        has_control_ajax_content('customers_details','View customer details');
        $this->load->helper('form');
        $this->pagedata['employee']= $this->employeesModel->employee($key);
        $this->pagedata['education'] = $this->employeesModel->educationLevel();
        $this->pagedata['document']= $this->employeesModel->documents($key);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/employee/documentsAjax');
    }

  function newDocument(){
        $docs['doc_user_key'] = $this->input->get('doc_user_key',TRUE);
        $docs['doc_desc'] = $this->input->get('doc_desc',TRUE);
        $docs['doc_title'] = $this->input->get('doc_title',TRUE);
        //$docs['doc_type'] = $this->input->get('doc_type',TRUE);
        $docs['doc_date'] = date('Y-m-d');
        $docs['doc_date_created'] = date('Y-m-d');
        if (!empty($this->input->get('uploadedfiles'))) {
            $raw = explode('LM-55', $_GET['uploadedfiles']);
            foreach ($raw as $key => $file) {
                $file = unserialize($file);
                if (is_array($file)) {
                    foreach ($file as $dt) {
                        if (!empty($dt)) {
                            $docs['doc_image'] = $dt['doc_image'];
                        }
                    }
                }
            }
        }
        if($this->employeesModel->createDocument($docs)){
            $result['status'] = 'ok';
            $result['message'] = 'Document uploaded successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

  function uploadempdocs(){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $uploadPath = uploadPath('doc_image/');
        $config['upload_path'] = $uploadPath;
        $config['file_ext_tolower']     = TRUE;
        $config['encrypt_name']         = TRUE;
        $config['allowed_types'] = 'jpg|jpeg|png|docx|doc|pdf|xls|xlsx';

        // Load and initialize upload library
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $i  = 0;
        if($this->upload->do_upload('file')){
            // Uploaded file data
            $fileData = $this->upload->data();
            $uploadData[$i]['doc_image'] = $fileData['file_name'];
        }

        if(!empty($uploadData)){
            $files = array();
            $result['status'] = true;
            foreach ($uploadData as $key => $file){
                $files[$key]['doc_image'] = $file['doc_image'];
            }
            $result['files'] = serialize($files);
        }else{
            $result['status'] = false;
            $result['files'] = '';
        }

        echo json_encode($result, JSON_PRETTY_PRINT);
    }

  function loadInformationDocumentsAction($customer){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax('customers_update','Update employee details');
        $uploadStatus = $this->appLibrary->uploadCustomerDocument(uploadPath('doc_image/'));
        if($uploadStatus['status']){
            $docs['doc_user_key'] = $customer;
            $docs['doc_desc'] = $this->input->post('doc_desc',TRUE);
            $docs['doc_title'] = $this->input->post('doc_title',TRUE);
            $docs['doc_image'] = $uploadStatus['data']['file_name'];
            $docs['doc_type'] = str_ireplace('.','',$uploadStatus['data']['file_ext']);
            $this->employeesModel->createDocument($docs);
            $result['status'] = 'ok';
            $result['message'] = 'Document uploaded';
        }else{
            $result['status'] = 'no';
            $result['message'] = $uploadStatus['data'];
        }

        print json_encode($result);
    }

    public function deleteDocument($flag,$key) {
//        if (!$this->input->is_ajax_request())
//            exit('not direct script allowed');
        $image_path = dirname(APPPATH).'/uploads/doc_image/';
        $query = $this->db->where('doc_key',$key)->from('user_documents')->get();

        foreach ($query->result_array() as $record){
            $filename = $image_path . $record['doc_image'];
            if (file_exists($filename)){
                unlink($filename);
            }
        }
        switch ($flag) {
            case 'document':
                if($this->employeesModel->documentDelete($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Data deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

 ///---------------EDUCATION------------------///

  public function loadInformationEducation($key='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax_content('employee_view_details','View Employee details');
        $this->pagedata['employee']= $this->employeesModel->employee($key);
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['level']= $this->employeesModel->educationLevel();
        $this->pagedata['education']= $this->employeesModel->employee_education($key);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/employee/educationAjax');
  }

  function datasourceEducation($key=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->employeesModel->education_employee($key);
        $columns = [
            'user_edu_id' => true,
            'user_edu_key' => true,
            'user_edu_user_key' => true,
            'user_edu_level' => true,
            'user_edu_institute' => true,
            'user_edu_year'=> true,
            'user_edu_from'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }

  function newEducation(){
      $edu['user_edu_user_key'] = $this->input->get('user_edu_user_key',TRUE);
      $edu['user_edu_year'] = $this->input->get('user_edu_year',TRUE);
      $edu['user_edu_from'] = $this->input->get('user_edu_from',TRUE);
      $edu['user_edu_level'] = $this->input->get('user_edu_level',TRUE);
      $edu['user_edu_institute'] = $this->input->get('user_edu_institute',TRUE);
      $edu['user_edu_date_created'] = date('Y-m-d');
        if($this->employeesModel->updateEducation($edu)){
            $result['status'] = 'ok';
            $result['message'] = 'Education details updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

  public function deleteEducation($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'education':
                if($this->employeesModel->deleteEducation($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Data deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

 ///---------------FAMILY------------------///

    public function loadInformationFamily($key='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax_content('employee_view_details','View Employee details');
        $this->pagedata['employee']= $this->employeesModel->employee($key);
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['level']= $this->employeesModel->educationLevel();
        $this->pagedata['family']= $this->employeesModel->employee_family($key);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/employee/familyAjax');
    }

    function datasourceFamily($key=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->employeesModel->family_employee($key);
        $columns = [
            'user_fam_id' => true,
            'user_fam_key' => true,
            'user_fam_user_key' => true,
            'user_fam_fname' => true,
            'user_fam_mname' => true,
            'user_fam_lname'=> true,
            'user_fam_dob'=> true,
            'user_fam_relation'=> true,
            'user_fam_gender'=> true,
            'user_fam_email'=> true,
            'user_fam_phone'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }

    function newFamily(){
        $family['user_fam_user_key'] = $this->input->get('user_fam_user_key',TRUE);
        $family['user_fam_fname'] = $this->input->get('user_fam_fname',TRUE);
        $family['user_fam_mname'] = $this->input->get('user_fam_mname',TRUE);
        $family['user_fam_lname'] = $this->input->get('user_fam_lname',TRUE);
        $family['user_fam_dob'] = $this->input->get('user_fam_dob',TRUE);
        $family['user_fam_gender'] = $this->input->get('user_fam_gender',TRUE);
        $family['user_fam_relation'] = $this->input->get('user_fam_relation',TRUE);
        $family['user_fam_email'] = $this->input->get('user_fam_email',TRUE);
        $family['user_fam_phone'] = $this->input->get('user_fam_phone',TRUE);
        $family['user_fam_date_created'] = date('Y-m-d');
        if($this->employeesModel->updateFamily($family)){
            $result['status'] = 'ok';
            $result['message'] = 'Family details updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function detailsFamily($family=''){
        $this->load->helper('form');
        $this->pagedata['familia'] = $this->employeesModel->familyMore($family);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/employee/detailsFamily');
    }

    public function deleteFamily($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'family':
                if($this->employeesModel->deleteFamily($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Data deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

    ///---------------EXPERIENCE------------------///

    public function loadInformationExperience($key='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax_content('employee_view_details','View Employee details');
        $this->pagedata['employee']= $this->employeesModel->employee($key);
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['level']= $this->employeesModel->educationLevel();
        $this->pagedata['experience']= $this->employeesModel->employee_experience($key);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/employee/experienceAjax');
    }

    function datasourceExperience($key=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->employeesModel->experience_employee($key);
        $columns = [
            'user_exp_id' => true,
            'user_exp_key' => true,
            'user_exp_company' => true,
            'user_exp_from' => true,
            'user_exp_to' => true,
            'user_exp_title'=> true,
            'user_exp_user_key'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }

    function newExperience(){
        $exp['user_exp_user_key'] = $this->input->get('user_exp_user_key',TRUE);
        $exp['user_exp_company'] = $this->input->get('user_exp_company',TRUE);
        $exp['user_exp_from'] = $this->input->get('user_exp_from',TRUE);
        $exp['user_exp_to'] = $this->input->get('user_exp_to',TRUE);
        $exp['user_exp_title'] = $this->input->get('user_exp_title',TRUE);
        $exp['user_exp_date_created'] = date('Y-m-d');
        if($this->employeesModel->updateExperience($exp)){
            $result['status'] = 'ok';
            $result['message'] = 'Family details updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function deleteExperience($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'experience':
                if($this->employeesModel->deleteExperience($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Data deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

    //---------------ATTENDANCE------------------///
    public function loadInformationAttendance($key='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax_content('employee_view_details','View Employee details');
        $this->pagedata['employee']= $this->employeesModel->employee($key);
        $this->pagedata['attendance']= $this->employeesModel->employee_attendance($key);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/employee/attendanceAjax');
    }

    function datasourceAttendance($key=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->employeesModel->attendance_employee($key);
        $columns = [
            'att_key' => true,
            'user_id' => true,
            'firstname' => true,
            'att_duration' => true,
            'att_status' => true,
            'att_user_id' => true,
            'att_date' => true,
            'att_time_in' => true,
            'att_time_out' => true,
            'att_time_in_device' => true,
            'att_time_out_device' => true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }

    public function deleteAttendance($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'experience':
                if($this->employeesModel->deleteAttendance($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Data deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

    ///---------------TASK------------------///
    public function loadInformationTask($key='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax_content('employee_view_details','View Employee details');
        $this->pagedata['employee']= $this->employeesModel->employee($key);
        $this->pagedata['task']= $this->employeesModel->employee_task($key);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/employee/taskAjax');
    }

    function datasourceTask($key=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->employeesModel->task_employee($key);
        $columns = [
            'task_employee_task_key' => true,
            'task_key' => true,
            'task_desc' => true,
            'task_status' => true,
            'task_mode' => true,
            'task_deadline'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }

    public function deleteTask($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'experience':
                if($this->employeesModel->deleteTask($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Data deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

    ///---------------MEDICAL------------------///
    public function loadInformationMedical($key='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax_content('employee_view_details','View Employee details');
        $this->pagedata['employee']= $this->employeesModel->employee($key);
        $this->pagedata['medical']= $this->employeesModel->employee_medical($key);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/employee/medicalAjax');
    }

    function datasourceMedical($key=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->employeesModel->medical_employee($key);
        $columns = [
            'medical_user_id' => true,
            'medical_key' => true,
            'medical_doctor_name' => true,
            'medical_doctor_phone' => true,
            'medical_blood_group' => true,
            'medical_disease_name' => true,
            'medical_weight' => true,
            'medical_height' => true,
            'medical_status'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }

    function newMedical(){
        $medical['medical_user_id'] = $this->input->get('medical_user_id',TRUE);
        $medical['medical_doctor_name'] = $this->input->get('medical_doctor_name',TRUE);
        $medical['medical_doctor_phone'] = $this->input->get('medical_doctor_phone',TRUE);
        $medical['medical_disease_name'] = $this->input->get('medical_disease_name',TRUE);
        $medical['medical_weight'] = $this->input->get('medical_weight',TRUE);
        $medical['medical_height'] = $this->input->get('medical_height',TRUE);
        $medical['medical_blood_group'] = $this->input->get('medical_blood_group',TRUE);
        $medical['medical_date_created'] = date('Y-m-d');
        if($this->employeesModel->updateMedical($medical)){
            $result['status'] = 'ok';
            $result['message'] = 'Medical details updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function deleteMedical($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'medical':
                if($this->employeesModel->deleteMedical($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Medical Information deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

    //---------------CONTACTS------------------///
    public function loadinformationpayroll($key='') {
        $this->load->helper('payroll/payroll');
        $this->load->model(array(
            'payroll/InsuranceModel' => 'insuranceModel',
            'payroll/DeductionsModel' => 'deductionsModel',
            'payroll/BenefitsModel' => 'benefitsModel',
            'payroll/AllowancesModel' => 'allowancesModel'
        ));
//        if (!$this->input->is_ajax_request())
//            exit('not direct script allowed');
        has_control_ajax_content('employee_view_details','View Employee details');
        $this->pagedata['employee']= employee($key);
        $this->pagedata['workday'] = $this->workDaySchemes->allWorkDaySchemes();
        $this->pagedata['contact']= $this->employeesModel->employee_contact($key);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/employee/payroll/index');
    }


    //---------------CONTACTS------------------///
    public function loadInformationContact($key='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax_content('employee_view_details','View Employee details');
        $this->pagedata['employee']= $this->employeesModel->employee($key);
        $this->pagedata['contact']= $this->employeesModel->employee_contact($key);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/employee/contactAjax');
    }


  public function loadInformationsallaryadvances($employee='') {
    $this->load->model(array('hrm/TitlesModel'=>'titlesModel'));
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax_content('employee_view_details','View Employee details');
    $data['ad_employee'] = $employee;
    $data['ad_date'] = date('Y-m-d');
    $data['ad_amount'] = to_dollar($this->input->get('amount',TRUE));
    $data['ad_details'] = $this->input->get('details',TRUE);
    if(!empty($_GET)){
       has_control_ajax('employee_update','Update Employee details');
      if($this->employeesModel->addsallaryadvance($employee,$data)){
        $result['status'] = 'ok';
        $result['message'] = 'Sallary Advance added successfully';
        }else{
          $result['status'] = 'no';
          $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
        exit();
    }
    $this->pagedata['total_advance'] = $this->employeesModel->employeetotalsallaryadvace($employee);
    $this->pagedata['month_advance'] = $this->employeesModel->employeemonthsallaryadvance($employee);
    $this->pagedata['paid_advance'] = $this->employeesModel->employeesallaryadvancepaidtotal($employee);
    $this->pagedata['employee']= $this->employeesModel->employee($employee);
    $this->pagedata['titles'] = $this->titlesModel->categories();
    $this->load->vars($this->pagedata);
    $this->load->view('hrm/employees/employee/sallaryadvances');
  }

  function modifysallaryadvance($employee='',$dept=''){
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax_content('employee_view_details','View Employee details');
    $data['ad_amount'] = to_dollar($this->input->get('amount',TRUE));
    $data['ad_details'] = $this->input->get('details',TRUE);
    if(!empty($_GET)){
      has_control_ajax('employee_update','Update Employee details');
      if($this->employeesModel->employeesallaryadvanceupdate($employee,$dept,$data)){
        $result['status'] = 'ok';
        $result['message'] = 'Sallary Advance updated successfully';
        }else{
          $result['status'] = 'no';
          $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
        exit();
    }
    $this->pagedata['employee']= $this->employeesModel->employee($employee);
    $this->pagedata['advance'] = $this->employeesModel->employeesallaryadvancedetails($employee,$dept);
    $this->load->vars($this->pagedata);
    $this->load->view('hrm/employees/employee/sallaryadvancedetails');
  }

  public function loadInformationinternaldepts($employee='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax_content('employee_view_details','View Employee details');
    $this->load->model(array('hrm/TitlesModel'=>'titlesModel'));
    $data['id_employee'] = $employee;
    $data['id_date'] = date('Y-m-d');
    $data['id_amount'] = to_dollar($this->input->get('amount',TRUE));
    $data['id_rate'] = to_dollar($this->input->get('rate',TRUE));
    $data['id_rate_type'] = $this->input->get('rate_type',TRUE);
    $data['id_details'] = $this->input->get('details',TRUE);
    if(!empty($_GET)){
      has_control_ajax('employee_update','Update Employee details');
      if($this->employeesModel->adddept($employee,$data)){
        $result['status'] = 'ok';
        $result['message'] = 'Dept added successfully';
        }else{
          $result['status'] = 'no';
          $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
        exit();
    }
    $this->pagedata['total_dept'] = $this->employeesModel->employeetotaldept($employee);
    $this->pagedata['month_dept'] = $this->employeesModel->employeemonthdept($employee);
    $this->pagedata['paid_depts'] = $this->employeesModel->employeedeptspaidtotal($employee);
    $this->pagedata['employee']= $this->employeesModel->employee($employee);
    $this->pagedata['titles'] = $this->titlesModel->categories();
    $this->load->vars($this->pagedata);
    $this->load->view('hrm/employees/employee/internaldepts');
  }

  function modifyinternaldept($employee='',$dept=''){
  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');
   has_control_ajax_content('employee_view_details','View Employee details');
  $data['id_rate'] = to_dollar($this->input->get('rate',TRUE));
  $data['id_rate_type'] = $this->input->get('rate_type',TRUE);
  $data['id_amount'] = to_dollar($this->input->get('amount',TRUE));
  $data['id_details'] = $this->input->get('details',TRUE);
  if(!empty($_GET)){
    has_control_ajax('employee_update','Update Employee details');
    if($this->employeesModel->employeeinternaldeptupdate($employee,$dept,$data)){
      $result['status'] = 'ok';
      $result['message'] = 'Dept updated successfully';
      }else{
        $result['status'] = 'no';
        $result['message'] = checkError($this->dbexeption());
      }
      print json_encode($result);
      exit();
  }
  $this->pagedata['employee']= $this->employeesModel->employee($employee);
  $this->pagedata['dept'] = $this->employeesModel->employeedeptdetails($employee,$dept);
  $this->load->vars($this->pagedata);
  $this->load->view('hrm/employees/employee/deptdetails');
}

  public function loadInformationsecurity($key='') {
    // if (!$this->input->is_ajax_request())
    //  exit('not direct script allowed');
     has_control_ajax_content('employee_view_details','View Employee details');
    $this->load->model(array('hrm/TitlesModel'=>'titlesModel'));
    $this->pagedata['employee']= $this->employeesModel->employee($key);
    $this->pagedata['titles'] = $this->titlesModel->categories();
    $this->load->vars($this->pagedata);
    $this->load->view('hrm/employees/employee/securityAjax');
  }

  public function loadInformationroles($key='') {
//    if (!$this->input->is_ajax_request())
//     exit('not direct script allowed');
     has_control_ajax_content('employee_view_details','View Employee details');
    $this->load->model(array('hrm/RolesModel'=>'rolesModel','hrm/TitlesModel'=>'titlesModel'));
    $this->pagedata['employee']= $this->employeesModel->employee($key);
    $this->pagedata['roles'] = $this->rolesModel->roles();
    $this->load->vars($this->pagedata);
    $this->load->view('hrm/employees/employee/rolesAjax');
  }

  public function loadInformationprimary($key='') {
//    if (!$this->input->is_ajax_request())
//     exit('not direct script allowed');
     has_control_ajax_content('employee_view_details','View Employee details');
    $this->pagedata['employee']= $this->employeesModel->employee($key);
    $this->load->vars($this->pagedata);
    $this->load->view('hrm/employees/employee/detailsAjax');
  }

  public function loadInformationsallaryslips($key='') {
//    if (!$this->input->is_ajax_request())
//     exit('not direct script allowed');
     has_control_ajax_content('employee_view_details','View Employee details');
    $this->pagedata['taxes'] = $this->payrollsModel->taxes();
    $this->pagedata['paye'] = $this->payrollsModel->paye();
    $this->pagedata['variables'] = $this->variablesModel->variables();
    $this->pagedata['employee']= $this->employeesModel->employee($key);
    $this->load->vars($this->pagedata);
    $this->load->view('hrm/employees/employee/payrollAjax');
  }

  public function loadInformationRoleAction($key='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax('employee_update','Update Employee details');
     has_control_ajax('roles_control','Update Role details');
     $roles['role_register_client'] = !empty($this->input->get('role_register_client', TRUE)) ? $this->input->get('role_register_client', TRUE) : 0;
     if($this->employeesModel->employeeUpdateRoles($key,$roles)){
               $result['status'] = 'ok';
               $result['message'] = 'Role(s) information changed successfully';
             }else{
               $result['status'] = 'no';
               $result['message'] = checkError($this->dbexeption());
             }
    print json_encode($result);
  }

  public function loadInformationSecurityAction($key='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     has_control_ajax('employee_update','Update Employee details');
         $security['user_lang'] = $this->input->get('user_lang', TRUE);
         $security['auth_level'] = $this->input->get('auth_level',TRUE);
         $security['user_title'] = $this->input->get('user_title',TRUE);
         $security['email'] = $this->input->get('email',TRUE);
         $security['username'] = $this->input->get('username',TRUE);
         if(!empty($this->input->get('password',TRUE))){
           $security['passwd'] =$this->authentication->hash_passwd($this->input->get('password',TRUE));
         }
         $security['communicate_sms'] = !empty($this->input->get('communicate_sms', TRUE)) ? $this->input->get('communicate_sms', TRUE) : 0;
         $security['communicate_phone'] = !empty($this->input->get('communicate_phone', TRUE)) ? $this->input->get('communicate_phone', TRUE) : 0;
         $security['communicate_email'] = !empty($this->input->get('communicate_email', TRUE)) ? $this->input->get('communicate_email', TRUE) : 0;
         if($this->employeesModel->employeeUpdateSecurity($key,$security)){
                   $result['status'] = 'ok';
                   $result['message'] = 'Security information changed successfully';
                 }else{
                   $result['status'] = 'no';
                   $result['message'] = checkError($this->dbexeption());
                 }
        print json_encode($result);

  }



  public function loadInformationPrimaryAction($key=''){
//    if (!$this->input->is_ajax_request())
//     exit('not direct script allowed');
     has_control_ajax('employee_update','Update Employee details');
     $employee['gender'] = $this->input->get('gender', TRUE);
     $employee['country'] = $this->input->get('country', TRUE);
     $employee['state'] = $this->input->get('state', TRUE);
     $employee['city'] = $this->input->get('city', TRUE);
     $employee['residential_address'] = $this->input->get('residential_address', TRUE);
     $employee['home_address'] = $this->input->get('home_address', TRUE);
     $employee['city'] = $this->input->get('city', TRUE);
     $employee['dob'] = date('Y-m-d',strtotime($this->input->get('dob', TRUE)));
     $employee['middlename'] = $this->input->get('middlename', TRUE);
     $employee['firstname'] = $this->input->get('firstname', TRUE);
     $employee['lastname'] = $this->input->get('lastname', TRUE);
     if($this->employeesModel->employeeUpdatePrimary($key,$employee)){
               $result['status'] = 'ok';
               $result['message'] = 'Primary information changed successifully';
             }else{
               $result['status'] = 'no';
               $result['message'] = checkError($this->dbexeption());
             }
       print json_encode($result);
  }

  function collectSecurityInfo(){
    $security['auth_level'] = $this->input->get('auth_level',TRUE);
    $security['user_title'] = $this->input->get('user_title',TRUE);
    $security['email'] = $this->input->get('email',TRUE);
    $security['username'] = $this->input->get('username',TRUE);
    $security['phonenumber'] = $this->input->get('phonenumber',TRUE);
    if(!empty($this->input->get('password',TRUE))){
      $security['passwd'] =$this->authentication->hash_passwd($this->input->get('password',TRUE));
    }
    $security['communicate_sms'] = !empty($this->input->get('communicate_sms', TRUE)) ? $this->input->get('communicate_sms', TRUE) : 0;
    $security['communicate_phone'] = !empty($this->input->get('communicate_phone', TRUE)) ? $this->input->get('communicate_phone', TRUE) : 0;
    $security['communicate_email'] = !empty($this->input->get('communicate_email', TRUE)) ? $this->input->get('communicate_email', TRUE) : 0;
    $security['user_branch'] = $this->branch;
    $security['user_business'] = $this->business;
    $security['user_lang'] = profile()->user_lang;
    return $security;
  }

  function collectPrimaryInfo(){
    $primary['details_branch'] = $this->branch;
    $primary['details_business'] = $this->business;
    $primary['firstname'] = $this->input->get('firstname',TRUE);
    $primary['middlename'] = $this->input->get('middlename',TRUE);
    $primary['lastname'] = $this->input->get('lastname',TRUE);
    $primary['gender'] = $this->input->get('gender',TRUE);
    $primary['dob'] = $this->input->get('dob',TRUE);
    $primary['user_department_key'] = $this->input->get('department_key',TRUE);
    $primary['country'] = $this->input->get('country',TRUE);
    $primary['state'] = $this->input->get('state',TRUE);
    $primary['city'] = $this->input->get('city',TRUE);
    $primary['home_address'] = $this->input->get('home_address',TRUE);
    $primary['residential_address'] = $this->input->get('residential_address',TRUE);
    $primary['identity_type'] = $this->input->get('identity_type',TRUE);
    $primary['identity_value'] = $this->input->get('identity_value',TRUE);
    $primary['holiday_scheme_key'] = $this->input->get('holiday_scheme_key',TRUE);
    $primary['leave_scheme_key'] = $this->input->get('leave_scheme_key',TRUE);
    $primary['workday_scheme_key'] = $this->input->get('workday_scheme_key',TRUE);
    //$primary['department_key'] = $this->input->get('department_key',TRUE);
    $primary['office_phone'] = $this->input->get('phonenumber',TRUE);
    return $primary;
  }

  function collectHolidayLeaveWorkday(){
        $hlw['details_branch'] = $this->branch;
        $hlw['details_business'] = $this->business;
        //$hlw['user_department_key'] = $this->input->get('user_department_key',TRUE);
        $hlw['holiday_scheme_key'] = $this->input->get('holiday_scheme_key',TRUE);
        $hlw['leave_scheme_key'] = $this->input->get('leave_scheme_key',TRUE);
        $hlw['workday_scheme_key'] = $this->input->get('workday_scheme_key',TRUE);
        $hlw['office_phone'] = $this->input->get('office_phone',TRUE);
        return $hlw;
    }

  function collectTaxinfo(){
    $taxes = $this->input->get('payroll_tax',TRUE);
    if(empty($taxes))
    return false;
    $overide = to_dollar($this->input->get('payroll_tax_overide',TRUE));
    $data = array();
    foreach ($taxes as $i => $tax) {
      $data[$i]['et_tax_key'] =  $tax;
      if(!empty($overide[$i])){
        $data[$i]['et_overide_value'] = $overide[$i];
      }else{
        $data[$i]['et_overide_value'] = NULL;
      }
    }
  return $data;
  }

  function collectRolesinfo(){
    $title = $this->input->get('user_title',TRUE);
    $query = $this->db->where('category_key',$title)->get('acl_categories')->row();
    if(!empty($query)){
        $categoryId = $this->db->where('category_key',$title)->get('acl_categories')->row()->category_id;
        $this->db->select('action_id');
        $this->db->where('action_business',$this->business);
        $this->db->where('category_id',$categoryId);
        $results = $this->db->get('acl_actions');
        if($results->num_rows()>0){
            $data = array();
            foreach ($results->result_array() as $k => $result) {
                $data[$k]['action_id'] =  $result['action_id'];
            }
            return $data;
        }else{
            return false;
        }
    }else{
        return false;
    }

  }

  function collectVariableinfo(){
    $variables = $this->input->get('payroll_variable',TRUE);
    if(empty($variables))
    return false;
    $overide = to_dollar(str_ireplace(',','',$this->input->get('payroll_variable_overide',TRUE)));
    $data = array();
    foreach ($variables as $i => $variable) {
      $data[$i]['ev_variable_key'] =  $variable;
      if(!empty($overide[$i])){
        $data[$i]['ev_overide_value'] = $overide[$i];
      }else{
        $data[$i]['ev_overide_value'] = NULL;
      }
    }
  return $data;
  }

  public function delete_employee($key){
      header('Content-Type: application/json');
      header('Access-Control-Allow-Origin: ' . base_url());
      header('Access-Control-Allow-Methods: GET, POST');
      header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
      if($this->employeesModel->employee_delete($key)){
          $result['status'] = true;
          $result['message'] = 'Employee deleted';
      }else{
          $result['status'] = false;
          $result['message'] = checkError();
      }
      print json_encode($result,JSON_PRETTY_PRINT);
  }

 public function delete($key, $flag='') {
     // if (!$this->input->is_ajax_request())
     //  exit('not direct script allowed');
           switch ($flag) {
               case 'employee':
               if($key != 1010101010){
               if($this->employeesModel->employee_delete($key)){
                         $result['status'] = 'ok';
                         $result['message'] = 'Employee deleted';
                       }else{
                         $result['status'] = 'no';
                         $result['message'] = checkError();
                       }
                 print json_encode($result);
                }else{
                  $result['status'] = 'no';
                  $result['message'] = 'You can not delete System Administrator';
                   print json_encode($result);
                }
               break;
               case 'dept':
               if($this->employeesModel->deletedept($key)){
                         $result['status'] = 'ok';
                         $result['message'] = 'Dept deleted successfully';
                       }else{
                         $result['status'] = 'no';
                         $result['message'] = checkError($this->dbexeption());
                       }
                 print json_encode($result);
                break;
                case 'sallaryadvance':
                if($this->employeesModel->deletesallaryadvance($key)){
                          $result['status'] = 'ok';
                          $result['message'] = 'Sallary Advance deleted successfully';
                        }else{
                          $result['status'] = 'no';
                          $result['message'] = checkError($this->dbexeption());
                        }
                  print json_encode($result);
                 break;
               default:
                   print 'fail';
               break;
           }
 }

 function employeedeptsummary($employee=''){
   $this->data['total_dept'] = $this->employeesModel->employeetotaldept($employee);
   $this->data['month_dept'] = $this->employeesModel->employeemonthdept($employee);
   $this->data['paid_depts'] = $this->employeesModel->employeedeptspaidtotal($employee);
   $this->load->view('hrm/employees/employee/deptsummary',$this->data);
 }

 function employeesallaryadvancesummary($employee=''){
   $this->pagedata['total_advance'] = $this->employeesModel->employeetotalsallaryadvace($employee);
   $this->pagedata['month_advance'] = $this->employeesModel->employeemonthsallaryadvance($employee);
   $this->pagedata['paid_advance'] = $this->employeesModel->employeesallaryadvancepaidtotal($employee);
   $this->load->view('hrm/employees/employee/sallaryadvancesummary',$this->pagedata);
 }

function datasource1($when=''){
   $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
   $data =  $this->employeesModel->employees();
    $columns = [
        'id' => true,
        'firstname' => true,
        'user_id' => true,
        'lastname' => true,
        'department_name' => true,
        'employee' => true,
        'joined'=> true,
        'gender' => true,
        'phonenumber' => true,
        'user_status' => true,
    ];
    print $this->datasourceLibrary->server($data,$columns);
}

function datasource($when =''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->employeesModel->employees($when);
        $columns = [
            'id' => true,
            'user_key' => true,
            'firstname' => true,
            'lastname' => true,
            'department_name' => true,
            'joined'=> true,
            'gender'=> true,
            'phonenumber'=> true,
            'user_id'=> true,
            'user_status'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }

function datasourcedepartments(){
  $data =  $this->employeesModel->departments();
  $this->sourcedata($data);
}

function datasourcedepts($key=''){
  $data =  $this->employeesModel->employee_depts($key);
  $this->sourcedata($data);
}

function datasourcesallaryadvances($key=''){
  $data =  $this->employeesModel->employeesallaryadvances($key);
  $this->sourcedata($data);
}

    function setInactive($emp){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->employeesModel->updateEmployeeStatus($emp,['user_status'=>'Inactive'])){
            publishEventFlash("emp_published",['title'=>"Employee updated"]);
            $results['message'] = 'Status updated successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to change status, Try again later';
            $results['status'] = false;
        }
        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function setActive($emp){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->employeesModel->updateEmployeeStatus($emp,['user_status'=>'Active'])){
            publishEventFlash("emp_published",['title'=>"Employee updated"]);
            $results['message'] = 'Status updated successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to change status, Try again later';
            $results['status'] = false;
        }
        echo json_encode($results, JSON_PRETTY_PRINT);
    }


}