<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Roles extends MY_Controller{

    public $pagedata;
    public $store;
    public $business;

    public function __construct() {
        parent::__construct();
        ($this->require_min_level(1));
        $this->pagedata['link']= 'administration';
        $this->load->helper('hrm/hrm');
        $this->load->model(array(
            'hrm/TitlesModel' => 'titlesModel',
            'hrm/RolesModel' => 'rolesModel'
        ));
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function index() {
        has_control('titles_view_all','View all roles');
        $this->load->helper('form');
        $this->pagedata['title'] = 'Roles | '.$this->config->item('application_name');
        $this->pagedata['titles'] = $this->titlesModel->categories();
        $this->pagedata['roles'] = $this->rolesModel->roles();
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/roles/roles');
    }

    function title($title){
        has_control_ajax_content('titles_view_all','View all Titles');
        $this->load->helper('form');
        $this->pagedata['title'] = 'Roles | '.$this->config->item('application_name');
        $this->pagedata['category'] = $this->titlesModel->category($title);
        $this->pagedata['roles'] = $this->rolesModel->roles();
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/roles/category');
    }

    public function employee($user='',$title='',$action=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        has_control_ajax('roles_control','Update role details');
        $action = urldecode($action);
        $title = urldecode($title);
        $status = isMyRoleAction($user,$title,$action);
        if(!empty($status)){
            $resultx = isTitleAction($title,$action);
            $this->db->where('action_id',$resultx->action_id);
            $this->db->where('user_id',$user);
            $this->db->delete('acl');
            $result['status'] = $this->db->affected_rows()>0 ? true : false;
            $result['message'] = $this->db->affected_rows()>0 ? 'Success' : 'Failed';
        }else{
            $query = isTitleAction($title,$action);
            if($query){
                $data['action_id'] = $query->action_id;
                $data['user_id'] = $user;
                $data['branch'] = $this->branch;
                $data['business'] = $this->business;
                $this->db->insert('acl',$data);
                $result['status'] = $this->db->affected_rows()>0 ? true : false;
                $result['message'] = $this->db->affected_rows()>0 ? 'Success' : 'Failed';
            }
            else{
                $result['status'] = false;
                $result['message'] = 'Failed';
            }

        }

        print json_encode($result,JSON_PRETTY_PRINT);
    }

    public function titleAction($title='',$action=''){

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

//  if (!$this->input->is_ajax_request())
//   exit('not direct script allowed');

        has_control_ajax('roles_control','Update role details');

        $action = urldecode($action);
        $title = urldecode($title);
        $status = isTitleAction($title,$action);

        if($status){
            $this->db->where('action_code',$action);
            $this->db->where('category_id',$title);
            $this->db->where('action_business',$this->business);
            $this->db->where('action_branch',$this->branch);
            $this->db->delete('acl_actions');
            $result['status'] = $this->db->affected_rows()>0 ? true : false;
            $result['message'] = $this->db->affected_rows()>0 ? 'Success' : 'Failed';
        }else{
            $data['action_code'] = $action;
            $data['category_id'] = $title;
            $data['action_desc'] = '';
            $data['action_branch'] = $this->branch;
            $data['action_business'] = $this->business;
            $this->db->insert('acl_actions',$data);
            $result['status'] = $this->db->affected_rows()>0 ? true : false;
            $result['message'] = $this->db->affected_rows()>0 ? 'Success' : 'Failed';
        }

        print json_encode($result,JSON_PRETTY_PRINT);

    }

}