<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author noely
 */
class Index extends MY_Controller {

    public $pagedata;
    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        ($this->require_min_level(1));
        $this->pagedata['link']= 'administration';
        $this->load->model(array(
            'hrm/holidaySchemesModel'=>'holidayScheme',
            'hrm/Employees'=>'employeesModel',
        ));
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
        $this->load->helper('hrm/employees');
    }

    public function index() {
        has_control('employee_view_all','View all employees');
        $this->load->helper('hrm/employees');
        $this->pagedata['link'] = 'holiday';
        $this->pagedata['holiday_schemes_key'] = $this->holidayScheme->holidaySchemes();
        $this->pagedata['title'] = 'Holiday Schemes | HRM '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/holiday/holiday_scheme');
    }

    function datasourceHolidaySchemes(){
        $data = $this->holidayScheme->holidaySchemes();
        $columnsDefault = [
            'hrm_holiday_schemes_key' => true,
            'user_id' => true,
            'firstname' => true,
            'lastname' => true,
            'hrm_holiday_schemes_tittle' => true,
            'hrm_holiday_schemes_created_at' => true,
        ];
        $this->sourcedataserver($data,$columnsDefault);
    }

    function createHolidayScheme(){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax('holiday_register','Register Holiday');
        $data['hrm_holiday_schemes_business_key'] = $this->business;
        $data['hrm_holiday_schemes_tittle'] = $this->input->get('holiday_title',TRUE);
        $data['hrm_holiday_schemes_created_at'] = date('Y-m-d');
        $data['hrm_holiday_schemes_created_by'] = $this->auth_user_id;
        if($this->holidayScheme->create_holiday_scheme($data)){
            $result['status'] = 'ok';
            $result['message'] = 'Holiday scheme registered successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = 'hapana';
        }
        print json_encode($result);
    }

    function detailsHoliday($holiday=''){
        $this->load->helper('form');
        $this->pagedata['holiday'] = $this->holidayScheme->holidayU($holiday);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/holiday/details_scheme');
    }

    function modifyScheme($holidayKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['holiday'] = $this->holidayScheme->holidayU($holidayKey);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/holiday/schemeModify');
    }

    function updateScheme($holidayKey=''){
        $data['hrm_holiday_schemes_tittle'] = $this->input->get('hrm_holiday_schemes_tittle',TRUE);
        if($this->holidayScheme->schemeUpdate($holidayKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Holiday Scheme updated successifully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function deleteScheme($holiday){
        $this->db->where('hrm_holiday_schemes_key',$holiday);
        $this->db->delete('hrm_holiday_schemes');
        if($this->db->affected_rows()>0){
            $result['status'] = 'ok';
            $result['message'] = 'Holiday Scheme Deleted successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }


    //------------Holiday---------------------//
    public function schemedates() {
        //has_control('employee_view_all','View all employees');
        $this->load->helper('hrm/employees');
        $this->pagedata['link'] = 'schemedates';
        $this->pagedata['title'] = 'Holiday | HRM '.$this->config->item('application_name');
        $this->pagedata['holiday_schemes_key'] = $this->holidayScheme->holidaySchemes();
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/holiday/holiday_schemes_dates');
    }

    function datasourceHolidaySchemesDates(){
        $data = $this->holidayScheme->holidaySchemeDates();
        $columnsDefault = [
            'hrm_holiday_schemes_dates_key' => true,
            'user_id' => true,
            'firstname' => true,
            'lastname' => true,
            'hrm_holiday_schemes_tittle' => true,
            'hrm_holiday_schemes_dates_title' => true,
            'hrm_holiday_schemes_dates_date_end' => true,
            'hrm_holiday_schemes_dates_date_start' => true,
        ];
        $this->sourcedataserver($data,$columnsDefault);
    }

    function createHolidaySchemeDate(){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax('departments_register','Register Department');
        $data['hrm_holiday_schemes_dates_key'] = $this->holidayScheme->unused_holiday_scheme_date();
        $data['hrm_holiday_schemes_dates_business_key'] = $this->business;
        $data['hrm_holiday_schemes_dates_holiday_schemes_key'] = $this->input->get('holiday_scheme_key',TRUE);
        $data['hrm_holiday_schemes_dates_date_start'] = $this->input->get('start_date',TRUE);
        $data['hrm_holiday_schemes_dates_date_end'] = $this->input->get('end_date',TRUE);
        $data['hrm_holiday_schemes_dates_title'] = $this->input->get('holiday_name',TRUE);
        $data['hrm_holiday_schemes_dates_created_at'] = date('Y-m-d');
        $data['hrm_holiday_schemes_dates_created_by'] = $this->auth_user_id;
        if($this->holidayScheme->create_holiday_scheme_date($data)){
            $result['status'] = 'ok';
            $result['message'] = 'Holiday registered successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = 'Not registered';
        }
        print json_encode($result);
    }

    function detailsHolidayScheme($holiday=''){
        $this->load->helper('form');
        $this->pagedata['holiday'] = $this->holidayScheme->holidaySchemeU($holiday);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/holiday/details_holiday');
    }

    function modifyHoliday($holidayKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['holiday_schemes_key'] = $this->holidayScheme->holidaySchemes();
        $this->pagedata['holiday'] = $this->holidayScheme->holidaySchemeU($holidayKey);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/holiday/holidayModify');
    }

    function updateHoliday($holidayKey=''){
        $data['hrm_holiday_schemes_dates_holiday_schemes_key'] = $this->input->get('hrm_holiday_schemes_dates_holiday_schemes_key',TRUE);
        $data['hrm_holiday_schemes_dates_title'] = $this->input->get('hrm_holiday_schemes_dates_title',TRUE);
        $data['hrm_holiday_schemes_dates_date_start'] = $this->input->get('hrm_holiday_schemes_dates_date_start',TRUE);
        $data['hrm_holiday_schemes_dates_date_end'] = $this->input->get('hrm_holiday_schemes_dates_date_end',TRUE);
        $data['hrm_holiday_schemes_dates_modified_by'] = $this->auth_user_id;
        if($this->holidayScheme->holidayUpdate($holidayKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Holiday updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function deleteHolidayDates($holiday){
        $this->db->where('hrm_holiday_schemes_dates_key',$holiday);
        $this->db->delete('hrm_holiday_schemes_dates');
        if($this->db->affected_rows()>0){
            $result['status'] = 'ok';
            $result['message'] = 'Holiday Deleted successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }


}