<?php

class Index extends MY_Controller {
    public $pagedata;
    public $branch;
    public $business;
    public function __construct() {
        parent::__construct();
        ($this->require_min_level(1));
        $this->pagedata['link']= 'workday';
        $this->load->model(array(
            'hrm/workDaySchemes'=>'workdaySchemes',
            'hrm/Employees'=>'employeesModel',
        ));
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
        $this->load->helper('hrm/employees');
    }

    public function index($key='') {
        has_control('employee_view_all','View all employees');
        $this->load->helper('hrm/employees');
        $this->pagedata['workdays_scheme_key'] = $this->workdaySchemes->allWorkDaySchemes();
        $this->pagedata['schemes'] = $this->workdaySchemes->allWorkDaySchemesbox($key);
        $this->pagedata['title'] = 'WorkDay Scheme | HRM '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/workday/workday_scheme');
    }

    function datasourceWorkdaySchemes(){
        $data = $this->workdaySchemes->allWorkDaySchemes();
        $columnsDefault = [
            'hrm_workdays_scheme_key' => true,
            'user_id' => true,
            'firstname' => true,
            'lastname' => true,
            'hrm_workdays_scheme_title' => true,
            'hrm_workdays_scheme_created_by' => true,
            'hrm_workdays_scheme_created_at' => true,
        ];
        $this->sourcedataserver($data,$columnsDefault);
    }

    function createWorkday(){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax('holiday_register','Register Workday');
        $data['hrm_workdays_scheme_title'] = $this->input->get('hrm_workdays_scheme_title',TRUE);
        $data['hrm_workdays_scheme_created_at'] = date('Y-m-d');
        $data['hrm_workdays_scheme_created_by'] = $this->auth_user_id;
        if($this->workdaySchemes->create_workday_scheme($data)){
            $result['status'] = 'ok';
            $result['message'] = 'Workday registered successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function detailsWorkday($workday=''){
        $this->load->helper('form');
        $this->pagedata['workday'] = $this->workdaySchemes->workdayU($workday);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/workday/details_workday');
    }

    function detailsWorkdayAdd($workday=''){
        $this->load->helper('form');
        $this->pagedata['workday'] = $this->workdaySchemes->workdayU($workday);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/workday/details_workday_add');
    }

    public function modifyWorkday($workdayKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['workday'] = $this->workdaySchemes->workdayU($workdayKey);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/workday/detailsModify');
    }

    function updateWorkday($workdayKey=''){
        $data['hrm_workdays_scheme_title'] = $this->input->get('hrm_workdays_scheme_title',TRUE);
        $data['hrm_workdays_scheme_modified_by'] = $this->auth_user_id;
        if($this->workdaySchemes->workdayUpdate($workdayKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Workday updated successifully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function delete($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'workday':
                if($this->workdaySchemes->deleteWorkday($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Workday deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

       //------------W2orkday scheme day--------//
    public function workdayschemeday() {
        has_control('employee_view_all','View all employees');
        $this->load->helper('hrm/employees');
        $this->pagedata['link'] = 'workdayday';
        $this->pagedata['title'] = 'Workday | HRM '.$this->config->item('application_name');
        $this->pagedata['workdays_scheme_key'] = $this->workdaySchemes->allWorkDaySchemes();
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/workday/workday_schemes_day');
    }

    function datasourceWorkdaySchemesDay(){
        $data = $this->workdaySchemes->workdaySchemeDay();
        $columnsDefault = [
            'hrm_workdays_schemes_days_key' => true,
            'hrm_workdays_scheme_days_workdays_schemes_key' => true,
            'hrm_workdays_scheme_title' => true,
            'user_id' => true,
            'firstname' => true,
            'lastname' => true,
            'hrm_workdays_schemes_days_day' => true,
            'hrm_workdays_schemes_days_start' => true,
            'hrm_workdays_schemes_days_end' => true,
            'hrm_workdays_schemes_days_hours' => true,
            'hrm_workdays_schemes_days_created_by' => true,
            'hrm_workdays_schemes_days_created_at' => true,
            'hrm_workdays_schemes_days_status' => true,
        ];
        $this->sourcedataserver($data,$columnsDefault);
    }

    function createWorkdaySchemeDay(){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax('holiday_register','Register Workday Day');
        $data['hrm_workdays_schemes_days_business_key'] = $this->business;
        $data['hrm_workdays_scheme_days_workdays_schemes_key'] = $this->input->get('hrm_workdays_scheme_days_workdays_schemes_key',TRUE);
        $data['hrm_workdays_schemes_days_day'] = $this->input->get('hrm_workdays_schemes_days_day',TRUE);
        $data['hrm_workdays_schemes_days_start'] = $this->input->get('hrm_workdays_schemes_days_start',TRUE);
        $data['hrm_workdays_schemes_days_end'] = $this->input->get('hrm_workdays_schemes_days_end',TRUE);
        $data['hrm_workdays_schemes_days_hours'] =  (strtotime($this->input->get('hrm_workdays_schemes_days_end',TRUE)) - strtotime($this->input->get('hrm_workdays_schemes_days_start',TRUE)))/3600;
        $data['hrm_workdays_schemes_days_status'] = $this->input->get('hrm_workdays_schemes_days_status',TRUE);
        $data['hrm_workdays_schemes_days_created_at'] = date('Y-m-d');
        $data['hrm_workdays_schemes_days_created_by'] = $this->auth_user_id;
        if($this->workdaySchemes->create_workday_scheme_day($data)){
            $result['status'] = 'ok';
            $result['message'] = 'Workday scheme day registered successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function detailsWorkdayScheme($workday=''){
        $this->load->helper('form');
        $this->pagedata['workday'] = $this->workdaySchemes->workdaySchemeU($workday);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/workday/details_scheme');
    }

    public function modifyWorkdayScheme($workdayKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['workdays_scheme_key'] = $this->workdaySchemes->allWorkDaySchemes();
        $this->pagedata['workday'] = $this->workdaySchemes->workdaySchemeU($workdayKey);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/workday/detailsScheme');
    }

    function updateWorkdayScheme($workdayKey=''){
        $data['hrm_workdays_scheme_days_workdays_schemes_key'] = $this->input->get('hrm_workdays_scheme_days_workdays_schemes_key',TRUE);
        $data['hrm_workdays_schemes_days_day'] = $this->input->get('hrm_workdays_schemes_days_day',TRUE);
        $data['hrm_workdays_schemes_days_start'] = $this->input->get('hrm_workdays_schemes_days_start',TRUE);
        $data['hrm_workdays_schemes_days_end'] = $this->input->get('hrm_workdays_schemes_days_end',TRUE);
        $data['hrm_workdays_schemes_days_hours'] =  (strtotime($this->input->get('hrm_workdays_schemes_days_end',TRUE)) - strtotime($this->input->get('hrm_workdays_schemes_days_start',TRUE)))/3600;
        $data['hrm_workdays_schemes_days_status'] = $this->input->get('hrm_workdays_schemes_days_status',TRUE);
        $data['hrm_workdays_schemes_days_modified_by'] = $this->auth_user_id;
        if($this->workdaySchemes->workdaySchemeUpdate($workdayKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Workday Scheme updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function deleteScheme($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'workday':
                if($this->workdaySchemes->deleteWorkdaySchemeDay($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Scheme deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

}