<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Attendance
 *
 * @author noely
 */
class Index extends MY_Controller {

    public $pagedata;
    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        ($this->require_min_level(1));
        $this->pagedata['link']= 'administration';
        $this->load->model(array(
            'hrm/AttendanceModel'=>'attendanceModel',
            'hrm/DeviceModel'=>'deviceModel',
            'hrm/Employees'=>'employeesModel',
        ));
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
        $this->load->helper('hrm/employees');
    }

    public function index() {
        has_control('employee_view_all','View all employees');
        $this->pagedata['link'] = 'attendance';
        $this->load->helper('form');
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['attendance'] = $this->attendanceModel->attendance();
        $this->pagedata['device'] = $this->deviceModel->devices();
        $data['show_table'] = $this->view_table();
        $this->pagedata['title'] = 'Hrm Attendance  | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/attendance/attendances',$data);
    }

    function datasourceAttendances(){
        $data = $this->attendanceModel->attendance();
        $columnsDefault = [
            'att_key' => true,
            'user_id' => true,
            'firstname' => true,
            'lastname' => true,
            'att_user_id' => true,
            'att_date' => true,
            'att_time_in' => true,
            'att_time_out' => true,
            'att_time_in_device' => true,
            'att_time_out_device' => true,
        ];
        $this->sourcedataserver($data,$columnsDefault);
    }

    public function view_table(){
        $result = $this->attendanceModel->show_all_data();
        if ($result != false) {
            return $result;
        } else {
            return 'Database is empty !';
        }
    }

    public function select_by_id() {
        $this->load->helper('form');
        $this->pagedata['link'] = 'attendance';
        $this->pagedata['attendance'] = $this->attendanceModel->attendance();
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $id = $this->input->post('id');
        if ($id != "") {
            $result = $this->attendanceModel->show_data_by_id($id);
            if ($result != false) {
                $data['result_display'] = $result;
            } else {
                $data['result_display'] = "No record found !";
            }
        } else {
            $data = array(
                'id_error_message' => "Id field is required"
            );
        }
        $data['show_table'] = $this->view_table();
        $this->pagedata['title'] = 'Hrm Attendance  | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/attendance/attendances',$data);
    }

    public function select_by_date() {
        $this->load->helper('form');
        $this->pagedata['link'] = 'attendance';
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['attendance'] = $this->attendanceModel->attendance();
        $date = $this->input->post('date');
        if ($date != "") {
            $result = $this->attendanceModel->show_data_by_date($date);

            if ($result != false) {
                $data['result_display'] = $result;
            } else {
                $data['result_display'] = "No record found !";
            }
        } else {
            $data['date_error_message'] = "Date field is required";
        }
        $data['show_table'] = $this->view_table();
        $this->pagedata['title'] = 'Hrm Attendance  | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/attendance/attendances',$data);
    }

    public function select_by_date_range() {
        $this->load->helper('form');
        $this->pagedata['link'] = 'attendance';
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['attendance'] = $this->attendanceModel->attendance();
        $date1 = $this->input->post('date_from');
        $date2 = $this->input->post('date_to');
        $data = array(
            'date1' => $date1,
            'date2' => $date2
        );
        if ($date1 == "" || $date2 == "") {
            $data['date_range_error_message'] = "Both date fields are required";
        } else {
            $result = $this->attendanceModel->show_data_by_date_range($data);
            if ($result != false) {
                $data['result_display'] = $result;
            } else {
                $data['result_display'] = "No record found !";
            }
        }
        $data['show_table'] = $this->view_table();
        $this->pagedata['title'] = 'Hrm Attendance  | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/attendance/attendances',$data);
    }

    function newAttendance(){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax('attendance_register','Attendance Recorded');
        $data['att_user_id'] = $this->input->get('att_user_id',TRUE);
        $data['att_date'] = date('Y-m-d');
        $data['att_time_in'] = $this->input->get('att_time_in',TRUE);
        $data['att_time_in_device'] = $this->input->get('att_time_in_device',TRUE);
        //$data['att_time_out'] = time();
        $data['att_status'] = 'Present';
        $data['att_created_by'] = $this->auth_user_id;
        if (!empty($this->input->get('uploadedfiles'))) {
            $raw = explode('LM-55', $_GET['uploadedfiles']);
            foreach ($raw as $key => $file) {
                $file = unserialize($file);
                if (is_array($file)) {
                    foreach ($file as $dt) {
                        if (!empty($dt)) {
                            $data['att_template'] = $dt['att_template'];
                        }
                    }
                }
            }
        }
        if($this->attendanceModel->createAttendance($data)){
            $result['status'] = 'ok';
            $result['message'] = 'Attendance recorded successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = 'hapana';
        }
        print json_encode($result);
    }

    function uploadtemplate(){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $uploadPath = uploadPath('att_template/');
        $config['upload_path'] = $uploadPath;
        $config['file_ext_tolower']     = TRUE;
        $config['encrypt_name']         = TRUE;
        $config['allowed_types'] = 'jpg|jpeg|png|docx|doc|pdf|xls|xlsx';

        // Load and initialize upload library
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $i  = 0;
        if($this->upload->do_upload('file')){
            // Uploaded file data
            $fileData = $this->upload->data();
            $uploadData[$i]['att_template'] = $fileData['file_name'];
        }

        if(!empty($uploadData)){
            $files = array();
            $result['status'] = true;
            foreach ($uploadData as $key => $file){
                $files[$key]['att_template'] = $file['att_template'];
            }
            $result['files'] = serialize($files);
        }else{
            $result['status'] = false;
            $result['files'] = '';
        }

        echo json_encode($result, JSON_PRETTY_PRINT);
    }

    public function clockOut($attKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['attendance'] = $this->attendanceModel->select_one_attendance($attKey);
        $this->pagedata['device'] = $this->deviceModel->devices();
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/attendance/attendanceModify');
    }

    function updateAttendance($attKey='') {
        $data['att_user_id'] = $this->input->get('att_user_id',TRUE);
        $data['att_time_in_device'] = $this->input->get('att_time_in_device',TRUE);
        $data['att_time_in'] = $this->input->get('att_time_in',TRUE);
        $data['att_time_out'] = $this->input->get('att_time_out',TRUE);
        $data['att_time_out_device'] = $this->input->get('att_time_out_device',TRUE);
        $data['att_clock'] = 'Clock out';
        if($this->attendanceModel->attendanceUpdate($attKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Clocked Out successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function clockIn($attKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['attendance'] = $this->attendanceModel->select_one_attendance($attKey);
        $this->pagedata['device'] = $this->deviceModel->devices();
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/attendance/attendanceClockin');
    }

    function inAttendance(){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax('attendance_register','Attendance Recorded');
        $data['att_user_id'] = $this->input->get('att_user_id',TRUE);
        $data['att_date'] = date('Y-m-d');
        $data['att_time_in'] = $this->input->get('att_time_in',TRUE);
        $data['att_time_in_device'] = $this->input->get('att_time_in_device',TRUE);
        $data['att_status'] = 'Present';
        $data['att_created_by'] = $this->auth_user_id;
        if (!empty($this->input->get('uploadedfiles'))) {
            $raw = explode('LM-55', $_GET['uploadedfiles']);
            foreach ($raw as $key => $file) {
                $file = unserialize($file);
                if (is_array($file)) {
                    foreach ($file as $dt) {
                        if (!empty($dt)) {
                            $data['att_template'] = $dt['att_template'];
                        }
                    }
                }
            }
        }
        if($this->attendanceModel->createAttendance($data)){
            $result['status'] = 'ok';
            $result['message'] = 'Attendance recorded successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = 'hapana mmh';
        }
        print json_encode($result);
    }


    //----------------DEVICE-----------------//

    public function device() {
        has_control('employee_view_all','View all employees');
        $this->pagedata['link'] = 'device';
        $this->load->helper('form');
        $this->pagedata['title'] = 'Hrm Device  | '.$this->config->item('application_name');
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['device'] = $this->deviceModel->devices();
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/attendance/device');
    }

    function newDevice(){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax('device_register','Register Device');
        $data['device_name'] = $this->input->get('device_name',TRUE);
        $data['device_number'] = $this->input->get('device_number',TRUE);
        $data['device_desc'] = $this->input->get('device_desc',TRUE);
        $data['device_price'] = $this->input->get('device_price',TRUE);
        $data['device_created_at'] = date('Y-m-d');
        $data['device_created_by'] = $this->auth_user_id;
        if (!empty($this->input->get('uploadedfiles'))) {
            $raw = explode('LM-55', $_GET['uploadedfiles']);
            foreach ($raw as $key => $file) {
                $file = unserialize($file);
                if (is_array($file)) {
                    foreach ($file as $dt) {
                        if (!empty($dt)) {
                            $data['device_image'] = $dt['device_image'];
                        }
                    }
                }
            }
        }

        if($this->deviceModel->createDevice($data)){
            $result['status'] = 'ok';
            $result['message'] = 'Device registered successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = 'hapana';
        }
        print json_encode($result);
    }

    function uploadexpensedocsd(){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $uploadPath = uploadPath('device_image/');
        $config['upload_path'] = $uploadPath;
        $config['file_ext_tolower']     = TRUE;
        $config['encrypt_name']         = TRUE;
        $config['allowed_types'] = 'jpg|jpeg|png|docx|doc|pdf|xls|xlsx';

        // Load and initialize upload library
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $i  = 0;
        if($this->upload->do_upload('file')){
            // Uploaded file data
            $fileData = $this->upload->data();
            $uploadData[$i]['device_image'] = $fileData['file_name'];
        }

        if(!empty($uploadData)){
            $files = array();
            $result['status'] = true;
            foreach ($uploadData as $key => $file){
                $files[$key]['device_image'] = $file['device_image'];
            }
            $result['files'] = serialize($files);
        }else{
            $result['status'] = false;
            $result['files'] = '';
        }

        echo json_encode($result, JSON_PRETTY_PRINT);
    }

    public function modifyDevice($deviceKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['device'] = $this->deviceModel->select_one_device($deviceKey);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/attendance/deviceModify');
    }

    function updateDevice($deviceKey='') {
        $data['device_name'] = $this->input->get('device_name',TRUE);
        $data['device_number'] = $this->input->get('device_number',TRUE);
        $data['device_status'] = $this->input->get('device_status',TRUE);
        $data['device_mode'] = $this->input->get('device_mode',TRUE);
        $data['device_desc'] = $this->input->get('device_desc',TRUE);
        if($this->deviceModel->deviceUpdate($deviceKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Device updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function activateDevice($device){
        if($this->deviceModel->activateDevice($device,['device_mode'=>'Active'])){
            $result['status'] = 'ok';
            $result['message'] = 'Device activated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function deactivateDevice($device){
        if($this->deviceModel->deactivateDevice($device,['device_mode'=>'Inactive'])){
            $result['status'] = 'ok';
            $result['message'] = 'Device deactivated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function onlineDevice($device){
        if($this->deviceModel->putonlineDevice($device,['device_status'=>'Online'])){
            $result['status'] = 'ok';
            $result['message'] = 'Device is now Online';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function offlineDevice($device){
        if($this->deviceModel->putofflineDevice($device,['device_status'=>'Offline'])){
            $result['status'] = 'ok';
            $result['message'] = 'Device switched off successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }








    function detailsHoliday($holiday=''){
        $this->load->helper('form');
        $this->pagedata['holiday'] = $this->holidayScheme->holidayU($holiday);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/holiday/details_scheme');
    }

    function modifyScheme($holidayKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['holiday'] = $this->holidayScheme->holidayU($holidayKey);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/holiday/schemeModify');
    }

    function updateScheme($holidayKey=''){
        $data['hrm_holiday_schemes_tittle'] = $this->input->get('hrm_holiday_schemes_tittle',TRUE);
        if($this->holidayScheme->schemeUpdate($holidayKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Holiday Scheme updated successifully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }


    //----------DELETE------------//

    function deleteAttend($attend){
        $this->db->where('att_key',$attend);
        $this->db->delete('attendance');
        if($this->db->affected_rows()>0){
            $result['status'] = 'ok';
            $result['message'] = 'Attendance Deleted successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function deleteDevice($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'device':
                if($this->deviceModel->deleteDevice($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Device deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

}