<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Dashboard
 *
 * @author test
 */

require_once APPPATH.'libraries/mails/vendor/autoload.php';

use PhpImap\Mailbox;

class Index extends MY_Controller{

    public  $appdata;

    public $bmsMailer;

    public $imapPath;

    public $per_page;

    public $defaultFolder = "INBOX";

    function __construct() {
        parent::__construct();

        $this->require_min_level(1);
        $this->imapPath = '{mail.lockminds.com:993/imap/ssl}INBOX';
        $this->defaultFolder = "INBOX";
        $this->initMails();
        $this->appdata['title']= 'Mailing';
        $this->load->model(array(
            'invoices/InvoicesModel'=>'invoicesModel',
        ));
        $this->load->library('pagination');
        $this->load->helper('mailing/helper');
        $this->load->helper('text');
        $this->appdata['link']= 'mailing';
        $this->appdata['boxes'] = $this->bmsMailer->getMailboxes();
    }

    function index() {
        $this->bmsMailer->switchMailbox($this->bmsMailer->getImapPath().'.'.$this->defaultFolder);
        $mailsIds = $this->bmsMailer->searchMailbox();
        $num_ids = count($mailsIds);
        rsort($mailsIds);

        if(!empty($index = $this->input->get("per_page"))){
            $page = ($index - 1) * $this->per_page;
            $mailsIds = array_slice($mailsIds, $page,$this->per_page);
        }else{
            $mailsIds = array_slice($mailsIds, 0,$this->per_page);
        }

        $this->initPagination($num_ids,base_url('mailing'));
        $this->appdata['link']= 'mailing';
        $this->appdata['mailsIds'] = $mailsIds;
        $this->load->vars($this->appdata);
        $this->load->view('mailing/mailing');
    }

    function mailbox($box='') {
        $this->bmsMailer->switchMailbox($this->bmsMailer->getImapPath().'.'.$box);
        $mailsIds = $this->bmsMailer->searchMailbox();
        $num_ids = count($mailsIds);
        rsort($mailsIds);

        if(!empty($index = $this->input->get("per_page"))){
            $page = ($index - 1) * $this->per_page;
            $mailsIds = array_slice($mailsIds, $page,$this->per_page);
        }else{
            $mailsIds = array_slice($mailsIds, 0,$this->per_page);
        }

        $this->initPagination($num_ids,base_url('mailing/mailbox/'.$box));
        $this->appdata['link']= 'mailing';
        $this->appdata['mailsIds'] = $mailsIds;
        $this->load->vars($this->appdata);
        $this->load->view('mailing/mailing');
    }

    function read($box,$num) {
        try {
            $this->bmsMailer->switchMailbox($this->bmsMailer->getImapPath().'.'.$box);
            $this->appdata['head']=  $this->bmsMailer->getMailHeader($num);
            $this->appdata['mail'] = $this->bmsMailer->getMail($num,true);
            $this->load->vars($this->appdata);
            $this->load->view('mailing/read');
        } catch ( \Exception $e ) {
           print 'not found';
        }

    }

    function initMails(){
        $this->per_page = 50;
        // Create PhpImap\Mailbox instance for all further actions
        $this->bmsMailer = new Mailbox(
            $this->imapPath, // IMAP server and mailbox folder
            'kelvin@lockminds.com', // Username for the before configured mailbox
            'email.com', // Password for the before configured username
            dirname(APPPATH).'/resources/mail_attachments/', // Directory, where attachments will be saved (optional)
            'UTF-8' // Server encoding (optional)
        );
    }


    function initPagination($rows,$url){
        $config['next_link'] = '<i class="flaticon2-right-arrow"></i>';
        $config['prev_link'] = '<i class="flaticon2-left-arrow"></i>';
        $config['last_link'] = '<i class="flaticon2-fast-next kt-font-brand"></i>';
        $config['first_link'] = '<i class="flaticon2-fast-back kt-font-brand"></i>';

        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';

        $config['cur_tag_open'] = '<li class="kt-pagination__link--active kt-padding-5 kt-font-light">';
        $config['cur_tag_close'] = '</li>';

        $config['uri_segment'] = 3;
        $config['per_page'] = $this->per_page;
        $config['num_links'] = 1;
        $config['use_page_numbers'] = TRUE;
        $config['page_query_string'] = TRUE;
        $config['reuse_query_string'] = FALSE;
        $config['full_tag_open'] = '<ul class="kt-pagination__links">';
        $config['full_tag_close'] = '</ul>';
        $config['base_url'] = $url;
        $config['total_rows'] = $rows;

        $this->pagination->initialize($config);
    }

}
