<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Dashboard
 *
 * @author test
 */

require_once APPPATH.'libraries/mails/vendor/autoload.php';

use PhpImap\Mailbox;

class Mailfilter extends MY_Controller{

    public  $appdata;

    public $bmsMailer;

    public $imapPath;

    public $defaultFolder = "INBOX";

    function __construct() {
        parent::__construct();

        $this->require_min_level(1);
        $this->imapPath = '{mail.lockminds.com:993/imap/ssl}INBOX';
        $this->defaultFolder = "INBOX";
        $this->initMails();
        $this->appdata['title']= 'Mailing';
        $this->load->model(array(
            'invoices/InvoicesModel'=>'invoicesModel',
        ));
        $this->load->library('pagination');
        $this->load->helper('mailing/helper');
        $this->appdata['link']= 'mailing';
        $this->appdata['boxes'] = $this->bmsMailer->getMailboxes();
    }

    function index($box='') {
        $this->bmsMailer->switchMailbox($this->bmsMailer->getImapPath().'.'.$box);
        $mailsIds = $this->bmsMailer->searchMailbox();
        $numAll = count($mailsIds);
        rsort($mailsIds);
        if(!empty($_GET['limit'])){
            array_splice($mailsIds, (int)trim($_GET['limit']));
        }else{
            array_splice($mailsIds, config_item('email_limit'));
        }
        $this->load->helper('form');
        $this->appdata['link']= 'mailing';
        $this->appdata['numAll'] = $numAll;
        $this->appdata['mailsIds'] = $mailsIds;
        $this->load->vars($this->appdata);
        $this->load->view('mailing/mailing');
    }

    function initMails(){
        // Create PhpImap\Mailbox instance for all further actions
        $this->bmsMailer = new Mailbox(
            $this->imapPath, // IMAP server and mailbox folder
            'kelvin@lockminds.com', // Username for the before configured mailbox
            'Nyamburawangu!1', // Password for the before configured username
            dirname(APPPATH).'/resources/mail_attachments/', // Directory, where attachments will be saved (optional)
            'UTF-8' // Server encoding (optional)
        );
    }

}
