<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Allowances extends MY_Controller{

    public $pagedata;

    public function __construct() {
        parent::__construct();
        ($this->require_min_level(1));
        $this->pagedata['link']= 'payrolls';
        $this->load->helper('payroll/payroll');
        $this->load->model(array(
            'payroll/AllowancesModel' => 'allowancesModel',
        ));
    }

    public function index() {
        has_control('payroll_view_all', 'View Allowances');
        $this->load->helper('form');
        $this->pagedata['title'] = 'Allowances | '.$this->config->item('application_name');
        $this->pagedata['allowances'] = $this->allowancesModel->allowances();
        $this->load->vars($this->pagedata);
        $this->load->view('payrolls/allowances/index');
    }

    public function allowanceDetails($allowanceKey='') {
        $this->pagedata['allowance'] = $this->allowancesModel->allowanceDetails($allowanceKey);
        $this->load->vars($this->pagedata);
        $this->load->view('payrolls/allowances/allowancedetails');
    }

    public function allowancemodify($allowanceKey='') {
        $this->pagedata['allowance'] = $this->allowancesModel->allowanceDetails($allowanceKey);
        $this->load->vars($this->pagedata);
        $this->load->view('payrolls/allowances/allowancemodify');
    }

    function newAllowance(){
        if (!$this->input->is_ajax_request())
            exit('No direct script is allowed');

        $allowance['pr_allowance_details'] = $this->input->post('allowance_details',TRUE);
        $allowance['pr_allowance_name'] = $this->input->post('allowance_name',TRUE);
        $allowance['pr_allowance_type'] = $this->input->post('allowance_type',TRUE);
        $allowance['pr_allowance_debit_account'] = $this->input->post('allowance_debit_account',TRUE);
        $allowance['pr_allowance_credit_account'] = $this->input->post('allowance_credit_account',TRUE);
        if($allowance['pr_allowance_type'] == 'fixed'){
            $allowance['pr_allowance_value'] = to_dollar(str_ireplace(',','',$this->input->post('allowance_value',TRUE)));
        }else{
            $allowance['pr_allowance_value'] = $this->input->post('allowance_value',TRUE);
        }

        if($this->allowancesModel->newAllowance($allowance)){
            $result['status'] = true;
            $result['message'] = 'Allowance registered successfully';
        }else{
            $result['status'] = false;
            $result['message'] = checkError();
        }

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        print json_encode($result);

    }

    function updateallowance($allowancekey=''){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');

        $allowance['pr_allowance_details'] = $this->input->post('allowance_details',TRUE);
        $allowance['pr_allowance_name'] = $this->input->post('allowance_name',TRUE);
        $allowance['pr_allowance_type'] = $this->input->post('allowance_type',TRUE);
        $allowance['pr_allowance_debit_account'] = $this->input->post('allowance_debit_account',TRUE);
        $allowance['pr_allowance_credit_account'] = $this->input->post('allowance_credit_account',TRUE);
        if($allowance['pr_allowance_type'] == 'fixed'){
            $allowance['pr_allowance_value'] = to_dollar(str_ireplace(',','',$this->input->post('allowance_value',TRUE)));
        }else{
            $allowance['pr_allowance_value'] = $this->input->post('allowance_value',TRUE);
        }

        if($this->allowancesModel->updateAllowance($allowancekey,$allowance)){
            $result['status'] = true;
            $result['message'] = 'Allowance updated successfully';
        }else{
            $result['status'] = false;
            $result['message'] = 'Failed to update';
        }

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        print json_encode($result);
    }

    public function delete($flag,$key) {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'allowance':
                if($this->allowancesModel->deleteAllowance($key)){
                    $result['status'] = true;
                    $result['message'] = 'Allowance updated successfully';
                }else{
                    $result['status'] = false;
                    $result['message'] = 'Failed to delete';
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = false;
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

    function removesessiondata($key){
        $data = !empty($_SESSION['allowances']) ? $_SESSION['allowances']: false;
        if($data){
            unset($_SESSION['allowances'][$key]);
        }
    }

    function removesessiondataall(){
        $data = !empty($_SESSION['allowances']) ? $_SESSION['allowances']: false;
        if($data){
            unset($_SESSION['allowances']);
        }
    }

    function getsessiondata(){

        $data = !empty($_SESSION['allowances']) ? $_SESSION['allowances']: false;
        if(!empty($data)){?>
            <table class="table table-sm table-info table-bordered">
                <tr>
                    <th colspan="4">Allowance Data</th>
                </tr>
                <tr>
                    <th>Allowance</th>
                    <th>Type</th>
                    <th>Value</th>
                    <th>Action</th>
                </tr>
                <tbody>
                <?php foreach ($data as $key => $datum){?>
                    <tr>
                        <td><?= $this->allowancesModel->allowanceDetails($datum['allowance_key'])->pr_allowance_name?></td>
                        <td><?= $datum['allowance_type'];?></td>
                        <?php if($datum['allowance_type'] == 'percent'){?>
                            <td><?= $datum['allowance_value'];?></td>
                        <?php  }else{ ?>
                            <td><?= number_format(to_money($datum['allowance_value']));?></td>
                        <?php } ?>

                        <td style="text-align: center;"><a href="javascript:removeSessionAllowance(<?= $key ?>);"><i class="fa fa-trash-alt kt-font-danger"></i></a></td>
                    </tr>
                <?php } ?>
                <tr>
                    <td colspan="3"></td>
                    <td style="text-align: center;"><a href="javascript:removeSessionAllowanceAll();"><i class="fa fa-trash-alt kt-font-danger"></i></a></td>
                </tr>
                </tbody>
            </table>
        <?php }
    }

    function addsessiondata(){

        $data['allowances'] = array();

        $allowance_key = $this->input->post('allowance_key');

        if(!empty($allowance_key)){

            $key = 0;

            $sessions = !empty($_SESSION['allowances']) ? $_SESSION['allowances']: false;
            if(!empty($sessions)){
                foreach ($sessions as $key => $session){
                    if($session['allowance_key'] != $allowance_key){
                        $data['allowances'][$key]['allowance_key'] = $session['allowance_key'];
                        $data['allowances'][$key]['allowance_name'] = $session['allowance_name'];
                        $data['allowances'][$key]['allowance_type'] = $session['allowance_type'];
                        $data['allowances'][$key]['allowance_value'] = $session['allowance_value'];
                    }
                }
            }

            $index = $key + 1;
            $data['allowances'][$index]['allowance_key'] = $this->input->post('allowance_key');
            $data['allowances'][$index]['allowance_name'] = $this->input->post('allowance_name');
            $data['allowances'][$index]['allowance_type'] = $this->input->post('allowance_type');
            $data['allowances'][$index]['allowance_value'] = to_dollar(toNumber($this->input->post('allowance_value')));
            $this->session->set_userdata($data);
        }

    }

    function jsondata($key){
        $data = $this->allowancesModel->allowanceDetails($key);

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if(!empty($data)){
            $result['status'] = true;
            $result['allowance_key'] = $data->pr_allowance_key;
            $result['allowance_name'] = $data->pr_allowance_name;
            if($data->pr_allowance_type == 'percent'){
                $result['allowance_value'] = $data->pr_allowance_value;
            }else{
                $result['allowance_value'] = number_format(to_money($data->pr_allowance_value));
            }
            $result['allowance_type'] = $data->pr_allowance_type;
        }else{
            $result['status'] = false;
            $result['message'] = 'We could not obtain allowance data for key '.$key;
        }

        print json_encode($result,JSON_PRETTY_PRINT);

    }

}
