<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Deductions extends MY_Controller{

    public $pagedata;

    public function __construct() {
        parent::__construct();
        ($this->require_min_level(1));
        $this->pagedata['link']= 'payrolls';
        $this->load->helper('payroll/payroll');
        $this->load->model(array(
            'payroll/DeductionsModel' => 'deductionsModel',
        ));
    }

    public function index() {
        has_control('payroll_view_all', 'View Deductions');
        $this->load->helper('form');
        $this->pagedata['title'] = 'Deductions | '.$this->config->item('application_name');
        $this->pagedata['deductions'] = $this->deductionsModel->deductions();
        $this->load->vars($this->pagedata);
        $this->load->view('payrolls/deductions/index');
    }

    public function deductionDetails($deductionKey='') {
        $this->pagedata['deduction'] = $this->deductionsModel->deductionDetails($deductionKey);
        $this->load->vars($this->pagedata);
        $this->load->view('payrolls/deductions/deductiondetails');
    }

    public function deductionmodify($deductionKey='') {
        $this->pagedata['deduction'] = $this->deductionsModel->deductionDetails($deductionKey);
        $this->load->vars($this->pagedata);
        $this->load->view('payrolls/deductions/deductionmodify');
    }

    function newDeduction(){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');

        $deduction['deduction_details'] = $this->input->post('deduction_details',TRUE);
        $deduction['deduction_name'] = $this->input->post('deduction_name',TRUE);
        $deduction['deduction_type'] = $this->input->post('deduction_type',TRUE);
        $deduction['deduction_debit_account'] = $this->input->post('deduction_debit_account',TRUE);
        $deduction['deduction_credit_account'] = $this->input->post('deduction_credit_account',TRUE);
        if($deduction['deduction_type'] == 'fixed'){
            $deduction['deduction_value'] = to_dollar(str_ireplace(',','',$this->input->post('deduction_value',TRUE)));
        }else{
            $deduction['deduction_value'] = $this->input->post('deduction_value',TRUE);
        }

        if($this->deductionsModel->newDeduction($deduction)){
            $result['status'] = true;
            $result['message'] = 'Deduction registered successfully';
        }else{
            $result['status'] = false;
            $result['message'] = checkError();
        }

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        print json_encode($result);

    }

    function updatededuction($deductionkey=''){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');

        $deduction['deduction_details'] = $this->input->post('deduction_details',TRUE);
        $deduction['deduction_name'] = $this->input->post('deduction_name',TRUE);
        $deduction['deduction_type'] = $this->input->post('deduction_type',TRUE);
        $deduction['deduction_debit_account'] = $this->input->post('deduction_debit_account',TRUE);
        $deduction['deduction_credit_account'] = $this->input->post('deduction_credit_account',TRUE);
        if($deduction['deduction_type'] == 'fixed'){
            $deduction['deduction_value'] = to_dollar(str_ireplace(',','',$this->input->post('deduction_value',TRUE)));
        }else{
            $deduction['deduction_value'] = $this->input->post('deduction_value',TRUE);
        }

        if($this->deductionsModel->updateDeduction($deductionkey,$deduction)){
            $result['status'] = true;
            $result['message'] = 'Deduction updated successfully';
        }else{
            $result['status'] = false;
            $result['message'] = 'Failed to update';
        }

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        print json_encode($result);
    }

    public function delete($flag,$key) {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'deduction':
                if($this->deductionsModel->deleteDeduction($key)){
                    $result['status'] = true;
                    $result['message'] = 'Deduction updated successfully';
                }else{
                    $result['status'] = false;
                    $result['message'] = 'Failed to delete';
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = false;
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

    function removesessiondata($key){
        $data = !empty($_SESSION['deductions']) ? $_SESSION['deductions']: false;
        if($data){
            unset($_SESSION['deductions'][$key]);
        }
    }

    function removesessiondataall(){
        $data = !empty($_SESSION['deductions']) ? $_SESSION['deductions']: false;
        if($data){
            unset($_SESSION['deductions']);
        }
    }

    function getsessiondata(){

        $data = !empty($_SESSION['deductions']) ? $_SESSION['deductions']: false;
        if(!empty($data)){?>
            <table class="table table-sm table-warning table-bordered">
                <tr>
                    <th colspan="4">Deduction Data</th>
                </tr>
                <tr>
                    <th>Deduction</th>
                    <th>Type</th>
                    <th>Value</th>
                    <th>Action</th>
                </tr>
                <tbody>
                <?php foreach ($data as $key => $datum){?>
                    <tr>
                        <td><?= $this->deductionsModel->deductionDetails($datum['deduction_key'])->deduction_name?></td>
                        <td><?= $datum['deduction_type'];?></td>
                        <?php if($datum['deduction_type'] == 'percent'){?>
                            <td><?= $datum['deduction_value'];?></td>
                        <?php  }else{ ?>
                            <td><?= number_format(to_money($datum['deduction_value']));?></td>
                        <?php } ?>

                        <td style="text-align: center;"><a href="javascript:removeSessionDeduction(<?= $key ?>);"><i class="fa fa-trash-alt kt-font-danger"></i></a></td>
                    </tr>
                <?php } ?>
                <tr>
                    <td colspan="3"></td>
                    <td style="text-align: center;"><a href="javascript:removeSessionDeductionAll();"><i class="fa fa-trash-alt kt-font-danger"></i></a></td>
                </tr>
                </tbody>
            </table>
        <?php }
    }

    function addsessiondata(){

        $data['deductions'] = array();

        $deduction_key = $this->input->post('deduction_key');

        if(!empty($deduction_key)){

            $key = 0;

            $sessions = !empty($_SESSION['deductions']) ? $_SESSION['deductions']: false;
            if(!empty($sessions)){
                foreach ($sessions as $key => $session){
                    if($session['deduction_key'] != $deduction_key){
                        $data['deductions'][$key]['deduction_key'] = $session['deduction_key'];
                        $data['deductions'][$key]['deduction_name'] = $session['deduction_name'];
                        $data['deductions'][$key]['deduction_type'] = $session['deduction_type'];
                        $data['deductions'][$key]['deduction_value'] = $session['deduction_value'];
                    }
                }
            }

            $index = $key + 1;
            $data['deductions'][$index]['deduction_key'] = $this->input->post('deduction_key');
            $data['deductions'][$index]['deduction_name'] = $this->input->post('deduction_name');
            $data['deductions'][$index]['deduction_type'] = $this->input->post('deduction_type');
            $data['deductions'][$index]['deduction_value'] = to_dollar(toNumber($this->input->post('deduction_value')));
            $this->session->set_userdata($data);
        }

    }

    function jsondata($key){
        $data = $this->deductionsModel->deductionDetails($key);

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if(!empty($data)){
            $result['status'] = true;
            $result['deduction_key'] = $data->deduction_key;
            $result['deduction_name'] = $data->deduction_name;
            if($data->deduction_type == 'percent'){
                $result['deduction_value'] = $data->deduction_value;
            }else{
                $result['deduction_value'] = number_format(to_money($data->deduction_value));
            }
            $result['deduction_type'] = $data->deduction_type;
        }else{
            $result['status'] = false;
            $result['message'] = 'We could not obtain deduction data for key '.$key;
        }

        print json_encode($result,JSON_PRETTY_PRINT);

    }


}
