<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Index extends MY_Controller{

    public $pagedata;

    public function __construct() {
        parent::__construct();
        ($this->require_min_level(1));
        $this->pagedata['link']= 'payrolls';
        $this->load->helper('payroll/payroll');
        $this->load->model(array(
            'hrm/Employees'=>'employeesModel',
            'payroll/PayrollsModel'=>'payrollsModel',
            'payroll/InsuranceModel'=>'insurancesModel',
            'payroll/AllowancesModel'=>'allowancesModel',
            'payroll/BenefitsModel'=>'benefitsModel',
            'payroll/VariablesModel'=>'variablesModel',
            'payroll/DeductionsModel'=>'deductionsModel',
            'accounting/GeneralLedgerModel'=>'generalLedgerModel',
        ));
    }

    function paye($amount){
        print number_format(to_money(payeCalculator($amount)));
    }

    public function index() {
        has_control('payroll_view_all', 'View Payroll');
        $this->load->helper('form');
        $this->pagedata['title'] = 'Payrolls | '.$this->config->item('application_name');
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->load->vars($this->pagedata);
        $this->load->view('payrolls/index');
    }

    public function process() {
        has_control('payroll_view_all', 'View Payroll');
        $this->load->helper('form');
        $this->pagedata['title'] = 'Payroll process | '.$this->config->item('application_name');
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['payroll'] = $this->payrollsModel->payrolls();
        $this->load->vars($this->pagedata);
        $this->load->view('payrolls/process');
    }

    public function processor($employee) {
        has_control('payroll_view_all', 'View Payroll');
        $this->load->helper('form');
        $this->pagedata['title'] = 'Payroll process | '.$this->config->item('application_name');
        $this->pagedata['taxes'] = $this->payrollsModel->taxes();
        $this->pagedata['paye'] = $this->payrollsModel->paye();
        $this->pagedata['insurances'] = $this->insurancesModel->insurances();
        $this->pagedata['employee'] = $this->employeesModel->employee($employee);
        $this->load->vars($this->pagedata);
        $this->load->view('payrolls/processor');
    }

    public function slips($employee) {
        has_control('payroll_view_all', 'View Payroll');
        $this->load->helper('form');
        $this->pagedata['title'] = 'Pay Slips | '.$this->config->item('application_name');
        $this->pagedata['taxes'] = $this->payrollsModel->taxes();
        $this->pagedata['paye'] = $this->payrollsModel->paye();
        $this->pagedata['insurances'] = $this->insurancesModel->insurances();
        $this->pagedata['employee'] = $this->employeesModel->employee($employee);
        $this->pagedata['payroll'] = $this->payrollsModel->payroll($employee);
        $this->load->vars($this->pagedata);
        $this->load->view('payrolls/slips/index');
    }

    public function slip($key) {
        has_control('payroll_view_all', 'View Payroll');
        $this->pagedata['payroll'] = $this->payrollsModel->get_payslip($key);
        $this->pagedata['allowances'] = $this->payrollsModel->get_allowance($key);
        $this->pagedata['deductions'] = $this->payrollsModel->get_deduction($key);
        $this->pagedata['insurances'] = $this->payrollsModel->get_insurance($key);
        $this->load->vars($this->pagedata);
        $this->load->view('payrolls/slips/details');
    }

    public function payrollDetails($employee) {
        has_control('payroll_view_all', 'View Payroll');
        $this->pagedata['taxes'] = $this->payrollsModel->taxes();
        $this->pagedata['paye'] = $this->payrollsModel->paye();
        $this->pagedata['insurances'] = $this->insurancesModel->insurances();
        $this->pagedata['employee'] = $this->employeesModel->employee($employee);
        $this->pagedata['payroll'] = $this->payrollsModel->payroll($employee);
        $this->load->vars($this->pagedata);
        $this->load->view('payrolls/payrollDetails');
    }

    public  function datasource_employee_payrolls($key, $when=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->payrollsModel->getPayroll($key, $when);
        $columns = [
            'payroll_id' => true,
            'payroll_employee' => true,
            'payroll_timestamp' => true,
            'payroll_basic_salary' => true,
            'payroll_gross_salary' => true,
            'payroll_taxable_salary'=> true,
            'payroll_paye'=> true,
            'payroll_net_salary'=> true,
            'allowance_value'=> true,
            'emp_deduction_value'=> true,
            'employee_cost_amount'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }

    public function processoraction2($employee='') {
        $data['payroll_employee'] = $employee;
        $data['payroll_timestamp'] = $this->input->post('payroll_timestamp');
        $data['payroll_basic_salary'] = to_dollar(toNumber($this->input->post('basic_salary')));
        $data['payroll_gross_salary'] = to_dollar(toNumber($this->input->post('payroll_gross_salary')));
        $data['payroll_taxable_salary'] = to_dollar(toNumber($this->input->post('payroll_taxable_salary')));
        $data['payroll_net_salary'] = to_dollar(toNumber($this->input->post('payroll_net_salary')));
        $data['payroll_paye'] = to_dollar(toNumber($this->input->post('payroll_paye')));

        if($this->payrollsModel->processPayroll($employee, $data)){
            unset($_SESSION['insurance']); unset($_SESSION['deductions']); unset($_SESSION['allowances']);
            $result['status'] = 'ok';
            $result['message'] = 'Payroll processed successfully';
        }
        else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function processoraction($employee='') {
        has_control('payroll_create', 'Create Payroll');
        /** This is the core function for processing payroll data **/

        //load account balance helper.
        $this->load->helper('reports/accounting/helper');

        /** Start Transaction **/
        $this->db->trans_start();

        /** Get inputs from client post and assign to a container variable data ($data) **/
        $data['payroll_employee'] = $employee;
        $data['payroll_timestamp'] = $this->input->get('payroll_timestamp', true);
        $data['payroll_basic_salary'] = to_dollar(toNumber($this->input->get('basic_salary', true)));
        $data['payroll_gross_salary'] = to_dollar(toNumber($this->input->get('payroll_gross_salary', true)));
        $data['payroll_taxable_salary'] = to_dollar(toNumber($this->input->get('payroll_taxable_salary', true)));
        $data['payroll_net_salary'] = to_dollar(toNumber($this->input->get('payroll_net_salary', true)));
        $data['payroll_paye'] = to_dollar(toNumber($this->input->get('payroll_paye', true)));


        /** After catching raw data send them to Payrolls Model for DB operations **/
        $this->payrollsModel->processPayroll($employee, $data);

        /** The processed payroll data now is directed to accounting, here is raw data patched on General Ledger  **/
        // 1. Debit Account Details
        $ledgerDebit['gl_account'] = $this->input->get('payroll_debit_account', TRUE);
        $ledgerDebit['gl_debit'] = $data['payroll_gross_salary'];
        $ledgerDebit['gl_amount'] = $data['payroll_gross_salary'];
        $ledgerDebit['gl_date'] = $data['payroll_timestamp'];
        $ledgerDebit['gl_status'] = "PENDING";
        $ledgerDebit['gl_category'] = "PAYROLL";
        $ledgerDebit['gl_type'] = "PAYROLL";
        $ledgerDebit['gl_reference'] = $employee;
        $ledgerDebit['gl_details'] = "Salary for ".date('d/m/Y', strtotime($ledgerDebit['gl_date']));
        $ledgerDebit['gl_activity'] = $employee;
        $id = $this->generalLedgerModel->insert($ledgerDebit);
        $balance['gl_balance'] = payrollAccountBalance($ledgerDebit['gl_account']);
        $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

        // 2. Credit Account Details
        $ledgerCredit['gl_account'] = $this->input->get('payroll_credit_account', TRUE);
        $ledgerCredit['gl_credit'] = $data['payroll_gross_salary'];
        $ledgerCredit['gl_date'] = $data['payroll_timestamp'];
        $ledgerCredit['gl_status'] = "PENDING";
        $ledgerCredit['gl_category'] = "PAYROLL";
        $ledgerCredit['gl_type'] = "PAYROLL";
        $ledgerCredit['gl_reference'] = $employee;
        $ledgerCredit['gl_details'] = "Salary for ".date('d/m/Y', strtotime($ledgerCredit['gl_date']));
        $ledgerCredit['gl_activity'] = $employee;
        $ledgerCredit['gl_amount'] = $data['payroll_gross_salary'];
        $id = $this->generalLedgerModel->insert($ledgerCredit);
        $balance['gl_balance'] = payrollAccountBalance($ledgerCredit['gl_account']);
        $this->generalLedgerModel->update_by(['gl_id'=> $id], $balance);

        /** End transaction **/
        $this->db->trans_complete();

        if($this->db->trans_status() === true ){
            unset($_SESSION['insurance']); unset($_SESSION['deductions']); unset($_SESSION['allowances']);
            $result['status'] = 'ok';
            $result['message'] = 'Payroll processed successfully';
        }
        else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function processoraction1($employee='') {
        $netSalary = to_dollar($this->input->get('net_salary',TRUE));
        $netInsurances = $this->getSalaryNetInsurance($this->collectInsuranceinfo());
        $netInsurance = $this->getSalaryInsurances($this->collectInsuranceinfo());
        $grossSalary = $netSalary + $netInsurances;
        $netTax = $this->getSalaryNetTax($grossSalary,$this->collectTaxinfo());
        $taxes = $this->getSalaryTaxes($grossSalary,$this->collectTaxinfo());
        if($this->payrollsModel->processPayroll($employee,$netSalary,$netTax,$taxes,$netInsurances,$netInsurance)){
            $result['status'] = 'ok';
            $result['message'] = 'Payroll processed successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function getSalaryTaxes($salary,$taxesi){
        $taxes = array();
        foreach ($taxesi as $k => $tax) {
            if(!empty($tax['et_overide_value']) && $tax['et_overide_value'] > 0 ){
                $taxes[$k]['pd_t_tax'] = $tax['et_tax_key'];
                $taxes[$k]['pd_t_amount'] = $salary * ($tax['et_overide_value']/100) ;
            }else{
                $taxes[$k]['pd_t_tax'] = $tax['et_tax_key'];
                $taxes[$k]['pd_t_amount'] =  $salary * (payrolltax($tax['et_tax_key'])->payroll_tax_percent/100);
            }
        }
        return $taxes;
    }

    function getSalaryNetTax($salary,$taxes){
        $netTax = 0;
        foreach ($taxes as $k => $tax) {
            if(!empty($tax['et_overide_value']) && $tax['et_overide_value'] > 0 ){
                $netTax += $salary * ($tax['et_overide_value']/100) ;
            }else{
                $netTax += $salary * (payrolltax($tax['et_tax_key'])->payroll_tax_percent/100);
            }
        }
        return $netTax;
    }

    function getSalaryNetInsurance($insurances){
        $netInsurance = 0;
        foreach ($insurances as $e => $insurance) {
            //$vp = payrollInsurance($insurance['ev_insurance_key']);
            $vp = employee_insurance($insurance['ev_insurance_key']);
            if(!empty($insurance['ev_overide_value']) && $insurance['ev_overide_value'] > 0 ){
                if(strtolower($vp->insurance_type) == 'deduct'){
                    $netInsurance += -$insurance['ev_overide_value'];
                }else{
                    $netInsurance += $insurance['ev_overide_value'];
                }
            }else{
                if(strtolower($vp->insurance_type) == 'deduct'){
                    $netInsurance += -$vp->insurance_amount;
                }else{
                    $netInsurance += $vp->insurance_amount;
                }
            }
        }
        return $netInsurance;
    }

    function getSalaryInsurances($insurances){
        $netInsurance = array();
        foreach ($insurances as $e => $insurance) {
            $vp = payrollInsurance($insurance['ev_insurance_key']);
            if(!empty($insurance['ev_overide_value']) && $insurance['ev_overide_value'] > 0 ){
                if(strtolower($vp->insurance_type) == 'deduct'){
                    $netInsurance[$e]['pd_v_amount'] = -$insurance['ev_overide_value'];
                    $netInsurance[$e]['pd_v_insurance'] = $insurance['ev_insurance_key'];
                }else{
                    $netInsurance[$e]['pd_v_amount'] = $insurance['ev_overide_value'];
                    $netInsurance[$e]['pd_v_insurance'] = $insurance['ev_insurance_key'];
                }
            }else{
                if(strtolower($vp->insurance_type) == 'deduct'){
                    $netInsurance[$e]['pd_v_amount'] = -$vp->insurance_amount;
                    $netInsurance[$e]['pd_v_insurance'] = $insurance['ev_insurance_key'];
                }else{
                    $netInsurance[$e]['pd_v_amount'] = $vp->insurance_amount;
                    $netInsurance[$e]['pd_v_insurance'] = $insurance['ev_insurance_key'];
                }
            }
        }
        return $netInsurance;
    }

    function collectTaxinfo(){
        $taxes = $this->input->get('payroll_tax',TRUE);
        if(empty($taxes))
            return false;
        $overide = to_dollar($this->input->get('payroll_tax_overide',TRUE));
        $data = array();
        foreach ($taxes as $i => $tax) {
            $data[$i]['et_tax_key'] =  $tax;
            if(!empty($overide[$i])){
                $data[$i]['et_overide_value'] = $overide[$i];
            }else{
                $data[$i]['et_overide_value'] = NULL;
            }
        }
        return $data;
    }


    function collectInsuranceinfo(){
        $insurances = $this->input->get('payroll_insurance',TRUE);
        if(empty($insurances))
            return false;
        $overide = to_dollar(str_ireplace(',','',$this->input->get('payroll_insurance_overide',TRUE)));
        $data = array();
        foreach ($insurances as $i => $insurance) {
            $data[$i]['ev_insurance_key'] =  $insurance;
            if(!empty($overide[$i])){
                $data[$i]['ev_overide_value'] = $overide[$i];
            }else{
                $data[$i]['ev_overide_value'] = NULL;
            }
        }
        return $data;
    }

    function echos($amont){
        var_dump(payePercent($amont));
    }

    public function delete($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'payroll':
                if($this->payrollsModel->deletePayroll($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Payroll deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

    function datasourceemployeespayrolls($employee=''){
        include dirname(APPPATH).'/resources/includes/lib/class-list-util.php';
        $data = $this->payrollsModel->employeesPayrolls($employee);
        $this->sourcedata($data);

    }


    function datasourcepayrolls(){
        include dirname(APPPATH).'/resources/includes/lib/class-list-util.php';

        $data = $alldata = $this->payrollsModel->payrolls();

        $datatable = array_merge(['pagination' => [], 'sort' => [], 'query' => []], $_REQUEST);

        // search filter by keywords
        $filter = isset($datatable['query']['generalSearch']) && is_string($datatable['query']['generalSearch'])
            ? $datatable['query']['generalSearch'] : '';
        if ( ! empty($filter)) {
            $data = array_filter($data, function ($a) use ($filter) {
                return (boolean)preg_grep("/$filter/i", (array)$a);
            });
            unset($datatable['query']['generalSearch']);
        }

        // filter by field query
        $query = isset($datatable['query']) && is_array($datatable['query']) ? $datatable['query'] : null;
        if (is_array($query)) {
            $query = array_filter($query);
            foreach ($query as $key => $val) {
                $data = list_filter($data, [$key => $val]);
            }
        }

        $sort  = ! empty($datatable['sort']['sort']) ? $datatable['sort']['sort'] : 'asc';
        $field = ! empty($datatable['sort']['field']) ? $datatable['sort']['field'] : 'RecordID';

        $meta    = [];
        $page    = ! empty($datatable['pagination']['page']) ? (int)$datatable['pagination']['page'] : 1;
        $perpage = ! empty($datatable['pagination']['perpage']) ? (int)$datatable['pagination']['perpage'] : -1;

        $pages = 1;
        $total = count($data); // total items in array

        // sort
        usort($data, function ($a, $b) use ($sort, $field) {
            if ( ! isset($a->$field) || ! isset($b->$field)) {
                return false;
            }

            if ($sort === 'asc') {
                return $a->$field > $b->$field ? true : false;
            }

            return $a->$field < $b->$field ? true : false;
        });

        // $perpage 0; get all data
        if ($perpage > 0) {
            $pages  = ceil($total / $perpage); // calculate total pages
            $page   = max($page, 1); // get 1 page when $_REQUEST['page'] <= 0
            $page   = min($page, $pages); // get last page when $_REQUEST['page'] > $totalPages
            $offset = ($page - 1) * $perpage;
            if ($offset < 0) {
                $offset = 0;
            }

            $data = array_slice($data, $offset, $perpage, true);
        }

        $meta = [
            'page'    => $page,
            'pages'   => $pages,
            'perpage' => $perpage,
            'total'   => $total,
        ];

        // if selected all records enabled, provide all the ids
        if (isset($datatable['requestIds']) && filter_var($datatable['requestIds'], FILTER_VALIDATE_BOOLEAN)) {
            $meta['rowIds'] = array_map(function ($row) {
                foreach($row as $first) break;
                return $first;
            }, $alldata);
        }


        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $result = [
            'meta' => $meta + [
                    'sort'  => $sort,
                    'field' => $field,
                ],
            'data' => $data,
        ];

        echo json_encode($result, JSON_PRETTY_PRINT);
    }

}
