<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Insurance extends MY_Controller{

    public $pagedata;

    public function __construct() {
        parent::__construct();
        $this->require_min_level(1);
        $this->pagedata['link']= 'payrolls';
        $this->load->helper('payroll/payroll');
        $this->load->model(array(
            'payroll/InsuranceModel' => 'insuranceModel',
        ));
    }

    public function index() {
        has_control('payroll_view_all', 'View Payroll');
        $this->load->helper('form');
        $this->pagedata['title'] = 'Taxes | '.$this->config->item('application_name');
        $this->pagedata['data'] = $this->insuranceModel->insurances();
        $this->load->vars($this->pagedata);
        $this->load->view('payrolls/insurance/index');
    }

    public function insuranceDetails($insuranceKey='') {
        $this->pagedata['insurance'] = $this->insuranceModel->insuranceDetails($insuranceKey);
        $this->load->vars($this->pagedata);
        $this->load->view('payrolls/insurance/insurancedetails');
    }

    public function insurancemodify($insuranceKey='') {
        $this->pagedata['insurance'] = $this->insuranceModel->insuranceDetails($insuranceKey);
        $this->load->vars($this->pagedata);
        $this->load->view('payrolls/insurance/insurancemodify');
    }

    function newInsurance(){
        has_control('payroll_create', 'Create Insurance');
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');

        $insurance['pr_insurance_details'] = $this->input->post('insurance_details',TRUE);
        $insurance['pr_insurer'] = $this->input->post('insurer',TRUE);
        $insurance['pr_insurance_type'] = $this->input->post('insurance_type',TRUE);
        $insurance['pr_insurance_debit_account'] = $this->input->post('insurance_debit_account',TRUE);
        $insurance['pr_insurance_credit_account'] = $this->input->post('insurance_credit_account',TRUE);
        if($insurance['pr_insurance_type'] == 'fixed'){
            $insurance['pr_company_cost'] = to_dollar(str_ireplace(',','',$this->input->post('company_cost',TRUE)));
            $insurance['pr_employee_cost'] = to_dollar(str_ireplace(',','',$this->input->post('employee_cost',TRUE)));
        }else{
            $insurance['pr_company_cost'] = $this->input->post('company_cost',TRUE);
            $insurance['pr_employee_cost'] = $this->input->post('employee_cost',TRUE);
        }

        if($this->insuranceModel->newInsurance($insurance)){
            $result['status'] = true;
            $result['message'] = 'Insurance registered successfully';
        }else{
            $result['status'] = false;
            $result['message'] = checkError();
        }

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        print json_encode($result);

    }

    function removesessiondata($key){
        $data = !empty($_SESSION['insurance']) ? $_SESSION['insurance']: false;
        if($data){
            unset($_SESSION['insurance'][$key]);
        }
    }

    function removesessiondataall(){
        $data = !empty($_SESSION['insurance']) ? $_SESSION['insurance']: false;
        if($data){
            unset($_SESSION['insurance']);
        }
    }

    function getsessiondata(){

        $data = !empty($_SESSION['insurance']) ? $_SESSION['insurance']: false;
        if(!empty($data)){?>
            <table class="table table-sm table-success table-bordered">
                <tr>
                    <th colspan="4">Insurance Data</th>
                </tr>
                <tr>
                    <th>Insurer</th>
                    <th>Company Cost</th>
                    <th>Employee Cost</th>
                    <th>Action</th>
                </tr>
                <tbody>
                <?php foreach ($data as $key => $datum){?>
                    <tr>
                        <td><?= $this->insuranceModel->insuranceDetails($datum['pr_insurer'])->pr_insurer?></td>
                        <td><?= $datum['pr_company_cost'];?></td>
                        <td><?= $datum['pr_employee_cost'];?></td>
                        <td style="text-align: center;"><a href="javascript:removeSessionInsurance(<?= $key ?>);"><i class="fa fa-trash-alt kt-font-danger"></i></a></td>
                    </tr>
                <?php } ?>
                <tr>
                    <td colspan="3"></td>
                    <td style="text-align: center;"><a href="javascript:removeSessionInsuranceAll();"><i class="fa fa-trash-alt kt-font-danger"></i></a></td>
                </tr>
                </tbody>
            </table>
        <?php }
    }

    function addsessiondata(){

        $data['insurance'] = array();

        $insurer = $this->input->post('insurer');

        if(!empty($insurer)){

            $key = 0;

            $sessions = !empty($_SESSION['insurance']) ? $_SESSION['insurance']: false;
            if(!empty($sessions)){
                foreach ($sessions as $key => $session){
                    if($session['insurer'] != $insurer){
                        $data['insurance'][$key]['pr_insurer'] = $session['insurer'];
                        $data['insurance'][$key]['pr_company_cost'] = $session['company_cost'];
                        $data['insurance'][$key]['pr_employee_cost'] = $session['employee_cost'];
                    }
                }
            }

            $index = $key + 1;
            $data['insurance'][$index]['pr_insurer'] = $this->input->post('insurer');
            $data['insurance'][$index]['pr_company_cost'] = $this->input->post('company_cost');
            $data['insurance'][$index]['pr_employee_cost'] = $this->input->post('employee_cost');
            $this->session->set_userdata($data);
        }

    }

    function jsondata($key){
        $data = $this->insuranceModel->insuranceDetails($key);

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if(!empty($data)){
            $result['status'] = true;
            $result['company_cost'] = $data->pr_company_cost;
            $result['employee_cost'] = $data->pr_employee_cost;
        }else{
            $result['status'] = false;
            $result['message'] = 'We could not obtain insurance data for key '.$key;
        }

        print json_encode($result,JSON_PRETTY_PRINT);

    }

    function updateInsurance($insurancekey=''){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');

        $insurance['pr_insurance_details'] = $this->input->post('insurance_details',TRUE);
        $insurance['pr_insurer'] = $this->input->post('insurer',TRUE);
        $insurance['pr_insurance_type'] = $this->input->post('insurance_type',TRUE);
        $insurance['pr_insurance_debit_account'] = $this->input->post('insurance_debit_account',TRUE);
        $insurance['pr_insurance_credit_account'] = $this->input->post('insurance_credit_account',TRUE);
        if($insurance['pr_insurance_type'] == 'fixed'){
            $insurance['pr_company_cost'] = to_dollar(str_ireplace(',','',$this->input->post('company_cost',TRUE)));
            $insurance['pr_employee_cost'] = to_dollar(str_ireplace(',','',$this->input->post('employee_cost',TRUE)));
        }else{
            $insurance['pr_company_cost'] = $this->input->post('company_cost',TRUE);
            $insurance['pr_employee_cost'] = $this->input->post('employee_cost',TRUE);
        }
        if($this->insuranceModel->updateInsurance($insurancekey,$insurance)){
            $result['status'] = true;
            $result['message'] = 'Insurance updated successfully';
        }else{
            $result['status'] = false;
            $result['message'] = 'Failed to update';
        }

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        print json_encode($result);
    }

    public function delete($flag,$key) {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'insurance':
                if($this->insuranceModel->deleteInsurance($key)){
                    $result['status'] = true;
                    $result['message'] = 'Insurance updated successfully';
                }else{
                    $result['status'] = false;
                    $result['message'] = 'Failed to delete';
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = false;
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

}
