<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Managetypes extends MY_Controller{

  public $pagedata;

  public function __construct() {
    parent::__construct();
    ($this->require_role('employee'));
    $this->pagedata['link']= 'expenses';
      $this->load->helper('payroll/payroll');
  }

  public function index() {
    $this->load->helper('form');
    $this->pagedata['employees'] = $this->employeesModel->employees();
    $this->pagedata['title'] = 'Expense Types | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('employee/expenses/types/types');
  }

  public function newtype(){
    if (!$this->input->is_ajax_request())
      exit('not direct script allowed');
       $expenseType['expense_type'] = $this->input->get('expense_type', TRUE);
       $expenseType['expense_type_category'] = $this->input->get('expense_type_category', TRUE);
       $expenseType['expense_type_account'] = $this->input->get('expense_type_account', TRUE);
         if($this->expensesModel->newExpenseType($expenseType)){
           $result['status'] = 'ok';
           $result['message'] = 'An expense added successfull';
         }else{
           $result['status'] = 'no';
           $result['message'] = checkError();
         }
         print json_encode($result);
  }


 public function delete($flag,$key) {
     switch ($flag) {
         case 'expensetype':
         if($this->expensesModel->deleteExpenseType($key)){
                   $result['status'] = 'ok';
                   $result['message'] = 'Expense Type deleted';
                 }else{
                   $result['status'] = 'no';
                   $result['message'] = checkError($this->dbexeption());
                 }
           print json_encode($result);
         break;
         default:
           $result['status'] = 'no';
           $result['message'] = 'No action';
            print json_encode($result);
         break;
     }
 }

function datasource(){
include dirname(APPPATH).'/resources/includes/lib/class-list-util.php';

$data = $alldata = $this->expensesModel->expenseTypes();

$datatable = array_merge(['pagination' => [], 'sort' => [], 'query' => []], $_REQUEST);

// search filter by keywords
$filter = isset($datatable['query']['generalSearch']) && is_string($datatable['query']['generalSearch'])
  ? $datatable['query']['generalSearch'] : '';
if ( ! empty($filter)) {
  $data = array_filter($data, function ($a) use ($filter) {
      return (boolean)preg_grep("/$filter/i", (array)$a);
  });
  unset($datatable['query']['generalSearch']);
}

// filter by field query
$query = isset($datatable['query']) && is_array($datatable['query']) ? $datatable['query'] : null;
if (is_array($query)) {
  $query = array_filter($query);
  foreach ($query as $key => $val) {
      $data = list_filter($data, [$key => $val]);
  }
}

$sort  = ! empty($datatable['sort']['sort']) ? $datatable['sort']['sort'] : 'asc';
$field = ! empty($datatable['sort']['field']) ? $datatable['sort']['field'] : 'RecordID';

$meta    = [];
$page    = ! empty($datatable['pagination']['page']) ? (int)$datatable['pagination']['page'] : 1;
$perpage = ! empty($datatable['pagination']['perpage']) ? (int)$datatable['pagination']['perpage'] : -1;

$pages = 1;
$total = count($data); // total items in array

// sort
usort($data, function ($a, $b) use ($sort, $field) {
  if ( ! isset($a->$field) || ! isset($b->$field)) {
      return false;
  }

  if ($sort === 'asc') {
      return $a->$field > $b->$field ? true : false;
  }

  return $a->$field < $b->$field ? true : false;
});

// $perpage 0; get all data
if ($perpage > 0) {
  $pages  = ceil($total / $perpage); // calculate total pages
  $page   = max($page, 1); // get 1 page when $_REQUEST['page'] <= 0
  $page   = min($page, $pages); // get last page when $_REQUEST['page'] > $totalPages
  $offset = ($page - 1) * $perpage;
  if ($offset < 0) {
      $offset = 0;
  }

  $data = array_slice($data, $offset, $perpage, true);
}

$meta = [
  'page'    => $page,
  'pages'   => $pages,
  'perpage' => $perpage,
  'total'   => $total,
];

// if selected all records enabled, provide all the ids
if (isset($datatable['requestIds']) && filter_var($datatable['requestIds'], FILTER_VALIDATE_BOOLEAN)) {
  $meta['rowIds'] = array_map(function ($row) {
      foreach($row as $first) break;
      return $first;
  }, $alldata);
}


header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

$result = [
  'meta' => $meta + [
          'sort'  => $sort,
          'field' => $field,
      ],
  'data' => $data,
];

echo json_encode($result, JSON_PRETTY_PRINT);
}

}
