<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author Kelvin Benard
 */
class Index extends MY_Controller{

  public $pagedata;
  public $branch;
  public $business;

  public function __construct() {
    parent::__construct();

    $this->require_min_level(1);

    $this->pagedata['link']= 'administration';
    $this->load->model(array(
        'profile/profileModel'=>'profileModel'));
  }

  public function index(){
      $this->load->helper('form');
      if($this->tokens->match){
          $this->load->library(array('appLibrary'=>"appLibrary"));
          $uploadStatus = $this->appLibrary->uploadFileImage(uploadPath('profile_pictures/'));
          if($uploadStatus['status']) {
              $data['avatar'] = $uploadStatus['data']['file_name'];
              //var_dump($data);
              $this->db->where('user_key',$this->auth_user_id);
              $this->db->update('users_details',$data);
          }
          //$this->uploadProfilePicture($this->auth_user_id,$uploadStatus);
      }
    $this->pagedata['profile']= $this->profileModel->profile($this->auth_user_id);
    $this->pagedata['title'] = 'Profile Account | '.$this->config->item('application_name');
    $this->pagedata['sublink'] = "personal";
    $this->load->vars($this->pagedata);
    $this->load->view('profile/profile');
  }

  public function overview(){
        if($this->tokens->match){
            $this->load->library(array('appLibrary'=>"appLibrary"));
            $uploadStatus = $this->appLibrary->uploadFileImage(uploadPath('profile_pictures/'));
            $this->uploadProfilePicture($this->auth_user_id,$uploadStatus);
        }
        $this->load->helper('form');
        $this->pagedata['profile']= $this->profileModel->profile($this->auth_user_id);
        $this->pagedata['title'] = 'Profile Account | '.$this->config->item('application_name');
        $this->pagedata['sublink'] = "overview";
        $this->load->vars($this->pagedata);
        $this->load->view('profile/overview');
    }

  public function primary(){
        $this->load->helper('form');
        if($this->tokens->match){
            $this->load->library(array('appLibrary'=>"appLibrary"));
            $uploadStatus = $this->appLibrary->uploadFileImage(uploadPath('profile_pictures/'));
            if($uploadStatus['status']) {
                $data['avatar'] = $uploadStatus['data']['file_name'];
                //var_dump($data);
                $this->db->where('user_key',$this->auth_user_id);
                $this->db->update('users_details',$data);
            }
            //$this->uploadProfilePicture($this->auth_user_id,$uploadStatus);
        }
        $this->pagedata['profile']= $this->profileModel->profile($this->auth_user_id);
        $this->pagedata['title'] = 'Profile Account | '.$this->config->item('application_name');
        $this->pagedata['sublink'] = "primary";
        $this->load->vars($this->pagedata);
        $this->load->view('profile/primary');
    }

  function updatepersonalPrimary($userKey='') {
        $data['country'] = $this->input->get("country",TRUE);
        $data['state'] = $this->input->get("state",TRUE);
        $data['city'] = $this->input->get("city",TRUE);
        $data['firstname'] = $this->input->get("firstname",TRUE);
        $data['middlename'] = $this->input->get("middlename",TRUE);
        $data['lastname'] = $this->input->get("lastname",TRUE);
        $data['mobilephone'] = $this->input->get("mobilephone",TRUE);
        $data['address'] = $this->input->get("address",TRUE);
        $data['identity_type'] = $this->input->get("identity_type",TRUE);
        $data['identity_value'] = $this->input->get("identity_value",TRUE);
        $data['dob'] = date("Y-m-d",strtotime($this->input->get("dob",TRUE)));
        if($this->profileModel->userUpdate($userKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Profile data updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

  public function security(){
        $this->load->helper('form');
        $this->pagedata['profile']= $this->profileModel->profile($this->auth_user_id);
        $this->pagedata['title'] = 'Profile Account | '.$this->config->item('application_name');
        $this->pagedata['sublink'] = "security";
        $this->load->vars($this->pagedata);
        $this->load->view('profile/security');
    }

  public function account(){
        $this->load->helper('form');
        $this->pagedata['profile']= $this->profileModel->profile($this->auth_user_id);
        $this->pagedata['title'] = 'Profile Account | '.$this->config->item('application_name');
        $this->pagedata['sublink'] = "account";
        $this->load->vars($this->pagedata);
        $this->load->view('profile/account');
    }


  function updatepersonaldata($user_id=""){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');

        if(empty($user_id)){
            $user_id = $this->input->post("user_id",TRUE);
        }

        $data['country'] = $this->input->post("country",TRUE);
        $data['state'] = $this->input->post("state",TRUE);
        $data['city'] = $this->input->post("city",TRUE);
        $data['firstname'] = $this->input->post("firstname",TRUE);
        $data['middlename'] = $this->input->post("middlename",TRUE);
        $data['lastname'] = $this->input->post("lastname",TRUE);
        $data['mobilephone'] = $this->input->post("mobilephone",TRUE);
        $data['dob'] = date("Y-m-d",strtotime($this->input->post("dob",TRUE)));

        if($this->profileModel->updatePersonalData($user_id,$data)){
            $result['status'] = true;
            $result['message'] = 'Personal data updated successfully';
        }else{
            $result['status'] = false;
            $result['message'] = checkError($this->dbexeption());
        }

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        print json_encode($result);
        exit();

    }

  function updateaccount($user_id=""){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');

        if(empty($user_id)){
            $user_id = $this->input->post("user_id",TRUE);
        }

        if(!empty($this->input->post("username",TRUE)) && $this->input->post("username",TRUE) != profile()->username){
            $this->load->library('form_validation');

            $username = [
                'username' => $this->input->post('username'),
            ];

            $validation_rules = [
                [
                    'field' => 'username',
                    'label' => 'username',
                    'rules' => 'is_unique[' . db_table('user_table') . '.username]',
                    'errors' => [
                        'is_unique' => 'Whoops, username not available.'
                    ]
                ],
            ];
            $this->form_validation->set_rules( $validation_rules );
            $this->form_validation->set_data( $username);
            if( !$this->form_validation->run() )
            {
                $result['status'] = false;
                $result['message'] = "Whoops, username is not available";
                header('Content-Type: application/json');
                header('Access-Control-Allow-Origin: ' . base_url());
                header('Access-Control-Allow-Methods: GET, POST');
                header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
                print json_encode($result);
                exit();
            }else{
                $data['username'] = $this->input->post("username",TRUE);
            }
        }

          if($this->input->post("user_lang",TRUE) != profile()->user_lang){
              $this->load->language(array('display'),$this->input->post("user_lang",TRUE));
              $_SESSION['language'] = $this->input->post("user_lang",TRUE);
          }

        $data['user_lang'] = $this->input->post("user_lang",TRUE);
        $data['timezone'] = $this->input->post("timezone",TRUE);
        $data['communicate_sms'] = !empty($this->input->post("communicate_sms",TRUE)) ? $this->input->post("communicate_sms",TRUE) :0;
        $data['communicate_phone'] = !empty($this->input->post("communicate_phone",TRUE)) ? $this->input->post("communicate_phone",TRUE) :0;
        $data['communicate_email'] = !empty($this->input->post("communicate_email",TRUE)) ? $this->input->post("communicate_email",TRUE) :0;

        if($this->profileModel->updateAccount($user_id,$data)){
            $result['status'] = true;
            $result['message'] = 'Account data updated successfully';
        }else{
            $result['status'] = false;
            $result['message'] = checkError($this->dbexeption());
        }

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        print json_encode($result);
        exit();

    }


  function updatepassword($user_id=""){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');

        if(empty($user_id)){
            $user_id = $this->input->post("user_id",TRUE);
        }

      $hashed = $this->profileModel->profile($user_id)->passwd;
      $oldpassword = $this->input->post('oldpassword',TRUE);
      $newpassword['passwd'] = $this->authentication->hash_passwd($this->input->post('newpassword',TRUE));

      if($this->authentication->check_passwd($hashed,$oldpassword)){
          $this->db->where('user_id', $user_id);
          $this->db->update('users',$newpassword);
          if($this->db->affected_rows()>0){
              $result['status'] = true;
              $result['message'] = 'Password updated successfully';
          }else{
              $result['status'] = false;
              $result['message'] = checkError($this->dbexeption());
          }
      }else{
          $result['status'] = false;
          $result['message'] = 'The old password might be wrong';
      }

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        print json_encode($result);
        exit();

    }

  public function details($employee='') {
    $this->load->helper('form');
    $this->pagedata['employee']= $this->employeesModel->employee($employee);
    $this->pagedata['title'] = 'Employee details | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view($this->auth_role.'/profile/details');
  }

  public function loadInformationsallaryadvances($employee='') {
    $this->load->model(array('TitlesModel'=>'titlesModel'));
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
    $data['ad_employee'] = $employee;
    $data['ad_date'] = date('Y-m-d');
    $data['ad_amount'] = to_dollar($this->input->get('amount',TRUE));
    $data['ad_details'] = $this->input->get('details',TRUE);
    if(!empty($_GET)){
       has_control_ajax('employee_update','Update Employee details');
      if($this->employeesModel->addsallaryadvance($employee,$data)){
        $result['status'] = 'ok';
        $result['message'] = 'Sallary Advance added successfully';
        }else{
          $result['status'] = 'no';
          $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
        exit();
    }
    $this->pagedata['total_advance'] = $this->employeesModel->employeetotalsallaryadvace($employee);
    $this->pagedata['month_advance'] = $this->employeesModel->employeemonthsallaryadvance($employee);
    $this->pagedata['paid_advance'] = $this->employeesModel->employeesallaryadvancepaidtotal($employee);
    $this->pagedata['employee']= $this->employeesModel->employee($employee);
    $this->pagedata['titles'] = $this->titlesModel->categories();
    $this->load->vars($this->pagedata);
    $this->load->view($this->auth_role.'/profile/sallaryadvances');
  }

  public function loadInformationinternaldepts($employee='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
    $this->load->model(array('TitlesModel'=>'titlesModel'));
    $data['id_employee'] = $employee;
    $data['id_date'] = date('Y-m-d');
    $data['id_amount'] = to_dollar($this->input->get('amount',TRUE));
    $data['id_rate'] = to_dollar($this->input->get('rate',TRUE));
    $data['id_rate_type'] = $this->input->get('rate_type',TRUE);
    $data['id_details'] = $this->input->get('details',TRUE);
    if(!empty($_GET)){
      has_control_ajax('employee_update','Update Employee details');
      if($this->employeesModel->adddept($employee,$data)){
        $result['status'] = 'ok';
        $result['message'] = 'Dept added successfully';
        }else{
          $result['status'] = 'no';
          $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
        exit();
    }
    $this->pagedata['total_dept'] = $this->employeesModel->employeetotaldept($employee);
    $this->pagedata['month_dept'] = $this->employeesModel->employeemonthdept($employee);
    $this->pagedata['paid_depts'] = $this->employeesModel->employeedeptspaidtotal($employee);
    $this->pagedata['employee']= $this->employeesModel->employee($employee);
    $this->pagedata['titles'] = $this->titlesModel->categories();
    $this->load->vars($this->pagedata);
    $this->load->view($this->auth_role.'/profile/internaldepts');
  }

  public function loadInformationsecurity($key='') {
     if (!$this->input->is_ajax_request())
      exit('not direct script allowed');
    $this->load->model(array('TitlesModel'=>'titlesModel'));
    $this->pagedata['employee']= $this->employeesModel->employee($key);
    $this->pagedata['titles'] = $this->titlesModel->categories();
    $this->load->vars($this->pagedata);
    $this->load->view($this->auth_role.'/profile/securityAjax');
  }

  public function loadInformationroles($key='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
    $this->load->model(array(
        'hrm/RolesModel'=>'rolesModel',
        'hrm/TitlesModel'=>'titlesModel')
            );
    $this->pagedata['employee']= $this->employeesModel->employee($key);
    $this->pagedata['roles'] = $this->rolesModel->roles();
    $this->load->vars($this->pagedata);
    $this->load->view($this->auth_role.'/profile/rolesAjax');
  }

  public function loadInformationprimary($key='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
    $this->pagedata['employee']= $this->employeesModel->employee($key);
    $this->load->vars($this->pagedata);
    $this->load->view($this->auth_role.'/profile/detailsAjax');
  }

  public function loadInformationsalaryslips($key='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
    $this->pagedata['taxes'] = $this->payrollsModel->taxes();
    $this->pagedata['paye'] = $this->payrollsModel->paye();
    $this->pagedata['variables'] = $this->variablesModel->variables();
    $this->pagedata['employee']= $this->employeesModel->employee($key);
    $this->load->vars($this->pagedata);
    $this->load->view($this->auth_role.'/profile/payrollAjax');
  }

  public function loadInformationRoleAction($key='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     $roles['role_register_client'] = !empty($this->input->get('role_register_client', TRUE)) ? $this->input->get('role_register_client', TRUE) : 0;
     if($this->employeesModel->employeeUpdateRoles($key,$roles)){
               $result['status'] = 'ok';
               $result['message'] = 'Role(s) information changed successifully';
             }else{
               $result['status'] = 'no';
               $result['message'] = checkError($this->dbexeption());
             }
    print json_encode($result);
  }

  public function loadInformationSecurityAction($key='') {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
         $security['user_lang'] = $this->input->get('user_lang', TRUE);
         if(!empty($this->input->get('password',TRUE))){
           $security['passwd'] =$this->authentication->hash_passwd($this->input->get('password',TRUE));
         }
         $security['communicate_sms'] = !empty($this->input->get('communicate_sms', TRUE)) ? $this->input->get('communicate_sms', TRUE) : 0;
         $security['communicate_phone'] = !empty($this->input->get('communicate_phone', TRUE)) ? $this->input->get('communicate_phone', TRUE) : 0;
         $security['communicate_email'] = !empty($this->input->get('communicate_email', TRUE)) ? $this->input->get('communicate_email', TRUE) : 0;
         if($this->employeesModel->employeeUpdateSecurity($key,$security)){
                   $result['status'] = 'ok';
                   $result['message'] = 'Security information changed successifully';
                 }else{
                   $result['status'] = 'no';
                   $result['message'] = checkError($this->dbexeption());
                 }
        print json_encode($result);

  }

  public function loadInformationPayrollAction($key=''){
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     $taxes = $this->collectTaxinfo();
     $variables = $this->collectVariableinfo();
     $salary['net_salary']  = to_dollar($this->input->get('net_salary',TRUE));
     if($this->employeesModel->employeeUpdatePayroll($key,$salary,$taxes,$variables)){
               $result['status'] = 'ok';
               $result['message'] = 'Payroll information changed successifully';
             }else{
               $result['status'] = 'no';
               $result['message'] = checkError($this->dbexeption());
             }
       print json_encode($result);
  }

  public function loadInformationPrimaryAction($key=''){
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
     $employee['net_salary']  = to_dollar($this->input->get('net_salary',TRUE));
     $employee['gender'] = $this->input->get('gender', TRUE);
     $employee['country'] = $this->input->get('country', TRUE);
     $employee['state'] = $this->input->get('state', TRUE);
     $employee['city'] = $this->input->get('city', TRUE);
     $employee['residential_address'] = $this->input->get('residential_address', TRUE);
     $employee['home_address'] = $this->input->get('home_address', TRUE);
     $employee['city'] = $this->input->get('city', TRUE);
     $employee['dob'] = date('Y-m-d',strtotime($this->input->get('dob', TRUE)));
     $employee['middlename'] = $this->input->get('middlename', TRUE);
     $employee['firstname'] = $this->input->get('firstname', TRUE);
     $employee['lastname'] = $this->input->get('lastname', TRUE);
     if($this->employeesModel->employeeUpdatePrimary($key,$employee)){
               $result['status'] = 'ok';
               $result['message'] = 'Primary information changed successifully';
             }else{
               $result['status'] = 'no';
               $result['message'] = checkError($this->dbexeption());
             }
       print json_encode($result);
  }

  function collectSecurityInfo(){
    $security['auth_level'] = $this->input->get('auth_level',TRUE);
    $security['user_title'] = $this->input->get('user_title',TRUE);
    $security['email'] = $this->input->get('email',TRUE);
    $security['username'] = $this->input->get('username',TRUE);
    $security['phonenumber'] = $this->input->get('phonenumber',TRUE);
    if(!empty($this->input->get('password',TRUE))){
      $security['passwd'] =$this->authentication->hash_passwd($this->input->get('password',TRUE));
    }
    $security['communicate_sms'] = !empty($this->input->get('communicate_sms', TRUE)) ? $this->input->get('communicate_sms', TRUE) : 0;
    $security['communicate_phone'] = !empty($this->input->get('communicate_phone', TRUE)) ? $this->input->get('communicate_phone', TRUE) : 0;
    $security['communicate_email'] = !empty($this->input->get('communicate_email', TRUE)) ? $this->input->get('communicate_email', TRUE) : 0;
    $security['user_branch'] = $this->branch;
    $security['user_business'] = $this->business;
    $security['user_lang'] = profile()->user_lang;
    return $security;
  }

  function collectPrimaryInfo(){
    $primary['details_branch'] = $this->branch;
    $primary['details_business'] = $this->business;
    $primary['net_salary'] = to_dollar(str_ireplace(',','',$this->input->get('net_salary',TRUE)));
    $primary['firstname'] = $this->input->get('firstname',TRUE);
    $primary['middlename'] = $this->input->get('middlename',TRUE);
    $primary['lastname'] = $this->input->get('lastname',TRUE);
    $primary['gender'] = $this->input->get('gender',TRUE);
    $primary['dob'] = $this->input->get('dob',TRUE);
    $primary['country'] = $this->input->get('country',TRUE);
    $primary['state'] = $this->input->get('state',TRUE);
    $primary['city'] = $this->input->get('city',TRUE);
    $primary['home_address'] = $this->input->get('home_address',TRUE);
    $primary['residential_address'] = $this->input->get('residential_address',TRUE);
    $primary['identity_type'] = $this->input->get('identity_type',TRUE);
    $primary['identity_value'] = $this->input->get('identity_value',TRUE);
    return $primary;
  }

  function collectTaxinfo(){
    $taxes = $this->input->get('payroll_tax',TRUE);
    if(empty($taxes))
    return false;
    $overide = to_dollar($this->input->get('payroll_tax_overide',TRUE));
    $data = array();
    foreach ($taxes as $i => $tax) {
      $data[$i]['et_tax_key'] =  $tax;
      if(!empty($overide[$i])){
        $data[$i]['et_overide_value'] = $overide[$i];
      }else{
        $data[$i]['et_overide_value'] = NULL;
      }
    }
  return $data;
  }

  function collectRolesinfo(){
    $title = $this->input->get('user_title',TRUE);
    $categoryId = $this->db->where('category_key',$title)->get('acl_categories')->row()->category_id;
    $this->db->select('action_id');
    $this->db->where('action_business',$this->business);
    $this->db->where('category_id',$categoryId);
    $results = $this->db->get('acl_actions');
    if($results->num_rows()>0){
     $data = array();
      foreach ($results->result_array() as $k => $result) {
        $data[$k]['action_id'] =  $result['action_id'];
      }
      return $data;
    }else{
      return false;
    }
  }

  function collectVariableinfo(){
    $variables = $this->input->get('payroll_variable',TRUE);
    if(empty($variables))
    return false;
    $overide = to_dollar(str_ireplace(',','',$this->input->get('payroll_variable_overide',TRUE)));
    $data = array();
    foreach ($variables as $i => $variable) {
      $data[$i]['ev_variable_key'] =  $variable;
      if(!empty($overide[$i])){
        $data[$i]['ev_overide_value'] = $overide[$i];
      }else{
        $data[$i]['ev_overide_value'] = NULL;
      }
    }
  return $data;
  }

 function employeedeptsummary($employee=''){
   $this->data['total_dept'] = $this->employeesModel->employeetotaldept($employee);
   $this->data['month_dept'] = $this->employeesModel->employeemonthdept($employee);
   $this->data['paid_depts'] = $this->employeesModel->employeedeptspaidtotal($employee);
   $this->load->view($this->auth_role.'/profile/deptsummary',$this->data);
 }

 function employeesallaryadvancesummary($employee=''){
   $this->pagedata['total_advance'] = $this->employeesModel->employeetotalsallaryadvace($employee);
   $this->pagedata['month_advance'] = $this->employeesModel->employeemonthsallaryadvance($employee);
   $this->pagedata['paid_advance'] = $this->employeesModel->employeesallaryadvancepaidtotal($employee);
   $this->load->view($this->auth_role.'/profile/sallaryadvancesummary',$this->pagedata);
 }

function datasource(){
  $data =  $this->employeesModel->employees();
  $this->sourcedata($data);
}

function datasourcedepartments(){
  $data =  $this->employeesModel->departments();
  $this->sourcedata($data);
}

function datasourcedepts($key=''){
  $data =  $this->employeesModel->employee_depts($key);
  $this->sourcedata($data);
}

function datasourcesallaryadvances($key=''){
  $data =  $this->employeesModel->employeesallaryadvances($key);
  $this->sourcedata($data);
}

function uploadProfilePicture($user,$uploadStatus){
    if($uploadStatus['status']){
        if(!empty(profile()->user_key)){

            if(file_exists(uploadPath('profile_pictures/'.profile($user)->avatar))){
                if(strtolower(profile($user)->avatar) != 'avatar.png'){
                    unlink(uploadPath('profile_pictures/'.profile($user)->avatar));
                }
                if(strtolower(profile($user)->avatar) != 'avatar.jpg'){
                    unlink(uploadPath('profile_pictures/'.profile($user)->avatar));
                }
                if(strtolower(profile($user)->avatar) != 'avatar.jpeg'){
                    unlink(uploadPath('profile_pictures/'.profile($user)->avatar));
                }
            }

            $this->db->where('user_key',$user);
            $data['avatar'] = $uploadStatus['data']['file_name'];
            $this->db->update('users_details',$data);
        }else{
            $business = runningBusiness()->business_key;
            $branch = runningBranch()->branch_key;
            $data['user_key'] = $user;
            $data['details_business'] = $business;
            $data['details_branch'] = $branch;
            $data['avatar'] = $uploadStatus['data']['file_name'];
            $this->db->insert('users_details',$data);
        }

        if($this->db->affected_rows()>0){
            return true;
        }else{
                $data['avatar'] = $uploadStatus['data']['file_name'];
                if(file_exists(uploadPath('profile_pictures/'.$data['avatar']))){
                    unlink(uploadPath('profile_pictures/'.$data['avatar']));
                }
            return true;
        }

    }else{

        return false;
    }
}

}
