<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
* Description of Dashboard
*
* @author Kelvin Benard
*/

class Index extends MY_Controller{

  public  $pagedata;

  public function __construct() {
    parent::__construct();
    $this->require_min_level(1);
    $this->pagedata['link']= 'settings';
    $this->pagedata['title'] = 'Settings | '.$this->config->item('application_name');
    $this->pagedata['profile']= profile();
  }

  public function index() {
    $this->pagedata['sublink']= 'settings';
    $this->load->vars($this->pagedata);
    $this->load->view('settings/settings');
  }
    public function sound() {
        $this->pagedata['sublink']= 'sound';
        $this->load->vars($this->pagedata);
        $this->load->view('settings/sound');
    }


  function update_setting_checkbox($key,$val){

      $result['sound'] = profile()->st_notification_sound;

      if(!empty(profile()->st_user)){
          $this->db->limit(1);
          $this->db->where("st_user",$this->auth_user_id);
          $this->db->update('user_settings',[$key=>$val]);
          if($this->db->affected_rows() == 1){
              $result['status'] = true;
          }else{
              $result['status'] = false;
          }
      }else{
          $data['st_user'] = $this->auth_user_id;
          $data[$key] = $val;
          $this->db->limit(1);
          $this->db->insert('user_settings',$data);
          if($this->db->affected_rows() == 1){
              $result['status'] = true;
          }else{
              $result['status'] = false;
          }
      }


      header('Content-Type: application/json');
      header('Access-Control-Allow-Origin: ' . base_url());
      header('Access-Control-Allow-Methods: GET, POST');
      header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
      print json_encode($result);
      exit();
  }

}
