<?php

class Index extends MY_Controller {
    public $pagedata;
    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        ($this->require_min_level(1));
        $this->pagedata['link']= 'tasks';
        $this->load->model(array(
            'task/TaskModel'=>'taskModel',
            'hrm/Employees'=>'employeesModel',
        ));
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
        $this->load->helper('task/task_helper');
    }

    public function index() {
        has_control('employee_view_all','View all employees');
        $this->pagedata['link'] = 'Task Manager';
        $this->pagedata['projects'] = $this->taskModel->projects();
        $this->pagedata['projecttask'] = $this->taskModel->projectsTask();
        $this->pagedata['fprojects'] = $this->taskModel->finished_projects();
        $this->pagedata['oprojects'] = $this->taskModel->ongoing_projects();
        $this->pagedata['tasks'] = $this->taskModel->tasks();
        $this->pagedata['tasksme'] = $this->taskModel->tasksbyme($this->auth_user_id);
        $this->pagedata['tasksmecount'] = $this->taskModel->tasksbymenumber($this->auth_user_id);
        $this->pagedata['ongoingmecount'] = $this->taskModel->ongoingbymenumber($this->auth_user_id);
        $this->pagedata['completemecount'] = $this->taskModel->completebymenumber($this->auth_user_id);
        $this->pagedata['privatecount'] = $this->taskModel->privatemenumber($this->auth_user_id);
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['title'] = 'Task Manager | TM '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('task/tasks');
    }

    public function selftask() {
        $this->load->helper('form');
        $this->pagedata['link'] = 'Task Manager';
        $this->pagedata['title'] = 'Task Manager | TM '.$this->config->item('application_name');
        $this->pagedata['projects'] = $this->taskModel->projects();
        $this->pagedata['projecttask'] = $this->taskModel->projectsTask();
        $this->pagedata['fprojects'] = $this->taskModel->finished_projects();
        $this->pagedata['oprojects'] = $this->taskModel->ongoing_projects();
        $this->pagedata['freight_tasks'] = $this->taskModel->freight_tasksbyme($this->auth_user_id);
        $this->pagedata['tasksme'] = $this->taskModel->tasksbyme($this->auth_user_id);
        $this->pagedata['tasksmecount'] = $this->taskModel->tasksbymenumber($this->auth_user_id);
        $this->pagedata['ongoingmecount'] = $this->taskModel->ongoingbymenumber($this->auth_user_id);
        $this->pagedata['completemecount'] = $this->taskModel->completebymenumber($this->auth_user_id);
        $this->pagedata['privatecount'] = $this->taskModel->privatemenumber($this->auth_user_id);
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->load->vars($this->pagedata);
        $this->load->view('task/tasksemployee');
    }

    public function create() {
        //has_control('task_view_all','View all task');
        $this->load->helper('form');
        $this->pagedata['link'] = 'newtask';

        if($this->tokens->match) {
            $this->db->trans_start();
            $mainTask = array(
                'task_business_key' => $this->business,
                'task_key' => $this->taskModel->taskKey(),
                'task_project_key' => $this->input->post('task_project_key',TRUE),
                'task_start' => $this->input->post('task_start', TRUE),
                'task_deadline' => $this->input->post('task_deadline', TRUE),
                'task_desc' => $this->input->post('task_desc',TRUE),
                'task_mode' => $this->input->post('task_mode',TRUE),
                'task_date_created' => date('Y-m-d H:i:s'),
                'task_created_by' => $this->auth_user_id,
            );
             $this->taskModel->createTasks($mainTask);

            $this->db->trans_complete();
            if ($this->db->trans_status() === TRUE) {
                $this->pagedata['form_action'] = TRUE;
                $this->pagedata['form_message'] = "Congratulation! Task created successfully";
                $this->pagedata['form_class'] = "success";
            } else {
                $this->pagedata['form_action'] = FALSE;
                $this->pagedata['form_message'] = "We could not process request successfully please try again later";
                $this->pagedata['form_class'] = "danger";
            }
        }

        $this->pagedata['projects'] = $this->taskModel->projects();
        $this->pagedata['projecttask'] = $this->taskModel->projectsTask();
        $this->pagedata['fprojects'] = $this->taskModel->finished_projects();
        $this->pagedata['tasks'] = $this->taskModel->tasks();
        $this->pagedata['tasksme'] = $this->taskModel->tasksbyme($this->auth_user_id);
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['title'] = 'Task Manager | TM '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('task/new_tasks');
    }

    public function viewMyTask() {
        $this->pagedata['tasks'] = $this->taskModel->tasksbyme($this->auth_user_id);
        $this->pagedata['title'] = 'Task Manager | TM '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('task/mytasks');
    }

    public function mytask() {
        $this->load->model(array('profile/profileModel'=>'profileModel'));
        $this->load->helper('form');
        $this->pagedata['title'] = 'My Task |'.$this->config->item('application_name');
        $this->pagedata['freight_tasks'] = $this->taskModel->freight_tasksbyme($this->auth_user_id);
        $this->pagedata['freight_ongoingme'] = $this->taskModel->freight_ongoingbyme($this->auth_user_id);
        $this->pagedata['freight_completeme'] = $this->taskModel->freight_completebyme($this->auth_user_id);
        $this->pagedata['tasksme'] = $this->taskModel->tasksbyme($this->auth_user_id);
        $this->pagedata['ongoingme'] = $this->taskModel->ongoingbyme($this->auth_user_id);
        $this->pagedata['completeme'] = $this->taskModel->completebyme($this->auth_user_id);
        $this->pagedata['privatecount'] = $this->taskModel->privatemenumber($this->auth_user_id);
        $this->pagedata['profile']= $this->profileModel->profile($this->auth_user_id);
        $this->load->vars($this->pagedata);
        $this->load->view('task/employee_tasks');
    }

    function newTask(){
        $task['task_key'] = $this->taskModel->taskKey();
        $task['task_business_key'] = $this->business;
        $task['task_created_by'] = $this->auth_user_id;
        $task['task_project_key'] = $this->input->get('task_project_key',TRUE);
        $task['task_desc'] = $this->input->get('task_desc',TRUE);
        $task['task_mode'] = $this->input->get('task_mode',TRUE);
        $task['task_deadline'] = $this->input->get('task_deadline',TRUE);
        $task['task_date_created'] = date('Y-m-d');
        $task['task_time_created'] = $this->input->get('task_time_created',TRUE);
        $employee= $this->input->get('employees', TRUE);
        if($this->taskModel->createTask($task,$employee)){
            $result['status'] = 'ok';
            $result['message'] = 'Task registered successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function modifyTask($taskKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['projects'] = $this->taskModel->projects();
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['task'] = $this->taskModel->select_one_task($taskKey);
        $this->load->vars($this->pagedata);
        $this->load->view('task/taskModify');
    }

    function updateTask($taskKey=''){
        $data['task_project_key'] = $this->input->get('task_project_key',TRUE);
        $data['task_deadline'] = $this->input->get('task_deadline',TRUE);
        $data['task_mode'] = $this->input->get('task_mode',TRUE);
        $data['task_desc'] = $this->input->get('task_desc',TRUE);
        $employee= $this->input->get('employees', TRUE);
        if($this->taskModel->taskUpdate($taskKey,$data,$employee)){
            $result['status'] = 'ok';
            $result['message'] = 'Task updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function deleteTasks($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'task':
                if($this->taskModel->deleteTask($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Task deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

    public function taskDetails($key='') {
        $this->load->helper('form');
        $this->pagedata['link']= 'tasks';
        $this->pagedata['title'] = 'Task | '.$this->config->item('application_name');
        $this->pagedata['data'] = $this->taskModel->select_one_task($key);
        $this->pagedata['comment'] = $this->taskModel->comment_task($key);
        $this->pagedata['tasksmecount'] = $this->taskModel->tasksbymenumber($this->auth_user_id);
        $this->pagedata['ongoingmecount'] = $this->taskModel->ongoingbymenumber($this->auth_user_id);
        $this->pagedata['completemecount'] = $this->taskModel->completebymenumber($this->auth_user_id);
        $this->pagedata['privatecount'] = $this->taskModel->privatemenumber($this->auth_user_id);
        $this->load->vars($this->pagedata);
        $this->load->view('task/task_details');
    }

    public function allTaskDetails($key='') {
        $this->load->helper('form');
        $this->pagedata['link']= 'tasks';
        $this->pagedata['title'] = 'Task Details | '.$this->config->item('application_name');
        $this->pagedata['tasksme'] = $this->taskModel->tasksbyme($this->auth_user_id);
        $this->pagedata['tasksmecount'] = $this->taskModel->tasksbymenumber($this->auth_user_id);
        $this->pagedata['ongoingmecount'] = $this->taskModel->ongoingbymenumber($this->auth_user_id);
        $this->pagedata['completemecount'] = $this->taskModel->completebymenumber($this->auth_user_id);
        $this->pagedata['privatecount'] = $this->taskModel->privatemenumber($this->auth_user_id);
        $this->pagedata['data'] = $this->taskModel->select_one_task($key);
        $this->pagedata['comment'] = $this->taskModel->comment_task($key);
        $this->pagedata['subtask'] = $this->taskModel->subTask($key);
        $this->pagedata['projecttask'] = $this->taskModel->projectsTask();
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->load->vars($this->pagedata);
        $this->load->view('task/tasks_more');
    }

    public function allFreightTaskDetails($key='') {
        $this->load->helper('form');
        $this->pagedata['link']= 'tasks';
        $this->pagedata['title'] = 'Task Details | '.$this->config->item('application_name');
        $this->pagedata['tasksme'] = $this->taskModel->tasksbyme($this->auth_user_id);
        $this->pagedata['tasksmecount'] = $this->taskModel->tasksbymenumber($this->auth_user_id);
        $this->pagedata['ongoingmecount'] = $this->taskModel->ongoingbymenumber($this->auth_user_id);
        $this->pagedata['completemecount'] = $this->taskModel->completebymenumber($this->auth_user_id);
        $this->pagedata['privatecount'] = $this->taskModel->privatemenumber($this->auth_user_id);
        $this->pagedata['data'] = $this->taskModel->select_one_task_freight($key);
        $this->pagedata['comment'] = $this->taskModel->comment_freight_task($key);
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->load->vars($this->pagedata);
        $this->load->view('freight/freight_tasks_more');
    }

    function commentTask(){
        $task['comment_task_key'] = $this->input->get('comment_task_key',TRUE);
        $task['comment_task_comment'] = $this->input->get('comment_task_comment',TRUE);
        $task['comment_user_id'] = $this->auth_user_id;
        if($this->taskModel->commentTask($task)){
            $result['status'] = 'ok';
            $result['message'] = 'Comment posted successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function commentFreightTask(){
        $task['comment_task_key'] = $this->input->get('comment_task_key',TRUE);
        $task['comment_task_comment'] = $this->input->get('comment_task_comment',TRUE);
        $task['comment_user_id'] = $this->auth_user_id;
        if($this->taskModel->commentFreightTask($task)){
            $result['status'] = 'ok';
            $result['message'] = 'Comment posted successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function startTask($task){
        if($this->taskModel->startTask($task,['task_status'=>'OnProgress'])){
            $result['status'] = 'ok';
            $result['message'] = 'Task started successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function setTaskPending($task){
        $data['task_det_task_status'] = 'Pending';
        $data['task_det_task_percent'] = '0';
        if($this->taskModel->startTaskEmployee($task,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Task changed successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function setFreightTaskPending($task){
        $data['freight_task_status'] = 'Pending';
        $data['freight_task_percent'] = '0';
        if($this->taskModel->startFreightTaskEmployee($task,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Task on pending successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function pauseTask($task){
        if($this->taskModel->startTask($task,['task_status'=>'Paused'])){
            $result['status'] = 'ok';
            $result['message'] = 'Task paused successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function finishTask($task){
        if($this->taskModel->startTask($task,['task_status'=>'Completed'])){
            $result['status'] = 'ok';
            $result['message'] = 'Task completed successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function finishFreightTask($task){
        $data['freight_task_status'] = 'Completed';
        $data['freight_task_percent'] = '100';
        if($this->taskModel->finishFreightTaskEmployee($task,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Task completed successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function finishTaskAdmin($taskKey){
        $data['task_status'] = 'Completed';
        $subtask= $this->taskModel->subTask($taskKey);
        if($this->taskModel->adminFinishTask($taskKey,$data,$subtask)){
            $result['status'] = 'ok';
            $result['message'] = 'Task Ended successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    //--------------------MODIFY----------------//

    function modify($key='') {
        $this->load->helper('form');
        $this->pagedata['title'] = 'Task Manager | TM '.$this->config->item('application_name');
        if($this->tokens->match) {
            $this->db->trans_start();
            $tasks = array(
                'task_project_key' => $this->input->post('task_project_key',TRUE),
                'task_start' => $this->input->post('task_start', TRUE),
                'task_deadline' => $this->input->post('task_deadline', TRUE),
                'task_desc' => $this->input->post('task_desc',TRUE),
                'task_status' => $this->input->post('task_status',TRUE),
                'task_mode' => $this->input->post('task_mode',TRUE),
            );

            $this->taskModel->update($key,$tasks);
            $this->db->trans_complete();
            if ($this->db->trans_status() === TRUE) {
                $this->pagedata['form_action'] = TRUE;
                $this->pagedata['form_message'] = "Congratulation! Task updated successfully";
                $this->pagedata['form_class'] = "success";
            } else {
                $this->pagedata['form_action'] = FALSE;
                $this->pagedata['form_message'] = "We could not process request successfully please try again later";
                $this->pagedata['form_class'] = "danger";
            }
        }
        $this->pagedata['projects'] = $this->taskModel->projects();
        $this->pagedata['projecttask'] = $this->taskModel->projectsTask();
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['task'] = $this->taskModel->select_one_task($key);
        $this->pagedata['items']= $this->taskModel->select_item($key);
        $this->pagedata['subtask'] = $this->taskModel->subTask($key);
        $this->load->vars($this->pagedata);
        $this->load->view('task/modify');
    }

    //--------------------TASK ABOUT EMPLOYEE--------------//

    public function taskPending() {
        $this->load->helper('form');
        $this->pagedata['title'] = 'My Pending Task |'.$this->config->item('application_name');
        $this->pagedata['tasksme'] = $this->taskModel->tasksbyme($this->auth_user_id);
        $this->pagedata['freight_tasks'] = $this->taskModel->freight_tasksbyme($this->auth_user_id);
        $this->load->vars($this->pagedata);
        $this->load->view('task/pending_tasks');
    }

    public function taskOngoing() {
        $this->load->helper('form');
        $this->pagedata['title'] = 'My Pending Task |'.$this->config->item('application_name');
        $this->pagedata['ongoingme'] = $this->taskModel->ongoingbyme($this->auth_user_id);
        $this->pagedata['freight_ongoingtasks'] = $this->taskModel->freight_ongoingbyme($this->auth_user_id);
        $this->load->vars($this->pagedata);
        $this->load->view('task/ongoing_tasks');
    }

    public function taskCompleted() {
        $this->load->helper('form');
        $this->pagedata['title'] = 'My Complete Tasks |'.$this->config->item('application_name');
        $this->pagedata['completeme'] = $this->taskModel->completebyme($this->auth_user_id);
        $this->pagedata['freight_completetasks'] = $this->taskModel->freight_completebyme($this->auth_user_id);
        $this->load->vars($this->pagedata);
        $this->load->view('task/completed_tasks');
    }

    public function modifyTaskEmployee($taskKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['projects'] = $this->taskModel->projects();
        $this->pagedata['task'] = $this->taskModel->select_one_task_employee($taskKey);
        $this->load->vars($this->pagedata);
        $this->load->view('task/taskemployeeModify');
    }

    public function modifyTaskFreightEmployee($taskKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['task'] = $this->taskModel->select_one_task_freight($taskKey);
        $this->load->vars($this->pagedata);
        $this->load->view('task/taskemployeeFreightModify');
    }


    public function modifyFreightTaskEmployee($taskKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['task'] = $this->taskModel->select_one_task_freight($taskKey);
        $this->load->vars($this->pagedata);
        $this->load->view('task/taskfreightModify');
    }


    public function modifySubTaskAdmin($taskKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['projects'] = $this->taskModel->projects();
        $this->pagedata['task'] = $this->taskModel->select_one_task_employee($taskKey);
        $this->load->vars($this->pagedata);
        $this->load->view('task/taskAdminModify');
    }

    function updateEmployeeTask($taskKey=''){
        $data['task_det_task_percent'] = $this->input->get('task_det_task_percent',TRUE);
        $data['task_det_task_desc'] = $this->input->get('task_det_task_desc',TRUE);
        if($this->taskModel->taskEmployeeUpdate($taskKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Task updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function updateFreightEmployeeTask($taskKey=''){
        $data['freight_task_percent'] = $this->input->get('freight_task_percent',TRUE);
        $data['freight_task_desc'] = $this->input->get('freight_task_desc',TRUE);
        if($this->taskModel->taskFreightEmployeeUpdate($taskKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Task Percent updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function updateEmployeeFreightTask($taskKey=''){
        $data['freight_task_percent'] = $this->input->get('freight_task_percent',TRUE);
        $data['freight_task_desc'] = $this->input->get('freight_task_desc',TRUE);
        if($this->taskModel->taskEmployeeFreightUpdate($taskKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Task updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function newSubTask(){
        $subtask['task_det_task_emp'] = $this->input->get('task_det_task_emp',TRUE);
        $subtask['task_det_task_mode'] = $this->input->get('task_det_task_mode',TRUE);
        $subtask['task_det_task_desc'] = $this->input->get('task_det_task_desc',TRUE);
        $subtask['task_det_task_start'] = $this->input->get('task_det_task_start',TRUE);
        $subtask['task_det_task_deadline'] = $this->input->get('task_det_task_deadline',TRUE);
        $subtask['task_det_project_key'] = $this->input->get('task_det_project_key',TRUE);
        $subtask['task_det_task_key'] = $this->input->get('task_det_task_key',TRUE);
        $subtask['task_det_task_created_by'] = $this->auth_user_id;
        $subtask['task_det_task_date_created'] = date('Y-m-d H:i:s');
        if($this->taskModel->createSubTask($subtask)){
            $result['status'] = 'ok';
            $result['message'] = 'Sub-Task added successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function startEmployeeTask($task){
        if($this->taskModel->startTaskEmployee($task,['task_det_task_status'=>'OnProgress'])){
            $result['status'] = 'ok';
            $result['message'] = 'Task started successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function startEmployeeFreightTask($task){
        if($this->taskModel->startFreightTaskEmployee($task,['freight_task_status'=>'OnProgress'])){
            $result['status'] = 'ok';
            $result['message'] = 'Task started successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function finishEmployeeTask($taskKey=''){
        $data['task_det_task_status'] = 'Completed';
        $data['task_det_task_percent'] = '100';
        if($this->taskModel->taskEmployeeUpdate($taskKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Task finished successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function finishFreightEmployeeTask($taskKey=''){
        $data['freight_task_status'] = 'Completed';
        $data['freight_task_percent'] = '100';
        if($this->taskModel->taskFreightEmployeeUpdate($taskKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Task finished successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    //---------PRIVATE NOTE-------------//

    function newNote(){
        $note['pri_note_created_by'] = $this->auth_user_id;
        $note['pri_note_project_key'] = $this->input->get('pri_note_project_key',TRUE);
        $note['pri_note_desc'] = $this->input->get('pri_note_desc',TRUE);
        $note['pri_note_mode'] = $this->input->get('pri_note_mode',TRUE);
        $note['pri_note_deadline'] = $this->input->get('pri_note_deadline',TRUE);
        $note['pri_note_date_created'] = date('Y-m-d H:i:s');
        $note['pri_note_time_created'] = $this->input->get('pri_note_time_created',TRUE);
        if($this->taskModel->createNote($note)){
            $result['status'] = 'ok';
            $result['message'] = 'Note saved successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function privateTask() {
        $this->load->helper('form');
        $this->pagedata['title'] = 'My Complete Tasks |'.$this->config->item('application_name');
        $this->pagedata['private'] = $this->taskModel->privateTask($this->auth_user_id);
        $this->load->vars($this->pagedata);
        $this->load->view('task/private_tasks');
    }

    public function deleteNote($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'note':
                if($this->taskModel->deleteNote($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Private Task deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }


}