<?php

class IndexOld extends MY_Controller {
    public $pagedata;
    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        ($this->require_min_level(1));
        $this->pagedata['link']= 'tasks';
        $this->load->model(array(
            'task/TaskModel'=>'taskModel',
            'hrm/Employees'=>'employeesModel',
        ));
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
        $this->load->helper('task/task_helper');
    }

    public function index() {
        has_control('employee_view_all','View all employees');
        $this->pagedata['link'] = 'Task Manager';
        $this->pagedata['projects'] = $this->taskModel->projects();
        $this->pagedata['projecttask'] = $this->taskModel->projectsTask();
        $this->pagedata['fprojects'] = $this->taskModel->finished_projects();
        $this->pagedata['tasks'] = $this->taskModel->tasks();
        $this->pagedata['tasksme'] = $this->taskModel->tasksbyme($this->auth_user_id);
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['title'] = 'Task Manager | TM '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('task/tasks');
    }

    public function viewMyTask() {
        $this->pagedata['tasks'] = $this->taskModel->tasksbyme($this->auth_user_id);
        $this->pagedata['title'] = 'Task Manager | TM '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('task/mytasks');
    }

    function newTask(){
        $task['task_key'] = $this->taskModel->taskKey();
        $task['task_business_key'] = $this->business;
        $task['task_created_by'] = $this->auth_user_id;
        $task['task_project_key'] = $this->input->get('task_project_key',TRUE);
        $task['task_desc'] = $this->input->get('task_desc',TRUE);
        $task['task_mode'] = $this->input->get('task_mode',TRUE);
        $task['task_deadline'] = $this->input->get('task_deadline',TRUE);
        $task['task_date_created'] = date('Y-m-d');
        $task['task_time_created'] = $this->input->get('task_time_created',TRUE);
        $employee= $this->input->get('employees', TRUE);
        if($this->taskModel->createTask($task,$employee)){
            $result['status'] = 'ok';
            $result['message'] = 'Task registered successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function modifyTask($taskKey='') {
        //if (!$this->input->is_ajax_request())
        //    exit('not direct script allowed');
        $this->pagedata['projects'] = $this->taskModel->projects();
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['task'] = $this->taskModel->select_one_task($taskKey);
        $this->load->vars($this->pagedata);
        $this->load->view('task/taskModify');
    }

    function updateTask($taskKey=''){
        $data['task_project_key'] = $this->input->get('task_project_key',TRUE);
        $data['task_deadline'] = $this->input->get('task_deadline',TRUE);
        $data['task_mode'] = $this->input->get('task_mode',TRUE);
        $data['task_desc'] = $this->input->get('task_desc',TRUE);
        $employee= $this->input->get('employees', TRUE);
        if($this->taskModel->taskUpdate($taskKey,$data,$employee)){
            $result['status'] = 'ok';
            $result['message'] = 'Task updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function deleteTasks($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'task':
                if($this->taskModel->deleteTask($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Task deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

    public function taskDetails($key='') {
        $this->load->helper('form');
        $this->pagedata['link']= 'tasks';
        $this->pagedata['title'] = 'Task | '.$this->config->item('application_name');
        $this->pagedata['data'] = $this->taskModel->select_one_task($key);
        $this->pagedata['comment'] = $this->taskModel->comment_task($key);
        $this->load->vars($this->pagedata);
        $this->load->view('task/task_details');
    }

    function commentTask(){
        $task['comment_task_key'] = $this->input->get('comment_task_key',TRUE);
        $task['comment_task_comment'] = $this->input->get('comment_task_comment',TRUE);
        $task['comment_user_id'] = $this->auth_user_id;
        if($this->taskModel->commentTask($task)){
            $result['status'] = 'ok';
            $result['message'] = 'Comment posted successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function startTask($task){
        if($this->taskModel->startTask($task,['task_status'=>'OnProgress'])){
            $result['status'] = 'ok';
            $result['message'] = 'Task started successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function pauseTask($task){
        if($this->taskModel->startTask($task,['task_status'=>'Paused'])){
            $result['status'] = 'ok';
            $result['message'] = 'Task paused successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function finishTask($task){
        if($this->taskModel->startTask($task,['task_status'=>'Completed'])){
            $result['status'] = 'ok';
            $result['message'] = 'Task completed successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

}