<?php

    function accountBalanceDebit($account,$dates=''){
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $lm =& get_instance();
        if(!empty($dates['start_date'])){
            $lm->db->where('gl_date >= ',$dates['start_date']);
        }
        if(!empty($dates['end_date'])){
            $lm->db->where('gl_date <= ',$dates['end_date']);
        }
        $query = $lm->db->select_sum( 'gl_debit')
            ->where( 'gl_account',$account)
            ->where('gl_business',$business)
            ->where('gl_branch',$branch)
            ->from('accounting_general_ledger')
            ->get();
        return ($query->num_rows()>0)? $query->row()->gl_debit : 0;
    }


    function accountBalanceCredit($account,$dates=''){
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $lm =& get_instance();
        if(!empty($dates['start_date'])){
            $lm->db->where('gl_date >= ',$dates['start_date']);
        }
        if(!empty($dates['end_date'])){
            $lm->db->where('gl_date <= ',$dates['end_date']);
        }
        $query = $lm->db->select_sum( 'gl_credit')
            ->where( 'gl_account',$account)
            ->where('gl_business',$business)
            ->where('gl_branch',$branch)
            ->from('accounting_general_ledger')
            ->get();
        return ($query->num_rows()>0)? $query->row()->gl_credit : 0;
    }

    function accountBalance($account,$dates = ''){
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $lm =& get_instance();
        $query = $lm->db->select('*')
            ->where( 'account_id',$account)
            ->where('account_business',$business)
            ->join('account_types','account_types'.'.actype_id='.'accounting_accounts'.'.account_type','left')
            ->get('accounting_accounts');
        $acc =  ($query->num_rows()>0)? $query->row() : false;
        if($acc == false ){
            return 0;
        }

        switch (strtolower($acc->actype_text)){
            case "current_assets":
                $balance = accountBalanceDebit($account,$dates) - accountBalanceCredit($account,$dates);
                return $balance;
                break;
            case "income":
                $balance = accountBalanceDebit($account,$dates) - accountBalanceCredit($account,$dates);
                return $balance;
                break;
            case "revenue":
                $balance = accountBalanceDebit($account,$dates) - accountBalanceCredit($account,$dates);
                return $balance;
                break;
            case "receivable":
                $balance = accountBalanceDebit($account,$dates) - accountBalanceCredit($account,$dates);
                return $balance;
                break;
            case "cash":
                $balance = accountBalanceDebit($account,$dates) - accountBalanceCredit($account,$dates);
                return $balance;
                break;
            case "expense":
                $balance = accountBalanceCredit($account,$dates) - accountBalanceDebit($account,$dates);
                return $balance;
                break;
            default:
                return 0;
                break;
        }
    }
