<?php
function get_status($status){
    if(strtolower($status) == "denied"){
        return "Decline";
    }else{
        return $status;
    }
}
function invoice_address(){?>
    <a href="#"><img style="height: 100%;" src="<?php echo base_url('resources/')?>assets/images/rurutz-logo.PNG"></a><br>
    <span class="kt-invoice__desc">
            <span>5th Floor Ubungo Plaza, </span>
            <span> P. O. Box 79910, Morogoro Rd</span>
            <span> Dar es Salaam, Tanzania</span>
            <span> Mobile: (255)-756-75-75-75 | Telephone: (255)-22-246-2099 | Fax: (255)-22-246-2099</span>
            <span> info@cmtl.co.tz</span>
        </span>
<?php }


function display_address(){?>
    <a href="#"><img style="height: 100%;" src="<?php echo base_url('resources/')?>assets/images/rurutz-logo.PNG"></a><br>
    <span class="kt-invoice__desc">
            <span>5th Floor Ubungo Plaza, </span>
            <span> P. O. Box 79910, Morogoro Rd</span>
            <span> Dar es Salaam, Tanzania</span>
            <span> Mobile: (255)-756-75-75-75 | Telephone: (255)-22-246-2099 | Fax: (255)-22-246-2099</span>
            <span> info@cmtl.co.tz</span>
        </span>
<?php }

function commUnreadInbox() {
    /** This function returns a number of unread messages of user inbox in Communication **/
    /** @author Elieza Kalaita **/
    $comm =& get_instance();
    $key = profile()->user_key;
    $comm->db->where('receiver_id', $key);
    $comm->db->where('msg_status', 'unread');
    $comm->db->where('is_receiver_deleted', 0);
    $comm->db->where('is_receiver_recycle', 0);
    $num_rows = $comm->db->count_all_results('comm_inbox');
    return $num_rows;
}

function commUnreadReply() {
    /** This function returns a number of unread message replies of user inbox in Communication **/
    /** @author Elieza Kalaita **/
    $comm =& get_instance();
    $key = profile()->user_key;
    $comm->db->where('receiver_id', $key);
    $comm->db->where('is_receiver_deleted', 0);
    $comm->db->where('is_receiver_recycle', 0);
    $comm->db->where('rep_status', 'unread');
    $comm->db->where('rep_created_by !=', $key);
    $comm->db->where('rep_deleted', 0);
    $comm->db->join('comm_reply rep', 'rep.rep_msg_key=msg_key');
    $num_rows = $comm->db->count_all_results('comm_inbox');
    return $num_rows;
}

function commUnreadReplySender() {
    /** This function returns a number of unread message replies of user inbox in Communication where the sender is the receiver **/
    /** @author Elieza Kalaita **/
    $comm =& get_instance();
    $key = profile()->user_key;
    $comm->db->where('sender_id', $key);
    $comm->db->where('is_sender_deleted', 0);
    $comm->db->where('is_sender_recycle', 0);
    $comm->db->where('msg_replied', 1);
    $comm->db->where('rep_status', 'unread');
    $comm->db->where('rep_created_by !=', $key);
    $comm->db->where('rep_deleted', 0);
    $comm->db->join('comm_reply rep', 'rep.rep_msg_key=msg_key');
    $num_rows = $comm->db->count_all_results('comm_inbox');
    return $num_rows;
}

function totalUnreadMessages(){
    /** This function returns a badge with a sum of user unread messages and their replies in Communication **/
    /** @author Elieza Kalaita **/
    $inbox = commUnreadInbox();
    $reply_receiver = commUnreadReply();
    $reply_sender = commUnreadReplySender();
    $total = $inbox + $reply_receiver + $reply_sender;
    if($total > 0){?>
        <span class="kt-inbox__label kt-badge kt-badge--unified-danger kt-badge--bold kt-badge--inline">
    <?php echo $total." Unread "; ?>
    </span><?php }
}

function countTasks($key) {
    /** This function returns a total tasks assigned on file (Freight Forwarding) **/
    /** @author Elieza Kalaita **/
    $spt =& get_instance();
    $spt->db->where('freight_task_freight_key', $key);
    $num_rows = $spt->db->count_all_results('freight_task');
    if($num_rows > 0)
    {
        echo $num_rows;
    }
    else
    {
        echo 0;
    }
}

function countPettyRequests($key) {
    /** This function returns a total petty cash requests on a file (Freight Forwarding) **/
    /** @author Elieza Kalaita **/
    $spt =& get_instance();
    $spt->db->where('petty_request_file_number', $key);
    $num_rows = $spt->db->count_all_results('petty_request');
    if($num_rows > 0)
    {
        echo $num_rows;
    }
    else
    {
        echo 0;
    }
}

function getUnapprovedRequests(){
    /** This function returns a badge with a number of unapproved petty requests (Freight Forwarding) */
    /** @author Elieza Kalaita */
    $petty =& get_instance();
    $petty->db->where('petty_request_status', 'UnApproved');
    $num_rows = $petty->db->count_all_results('petty_request');
    if($num_rows > 0){?>
        <span class="kt-inbox__label kt-badge kt-badge--unified-danger kt-badge--bold kt-badge--inline">
        <?php echo $num_rows." Pending"; ?>
        </span><?php }
}

function get_intl_number($input){
    $number = strval($input);
    $final = $number;
    if($number[0] == "0"){
        $final = "255".ltrim($number,"0");
    }
    if($number[0] == "+"){
        $final = ltrim($number,"+");
    }
    return $final;
}

function get_intl_number_with_code($input,$code){

    $number = strval($input);

    $final = $number;

    if($number[0] == "0"){
        $final = $code.ltrim($number,"0");
    }

    if($number[0] == "+"){
        $final = ltrim($number,"+");
    }

    return $final;

}

function validMyEvents($user='',$action_code=''){
    $bms =& get_instance();
    $bms->db->select('action_code');
    $bms->db->where('user_id',$user);
    $bms->db->where('action_code',$action_code);
    $bms->db->join('acl_actions aa','aa.action_id=acl.action_id','both');
    $query = $bms->db->get('acl');
    if($query->num_rows()>0){
        return true;
    }else{
        return false;
    }
}

function validEvents($user){
    $bms =& get_instance();
    $branch = runningBranch()->branch_key;
    $business = runningBusiness()->business_key;
    $bms->db->select('action_code');
    $bms->db->where('branch',$branch);
    $bms->db->where('business',$business);
    $bms->db->where('user_id',$user);
    $bms->db->join('acl_actions aa','aa.action_id=acl.action_id','both');
    $query = $bms->db->get('acl');
    return $query->num_rows()>0 ? $query->result_array() : FALSE;
}

function filterNumber($mix){
    return preg_replace('/[^0-9]/', '', $mix);
}

function isAjax(){
    $lm =& get_instance();
    return $lm->input->is_ajax_request() ? TRUE : FALSE;
}

function lm_number($number){
    $lm =& get_instance();
    $decimal = 2;//$lm->configurationModel->loadConfigs()->config_decimal_places_display;
    return number_format($number,$decimal);
}

function lm_number_db($number){
    $lm =& get_instance();
    $decimal = 2;//$lm->configurationModel->loadConfigs()->config_decimal_places_display;
    return round($number,$decimal);
}


function timeAgo( $time )
{
    $time_difference = time() - strtotime($time);

    if( $time_difference < 1 ) { return 'less than 1 second ago'; }
    $condition = array( 12 * 30 * 24 * 60 * 60 =>  'year',
                30 * 24 * 60 * 60       =>  'month',
                24 * 60 * 60            =>  'day',
                60 * 60                 =>  'hour',
                60                      =>  'minute',
                1                       =>  'second'
    );

    foreach( $condition as $secs => $str )
    {
        $d = $time_difference / $secs;

        if( $d >= 1 )
        {
            $t = round( $d );
            return 'about ' . $t . ' ' . $str . ( $t > 1 ? 's' : '' ) . ' ago';
        }
    }
}

function educationLevels(){
    $lms =& get_instance();
    return $lms->db->get('education_levels')->result_array();
}

function profileMenu($breadcrumb =''){?>
    <div class="kt-subheader   kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title">
                    <button class="kt-subheader__mobile-toggle kt-subheader__mobile-toggle--left" id="kt_subheader_mobile_toggle"><span></span></button>
                    Settings
                </h3>
                <span class="kt-subheader__separator kt-hidden"></span>
               <?php echo $breadcrumb;?>
            </div>
        </div>
    </div>
<?php }

function paymentMethods(){
    $bms =& get_instance();
    $business = runningBusiness()->business_key;
    $branch = runningBranch()->branch_key;
    $bms->db->where('method_business',$business);
    $bms->db->where('method_branch',$branch);
    $query = $bms->db->get('payment_methods');
    return  $query->num_rows() > 0 ? $query->result_array() : false;
}

function nonemployees(){
    $lms =& get_instance();
    $lms->db->where('auth_level <',8);
    $lms->db->join('user_details u','u.details_user=users.user_id','left');
    $query = $lms->db->get('users');
    if(!empty($query && $query->num_rows()<0)){
        return $query->result_array();
    }else{
        return false;
    }
}

function customers(){
    $lms =& get_instance();
    $lms->db->select('*');
    $branch = runningBranch()->branch_key;
    $business = runningBusiness()->business_key;
    $lms->db->where('auth_level <',8);
    $lms->db->order_by('id','DESC');
    $lms->db->where('user_branch',$branch);
   // $lms->db->where('firstname !=',"");
    $lms->db->where('user_business',$business);
    $query = $lms->db
        ->join('users_details','users_details.user_key=users.user_id','left')
        ->join('customer_groups','customer_groups.group_key=users.user_group','left')
        ->get( 'users' );
    return $query->result_array();
}

function topToolBarActivities(){
    $bms =& get_instance();?>
    <!-- begin:: Content Head -->
    <div class="kt-subheader   kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
        <div class="kt-subheader__main">
            <h3 class="kt-subheader__title">Activities</h3>
            <span class="kt-subheader__separator kt-subheader__separator--v"></span>
            <span class="kt-subheader__desc"><?php echo runningBranch()->branch_name;?></span>
            <div class="kt-input-icon kt-input-icon--right kt-subheader__search ">
                <input type="text" class="form-control" placeholder="Search order..." id="generalSearch">
                <span class="kt-input-icon__icon kt-input-icon__icon--right">
          <span><i class="flaticon2-search-1"></i></span>
        </span>
            </div>
        </div>
        <div class="kt-subheader__toolbar">
            <div class="kt-subheader__wrapper">
                <?php lmDates();?>
            </div>
        </div>
        </div>
    </div>
<?php }

function rondomId($max){
    if(!empty($max)){
        return rondom(0,$max);
    }else{
        return rondom(0,5);
    }

}

function inputAllGet(){
  $lms =& get_instance();
  $get=$_GET;
  $data = array();
  foreach ($get as $key => $value) {
    array_push($data, $key);
  }
  unset($get);
  $basic = $lms->input->get($data,TRUE);
  return $basic;
}

function inputAllPost(){
  $lms =& get_instance();
  $get=$_POST;
  $data = array();
  foreach ($get as $key => $value) {
    array_push($data, $key);
  }
  unset($get);
  $basic = $lms->input->get($data,TRUE);
  return $basic;
}

function has_string($string,$str){
  if(preg_match("/{$string}/i", $str)) {
    return TRUE;
  }else{
    return FALSE;
  }
}

function usernames(){
  $lms =& get_instance();
  $lms->db->select('username');
  $lms->db->where('username!=','');
  return $lms->db->get('users')->result_array();
}

function employees(){
    $lms =& get_instance();
    $lms->db->where('auth_level >=',8);
    $lms->db->join('users_details','users_details.user_key=user_id','both');
    return $lms->db->get('users')->result_array();
}


function users(){
  $lms =& get_instance();
  $lms->db->join('users_details','users_details.user_key=user_id','both');
  return $lms->db->get('users')->result_array();
}

function branchCode($branchKey=''){
  $lms =& get_instance();
  $id = $lms->branchesModel->branch($branchKey)->branch_id;
  if(strlen($id) < 2){
    return '0'.$id;
  }else{
    return $id;
  }
}

function toNumber($string){
    return trim(str_ireplace(',', '',$string));
}

function inputNumber(){?>
    <script type="text/javascript">
        (function($, undefined) {
            "use strict";
            // When ready.
            $(function() {
                var $input = $( "input.number" );
                $input.on( "keyup", function( event ) {
                    // When user select text in the document, also abort.
                    var selection = window.getSelection().toString();
                    if ( selection !== '' ) {
                        return;
                    }
                    // When the arrow keys are pressed, abort.
                    if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
                        return;
                    }
                    var $this = $( this );
                    // Get the value.
                    var input = $this.val();
                    var input = input.replace(/[\D\s\._\-]+/g, "");
                    input = input ? parseInt( input, 10 ) : 0;
                    $this.val( function() {
                        return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
                    } );
                });
            });
        })(jQuery);
    </script>
<?php }

function in_array_r($needle, $haystack, $strict = false) {
    foreach ($haystack as $item) {
        if (($strict ? $item === $needle : $item == $needle) || (is_array($item) && in_array_r($needle, $item, $strict))) {
            return true;
        }
    }
    return false;
}


function rolename($role){
      switch ($role) {
          case 9:
              return 'Administrator';
              break;
          case 2:
              return 'Stockman';
              break;
          case 5:
              return 'Cashier';
              break;
          case 8:
              return 'Employee';
              break;
          default:
              return 'Unknown';
              break;
      }
  }


function uploadPath($path=''){
  return dirname(APPPATH).'/uploads/'.$path;
}

function writablePath($path=''){
    return dirname(APPPATH).'/writable/'.$path;
}

function writablePathUrl($path=''){
    return base_url().'/writable/'.$path;
}

function uploadFilePath($path){
  return base_url().'/uploads/'.$path;
}

function backupPath($path){
  return base_url().'/uploads/db_backup/'.$path;
}

function nbs($j =1){
  for ($i=0; $i < $j; $i++) {
    print '&nbsp';
  }
}

function product($key){
  $lm =& get_instance();
  return $lm->appModel->product($key);
}

function product_stock_level($key){
  $lm =& get_instance();
  return $lm->appModel->product_stock_level($key);
}

function product_buying_price($key){
  $lm =& get_instance();
  return $lm->appModel->product_buying_price($key);
}

function truck($key){
    $lm =& get_instance();
    return $lm->appModel->truck_get_single_detail($key);
}

function profile($key=""){

    if($key == '')
    $key = config_item('auth_user_id');

    $lm =& get_instance();
    $lm->db->join('users_details d','d.user_key=user_id','left')
    ->join('user_settings us','us.st_user=user_id','left')
    ->join('user_roles','user_roles.role_user=users.user_id','left')
    ->join('acl_categories','acl_categories.category_key=user_title','left');
    return $lm->appModel->profile($key);
}

function userdata($key=""){
    if($key == '')
        $key = config_item('auth_user_id');
    $lm =& get_instance();
    $lm->db->join('users_details d','d.user_key=user_id','left');
    $lm->db->join('acl_categories','acl_categories.category_key=user_title','left');
    return $lm->appModel->profile($key);
}

function profileSimple($key=""){
    if($key == '')
        $key = config_item('auth_user_id');
    $lm =& get_instance();
    return $lm->appModel->profile($key);
}

function to_money($money){
  $money = (double)str_ireplace(',','',$money);
    $unit = 1 * runnCurrency()->bs_conversion;
    $result =  $money * $unit;
    return round($result,config_item('display_decimal_places'));
}

function to_dollar($money){
  $money = (double)str_ireplace(',','',$money);
    $unit = 1 / runnCurrency()->bs_conversion;
    $result =  $money * $unit;
    return $result;
}

function runningBranch(){
  $lm =& get_instance();
  if(!empty($lm->session->branch)){
    $lm->load->model('branchesModel');
    return $lm->branchesModel->branch($lm->session->branch);
  }else{
    return $lm->branchesModel->branch();
  }
}

function runningBusiness(){
  $lm =& get_instance();
  if(!empty($lm->session->business)){
    $lm->load->model('businessModel');
    return $lm->businessModel->business($lm->session->business);
  }else{
    if(!empty(profileSimple()->user_business)){
      $business = profileSimple()->user_business;
      return $lm->businessModel->business($business);
    }
  }
}

function runnCurrency(){
  $lms =& get_instance();
  $business = profileSimple()->user_business;
  $lms->db->where('bs_business',$business);
  $query = $lms->db->get('business_currency');
  if($query->num_rows()>0){
      return $query->row();
  }else{
      return false;
  }
}

function topToolBarLocked($link=''){
    $bms =& get_instance();?>
    <!-- begin:: Content Head -->
    <div class="kt-subheader   kt-grid__item bg-warning" id="kt_subheader">
        <div class="kt-container kt-container--fluid">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title">Application <b>Locked</b></h3>
            </div>
        </div>
    </div>
<?php }


function metatags(){
  $tags[0] = ['name'=>'author', 'content'=>'Lockminds, Greenapp'];
  $tags[1] = ['name'=>'keywords', 'content'=>'ISP,Tanzania,Dar es salaam,Human Resource,Domains,Domain,Hosting,Webhosting,VPS,Reseller,Wordpress,Android,Ios,Sa
      les,Accounting,HR,Lockminds,Websites,Website'];
  $tags[3] = ['name'=>'description','content'=>'Lockminds Hosting Company'];
      if(!empty($tags)){
          foreach ($tags as $val) {?>
              <meta name="<?php echo $val['name'];?>" content="<?php echo $val['content'];?>">
        <?php  }
      }
 }

 function checkError($code){
    switch ($code) {
        case 1062:
            return '<span style="color:red"><b>FAILED!</b></span>, A record with the same value exists';
            break;
        case 1451:
            return '<span style="color:red"><b>FAILED!</b></span>, Because an item is releated with another item(s), try removing other item(s) first';
            break;
        default:
            return 'Action could not be completed ED#'.$code;
            break;
    }
}


function checkMysqlErrorWithCode(){
    $bms =& get_instance();
    $code = $bms->db->error();
    switch ($code['code']) {
        case 1062:
            return '<span style="color:red"><br/>A record with the same value exists</span>';
            break;
        case 1451:
            return '<span style="color:red"><br/>You can not remove a record because it being used by other parts in the system</span>';
            break;
        case 1054:
            return '<span style="color:red"><br/>'.$code['message'].'</span>';
            break;
        default:
            return '<span style="color:red">Action could not be completed</span>';
            break;
    }
}

function currencies(){
  $currenciesRaw = '[
                      {"cc":"AED","symbol":"\u062f.\u0625;","name":"UAE dirham"},
                      {"cc":"AFN","symbol":"Afs","name":"Afghan afghani"},
                      {"cc":"ALL","symbol":"L","name":"Albanian lek"},
                      {"cc":"AMD","symbol":"AMD","name":"Armenian dram"},
                      {"cc":"ANG","symbol":"NA\u0192","name":"Netherlands Antillean gulden"},
                      {"cc":"AOA","symbol":"Kz","name":"Angolan kwanza"},
                      {"cc":"ARS","symbol":"$","name":"Argentine peso"},
                      {"cc":"AUD","symbol":"$","name":"Australian dollar"},
                      {"cc":"AWG","symbol":"\u0192","name":"Aruban florin"},
                      {"cc":"AZN","symbol":"AZN","name":"Azerbaijani manat"},
                      {"cc":"BAM","symbol":"KM","name":"Bosnia and Herzegovina konvertibilna marka"},
                      {"cc":"BBD","symbol":"Bds$","name":"Barbadian dollar"},
                      {"cc":"BDT","symbol":"\u09f3","name":"Bangladeshi taka"},
                      {"cc":"BGN","symbol":"BGN","name":"Bulgarian lev"},
                      {"cc":"BHD","symbol":".\u062f.\u0628","name":"Bahraini dinar"},
                      {"cc":"BIF","symbol":"FBu","name":"Burundi franc"},
                      {"cc":"BMD","symbol":"BD$","name":"Bermudian dollar"},
                      {"cc":"BND","symbol":"B$","name":"Brunei dollar"},
                      {"cc":"BOB","symbol":"Bs.","name":"Bolivian boliviano"},
                      {"cc":"BRL","symbol":"R$","name":"Brazilian real"},
                      {"cc":"BSD","symbol":"B$","name":"Bahamian dollar"},
                      {"cc":"BTN","symbol":"Nu.","name":"Bhutanese ngultrum"},
                      {"cc":"BWP","symbol":"P","name":"Botswana pula"},
                      {"cc":"BYR","symbol":"Br","name":"Belarusian ruble"},
                      {"cc":"BZD","symbol":"BZ$","name":"Belize dollar"},
                      {"cc":"CAD","symbol":"$","name":"Canadian dollar"},
                      {"cc":"CDF","symbol":"F","name":"Congolese franc"},
                      {"cc":"CHF","symbol":"Fr.","name":"Swiss franc"},
                      {"cc":"CLP","symbol":"$","name":"Chilean peso"},
                      {"cc":"CNY","symbol":"\u00a5","name":"Chinese/Yuan renminbi"},
                      {"cc":"COP","symbol":"Col$","name":"Colombian peso"},
                      {"cc":"CRC","symbol":"\u20a1","name":"Costa Rican colon"},
                      {"cc":"CUC","symbol":"$","name":"Cuban peso"},
                      {"cc":"CVE","symbol":"Esc","name":"Cape Verdean escudo"},
                      {"cc":"CZK","symbol":"K\u010d","name":"Czech koruna"},
                      {"cc":"DJF","symbol":"Fdj","name":"Djiboutian franc"},
                      {"cc":"DKK","symbol":"Kr","name":"Danish krone"},
                      {"cc":"DOP","symbol":"RD$","name":"Dominican peso"},
                      {"cc":"DZD","symbol":"\u062f.\u062c","name":"Algerian dinar"},
                      {"cc":"EEK","symbol":"KR","name":"Estonian kroon"},
                      {"cc":"EGP","symbol":"\u00a3","name":"Egyptian pound"},
                      {"cc":"ERN","symbol":"Nfa","name":"Eritrean nakfa"},
                      {"cc":"ETB","symbol":"Br","name":"Ethiopian birr"},
                      {"cc":"EUR","symbol":"\u20ac","name":"European Euro"},
                      {"cc":"FJD","symbol":"FJ$","name":"Fijian dollar"},
                      {"cc":"FKP","symbol":"\u00a3","name":"Falkland Islands pound"},
                      {"cc":"GBP","symbol":"\u00a3","name":"British pound"},
                      {"cc":"GEL","symbol":"GEL","name":"Georgian lari"},
                      {"cc":"GHS","symbol":"GH\u20b5","name":"Ghanaian cedi"},
                      {"cc":"GIP","symbol":"\u00a3","name":"Gibraltar pound"},
                      {"cc":"GMD","symbol":"D","name":"Gambian dalasi"},
                      {"cc":"GNF","symbol":"FG","name":"Guinean franc"},
                      {"cc":"GQE","symbol":"CFA","name":"Central African CFA franc"},
                      {"cc":"GTQ","symbol":"Q","name":"Guatemalan quetzal"},
                      {"cc":"GYD","symbol":"GY$","name":"Guyanese dollar"},
                      {"cc":"HKD","symbol":"HK$","name":"Hong Kong dollar"},
                      {"cc":"HNL","symbol":"L","name":"Honduran lempira"},
                      {"cc":"HRK","symbol":"kn","name":"Croatian kuna"},
                      {"cc":"HTG","symbol":"G","name":"Haitian gourde"},
                      {"cc":"HUF","symbol":"Ft","name":"Hungarian forint"},
                      {"cc":"IDR","symbol":"Rp","name":"Indonesian rupiah"},
                      {"cc":"ILS","symbol":"\u20aa","name":"Israeli new sheqel"},
                      {"cc":"INR","symbol":"\u20B9","name":"Indian rupee"},
                      {"cc":"IQD","symbol":"\u062f.\u0639","name":"Iraqi dinar"},
                      {"cc":"IRR","symbol":"IRR","name":"Iranian rial"},
                      {"cc":"ISK","symbol":"kr","name":"Icelandic kr\u00f3na"},
                      {"cc":"JMD","symbol":"J$","name":"Jamaican dollar"},
                      {"cc":"JOD","symbol":"JOD","name":"Jordanian dinar"},
                      {"cc":"JPY","symbol":"\u00a5","name":"Japanese yen"},
                      {"cc":"KES","symbol":"KSh","name":"Kenyan shilling"},
                      {"cc":"KGS","symbol":"\u0441\u043e\u043c","name":"Kyrgyzstani som"},
                      {"cc":"KHR","symbol":"\u17db","name":"Cambodian riel"},
                      {"cc":"KMF","symbol":"KMF","name":"Comorian franc"},
                      {"cc":"KPW","symbol":"W","name":"North Korean won"},
                      {"cc":"KRW","symbol":"W","name":"South Korean won"},
                      {"cc":"KWD","symbol":"KWD","name":"Kuwaiti dinar"},
                      {"cc":"KYD","symbol":"KY$","name":"Cayman Islands dollar"},
                      {"cc":"KZT","symbol":"T","name":"Kazakhstani tenge"},
                      {"cc":"LAK","symbol":"KN","name":"Lao kip"},
                      {"cc":"LBP","symbol":"\u00a3","name":"Lebanese lira"},
                      {"cc":"LKR","symbol":"Rs","name":"Sri Lankan rupee"},
                      {"cc":"LRD","symbol":"L$","name":"Liberian dollar"},
                      {"cc":"LSL","symbol":"M","name":"Lesotho loti"},
                      {"cc":"LTL","symbol":"Lt","name":"Lithuanian litas"},
                      {"cc":"LVL","symbol":"Ls","name":"Latvian lats"},
                      {"cc":"LYD","symbol":"LD","name":"Libyan dinar"},
                      {"cc":"MAD","symbol":"MAD","name":"Moroccan dirham"},
                      {"cc":"MDL","symbol":"MDL","name":"Moldovan leu"},
                      {"cc":"MGA","symbol":"FMG","name":"Malagasy ariary"},
                      {"cc":"MKD","symbol":"MKD","name":"Macedonian denar"},
                      {"cc":"MMK","symbol":"K","name":"Myanma kyat"},
                      {"cc":"MNT","symbol":"\u20ae","name":"Mongolian tugrik"},
                      {"cc":"MOP","symbol":"P","name":"Macanese pataca"},
                      {"cc":"MRO","symbol":"UM","name":"Mauritanian ouguiya"},
                      {"cc":"MUR","symbol":"Rs","name":"Mauritian rupee"},
                      {"cc":"MVR","symbol":"Rf","name":"Maldivian rufiyaa"},
                      {"cc":"MWK","symbol":"MK","name":"Malawian kwacha"},
                      {"cc":"MXN","symbol":"$","name":"Mexican peso"},
                      {"cc":"MYR","symbol":"RM","name":"Malaysian ringgit"},
                      {"cc":"MZM","symbol":"MTn","name":"Mozambican metical"},
                      {"cc":"NAD","symbol":"N$","name":"Namibian dollar"},
                      {"cc":"NGN","symbol":"\u20a6","name":"Nigerian naira"},
                      {"cc":"NIO","symbol":"C$","name":"Nicaraguan c\u00f3rdoba"},
                      {"cc":"NOK","symbol":"kr","name":"Norwegian krone"},
                      {"cc":"NPR","symbol":"NRs","name":"Nepalese rupee"},
                      {"cc":"NZD","symbol":"NZ$","name":"New Zealand dollar"},
                      {"cc":"OMR","symbol":"OMR","name":"Omani rial"},
                      {"cc":"PAB","symbol":"B./","name":"Panamanian balboa"},
                      {"cc":"PEN","symbol":"S/.","name":"Peruvian nuevo sol"},
                      {"cc":"PGK","symbol":"K","name":"Papua New Guinean kina"},
                      {"cc":"PHP","symbol":"\u20b1","name":"Philippine peso"},
                      {"cc":"PKR","symbol":"Rs.","name":"Pakistani rupee"},
                      {"cc":"PLN","symbol":"z\u0142","name":"Polish zloty"},
                      {"cc":"PYG","symbol":"\u20b2","name":"Paraguayan guarani"},
                      {"cc":"QAR","symbol":"QR","name":"Qatari riyal"},
                      {"cc":"RON","symbol":"L","name":"Romanian leu"},
                      {"cc":"RSD","symbol":"din.","name":"Serbian dinar"},
                      {"cc":"RUB","symbol":"R","name":"Russian ruble"},
                      {"cc":"SAR","symbol":"SR","name":"Saudi riyal"},
                      {"cc":"SBD","symbol":"SI$","name":"Solomon Islands dollar"},
                      {"cc":"SCR","symbol":"SR","name":"Seychellois rupee"},
                      {"cc":"SDG","symbol":"SDG","name":"Sudanese pound"},
                      {"cc":"SEK","symbol":"kr","name":"Swedish krona"},
                      {"cc":"SGD","symbol":"S$","name":"Singapore dollar"},
                      {"cc":"SHP","symbol":"\u00a3","name":"Saint Helena pound"},
                      {"cc":"SLL","symbol":"Le","name":"Sierra Leonean leone"},
                      {"cc":"SOS","symbol":"Sh.","name":"Somali shilling"},
                      {"cc":"SRD","symbol":"$","name":"Surinamese dollar"},
                      {"cc":"SYP","symbol":"LS","name":"Syrian pound"},
                      {"cc":"SZL","symbol":"E","name":"Swazi lilangeni"},
                      {"cc":"THB","symbol":"\u0e3f","name":"Thai baht"},
                      {"cc":"TJS","symbol":"TJS","name":"Tajikistani somoni"},
                      {"cc":"TMT","symbol":"m","name":"Turkmen manat"},
                      {"cc":"TND","symbol":"DT","name":"Tunisian dinar"},
                      {"cc":"TRY","symbol":"TRY","name":"Turkish new lira"},
                      {"cc":"TTD","symbol":"TT$","name":"Trinidad and Tobago dollar"},
                      {"cc":"TWD","symbol":"NT$","name":"New Taiwan dollar"},
                      {"cc":"TZS","symbol":"TZS","name":"Tanzanian shilling"},
                      {"cc":"UAH","symbol":"UAH","name":"Ukrainian hryvnia"},
                      {"cc":"UGX","symbol":"USh","name":"Ugandan shilling"},
                      {"cc":"USD","symbol":"US$","name":"United States dollar"},
                      {"cc":"UYU","symbol":"$U","name":"Uruguayan peso"},
                      {"cc":"UZS","symbol":"UZS","name":"Uzbekistani som"},
                      {"cc":"VEB","symbol":"Bs","name":"Venezuelan bolivar"},
                      {"cc":"VND","symbol":"\u20ab","name":"Vietnamese dong"},
                      {"cc":"VUV","symbol":"VT","name":"Vanuatu vatu"},
                      {"cc":"WST","symbol":"WS$","name":"Samoan tala"},
                      {"cc":"XAF","symbol":"CFA","name":"Central African CFA franc"},
                      {"cc":"XCD","symbol":"EC$","name":"East Caribbean dollar"},
                      {"cc":"XDR","symbol":"SDR","name":"Special Drawing Rights"},
                      {"cc":"XOF","symbol":"CFA","name":"West African CFA franc"},
                      {"cc":"XPF","symbol":"F","name":"CFP franc"},
                      {"cc":"YER","symbol":"YER","name":"Yemeni rial"},
                      {"cc":"ZAR","symbol":"R","name":"South African rand"},
                      {"cc":"ZMK","symbol":"ZK","name":"Zambian kwacha"},
                      {"cc":"ZWR","symbol":"Z$","name":"Zimbabwean dollar"}
                    ]';
    return json_decode($currenciesRaw);
}

function phone_number_format($number) {
    // Allow only Digits, remove all other characters.
    $number = preg_replace("/[^\d]/","",$number);

    // get number length.
    $length = strlen($number);

    // if number = 10
    if($length == 12) {
        $number = preg_replace("/^1?(\d{3})(\d{3})(\d{6})$/", "$1 $2 $3", $number);
        return $number;
    }else{
        return 'Invalid';
    }
}

function customer_search(){?>
    <style type="text/css">
        .Typeahead *,
        .Typeahead *:before,
        .Typeahead *:after {
            -moz-box-sizing: border-box;
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
        }

        /* Utilities */

        .u-cf:before,
        .u-cf:after {
            content: " ";
            display: table;
        }

        .u-cf:after {
            clear: both;
        }

        .u-hidden {
            display: none !important;
        }

        .u-posRelative {
            position: relative;
        }

        /* Typeahead */

        .Typeahead {
            position: relative;
            *z-index: 1;
            width: 500px;
            margin: 50px auto 0 auto;
            padding: 15px;
            text-align: left;
            background-color: #0097cf;
            background-image: -moz-linear-gradient(top, #04a2dd, #03739c);
            background-image: -webkit-gradient(linear, 0 0, 0 100%, from(#04a2dd), to(#03739c));
            background-image: -webkit-linear-gradient(top, #04a2dd, #03739c);
            background-image: -o-linear-gradient(top, #04a2dd, #03739c);
            background-image: linear-gradient(top, #04a2dd, #03739c);
            background-repeat: repeat-x;
            border: 1px solid #024e6a;
            -webkit-border-radius: 10px;
            -moz-border-radius: 10px;
            border-radius: 10px;
            -webkit-box-shadow: 0 0 2px #111;
            -moz-box-shadow: 0 0 2px #111;
            box-shadow: 0 0 2px #111;
        }

        .Typeahead-spinner {
            position: absolute;
            top: 7px;
            right: 7px;
            display: none;
            width: 28px;
            height: 28px;
        }

        .Typeahead-hint,
        .Typeahead-input {
            width: 100%;
            padding: 5px 8px;
            font-size: 24px;
            line-height: 30px;
            border: 1px solid #024e6a;
            -webkit-border-radius: 8px;
            -moz-border-radius: 8px;
            border-radius: 8px;
        }

        .Typeahead-hint {
            position: absolute;
            top: 0;
            left: 0;
            color: #ccd6dd;
            opacity: 1;
        }

        .Typeahead-input {
            position: relative;
            background-color: transparent;
            background-image: url(data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7);
            outline: none;
        }

        .Typeahead-menu {
            position: absolute;
            top: 95%;
            left: 2.5%;
            z-index: 100;
            display: none;
            width: 95%;
            margin-bottom: 20px;
            overflow: hidden;
            background-color: #fff;
            -webkit-border-radius: 8px;
            -moz-border-radius: 8px;
            border-radius: 8px;
            box-shadow: 0px 0px 0px 1px green;
            -webkit-box-shadow: 0 5px 10px rgba(0,0,0,.2);
            -moz-box-shadow: 0 5px 10px rgba(0,0,0,.2);
            box-shadow: 0 5px 10px rgba(0,0,0,.2);
        }

        .Typeahead-menu.is-open {
            display: block;
        }

        .Typeahead-selectable {
            cursor: pointer;
        }

        .Typeahead-selectable + .Typeahead-selectable {
            border-top: 1px solid #ccd6dd;
        }

        /* ProfileCard */

        .ProfileCard {
            position: relative;
            padding: 8px;
        }

        .ProfileCard-avatar {
            position: absolute;
            top: 8px;
            left: 8px;
            width: 52px;
            height: 52px;
            border: 2px solid #ccd6dd;
            border-radius: 5px;
        }

        .ProfileCard:hover .ProfileCard-avatar {
            border-color: #f5f8fa;
        }

        .ProfileCard-details {
            min-height: 60px;
            padding-left: 60px;
        }

        .ProfileCard-realName,
        .ProfileCard-screenName {
            display: inline-block;
        }

        .ProfileCard-realName {
            font-weight: 700;
        }

        .ProfileCard-screenName {
            color: #8899a6;
        }

        .ProfileCard-description {
            margin-top: 5px;
            font-size: 14px;
            line-height: 18px;
        }

        .ProfileCard-stats {
            float: right;
            text-align: right;
        }

        .ProfileCard-stat {
            display: inline-block;
            font-size: 12px;
            line-height: 16px;
            text-transform: uppercase;
        }

        .ProfileCard-stat-label {
            color: #8899a6;
            font-weight: 500;
        }

        .ProfileCard-stat + .ProfileCard-stat {
            margin-left: 5px;
        }

        .ProfileCard:hover,
        .ProfileCard.is-active {
            color: #fff;
            background: #55acee;
        }

        .ProfileCard:hover .ProfileCard-screenName,
        .ProfileCard:hover .ProfileCard-stat-label,
        .ProfileCard.is-active .ProfileCard-screenName,
        .ProfileCard.is-active .ProfileCard-stat-label {
            color: #fff;
        }

        /* EmptyMessage */

        .EmptyMessage {
            position: relative;
            padding: 10px;
            font-size: 24px;
            line-height: 30px;
            text-align: center;

        }
    </style>
    <input type="hidden" name="mode" value="users">
    <div class="Typeahead Typeahead--twitterUsers">
        <div class="u-posRelative">
            <input type="hidden" required name="bms_client" id="bms-client" />
            <input class="Typeahead-hint" type="text" tabindex="-1" readonly>
            <input class="Typeahead-input" id="demo-input" type="text" name="q" placeholder="Search clients...">
            <img class="Typeahead-spinner" src="http://twitter.github.io/typeahead.js/img/spinner.gif">
        </div>
        <div class="Typeahead-menu"></div>
    </div>
    <script id="result-template" type="text/x-handlebars-template">
        <div class="ProfileCard u-cf">
            <img class="ProfileCard-avatar" src="{{image}}">

            <div class="ProfileCard-details">
                <div class="ProfileCard-realName">{{name}}</div>
                <div class="ProfileCard-screenName">{{email}}</div>
                <div class="ProfileCard-description">{{address}}</div>
            </div>

            <div class="ProfileCard-stats">
                <div class="ProfileCard-stat"><span class="ProfileCard-stat-label">Mobile:</span> {{phonenumber}}</div>
                <div class="ProfileCard-stat"><span class="ProfileCard-stat-label">Category:</span> {{category}}</div>
                <div class="ProfileCard-stat"><span class="ProfileCard-stat-label">ID Number:</span> {{user_id}}</div>
            </div>
        </div>
    </script>
    <div class="modal" id="new-client" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
            <div class="modal-content">
                <div class="modal-body" style="min-height: 100px;"> </div>
            </div>
        </div>
    </div>
    <script id="empty-template" type="text/x-handlebars-template">
        <div class="EmptyMessage">Your search turned up 0 results. Yu can add new <a href="#new-client" data-backdrop="false" class="kt-font-danger" data-toggle="modal"><b>HERE</b></a> </div>
    </script>

<?php }

function workingclockLM(){
    $helper =&  get_instance();
    $helper->load->model(array("clock/clockModel"=>"clockModel"));
    return $helper->clockModel->workingclockbyme(config_item('auth_user_id'));
}

function noWorkingclocoutkLM(){
    $helper =&  get_instance();
    $helper->load->model(array("clock/clockModel"=>"clockModel"));
    return $helper->clockModel->noWorkingclockbyme(config_item('auth_user_id'));
}

function noWorkingclocoutkLM1(){
    $helper =&  get_instance();
    $helper->load->model(array("clock/clockModel"=>"clockModel"));
    return $helper->clockModel->noWorkingclockbyme1(config_item('auth_user_id'));
}

function depreciationData($key=''){
    $helper =&  get_instance();
    $helper->load->model(array("assets/AssetsModel"=>"assetsModel"));
    return $helper->assetsModel->depDataRow($key);
}


function myTaskLM(){
    $helper =&  get_instance();
    $helper->load->model(array("task/TaskModel"=>"taskModel"));
    return $helper->taskModel->tasksbyme(config_item('auth_user_id'));
}

function userInfo($key=""){
    if($key == '')
        $key = config_item('user_id');
    $lm =& get_instance();
    $lm->db->join('users_details d','d.user_key=user_id','left')
        ->join('user_settings us','us.st_user=user_id','left')
        ->join('user_roles','user_roles.role_user=users.user_id','left')
        ->join('acl_categories','acl_categories.category_key=user_title','left');
    return $lm->appModel->info($key);
}

function getFileExt($filename){

    $mime_types = array(

        'txt' => 'text/plain',
        'htm' => 'text/html',
        'html' => 'text/html',
        'php' => 'text/html',
        'css' => 'text/css',
        'js' => 'application/javascript',
        'json' => 'application/json',
        'xml' => 'application/xml',
        'swf' => 'application/x-shockwave-flash',
        'flv' => 'video/x-flv',

        // images
        'png' => 'image/png',
        'jpe' => 'image/jpeg',
        'jpeg' => 'image/jpeg',
        'jpg' => 'image/jpeg',
        'gif' => 'image/gif',
        'bmp' => 'image/bmp',
        'ico' => 'image/vnd.microsoft.icon',
        'tiff' => 'image/tiff',
        'tif' => 'image/tiff',
        'svg' => 'image/svg+xml',
        'svgz' => 'image/svg+xml',

        // archives
        'zip' => 'application/zip',
        'rar' => 'application/x-rar-compressed',
        'exe' => 'application/x-msdownload',
        'msi' => 'application/x-msdownload',
        'cab' => 'application/vnd.ms-cab-compressed',

        // audio/video
        'mp3' => 'audio/mpeg',
        'qt' => 'video/quicktime',
        'mov' => 'video/quicktime',

        // adobe
        'pdf' => 'application/pdf',
        'psd' => 'image/vnd.adobe.photoshop',
        'ai' => 'application/postscript',
        'eps' => 'application/postscript',
        'ps' => 'application/postscript',

        // ms office
        'doc' => 'application/msword',
        'rtf' => 'application/rtf',
        'xls' => 'application/vnd.ms-excel',
        'ppt' => 'application/vnd.ms-powerpoint',

        // open office
        'odt' => 'application/vnd.oasis.opendocument.text',
        'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
    );
    $fil = explode('.',$filename);
    $ext = strtolower(array_pop($fil));
    return $ext;

}

function getFileExtMime($filename){

    $mime_types = array(

        'txt' => 'text/plain',
        'htm' => 'text/html',
        'html' => 'text/html',
        'php' => 'text/php',
        'css' => 'text/css',
        'js' => 'application/javascript',
        'json' => 'application/json',
        'xml' => 'application/xml',
        'swf' => 'application/x-shockwave-flash',
        'flv' => 'video/x-flv',

        // images
        'png' => 'image/png',
        'jpe' => 'image/jpeg',
        'jpeg' => 'image/jpeg',
        'jpg' => 'image/jpeg',
        'gif' => 'image/gif',
        'bmp' => 'image/bmp',
        'ico' => 'image/vnd.microsoft.icon',
        'tiff' => 'image/tiff',
        'tif' => 'image/tiff',
        'svg' => 'image/svg+xml',
        'svgz' => 'image/svg+xml',

        // archives
        'zip' => 'application/zip',
        'rar' => 'application/x-rar-compressed',
        'exe' => 'application/x-msdownload',
        'msi' => 'application/x-msdownload',
        'cab' => 'application/vnd.ms-cab-compressed',

        // audio/video
        'mp3' => 'audio/mpeg',
        'qt' => 'video/quicktime',
        'mov' => 'video/quicktime',

        // adobe
        'pdf' => 'application/pdf',
        'psd' => 'image/vnd.adobe.photoshop',
        'ai' => 'application/postscript',
        'eps' => 'application/postscript',
        'ps' => 'application/postscript',

        // ms office
        'doc' => 'application/msword',
        'rtf' => 'application/rtf',
        'xls' => 'application/vnd.ms-excel',
        'ppt' => 'application/vnd.ms-powerpoint',

        // open office
        'odt' => 'application/vnd.oasis.opendocument.text',
        'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
    );

    $ext = strtolower(array_pop(explode('.',$filename)));
    if (array_key_exists($ext, $mime_types)) {
        return $mime_types[$ext];
    }
    elseif (function_exists('finfo_open')) {
        $finfo = finfo_open(FILEINFO_MIME);
        $mimetype = finfo_file($finfo, $filename);
        finfo_close($finfo);
        if (array_key_exists($mimetype,$mime_types)) {
            return $mime_types[$ext];
        }else{
            return $mimetype;
        }

    }
    else {
        return 'application/octet-stream';
    }

}


function moneyUnit($money){

    if($money < 1000){
        return $money;
    }

    if($money >= 1000 & $money < 1000000){
        $raw = $money / 1000;
        return round($raw,2).'K';
    }

    if($money >= 1000000 & $money < 1000000000){
        $raw = $money / 1000000;
        return round($raw,2).'M';
    }

    if($money >= 1000000000 & $money < 1000000000000){
        $raw = $money / 1000000000;
        return round($raw,2).'B';
    }

    if($money >= 1000000000000 & $money < 1000000000000000){
        $raw = $money / 1000000000000;
        return round($raw,2).'T';
    }

}
