<?php

    function topMenuExpenses($flag=""){?>
        <div class="kt-subheader   kt-grid__item" id="kt_subheader">
            <div class="kt-container">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title">Expenses</h3>
                <span class="kt-subheader__separator kt-subheader__separator--v"></span>
                <a class="btn btn-outline-dark text-uppercase " href="#expenseModal"
                   data-toggle="modal" style="vertical-align: middle;">New Expense</a>
            </div>
            <div class="kt-subheader__toolbar">
                <div class="kt-subheader__wrapper">
                    <?php lmDates();?>
                </div>
            </div>
            </div>
        </div>
    <?php }

function budgetBalance($budget){
    $lm =& get_instance();
    $spent = $lm->expensesModel->expenseTotalBudget($budget);
    $value = $lm->db->where('budget_id',$budget)->get('expense_budgets')->row()->budget_value;
    $balance = $value - $spent;
    return $balance;
}

function typeBalance($type){
    $lm =& get_instance();
    $spent = $lm->expensesModel->expenseTotalType($type);
    $value = $lm->db->where('type_id',$type)->get('expense_types')->row()->type_max;
    $balance = $value - $spent;
    return $balance;
}

function expenseSummary(){
    $lm =& get_instance();?>
    <div class="row">
        <div class="col-md-3 col-sm-6">
            <div class="lm-box btn-elevate bg-success">
          <span class="lm-box-money kt-font-light pull-left" >
            <?php echo number_format($lm->expensesModel->expenseTotal('today'));?>
          </span><br/>
                <span class="lm-box-title">
              Expense Today
            </span>
            </div>
        </div>
        <div class="col-md-3 col-sm-6">
            <div class="lm-box btn-elevate bg-warning">
          <span class="lm-box-money kt-font-light pull-left">
            <?php echo number_format($lm->expensesModel->expenseTotal('week'));?>
          </span><br/>
                <span class="lm-box-title">
              Expense Weekly
            </span>
            </div>
        </div>
        <div class="col-md-3 col-sm-6">
            <div class="lm-box btn-elevate bg-danger">
          <span class="lm-box-money kt-font-light pull-left">
            <?php echo number_format($lm->expensesModel->expenseTotal('month'));?>
          </span><br/>
                <span class="lm-box-title kt-font-light">
              Expense Monthly
            </span>
            </div>
        </div>
        <div class="col-md-3 col-sm-6">
            <div class="lm-box btn-elevate bg-info" >
          <span class="lm-box-money kt-font-light">
            <?php echo number_format($lm->expensesModel->expenseTotal('year'));?>
          </span>
                <span class="lm-box-title">
              Expense Annually
            </span>
            </div>
        </div>
    </div>
<?php }

function expenseRibbon(){?>
    <a class="btn btn-success text-uppercase" href="#expenseModal" data-toggle="modal">New Expense</a>
<?php }