<?php

function has_menu_employee(){
    if(
        // Loans
        has_role('employee_view_all') ||
        has_role('employee_view_single') ||
        has_role('employee_create') ||
        has_role('employee_update') ||
        has_role('employee_delete') ||
        has_role('employee_receive') ||
        has_role('employee_approve') ||
        has_role('employee_view_report') ||
        has_role('employee_print_report')
    ){
        return TRUE;
    }else{
        return FALSE;
    }
}

function has_menu_payroll(){
    if(
        // Loans
        has_role('payroll_view_all') ||
        has_role('payroll_create') ||
        has_role('payroll_update') ||
        has_role('payroll_delete')
    ){
        return TRUE;
    }else{
        return FALSE;
    }
}

function has_menu_freight(){
    if(
        // Freights
        has_role('freight_view_all') ||
        has_role('freight_view_single') ||
        has_role('freight_create') ||
        has_role('freight_update') ||
        has_role('freight_delete') ||
        has_role('freight_view_report') ||
        has_role('freight_print_report') ||
        has_role('freight_view_shipping_line') ||
        has_role('freight_create_shipping_line') ||
        has_role('freight_update_shipping_line') ||
        has_role('freight_delete_shipping_line') ||
        has_role('freight_view_documentations') ||
        has_role('freight_create_documentations') ||
        has_role('freight_update_documentations') ||
        has_role('freight_delete_documentations') ||
        has_role('freight_view_delivery_note') ||
        has_role('freight_create_delivery_note') ||
        has_role('freight_update_delivery_note') ||
        has_role('freight_delete_delivery_note') ||
        has_role('freight_view_port_charge') ||
        has_role('freight_create_port_charge') ||
        has_role('freight_update_port_charge') ||
        has_role('freight_delete_port_charge') ||
        has_role('freight_view_stages') ||
        has_role('freight_create_stages') ||
        has_role('freight_update_stages') ||
        has_role('freight_delete_stages') ||
        has_role('freight_view_assessment') ||
        has_role('freight_create_assessment') ||
        has_role('freight_update_assessment') ||
        has_role('freight_delete_assessment') ||
        has_role('petty_view_all') ||
        has_role('petty_view_single') ||
        has_role('petty_approve') ||
        has_role('petty_create') ||
        has_role('petty_update') ||
        has_role('petty_delete') ||
        has_role('petty_print') ||
        has_role('petty_reject')
    ){
        return TRUE;
    }else{
        return FALSE;
    }
}

function has_menu_customers(){
    if(
        // Employee actions
        has_role('customers_view_all') ||
        has_role('customers_details') ||
        has_role('customers_update') ||
        has_role('customers_delete') ||
        has_role('customers_register') ||
        has_role('customers_approve') ||
        has_role('customers_disapprove') ||

        // groups
        has_role('customer_group_view_all')||
        has_role('customer_group_register') ||
        has_role('customer_group_update') ||
        has_role('customer_group_details') ||
        has_role('customer_group_details') ||
        has_role('customer_group_delete')
    ){
        return TRUE;

    }else{
        return FALSE;
    }

}

function has_control_menu_customers(){
    if(
        // Employee actions
        has_role('customers_view_all') ||
        // Branch actions
        has_role('customer_group_view_all')
      ){
      return TRUE;

      }else{
        return FALSE;
      }

  }

function has_control_menu_administration(){
    if(
        // Employee actions
        has_role('employee_view_all') ||
        // Branch actions
        has_role('branches_view_all') ||
        // Departments
        has_role('departments_view_all') ||
        // Titles
        has_role('titles_view_all') ||
        // roles
        has_role('roles_view_all')
      ){
      return TRUE;
      }else{
        return FALSE;
      }

  }

function has_control($role,$message){
    if(!has_role($role)){
        $_SESSION['noaccess'] = $message;
        if (isset($_SERVER["HTTP_REFERER"])) {
            header("Location: " . $_SERVER["HTTP_REFERER"]);
        }else{
            header("Location: " . base_url());
        }
    }else{
        unset($_SESSION['noaccess']);
    }
}

function has_control_ajax($role,$message){
  if(!has_role($role)){
    $result['status'] = false;
    $result['message'] = 'You don\'t have <span class="text-danger"><b>ACCESS CONTROL</b></span> for<span class="text-danger"> <b>'.$message.'</b></span>';
    print json_encode($result);
  exit();  }
}

function has_control_ajax_content($role,$message){
  if(!has_role($role)){?>
    <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
        <div class="alert alert-warning" role="alert">
            <div class="alert-text">
              <h4 class="alert-heading">Access Control!</h4>
              <p>You don't have <b>ACCESS CONTROL</b> for <b><?php echo $message;?></b></p>
            </div>
          </div>
      </div>
     <?php  exit(); }

    }

function isTitleAction($title,$action){

    $bms =& get_instance();
    $branch = runningBranch()->branch_key;
    $business = runningBusiness()->business_key;
    $bms->db->where('action_branch',$branch);
    $bms->db->where('action_business',$business);
    $bms->db->where('action_code',$action);
    $bms->db->where('category_id',$title);
    $query = $bms->db->get('acl_actions');
    return $query->num_rows()>0 ? $query->row() : FALSE;
}

function isMyRoleAction($user,$title,$action){
    $bms =& get_instance();
    if($result = isTitleAction($title,$action)){
        $bms->db->where('action_id',$result->action_id);
        $bms->db->where('user_id',$user);
        $query = $bms->db->get('acl');
        return $query->num_rows()>0 ? TRUE : FALSE;
    }else{
        return FALSE;
    }
}

 function nonAccessControl(){?>
    <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
        <div class="alert alert-warning" role="alert" style="border-radius: 0;">
            <div class="alert-text">
              <h4 class="alert-heading">Access Control!</h4>
              <p>Currently you don't have control to access this information</p>
              <hr>
              <p class="mb-0">Plaese contact your <a href="#contactSystemAdmin" data-toggle="modal"><b>System Admin</b></a> to get <b>Control</b></p>
            </div>
          </div>
      </div>
  <?php }

function supportComposeAccessControl(){?>
    <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
        <div class="alert alert-warning" role="alert" style="border-radius: 0;">
            <div class="alert-text">
                <h4 class="alert-heading">Access Control!</h4>
                <p>Currently you don't have access control to compose message</p>
                <hr>
                <p class="mb-0">Please contact your <a href="#contactSystemAdmin" data-toggle="modal"><b>System Admin</b></a> to get <b>Control</b></p>
            </div>
        </div>
    </div>
<?php }

function FreightAccessControl(){?>
    <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
        <div class="alert alert-warning" role="alert" style="border-radius: 0;">
            <div class="alert-text">
                <h4 class="alert-heading">Access Denied!</h4>
                <p>Currently you don't have access control to this operation</p>
                <hr>
                <p class="mb-0">Please contact your <a href="#contactSystemAdmin" data-toggle="modal"><b>System Admin</b></a> to get <b>Control</b></p>
            </div>
        </div>
    </div>
<?php }

function supportReadAccessControl(){?>
    <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
        <div class="alert alert-warning" role="alert" style="border-radius: 0;">
            <div class="alert-text">
                <h4 class="alert-heading">Access Control!</h4>
                <p>Currently you don't have access control to read messages</p>
                <hr>
                <p class="mb-0">Please contact your <a href="#contactSystemAdmin" data-toggle="modal"><b>System Admin</b></a> to get <b>Control</b></p>
            </div>
        </div>
    </div>
<?php }

function supportReplyAccessControl(){?>
    <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
        <div class="alert alert-warning" role="alert" style="border-radius: 0;">
            <div class="alert-text">
                <h4 class="alert-heading">Access Control!</h4>
                <p>Currently you don't have access control to reply this message</p>
                <hr>
                <p class="mb-0">Please contact your <a href="#contactSystemAdmin" data-toggle="modal"><b>System Admin</b></a> to get <b>Control</b></p>
            </div>
        </div>
    </div>
<?php }

function has_role($role){
    if(strtolower(config_item('auth_role')) == 'supper')
        return TRUE;
    $profile = profile();
    return isMyRoleAction($profile->user_id,$profile->category_id,$role) ? TRUE : FALSE;
}

  function is_locked(){
    $bms =& get_instance();
    $user = config_item('auth_user_id');
    $branch = runningBranch()->branch_key;
    if(!empty(profile()->user_business)){
      $business = runningBusiness()->business_key;
      $bms->db->where('business',$business);
    }
    $bms->db->where('user',$user);
    $bms->db->where('store',$branch);
    $query = $bms->db->get('locked_users');
    return $query->num_rows()>0 ? $query->row() : FALSE;
  }

function roles_groups(){
    $bms =& get_instance();
    $bms->db->select('role_group,role_class');
    $bms->db->group_by('role_group');
    $query = $bms->db->get('roles');
    return $query->num_rows()>0 ? $query->result_array() : FALSE;
}
