<?php

  require __DIR__.'/vendor/autoload.php';

    use PhpOffice\PhpSpreadsheet\Spreadsheet;
    use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
    use PhpOffice\PhpSpreadsheet\Helper\Sample;
  Class Ssheet {

  protected $rida;

  protected $src;

  protected $path;

  public function __construct(){
   	$this->rida =& get_instance();
    $this->path  = dirname(APPPATH);
    $this->src = __DIR__.'/vendor/phpoffice/phpspreadsheet/';
  }

  public function createFile($meta,$data){
      $helper = new Sample();
      // Create new Spreadsheet object
      $spreadsheet = new Spreadsheet();

      // Set document properties
      $spreadsheet->getProperties()->setCreator($meta['author'])
          ->setLastModifiedBy($meta['author'])
          ->setTitle($meta['title'])
          ->setSubject($meta['subject'])
          ->setDescription($meta['description'])
          ->setKeywords($meta['keywords'])
          ->setCategory($meta['category']);

      // Create the worksheet
      $spreadsheet->setActiveSheetIndex(0);
      $spreadsheet->getActiveSheet()
          ->setCellValue('A1', 'Requester')
          ->setCellValue('B1', 'Client')
          ->setCellValue('C1', 'Project ID')
          ->setCellValue('D1', 'Date')
          ->setCellValue('E1', 'Reason')
          ->setCellValue('F1', 'Other Reason')
          ->setCellValue('G1', 'Reason Qty')
          ->setCellValue('H1', 'Reason @price')
          ->setCellValue('I1', 'Reason Total')
          ->setCellValue('J1', 'Request Amount')
          ->setCellValue('K1', 'Request Paid')
          ->setCellValue('L1', 'Request Balance')
          ->setCellValue('M1', 'Status')
          ->setCellValue('N1', 'Retired');


      $spreadsheet->getActiveSheet()->fromArray($data, null, 'A2');

// Set title row bold
      $spreadsheet->getActiveSheet()->getStyle('A1:N1')->getFont()->setBold(true);

// Set autofilter
// Always include the complete filter range!
// Excel does support setting only the caption
// row, but that's not a best practise...
      $spreadsheet->getActiveSheet()->setAutoFilter($spreadsheet->getActiveSheet()->calculateWorksheetDimension());

// Save
      $writer = new Xlsx($spreadsheet);
      $writer->save($meta['filename']);

  }

  public function readFileSpreadsheet($file,$sheet){
    $inputFileType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($file);
    $reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);
    $reader->setReadDataOnly(true);
    $reader->setLoadSheetsOnly($sheet);
    return $reader->load($file);
  }


}

