<?php

require_once __DIR__.'/src/Source.php';

Class Pusher extends source {
    protected $lm;

    public function __construct(){
        $this->lm =& get_instance();
    }

    function pusherSettings(){
        $query = $this->lm->db->get('pusher');
        return $query->num_rows()>0 ? $query->row(): false;
    }

    public function triggerFlash($event,$data){
        $this->pusherObj();
        $channel = runningBranch()->branch_key;
        $response = $this->pusher->trigger($channel,$event, $data);
        return $response;
    }

    public function triggerRegister($event,$data){
        $this->pusherObj();
        $this->lm->notificationsModel->register($data);
        $channel = runningBranch()->branch_key;
        $response = $this->pusher->trigger($channel,$event, $data);
        return $response;
    }

    public function publishEventFlash($channel,$event,$data){
        $this->pusherObj();
        $response = $this->pusher->trigger($channel,$event, $data);
        return $response;
    }

}
