<?php
/**
 * Description of StocksModel
 *
 * @author Kelvin Benard
 * @email kelvin@lockminds.com
 */

class GlModel extends MY_Model{

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    function account_history($account,$when=""){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('gl_date >=',$dates['start']);
            $this->db->where('gl_date <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->order_by('gl_id','DESC');
        $this->db->where('gl_branch', $this->branch);
        $this->db->where('gl_business', $this->business);
        $this->db->where('gl_account', $account);
        $this->db->join('accounting_accounts acc','acc.account_key=gl_account','both');
        $this->db->select('DATE_FORMAT(gl_date, "%m/%d/%Y") as date', FALSE);
        $query = $this->db->get('accounting_general_ledger');
        if(!empty($query) && $query->num_rows()>0){
            return $query->result_array();
        }else{
            return false;
        }
    }

    function gls($when = ''){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('gl_date >=',$dates['start']);
            $this->db->where('gl_date <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->order_by('gl_id','DESC');
        $this->db->where('gl_branch', $this->branch);
        $this->db->where('gl_business', $this->business);
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->select('DATE_FORMAT(gl_date, "%m/%d/%Y") as gl_date', FALSE);
        $this->db->join('accounting_accounts acc','acc.account_id=gl_account','left');
        $this->db->join('users_details u','u.user_key=gl_user','left');
        $query = $this->db->get('accounting_general_ledger');
        if(!empty($query) && $query->num_rows()>0){
            return $query->result_array();
        }else{
            return false;
        }
    }


    function deleterecord($key){
        $this->db->where('gl_branch', $this->branch);
        $this->db->where('gl_business', $this->business);
        $this->db->where('gl_key', $key);
        $this->db->delete('accounting_general_ledger');
        if($this->db->affected_rows()>0){
            return true;
        }else{
            return false;
        }
    }

    function gl($key){
        $this->db->where('gl_branch', $this->branch);
        $this->db->where('gl_business', $this->business);
        $this->db->where('gl_key', $key);
        $query = $this->db->get('accounting_general_ledger');
        if(!empty($query) && $query->num_rows()>0){
            return $query->row();
        }else{
            return false;
        }
    }

    public function glKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'gl_key', $random_unique_int )
            ->get_where( 'accounting_general_ledger' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->glKey();
        }

        return $random_unique_int;
    }
    

}
