<?php

require_once APPPATH.'models/BMS_Model.php';

class JournalsModel extends BMS_Model
{
    protected $branch_field = "journal_branch";
    protected $branch;
    protected $business_field = 'journal_business';
    protected $business;

    protected $filterable_date_field = 'journal_date';

    protected $table_name   = 'accounting_journals';
    protected $key          = 'journal_key';
    protected $primary_key  = 'journal_key';
    protected $soft_deletes = TRUE;
    protected $date_format  = 'datetime';
    protected $log_user     = TRUE;

    public    $selectable_fields = array('journal_id','journal_key','journal_title','journal_date','journal_status','journal_type','journal_branch','journal_business','journal_created_by','journal_modified_by','journal_created_on','journal_modified_on','journal_deleted','journal_deleted_by');

    protected $set_created  = TRUE;
    protected $created_field    = 'journal_created_on';
    protected $created_by_field = 'journal_created_by';

    protected $set_modified     = TRUE;
    protected $modified_field   = 'journal_modified_on';
    protected $modified_by_field = 'journal_modified_by';

    protected $soft_delete_key    = 'journal_deleted';
    protected $deleted_by_field = 'journal_deleted_by';

    // Observers
    protected $before_insert    = array('set_key','set_ownership');
    protected $after_insert     = array('publish_event');
    protected $before_update    = array();
    protected $after_update     = array('publish_event');
    protected $before_find      = array('set_selectable_fields','set_join','set_select_dates','set_ownership_select','set_limit_offset');
    protected $after_find       = array();
    protected $before_delete    = array();
    protected $after_delete     = array('publish_event');

    protected $return_type      = 'array';
    protected $protected_attributes   = array();

    protected $validation_rules         = array();
    protected $insert_validation_rules  = array();
    protected $skip_validation          = true;

    public function __construct(&$write_db = null, &$read_db = null)
    {
        parent::__construct($write_db, $read_db);
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    protected function set_key($row){

        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( $this->key, $random_unique_int )
            ->get_where( $this->table_name );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->taxClassKey();
        }

        if (!array_key_exists($this->key, $row))
        {
            $row[$this->key] = $random_unique_int;
        }

        return $row;
    }

    protected function set_ownership($row){

        if(!empty($this->business)){
            $row[$this->business_field] = $this->business;
        }

        if(!empty($this->branch)){
            $row[$this->branch_field] = $this->branch;
        }

        return $row;
    }

    protected function set_created_by($row)
    {
        if (!array_key_exists($this->created_by_field, $row))
        {
            $row[$this->created_by_field] = config_item("auth_user_id");
        }

        return $row;
    }

    protected function set_deleted_by($id)
    {
        $this->dbw->where($this->primary_key, $id);
        $this->db->update($this->table_name, [$this->deleted_by_field => config_item("auth_user_id")]);
    }

    protected function set_modified_by($row)
    {
        if (!array_key_exists($this->modified_by_field, $row))
        {
            $row[$this->modified_by_field] = config_item("auth_user_id");
        }

        return $row;
    }

    protected function set_modified_on($row)
    {
        if (!array_key_exists($this->modified_field, $row))
        {
            $row[$this->modified_field] = date('Y-m-d H:m:i');
        }

        return $row;
    }

    protected function set_selectable_fields()
    {
        if(!empty($this->selectable_fields)){
            $this->db->select($this->selectable_fields);
        }

    }

    protected function set_select_dates(){
        if(!empty($when = $this->input->get("when"))){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where($this->filterable_date_field.'>=',$dates['start']);
            $this->db->where($this->filterable_date_field.'<=',$dates['end']);
        }
    }

    protected function set_join(){
       // $this->db->join('accounting_accounts acc','acc.account_key=gl_account','both');
    }

    protected function set_ownership_select(){
        $this->db->where($this->business_field,$this->business);
        $this->db->where($this->branch_field,$this->branch);
    }

    protected function publish_event(){
        publishEventFlash('data-table-refresh');
    }

    protected function set_limit_offset(){
        if(!empty($when = $this->input->get("when"))){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where($this->filterable_date_field.'>=',$dates['start']);
            $this->db->where($this->filterable_date_field.'<=',$dates['end']);
        }
    }
}