<?php

class AssetsModel extends My_model {

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function asset($asset) {
        $query = $this->db->where( 'asset_key',$asset )
            ->where('asset_branch',$this->branch)
            ->where('asset_business',$this->business)
            ->join('asset_types','asset_types'.'.asset_type_key='.'assets'.'.asset_type','left')
            ->join('accounting_accounts','account_key=asset_withdraw_account','left')
            ->from('assets')
            ->get();
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    public function check_depreciation($dep_key, $period_key) {
        $query = $this->db->where( 'asset_dep_period', $period_key)
            ->where('asset_dep_asset_key', $dep_key)
            ->join('financial_periods','fp_key=asset_dep_period','left')
            ->from('asset_depreciation')
            ->get();
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    public function count_depreciated($asset_key) {
        $query = $this->db->where( 'asset_dep_asset_key', $asset_key)
            ->where('asset_dep_status', 'Depreciated')
            ->from('asset_depreciation')
            ->get();
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    public function check_appreciation($app_key, $period_key) {
        $query = $this->db->where( 'asset_app_period', $period_key)
            //->where('asset_app_key', $app_key)
            ->where('asset_app_asset_key', $app_key)
            ->join('financial_periods','fp_key=asset_app_period','left')
            ->from('asset_appreciation')
            ->get();
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    public function count_appreciated($asset_key) {
        $query = $this->db->where( 'asset_app_asset_key', $asset_key)
            ->where('asset_app_status', 'Appreciated')->from('asset_appreciation')->get();
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    public function assets() {
        /** This is for assets with depreciation in nature */
        $query = $this->db->select( '*')
            ->select('DATE_FORMAT(asset_date, "%Y/%M/%d") as asset_date', FALSE)
            ->order_by( 'asset_id','DESC' )
            ->group_by( 'asset_dep_asset_key')
            ->where('asset_branch',$this->branch)
            ->where('asset_business',$this->business)
            ->where('asset_dep_status', 'Pending')
            ->where('asset_value_nature', 'Depreciate')
            ->join('asset_types','asset_types'.'.asset_type_key='.'assets'.'.asset_type','left')
            ->join('asset_depreciation','asset_depreciation.asset_dep_asset_key=assets.asset_key','left')
            ->join('financial_periods','financial_periods.fp_key=asset_depreciation.asset_dep_period','left')
            ->from('assets','financial_periods')
            ->get();
        return $query->result_array();
    }
    public function appreciating_assets() {
        /** This is for assets with appreciation in nature */
        $query = $this->db->select( '*')
            ->select('DATE_FORMAT(asset_date, "%Y/%M/%d") as asset_date', FALSE)
            ->order_by( 'asset_id','DESC' )
            ->group_by( 'asset_app_asset_key')
            ->where('asset_branch',$this->branch)
            ->where('asset_business',$this->business)
            ->where('asset_app_status', 'Pending')
            ->where('asset_value_nature', 'Appreciate')
            ->join('asset_types','asset_types'.'.asset_type_key='.'assets'.'.asset_type','left')
            ->join('asset_appreciation','asset_appreciation.asset_app_asset_key=assets.asset_key','left')
            ->join('financial_periods','financial_periods.fp_key=asset_appreciation.asset_app_period','left')
            ->from('assets','financial_periods')
            ->get();
        return $query->result_array();
    }

    public function newAsset($asset) {
        $assetType = $this->assetType($asset['asset_type']);
        $drAccount['trans_branch'] = $this->branch;
        $drAccount['trans_business'] = $this->business;
        $drAccount['trans_key'] = $this->transactionKey();
        $drAccount['trans_action'] = 'debit';
        $drAccount['trans_amount'] = $asset['asset_total_cost'];
        $drAccount['trans_origin'] = $asset['asset_key'];
        $drAccount['trans_account'] = $assetType->asset_type_account;
        $drAccount['trans_type'] = 'Purchase assets from a supplier';
        $drAccount['trans_date'] = $asset['asset_date'];
        $drAccount['trans_details'] = $asset['asset_description'];
        $drAccount['trans_payee'] = $asset['asset_bougth_from'];
        $drAccount['trans_employee'] = config_item('auth_user_id');

        $crAccount['trans_branch'] = $this->branch;
        $crAccount['trans_business'] = $this->business;
        $crAccount['trans_key'] = $this->transactionKey($drAccount['trans_key']);
        $crAccount['trans_action'] = 'credit';
        $crAccount['trans_amount'] = -$asset['asset_total_cost'];
        $crAccount['trans_origin'] = $asset['asset_key'];
        $crAccount['trans_account'] = $asset['asset_withdraw_account'];
        $crAccount['trans_type'] = 'Purchase assets from a supplier';
        $crAccount['trans_date'] = $asset['asset_date'];
        $crAccount['trans_details'] = $asset['asset_description'];
        $crAccount['trans_payee'] = $asset['asset_bougth_from'];
        $crAccount['trans_employee'] = config_item('auth_user_id');

        $this->db->trans_start();
        $this->db->insert('transactions',$drAccount);
        $this->db->insert('transactions',$crAccount);

        $asset['asset_branch'] = $this->branch;
        $asset['asset_business'] = $this->business;
        $this->db->insert('assets',$asset);

        /** After inserting data onto assets table, the next operation is to
         * create initial points for depreciation or appreciation after checking
         * whether the nature of asset value is depreciating or appreciating
         */
        if($asset['asset_value_nature'] == "Depreciate"){
            $dep['asset_dep_key'] = $this->assetDepKey();
            $dep['asset_dep_asset_key'] = $asset['asset_key'];
            $dep['asset_dep_price_difference'] = $asset['asset_cost'];
            $dep['asset_dep_depriciation_month_price'] = $asset['asset_monthly_dep'];
            $dep['asset_dep_year'] = date('Y');
            $dep['asset_dep_month'] = date('m');
            $dep['asset_dep_created_by'] = $this->auth_user_id;
            $this->db->insert('asset_depreciation',$dep);
        }
        elseif ($asset['asset_value_nature'] == "Appreciate"){
            $app['asset_app_key'] = $this->assetAppKey();
            $app['asset_app_asset_key'] = $asset['asset_key'];
            $app['asset_app_price_difference'] = $asset['asset_cost'];
            $app['asset_app_month_price'] = $asset['asset_monthly_app'];
            $app['asset_app_year'] = date('Y');
            $app['asset_app_month'] = date('m');
            $app['asset_app_created_by'] = $this->auth_user_id;
            $this->db->insert('asset_appreciation',$app);
        }


        $this->db->trans_complete();
        if($this->db->trans_status()){
            return TRUE;
        }else{
            return FALSE;
        }
    }

    public function upadateAsset($assetKey, $asset){

    }

    public function newAssetType($data) {
        $data['asset_type_branch']= $this->branch;
        $data['asset_type_business'] = $this->business;
        $data['asset_type_key'] = $this->asset_type_key();
        $this->db->insert('asset_types',$data);
        if($this->db->affected_rows() > 0){
            return TRUE;
        }else{
            return FALSE;
        }
    }

    public function assetTypes() {
        $this->db->where('asset_type_business',$this->business);
        //$this->db->where('asset_type_branch',$this->branch);
        $this->db->join('accounting_accounts','accounting_accounts.account_id=asset_type_account','left');
        $query = $this->db->order_by('asset_type_id','DESC')->join('asset_categories','asset_categories'.'.category_key='.'asset_types'.'.asset_type_category','left')->get('asset_types');
        return $query->result_array();
    }

    public function assetType($assetType) {
        $this->db->where('asset_type_business',$this->business);
        $this->db->where('asset_type_branch',$this->branch);
        $query = $this->db->where('asset_type_key',$assetType)->join('asset_categories','asset_categories'.'.category_key='.'asset_types'.'.asset_type_category','left')->get('asset_types');
        return $query->row();
    }

    public function assetCategories() {
        $query = $this->db->get('asset_categories');
        return $query->result_array();
    }

    public function deleteAsset($assetKey) {
        $this->db->trans_start();
        $this->deleteTransOrigin($assetKey);
        $this->db->where('asset_business',$this->business);
        $this->db->where('asset_branch',$this->branch);
        $this->db->limit(1)
            ->where('asset_key=', $assetKey)
            ->delete('assets');
        $this->db->trans_complete();
        if($this->db->trans_status()){
            return TRUE;
        }else{
            return FALSE;
        }
    }

    public function deleteDep($assetKey) {
        $this->db->trans_start();
        $this->deleteTransOrigin($assetKey);
        $this->db->where('asset_dep_asset_key=', $assetKey)->delete('asset_depreciation');
        $this->db->trans_complete();
        if($this->db->trans_status()){
            return TRUE;
        }else{
            return FALSE;
        }
    }
    public function deleteApp($assetKey) {
        $this->db->trans_start();
        $this->deleteTransOrigin($assetKey);
        $this->db->where('asset_app_asset_key=', $assetKey)->delete('asset_appreciation');
        $this->db->trans_complete();
        if($this->db->trans_status()){
            return TRUE;
        }else{
            return FALSE;
        }
    }

    public function deleteAssetType($assetTypeKey) {
        $this->db->where('asset_type_business',$this->business);
        //$this->db->where('asset_type_branch',$this->branch);
        $this->db->limit(1)
            ->where('asset_type_key=',$assetTypeKey)
            ->delete('asset_types');
        if($this->db->affected_rows() > 0){
            $log = array(
                'log_message' => 'Delete Asset Type',
                'log_details' => 'Asset Type deleted successfull',
                'log_activity' => $assetTypeKey,
            );
            $this->logActivity($log);
            return TRUE;
        }else{
            $log = array(
                'log_message' => 'Delete Asset Type',
                'log_details' => 'Asset Type was not deleted',
                'log_activity' => $assetTypeKey,
            );
            $this->logActivity($log);
            return FALSE;
        }
    }

    public function update($key, $data){
        $this->db->where("asset_key", $key);
        $this->db->update("assets",$data);
        return $this->db->affected_rows();
    }

    public function updateAsset($assetKey,$asset) {

        $assetType = $this->assetType($asset['asset_type']);

        $drAccount['trans_branch'] = $this->branch;
        $drAccount['trans_business'] = $this->business;
        $drAccount['trans_key'] = $this->transactionKey();
        $drAccount['trans_action'] = 'debit';
        $drAccount['trans_amount'] = $asset['asset_total_cost'];
        $drAccount['trans_origin'] = $assetKey;
        $drAccount['trans_account'] = $assetType->asset_type_account;
        $drAccount['trans_type'] = 'Expense';
        $drAccount['trans_date'] = $asset['asset_date'];
        $drAccount['trans_details'] = $asset['asset_description'];
        $drAccount['trans_payee'] = $asset['asset_bougth_from'];
        $drAccount['trans_employee'] = config_item('auth_user_id');

        $crAccount['trans_branch'] = $this->branch;
        $crAccount['trans_business'] = $this->business;
        $crAccount['trans_key'] = $this->transactionKey($drAccount['trans_key']);
        $crAccount['trans_action'] = 'credit';
        $crAccount['trans_amount'] = -$asset['asset_total_cost'];
        $crAccount['trans_origin'] = $assetKey;
        $crAccount['trans_account'] = $asset['asset_withdraw_account'];
        $crAccount['trans_type'] = 'Expense';
        $crAccount['trans_date'] = $asset['asset_date'];
        $crAccount['trans_details'] = $asset['asset_description'];
        $crAccount['trans_payee'] = $asset['asset_bougth_from'];
        $crAccount['trans_employee'] = config_item('auth_user_id');

        $this->db->trans_start();
        $this->deleteTransOrigin($assetKey);

        $this->db->insert('transactions',$drAccount);
        $this->db->insert('transactions',$crAccount);

        $this->db->where('asset_branch',$this->branch);
        $this->db->where('asset_business',$this->business);
        $this->db->where('asset_key',$assetKey);
        $this->db->update('assets',$asset);
        $this->db->trans_complete();
        if($this->db->trans_status()){
            return TRUE;
        }else{
            return FALSE;
        }
    }

    public function updateAssetType($assetTypeKey,$data) {
        $this->db->where('asset_type_business',$this->business);
        //$this->db->where('asset_type_branch',$this->branch);
        $this->db->limit(1)
            ->where('asset_type_key',$assetTypeKey)
            ->update( 'asset_types',$data );
        if($this->db->affected_rows() > 0){
            return TRUE;
        }else{
            return FALSE;
        }
    }

    function documents($key){
        $query = $this->db->where('asset_doc_asset_key',$key)->get('asset_documents');
        return ($query->num_rows()>=0) ? $query->result_array() : false;
    }

    public function createDocument($docs) {
        $docs['asset_doc_business_key'] = $this->business;
        $docs['asset_doc_branch_key'] = $this->branch;
        $docs['asset_doc_key'] = $this->assetdoc_key();
        $this->db->limit(1)
            ->insert('asset_documents',$docs);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function documentDelete($key) {
        $this->db->where('asset_doc_branch_key',$this->branch);
        $this->db->where('asset_doc_business_key',$this->business);
        $this->db->limit(1)
            ->where('asset_doc_key=',$key)
            ->delete('asset_documents');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    function asset_depreciation($key){
        $this->db->join('assets','assets.asset_key=asset_depreciation.asset_dep_asset_key','left');
        $query = $this->db->where('asset_dep_asset_key',$key)->get('asset_depreciation');
        return ($query->num_rows()>=0) ? $query->result_array() : false;
    }

    public function runDepreciation($depr){
        $updt['asset_dep_status']= 'Depreciated';
        $this->db->where('asset_dep_key',$depr);
        $this->db->update('asset_depreciation',$updt);
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }
    public function runAppreciation($appr){
        $updt['asset_app_status']= 'Appreciated';
        $this->db->where('asset_app_key',$appr);
        $this->db->update('asset_appreciation',$updt);
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    function runDepreciation1($data){
        $this->db->insert('asset_depreciation',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    public function depData($key) {
        $this->db->where('asset_dep_business_key',$this->business);
        $this->db->where('asset_dep_key', $key);
        $query = $this->db->get( 'asset_depreciation' );
        return $query->row();
    }

    public function depDataRow($key) {
        $this->db->where('asset_dep_business_key',$this->business);
        $this->db->where('asset_dep_asset_key', $key);
        $this->db->order_by('asset_dep_date_created','DESC');
        //$this->db->limit(1);
        $query = $this->db->get('asset_depreciation',1);
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    public function select_one_data($key){
        //$this->db->where('asset_dep_business_key',$this->business);
        $this->db->where('asset_dep_key', $key);
        $this->db->join('assets','asset_key=asset_dep_asset_key', 'left');
        $query = $this->db->get( 'asset_depreciation' );
        return $query->num_rows()>0 ? $query->row() : FALSE;
    }
    public function select_app_data($key){
        //$this->db->where('asset_dep_business_key',$this->business);
        $this->db->where('asset_app_key', $key);
        $this->db->join('assets','asset_key=asset_app_asset_key', 'left');
        $query = $this->db->get( 'asset_appreciation' );
        return $query->num_rows()>0 ? $query->row() : FALSE;
    }

    public function depDelete($key) {
        $this->db->where('asset_dep_branch_key',$this->branch);
        $this->db->where('asset_dep_business_key',$this->business);
        $this->db->limit(1)
            ->where('asset_dep_key=',$key)
            ->delete('asset_depreciation');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }



    public function asset_key(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'asset_key', $random_unique_int )
            ->get_where( 'assets' );

        if( $query->num_rows() > 0 ) {
            $query->free_result();
            // If the random user_id is already in use, try again
            return $this->asset_key();
        }
        return $random_unique_int;
    }

    public function assetdoc_key() {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'asset_doc_key', $random_unique_int )
            ->get_where( 'asset_documents' );
        if( $query->num_rows() > 0 )
        {
            $query->free_result();
            // If the random user_id is already in use, try again
            return $this->assetdoc_key();
        }
        return $random_unique_int;
    }

    public function asset_type_key()
    {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'asset_type_key', $random_unique_int )
            ->get_where( 'asset_types' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->asset_type_key();
        }

        return $random_unique_int;
    }

    public function assetDepKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'asset_dep_key', $random_unique_int )
            ->get_where( 'asset_depreciation' );

        if( $query->num_rows() > 0 ) {
            $query->free_result();
            // If the random user_id is already in use, try again
            return $this->assetDepKey();
        }
        return $random_unique_int;
    }

    public function assetAppKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'asset_app_key', $random_unique_int )
            ->get_where( 'asset_appreciation' );

        if( $query->num_rows() > 0 ) {
            $query->free_result();
            // If the random user_id is already in use, try again
            return $this->assetAppKey();
        }
        return $random_unique_int;
    }



}
