<?php


class Sendmsg_model extends MY_Model {

    public function msgKey()
    {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'msg_id', $random_unique_int )
            ->get_where( 'comm_sent' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->msgKey();
        }

        return $random_unique_int;
    }

    function insertOutbox($data)
    {
        $this->db->insert('comm_sent',$data);
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    function insertInbox($data2)
    {
        $this->db->insert('comm_inbox',$data2);
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    function insertReply($data)
    {
        $this->db->insert('comm_reply',$data);
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    function insertDraft($data)
    {
        $this->db->insert('comm_sent',$data);
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

}