<?php

class CommunicationsModel extends MY_Model {

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function customer_modify($key) {
        $this->db->where('user_branch',$this->branch);
        $this->db->where('user_business',$this->business);
        $query = $this->db->select( '*' )
            ->join('users_details','users_details.user_key=users.user_id','left')
            ->join('user_roles','user_roles.role_user=users.user_id','left')
            ->join('customer_groups','customer_groups.group_key=users.user_group','left')
            ->join('acl_categories','acl_categories.category_key=users.user_title','left')
            ->where('user_id',$key)->get('users');
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    public function allCount() {
        $this->db->where('sms_is_bulk',0);
        $num_rows = $this->db->count_all_results('bulksms');
        return $num_rows;
    }

}