<?php


class ViewInbox_model extends MY_Model
{
    function getInboxList($email)
    {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('receiver_id',$email);
        $this->db->where('is_trash',0);
        $this->db->where('is_recycle',0);
        $query = $this->db->get('comm_inbox');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    //function for pagination
    public function getInbobo($limit, $start) {
        $email = profile()->email;
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('receiver_id', $email);
        //$this->db->where('status', 'unread');
        $this->db->where('is_trash',0);
        $this->db->where('is_recycle',0);
        $this->db->limit($limit, $start);
        $query = $this->db->get('comm_inbox');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    //get total rows of inbox messages
    function countInbox($email)
    {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('receiver_id',$email);
        $this->db->where('is_trash', 0);
        $this->db->where('is_recycle', 0);
        $query = $this->db->get('comm_inbox');
        return $query->num_rows();
    }

    //view expanded message from inbox list
    function getMsg($msg_id = FALSE)
    {
        if ($msg_id === FALSE)
        {
            $query = $this->db->get('comm_inbox');
            return $query->result_array();
        }

        $query = $this->db->get_where('comm_inbox', array('msg_id' => $msg_id));
        return $query->row_array();

    }

    //delete inbox messages
    function deleteMsg($msg)
    {
        $data = array('is_trash'=>1);
        $this->db->where('msg_id', $msg);
        $this->db->update('comm_inbox',$data);
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    //move inbox trashes to recycle folder
    function deleteTrash($msg,$email)
    {
        //$email = profile()->email;
        $data = array('is_trash'=>0,'is_recycle'=>1);
        $this->db->where('msg_id', $msg);
        $this->db->where('receiver_id',$email);
        $this->db->update('comm_inbox',$data);
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    //mark inbox message as important
    function markInbox($msg)
    {
        $data = array('is_marked'=>1);
        $this->db->where('msg_id', $msg);
        $this->db->update('comm_inbox', $data);
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    //mark outbox message as important
    function markOutbox($msg)
    {

    }

    //count marked messages from inbox list
    function countMarkedInbox($email)
    {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('receiver_id',$email);
        $this->db->where('is_marked',1);
        $query = $this->db->get('comm_inbox');
        return $query->num_rows();
    }

    //count marked messages from sent list
    function countMarkedSent($email)
    {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('sender_id',$email);
        $this->db->where('is_marked',1);
        $query = $this->db->get('comm_sent');
        return $query->num_rows();
    }

    //retrieve marked msg from inbox folder
    function getMarkedInbox($email)
    {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('receiver_id', $email);
        $this->db->where('is_marked', 1);
        $this->db->where('is_recycle', 0);
        $query =  $this->db->get('comm_inbox');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    //retrieve marked msg from outbox folder
    function getMarkedSent($email)
    {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('sender_id', $email);
        $this->db->where('is_marked', 1);
        $this->db->where('is_recycle', 0);
        $query =  $this->db->get('comm_sent');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    //get trashed messages form inbox folder
    function getInboxTrash($email)
    {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        //$this->db->where('receiver_id', $email);
        $this->db->where('is_trash',1);
        $this->db->where('is_recycle',0);
        $query =  $this->db->get('comm_inbox');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    //get trashed messages from outbox folder
    function getSentTrash($email)
    {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('sender_id', $email);
        $this->db->where('is_trash', 1);
        $this->db->where('is_recycle',0);
        $query =  $this->db->get('comm_sent');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }


    //count trashed messages from inbox folder
    function countTrashInbox($email)
    {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('receiver_id',$email);
        $this->db->where('is_trash',1);
        $this->db->where('is_recycle',0);
        $query = $this->db->get('comm_inbox');
        return $query->num_rows();
    }

    //count trashed messages from sent folder
    function countTrashSent($email)
    {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('sender_id',$email);
        $this->db->where('is_trash',1);
        $this->db->where('is_recycle',0);
        $query = $this->db->get('comm_sent');
        return $query->num_rows();
    }

    //count drafted messages
    function countDraft($email)
    {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('sender_id',$email);
        $this->db->where('status', 'drafted');
        $query = $this->db->get('comm_sent');
        return $query->num_rows();
    }

    //filter newest or older messages in inbox folder
    function msgCategory($email, $flag)
    {
        if($flag == 'newest')
        {
            $this->db->select('*');
            $this->db->order_by('sent_at', 'DESC');
            $this->db->where('receiver_id',$email);
            $this->db->where('is_trash',0);
            $this->db->where('is_recycle',0);
            $query = $this->db->get('comm_inbox',10);
            return $query->num_rows()>0 ? $query->result_array() : FALSE;
        }
        elseif ($flag == 'older')
        {
            $this->db->select('*');
            $this->db->order_by('sent_at', 'ASC');
            $this->db->where('receiver_id',$email);
            $this->db->where('is_trash',0);
            $this->db->where('is_recycle',0);
            $query = $this->db->get('comm_inbox',10);
            return $query->num_rows()>0 ? $query->result_array() : FALSE;
        }
    }

    //Trash folder - filter newest or older messages trashed from inbox folder
    function filterInboxTrash($email, $flag)
    {
        if($flag == 'newest')
        {
            $this->db->select('*');
            $this->db->order_by('sent_at', 'DESC');
            $this->db->where('receiver_id',$email);
            $this->db->where('is_trash',1);
            $this->db->where('is_recycle',0);
            $query = $this->db->get('comm_inbox',10);
            return $query->num_rows()>0 ? $query->result_array() : FALSE;
        }
        elseif ($flag == 'older')
        {
            $this->db->select('*');
            $this->db->order_by('sent_at', 'ASC');
            $this->db->where('receiver_id',$email);
            $this->db->where('is_trash',1);
            $this->db->where('is_recycle',0);
            $query = $this->db->get('comm_inbox',10);
            return $query->num_rows()>0 ? $query->result_array() : FALSE;
        }
    }

    //Trash folder - filter newest or older messages trashed from sent folder
    function filterSentTrash($email, $flag)
    {
        if($flag == 'newest')
        {
            $this->db->select('*');
            $this->db->order_by('sent_at', 'DESC');
            $this->db->where('sender_id',$email);
            $this->db->where('is_trash',1);
            $this->db->where('is_recycle',0);
            $query = $this->db->get('comm_sent',10);
            return $query->num_rows()>0 ? $query->result_array() : FALSE;
        }
        elseif ($flag == 'older')
        {
            $this->db->select('*');
            $this->db->order_by('sent_at', 'ASC');
            $this->db->where('sender_id',$email);
            $this->db->where('is_trash',1);
            $this->db->where('is_recycle',0);
            $query = $this->db->get('comm_sent',10);
            return $query->num_rows()>0 ? $query->result_array() : FALSE;
        }
    }

    //Marked folder - filter newest or older messages marked from sent folder
    function filterMarkedInbox($email, $flag)
    {
        if($flag == 'newest')
        {
            $this->db->select('*');
            $this->db->order_by('sent_at', 'DESC');
            $this->db->where('receiver_id',$email);
            $this->db->where('is_marked',1);
            $this->db->where('is_trash',0);
            $query = $this->db->get('comm_inbox',10);
            return $query->num_rows()>0 ? $query->result_array() : FALSE;
        }
        elseif ($flag == 'older')
        {
            $this->db->select('*');
            $this->db->order_by('sent_at', 'ASC');
            $this->db->where('receiver_id',$email);
            $this->db->where('is_marked',1);
            $this->db->where('is_trash',0);
            $query = $this->db->get('comm_inbox',10);
            return $query->num_rows()>0 ? $query->result_array() : FALSE;
        }
    }

    //Marked folder - filter newest or older messages marked from sent folder
    function filterMarkedSent($email, $flag)
    {
        if($flag == 'newest')
        {
            $this->db->select('*');
            $this->db->order_by('sent_at', 'DESC');
            $this->db->where('sender_id',$email);
            $this->db->where('is_marked',1);
            $this->db->where('is_trash',0);
            $query = $this->db->get('comm_sent',10);
            return $query->num_rows()>0 ? $query->result_array() : FALSE;
        }
        elseif ($flag == 'older')
        {
            $this->db->select('*');
            $this->db->order_by('sent_at', 'ASC');
            $this->db->where('sender_id',$email);
            $this->db->where('is_marked',1);
            $this->db->where('is_trash',0);
            $query = $this->db->get('comm_sent',10);
            return $query->num_rows()>0 ? $query->result_array() : FALSE;
        }
    }

    function getInbox($email) {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('receiver_id', $email);
        $this->db->where('is_trash', 0);
        $this->db->where('is_recycle', 0);
        $query =  $this->db->get('comm_inbox');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }
}