<?php

class CustomersModel extends MY_Model {

 public function __construct() {
    parent::__construct();
    $this->branch = runningBranch()->branch_key;
    $this->business = runningBusiness()->business_key;
  }

  public function customerUpdatePayroll($key,$salary,$taxes,$variables) {
    $this->db->trans_start();

    $this->db->where('user_key',$key);
    $this->db->update('users_details',$salary);


      $this->db->where('ev_customer_key',$key);
      $this->db->delete('customer_variables');
        if(!empty($variables)){
          foreach ($variables as $v => $variable) {
            $dataVariable['ev_variable_key'] = $variable['ev_variable_key'];
            $dataVariable['ev_overide_value'] = $variable['ev_overide_value'];
            $dataVariable['ev_customer_key'] = $key;
            $this->db->insert('customer_variables',$dataVariable);
          }
       }

     $this->db->where('et_customer_key',$key);
     $this->db->delete('customer_taxes');

   if(!empty($taxes)){
      foreach ($taxes as $t => $tax) {
        $dataTax['et_tax_key'] = $tax['et_tax_key'];
        $dataTax['et_overide_value'] = $tax['et_overide_value'];
        $dataTax['et_customer_key'] = $key;
        $this->db->insert('customer_taxes',$dataTax);
      }
    }

    $this->db->trans_complete();
    return $this->db->trans_status();
   }

  public function registerCustomer($primary,$security,$business) {
     $this->db->trans_start();

     $security['user_id'] = $this->unused_user_id();
     $security['created_at'] = date('Y-m-d H:i:s');
     $security['user_account'] = branchCode().'-'.$security['user_id'];
     $this->db->insert('users',$security);

     $primary['user_key'] = $security['user_id'];
     $this->db->insert('users_details',$primary);

     $business['business_customer'] = $security['user_id'];
     $this->db->insert('customer_business',$business);

     $this->db->trans_complete();
     return $this->db->trans_status();
    }
    
    public function freightcustomers($when='') {
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('created_at >=',$dates['start']);
            $this->db->where('created_at <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->order_by('id','DESC');
        $this->db->where('user_branch',$this->branch);
        $this->db->where('user_business',$this->business);
        $this->db->where('auth_level','1')
                 ->or_where('auth_level','2');
        $this->db->select('DATE_FORMAT(created_at, "%m/%d/%Y") as joined', FALSE);
        $query = $this->db
            ->join('users_details','users_details.user_key=users.user_id','left')
            ->join('user_roles','user_roles.role_user=users.user_id','left')
            ->join('customer_groups','customer_groups.group_key=users.user_group','left')
            ->join('acl_categories','acl_categories.category_key=users.user_title','left')
            ->get( 'users' );
        return $query->result_array();
    }
    
    public function freightshippers($when='') {
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('created_at >=',$dates['start']);
            $this->db->where('created_at <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->order_by('id','DESC');
        //$this->db->where('user_branch',$this->branch);
        $this->db->where('user_business',$this->business);
        $this->db->where('auth_level', 5);
        $this->db->select('DATE_FORMAT(created_at, "%m/%d/%Y") as joined', FALSE);
        $query = $this->db->join('users_details','users_details.user_key=users.user_id','left')
            ->join('user_roles','user_roles.role_user=users.user_id','left')
            ->join('customer_groups','customer_groups.group_key=users.user_group','left')
            ->join('acl_categories','acl_categories.category_key=users.user_title','left')
            ->get( 'users' );
        return $query->result_array();
    }

  public function groups() {
    $this->db->order_by('group_id');
    $this->db->where('group_branch',$this->branch);
    $this->db->where('group_business',$this->business);
    $query = $this->db->get( 'customer_groups' );
     return $query->result_array();
   }

  public function customers($when='') {
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('created_at >=',$dates['start']);
            $this->db->where('created_at <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->order_by('id','DESC');
        $this->db->where('auth_level','1');
        //$this->db->where('auth_level','2');
        $this->db->select('DATE_FORMAT(created_at, "%m/%d/%Y") as joined', FALSE);
        $query = $this->db
            ->join('users_details','users_details.user_key=users.user_id','left')
            ->join('user_roles','user_roles.role_user=users.user_id','left')
            ->join('customer_groups','customer_groups.group_key=users.user_group','left')
            ->join('acl_categories','acl_categories.category_key=users.user_title','left')
            ->get( 'users' );
        return $query->result_array();
    }

  public function corporate($when='') {
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('created_at >=',$dates['start']);
            $this->db->where('created_at <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->order_by('id','DESC');
        $this->db->where('auth_level','2');
        $this->db->select('DATE_FORMAT(created_at, "%m/%d/%Y") as joined', FALSE);
        $query = $this->db
            ->join('users_details','users_details.user_key=users.user_id','left')
            ->join('user_roles','user_roles.role_user=users.user_id','left')
            ->join('customer_groups','customer_groups.group_key=users.user_group','left')
            ->join('acl_categories','acl_categories.category_key=users.user_title','left')
            ->get( 'users' );
        return $query->result_array();
    }

  public function employees($when='') {
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('created_at >=',$dates['start']);
            $this->db->where('created_at <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->order_by('id','DESC');
        $this->db->where('user_branch',$this->branch);
        $this->db->where('user_business',$this->business);
        $this->db->where('auth_level','8');
        $this->db->select('DATE_FORMAT(created_at, "%m/%d/%Y") as joined', FALSE);
        $query = $this->db
            ->join('users_details','users_details.user_key=users.user_id','left')
            ->join('customer_groups','customer_groups.group_key=users.user_group','left')
            ->join('acl_categories','acl_categories.category_key=users.user_title','left')
            ->get( 'users' );
        return $query->result_array();
    }

  public function totalCustomers() {
      $this->db->select('user_id');
       $this->db->where('user_branch',$this->branch);
       $this->db->where('user_business',$this->business);
       $query = $this->db->where('auth_level <',2)
            ->get( 'users' );
        return $query->num_rows();
      }

  public function newCustomers() {
        $this->db->select('user_id');
         $this->db->where('user_branch',$this->branch);
         $this->db->where('created_at > ',date('Y-m-d',strtotime("-1 days")));
         $this->db->where('user_business',$this->business);
         $query = $this->db->where('auth_level <',2)
              ->get( 'users' );
          return $query->num_rows();
        }

  public function totalCustomersActive() {
     $this->db->select('COUNT(`app_customer`) as total');
     $this->db->group_by('app_customer');
     $this->db->where('user_branch',$this->branch);
     $this->db->where('user_business',$this->business)
     ->join('loan_applications','loan_applications.app_customer=users.user_id','left');
     $query = $this->db->where('auth_level <',2)
          ->get( 'users' );
      return $query->num_rows()>0 ? $query->row()->total : 0;
    }

  public function customer($key) {
      $this->db->where('auth_level <',3);
      $query = $this->db->where('user_id',$key)
       ->join('users_details','users_details.user_key=users.user_id','left')
       ->join('customer_groups cg','cg.group_key=users.user_group','left')
       ->join('customer_business','customer_business.business_customer=users.user_id','left')
       ->join('user_roles','user_roles.role_user=users.user_id','left')
       ->join('acl_categories','acl_categories.category_key=users.user_title','left')
       ->get( 'users' );
     return $query->num_rows()>0 ? $query->row() : FALSE;
   }

    public function customer_shipper($key) {
        $this->db->where('auth_level','5');
        $query = $this->db->where('user_id',$key)
            ->join('users_details','users_details.user_key=users.user_id','left')
            ->join('customer_groups cg','cg.group_key=users.user_group','left')
            ->join('customer_business','customer_business.business_customer=users.user_id','left')
            ->join('user_roles','user_roles.role_user=users.user_id','left')
            ->join('acl_categories','acl_categories.category_key=users.user_title','left')
            ->get( 'users' );
        return $query->num_rows()>0 ? $query->row() : FALSE;
    }

  public function customer_email($key) {
        $this->db->where('user_branch',$this->branch);
        $this->db->where('user_business',$this->business);
        $query = $this->db->select( '*' )
            ->join('users_details','users_details.user_key=users.user_id','left')
            ->join('user_roles','user_roles.role_user=users.user_id','left')
            ->join('customer_groups','customer_groups.group_key=users.user_group','left')
            ->join('acl_categories','acl_categories.category_key=users.user_title','left')
            ->where('user_id',$key)->get('users');
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

  public function customerDetails($key) {
       $this->db->where('user_key',$key);
       $this->db->where('details_branch',$this->branch);
       $this->db->where('details_business',$this->business);
       $query = $this->db->get( 'users_details' );
      return $query->num_rows()>0 ? $query->row() : FALSE;
    }

  public function customerRoles($key) {
       $this->db->where('role_user',$key);
       $this->db->where('role_branch',$this->branch);
       $this->db->where('role_business',$this->business);
       $query = $this->db->get( 'user_roles' );
      return $query->num_rows()>0 ? $query->row() : FALSE;
    }

  public function customerUpdateSecurity($key,$details) {
      $details['user_account'] = branchCode().'-'.$key;
      $this->db->where('user_id',$key);
      $this->db->where('user_business',$this->business);
      $this->db->update('users',$details);
     return $this->db->affected_rows();
    }

  public function customerUpdatePrimary($key,$details) {
     if($this->customerDetails($key)){
       $this->db->where('user_key',$key);
       $this->db->where('details_branch',$this->branch);
       $this->db->where('details_business',$this->business);
       $this->db->update('users_details',$details);
     }else{
       $details['user_key'] = $key;
       $details['details_branch'] = $this->branch;
       $details['details_business'] = $this->business;
       $this->db->insert('users_details',$details);
     }
      return $this->db->affected_rows();
   }

  public function customerUpdateBusiness($key,$details) {
     if($this->customerBusiness($key)){
       $this->db->where('business_customer',$key);
       $this->db->where('business_branch',$this->branch);
       $this->db->where('business_business',$this->business);
       $this->db->update('customer_business',$details);
     }else{
       $details['business_customer'] = $key;
       $details['business_branch'] = $this->branch;
       $details['business_business'] = $this->business;
       $this->db->insert('customer_business',$details);
     }
      return $this->db->affected_rows();
   }

   public function customerBusiness($key) {
       $this->db->where('business_customer',$key);
       $this->db->where('business_branch',$this->branch);
       $this->db->where('business_business',$this->business);
        $query = $this->db->get( 'customer_business' );
       return $query->num_rows()>0 ? $query->row() : FALSE;
     }

  public function customer_freight($key) {
        $this->db->order_by('fr_id','DESC');
        $this->db->where('fr_client',$key);
        $query = $this->db->get( 'freights' );
        return $query->num_rows()>=0 ? $query->result_array() : FALSE;
    }

   public function customerUpdateRoles($key,$roles) {
     if($this->customerRoles($key)){
       $this->db->where('role_user',$key);
       $this->db->where('role_branch',$this->branch);
       $this->db->where('role_business',$this->business);
       $this->db->update('user_roles',$roles);
     }else{
       $roles['role_user'] = $key;
       $roles['role_branch'] = $this->branch;
       $roles['role_business'] = $this->business;
       $this->db->insert('user_roles',$roles);
     }

    if($this->db->affected_rows()>0){
        return TRUE;
      }else{
        return FALSE;
    }

  }

    public function select_one_sms($key){
        $query = $this->db->where('sms_id', $key)->from('bulksms')->get();
        return $query->row();
    }

    public function select_one_bulk1($key){
        $query = $this->db->group_by('sms_bulk_id')->where('sms_bulk_id', $key)->order_by('sms_id', 'DESC')->from('bulksms')->get();
        return $query->row();
    }

    public function select_one_bulk($key){
        $query = $this->db->group_by('sms_bulk_id')->where('sms_id', $key)->order_by('sms_id', 'DESC')->from('bulksms')->get();
        return $query->row();
    }

    public function customer_delete($key) {
     $this->db->trans_start();
         $this->db->where('user_id',$key)
           ->delete( 'users' );
        $this->db->where('user_key',$key)
            ->delete( 'users_details' );
        $this->db->where('fr_importer',$key)->or_where("fr_client",$key)
            ->delete( 'freights' );
        $this->db->where('fr_exporter',$key)
            ->delete( 'freights' );
     $this->db->trans_complete();
     if($this->db->trans_status() == true){
       return true;
     }else{
         return  false;
     }

    }

    public function documentDelete($key) {
        $this->db->limit(1)
            ->where('document_key=',$key)
            ->delete('customer_documents');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

  public function unused_user_id() {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'user_id', $random_unique_int )
            ->get_where( 'users');

        if( $query->num_rows() > 0 )
        {
            $query->free_result();
            // If the random user_id is already in use, try again
            return $this->unused_user_id();
        }

        return $random_unique_int;
    }

}