<?php

class GroupsModel extends MY_Model {

 public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

public function groupActions($group) {
      $this->db->order_by('group_id');
      $this->db->where('group_branch',$this->branch);
      $this->db->where('group_business',$this->business);
      $this->db->where('group_key',$this->business);
      $query = $this->db->get( 'customer_groups' );
      return $query->num_rows()>0 ? $query->result_array() : FALSE;
     }

  public function groups() {
    $this->db->select('*');
    $this->db->select('DATE_FORMAT(group_created, "%Y/%m/%d") as group_created', FALSE);
    $this->db->order_by('group_id');
    $this->db->where('group_branch',$this->branch);
    $this->db->where('group_business',$this->business);
    $query = $this->db->get( 'customer_groups' );
    return $query->num_rows()>0 ? $query->result_array() : FALSE;
   }

 public function group($key) {
   $this->db->where('group_branch',$this->branch);
   $this->db->where('group_business',$this->business);
      $query = $this->db->select( '*' )
        ->where('group_key',$key)->get('customer_groups');
    return ($query->num_rows()>0)? $query->row() : FALSE;
  }

  public function groupUpdate($key,$data){
    $this->db->where('group_business',$this->business);
    $this->db->limit(1)
      ->where('group_key=',$key)
      ->update('customer_groups',$data );
      return ($this->db->affected_rows()== 1)? TRUE :FALSE;
  }

  public function groupRegister($group) {
    $group['group_key'] = $this->group_key();
    $group['group_branch'] = $this->branch;
    $group['group_business'] = $this->business;
      $this->db->limit(1)
        ->insert('customer_groups',$group);
      return ($this->db->affected_rows()==1)? TRUE : FALSE;
  }

  public function deleteGroup($key) {
    $this->db->where('group_branch',$this->branch);
    $this->db->where('group_business',$this->business);
      $this->db->limit(1)
        ->where('group_key=',$key)
        ->delete('customer_groups');
      return ($this->db->affected_rows()==1)? TRUE :FALSE;
  }

 public function group_key()
    {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'group_key', $random_unique_int )
            ->get_where( 'customer_groups');

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->group_key();
        }

        return $random_unique_int;
    }

}