<?php

class CurrenciesModel extends My_model {

 public function __construct() {
        parent::__construct();
    }

    public function currencies() {
        return $this->db->get('currencies')->result_array();
    }

    public function currency_add($currency) {
      $currency['currency_key'] = $this->currencyKey();
        $this->db->insert('currencies',$currency);
        if($this->db->affected_rows() > 0){
          $log = array(
            'log_message' => 'Adding currency to the system',
            'log_details' => 'Currency added successfull',
            'log_activity' => $this->db->insert_id(),
          );
          $this->logActivity($log);
          return TRUE;
        }else{
          $log = array(
            'log_message' => 'Adding currency to the system',
            'log_details' => 'Currency was not added',
            'log_activity' => '',
          );
          $this->logActivity($log);
          return FALSE;
        }
    }

    public function currencyUpdate($currencyKey,$data) {
        $this->db->where('currency_key',$currencyKey);
        $this->db->limit(1);
        $this->db->update('currencies',$data);
        if($this->db->affected_rows() > 0){
          $log = array(
            'log_message' => 'Updating currency',
            'log_details' => 'Currency updated successfull',
            'log_activity' => $currencyKey,
          );
          $this->logActivity($log);
          return TRUE;
        }else{
          $log = array(
            'log_message' => 'Updating currency',
            'log_details' => 'Currency was not updated',
            'log_activity' => '',
          );
          $this->logActivity($log);
          return FALSE;
        }
    }

    public function currency_delete($currencyKey) {
      if( ! $this->currency_is_default($currencyKey)):
        $this->db->where('currency_key',$currencyKey);
        $this->db->limit(1);
        $this->db->delete('currencies');
        if($this->db->affected_rows() > 0){
          $log = array(
            'log_message' => 'Deleting currency',
            'log_details' => 'Currency deleted successfull',
            'log_activity' => $currencyKey,
          );
          $this->logActivity($log);
          return TRUE;
        }else{
          $log = array(
            'log_message' => 'Deleting currency',
            'log_details' => 'Currency was not deleted',
            'log_activity' => $currencyKey,
          );
          $this->logActivity($log);
          return FALSE;
        }
       else:
         $log = array(
           'log_message' => 'Deleting currency',
           'log_details' => 'Currency was not deleted because is default currency',
           'log_activity' => $currencyKey,
         );
         $this->logActivity($log);
           return FALSE;
       endif;
    }

    public function currency($currencyKey) {
        $query = $this->db->where('currency_key',$currencyKey)
                ->get('currencies');
        return ($query->num_rows() ==1)? $query->row() : FALSE;
    }

    public function currency_is_default($currencyKey) {
        $query = $this->db->where('currency_key',$currencyKey)
                ->where('currency_default',TRUE)
                ->get('currencies');
        return ($query->num_rows() > 0)? TRUE : FALSE;
    }

    public function currency_get_default() {
        $query = $this->db->where('currency_default',TRUE)
                ->get('currencies');
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    public function currency_make_default($currencyKey) {
        $default = $this->currency_get_default()->currency_key;
        $currency['currency_default'] = TRUE;
        $this->db->where('currency_key',$currencyKey)
                ->update('currencies',$currency);
        if($this->db->affected_rows()>0):
            $this->currency_remove_default($default);
            $log = array(
              'log_message' => 'Making currency default',
              'log_details' => 'Currency was made default currency',
              'log_activity' => $currencyKey,
            );
            $this->logActivity($log);
            return TRUE;
         else:
           $log = array(
             'log_message' => 'Making currency default',
             'log_details' => 'Currency was not made default currency',
             'log_activity' => $currencyKey,
           );
           $this->logActivity($log);
             return FALSE;
        endif;
    }

    public function currency_remove_default($currencyKey) {
        $currency['currency_default'] = FALSE;
        $this->db->where('currency_key',$currencyKey)
                ->update('currencies',$currency);
                if($this->db->affected_rows() > 0){
                  $log = array(
                    'log_message' => 'Remove default currency',
                    'log_details' => 'Currency was removed successfull',
                    'log_activity' => $currencyKey,
                  );
                  $this->logActivity($log);
                  return TRUE;
                }else{
                  $log = array(
                    'log_message' => 'Remove default currency',
                    'log_details' => 'Currency was not removed',
                    'log_activity' => $currencyKey,
                  );
                  $this->logActivity($log);
                  return FALSE;
                }
    }


    public function currencyKey()
    {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'currency_key', $random_unique_int )
            ->get_where( 'currencies' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->currencyKey();
        }

        return $random_unique_int;
    }
}
